/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.common;

import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.api.HostId;
import fleet.api.ProjectRootStatus;
import fleet.api.ProjectRootsHookApiKt;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.common.fs.SharedProjectRootsKt;
import fleet.common.topology.HostEntity;
import fleet.common.topology.HostKt;
import fleet.common.topology.ServiceEntity;
import fleet.git.common.GitHostService;
import fleet.git.common.GitHostServiceWithProject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"GIT_STATUS_LABEL", "", "findGitHostService", "Lfleet/git/common/GitHostServiceWithProject;", "projectRootAddress", "Lfleet/api/FileAddress;", "label", "fleet.git.common"})
@SourceDebugExtension(value={"SMAP\nGitServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitServices.kt\nfleet/git/common/GitServicesKt\n+ 2 Host.kt\nfleet/common/topology/HostKt\n+ 3 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n*L\n1#1,42:1\n194#2:43\n34#3,12:44\n*S KotlinDebug\n*F\n+ 1 GitServices.kt\nfleet/git/common/GitServicesKt\n*L\n32#1:43\n33#1:44,12\n*E\n"})
public final class GitServicesKt {
    @NotNull
    public static final String GIT_STATUS_LABEL = "git_status_worker_cli";

    @Nullable
    public static final GitHostServiceWithProject findGitHostService(@NotNull FileAddress projectRootAddress, @NotNull String label) {
        HostEntity host;
        Intrinsics.checkNotNullParameter((Object)projectRootAddress, (String)"projectRootAddress");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        HostEntity hostEntity = HostKt.hostOrNull((HostId)projectRootAddress.getHostId());
        if (hostEntity == null) {
            return null;
        }
        HostEntity $this$service$iv = host = hostEntity;
        boolean $i$f$service = false;
        GitHostService gitHostService = (GitHostService)HostKt.service((HostEntity)$this$service$iv, (KClass)Reflection.getOrCreateKotlinClass(GitHostService.class));
        if (gitHostService == null) {
            return null;
        }
        GitHostService service = gitHostService;
        Iterable $this$singleOrNullOrThrow$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)SharedProjectRootEntity.Companion.getFileAddressAttr()), (Object)projectRootAddress);
        boolean $i$f$singleOrNullOrThrow = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$singleOrNullOrThrow$iv) {
            SharedProjectRootEntity it = (SharedProjectRootEntity)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag().getLabel(), (Object)label)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element: " + single$iv + ", " + element$iv);
            }
            single$iv = element$iv;
            found$iv = true;
        }
        SharedProjectRootEntity sharedProjectRootEntity = single$iv;
        if (sharedProjectRootEntity == null) {
            return null;
        }
        SharedProjectRootEntity root = sharedProjectRootEntity;
        ProjectRootStatus projectRootStatus = SharedProjectRootsKt.status((ServiceEntity)((ServiceEntity)service), (SharedProjectRootEntity)root);
        if (projectRootStatus == null) {
            return null;
        }
        ProjectRootStatus status = projectRootStatus;
        return ProjectRootsHookApiKt.isTerminal((ProjectRootStatus)status) ? new GitHostServiceWithProject(service, root.getId()) : null;
    }
}

