/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.lexer.LexerBaseEx;
import org.toml.lang.lexer.TomlEscapeLexerKt;
import org.toml.lang.psi.ElementTypesKt;
import org.toml.lang.psi.TomlElementTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0014J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/toml/lang/lexer/TomlEscapeLexer;", "Lorg/toml/lang/lexer/LexerBaseEx;", "defaultToken", "Lfleet/com/intellij/psi/tree/IElementType;", "eol", "", "(Lfleet/com/intellij/psi/tree/IElementType;Z)V", "determineTokenType", "isValidUnicodeEscape", "start", "", "end", "locateToken", "unicodeTokenEnd", "expectedLength", "Companion", "toml-parser"})
public final class TomlEscapeLexer
extends LexerBaseEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IElementType defaultToken;
    private final boolean eol;
    @NotNull
    private static final TokenSet ESCAPABLE_LITERALS_TOKEN_SET = ElementTypesKt.getTOML_BASIC_STRINGS();

    private TomlEscapeLexer(IElementType defaultToken, boolean eol) {
        this.defaultToken = defaultToken;
        this.eol = eol;
    }

    @Override
    @Nullable
    protected IElementType determineTokenType() {
        if (this.getTokenStart() >= this.getTokenEnd()) {
            return null;
        }
        if (this.getBufferSequence().charAt(this.getTokenStart()) != '\\') {
            return this.defaultToken;
        }
        if (this.getTokenStart() + 1 >= this.getTokenEnd()) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        char c = this.getBufferSequence().charAt(this.getTokenStart() + 1);
        return (c == 'u' ? true : c == 'U') ? (this.isValidUnicodeEscape(this.getTokenStart(), this.getTokenEnd()) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) : ((c == '\r' ? true : c == '\n') ? TomlEscapeLexerKt.access$esc(this.eol) : (((((((c == 'b' ? true : c == 't') ? true : c == 'n') ? true : c == 'f') ? true : c == 'r') ? true : c == '\"') ? true : c == '\\') ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidUnicodeEscape(int start, int end) {
        try {
            boolean bl;
            int value = Integer.parseInt(((Object)this.getBufferSequence().subSequence(start + 2, end)).toString(), CharsKt.checkRadix((int)16));
            if (0 <= value) {
                if (value < 55296) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (57344 > value) return false;
            if (value >= 0x110000) return false;
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected int locateToken(int start) {
        if (start >= this.getBufferEnd()) {
            return start;
        }
        if (this.getBufferSequence().charAt(start) == '\\') {
            int n;
            int i = start + 1;
            if (i >= this.getBufferEnd()) {
                return this.getBufferEnd();
            }
            char c = this.getBufferSequence().charAt(i);
            if (c == 'u') {
                n = this.unicodeTokenEnd(i + 1, 4);
            } else if (c == 'U') {
                n = this.unicodeTokenEnd(i + 1, 8);
            } else if (c == '\r' ? true : c == '\n') {
                int j;
                for (j = i; j < this.getBufferEnd() && TomlEscapeLexerKt.access$isWhitespaceChar(this.getBufferSequence().charAt(j)); ++j) {
                }
                n = j;
            } else {
                n = i + 1;
            }
            return n;
        }
        int idx = CharArrayUtil.indexOf((CharSequence)this.getBufferSequence(), (CharSequence)"\\", (int)(start + 1), (int)this.getBufferEnd());
        return idx != -1 ? idx : this.getBufferEnd();
    }

    private final int unicodeTokenEnd(int start, int expectedLength) {
        int n = start + expectedLength;
        for (int i = start; i < n; ++i) {
            if (i < this.getBufferEnd() && StringUtil.isHexDigit((char)this.getBufferSequence().charAt(i))) continue;
            return start;
        }
        return start + expectedLength;
    }

    public /* synthetic */ TomlEscapeLexer(IElementType defaultToken, boolean eol, DefaultConstructorMarker $constructor_marker) {
        this(defaultToken, eol);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/toml/lang/lexer/TomlEscapeLexer$Companion;", "", "()V", "ESCAPABLE_LITERALS_TOKEN_SET", "Lfleet/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getESCAPABLE_LITERALS_TOKEN_SET", "()Lfleet/com/intellij/psi/tree/TokenSet;", "of", "Lorg/toml/lang/lexer/TomlEscapeLexer;", "tokenType", "Lfleet/com/intellij/psi/tree/IElementType;", "toml-parser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TomlEscapeLexer of(@NotNull IElementType tokenType) {
            TomlEscapeLexer tomlEscapeLexer;
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            IElementType iElementType = tokenType;
            if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.BASIC_STRING)) {
                IElementType iElementType2 = TomlElementTypes.BASIC_STRING;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"BASIC_STRING");
                tomlEscapeLexer = new TomlEscapeLexer(iElementType2, false, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.MULTILINE_BASIC_STRING)) {
                IElementType iElementType3 = TomlElementTypes.MULTILINE_BASIC_STRING;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"MULTILINE_BASIC_STRING");
                tomlEscapeLexer = new TomlEscapeLexer(iElementType3, true, null);
            } else {
                throw new IllegalArgumentException("Unsupported literal type: " + tokenType);
            }
            return tomlEscapeLexer;
        }

        @NotNull
        public final TokenSet getESCAPABLE_LITERALS_TOKEN_SET() {
            return ESCAPABLE_LITERALS_TOKEN_SET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

