/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.yaml.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.NoneType;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorInt;
import org.llvm.adt.ilist;
import org.llvm.adt.ilist_iterator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.MemoryBufferRef;
import org.llvm.support.SMLoc;
import org.llvm.support.SMRange;
import org.llvm.support.SourceMgr;
import org.llvm.support.impl.SimpleKey;
import org.llvm.support.impl.UnicodeEncodingForm;
import org.llvm.support.impl.YAMLParserStatics;
import org.llvm.support.llvm;
import org.llvm.support.yaml.impl.Token;
import org.llvm.support.yaml.impl.ilistToken;
import org.llvm.support.yaml.impl.ilist_traitsToken;

public class Scanner
implements Destructors.ClassWithDestructor {
    private final SourceMgr SM;
    private MemoryBufferRef InputBuffer;
    private char.ptr Current;
    private char.ptr End;
    private int Indent;
    private int Column;
    private int Line;
    private int FlowLevel;
    private boolean IsStartOfStream;
    private boolean IsSimpleKeyAllowed;
    private boolean Failed;
    private boolean ShowColors;
    private ilist<Token> TokenQueue;
    private SmallVectorInt Indents;
    private SmallVector<SimpleKey> SimpleKeys;

    public Scanner(StringRef Input2, SourceMgr sm) {
        this(Input2, sm, true);
    }

    public Scanner(StringRef Input2, SourceMgr sm, boolean ShowColors) {
        this.SM = sm;
        this.InputBuffer = new MemoryBufferRef();
        this.ShowColors = ShowColors;
        this.TokenQueue = new ilistToken();
        this.Indents = new SmallVectorInt(4);
        this.SimpleKeys = new SmallVector<Object>(4, null);
        this.init(new MemoryBufferRef(new StringRef(Input2), new StringRef("YAML")));
    }

    public Scanner(MemoryBufferRef Buffer, SourceMgr SM_) {
        this(Buffer, SM_, true);
    }

    public Scanner(MemoryBufferRef Buffer, SourceMgr SM_, boolean ShowColors) {
        this.SM = SM_;
        this.InputBuffer = new MemoryBufferRef();
        this.ShowColors = ShowColors;
        this.TokenQueue = new ilistToken();
        this.Indents = new SmallVectorInt(4);
        this.SimpleKeys = new SmallVector<Object>(4, null);
        this.init(new MemoryBufferRef(Buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token peekNext() {
        boolean NeedMore = false;
        while (true) {
            if ((this.TokenQueue.empty() || NeedMore) && !this.fetchMoreTokens()) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    this.TokenQueue.clear();
                    this.TokenQueue.push_back((Token)$c$.track((Object)new Token()));
                    $c$.clean();
                    Token token = (Token)this.TokenQueue.front();
                    return token;
                }
                finally {
                    $c$.$destroy();
                }
            }
            assert (!this.TokenQueue.empty()) : "fetchMoreTokens lied about getting tokens!";
            this.removeStaleSimpleKeyCandidates();
            SimpleKey SK = new SimpleKey();
            SK.Tok.$assignMove((ilist_iterator<Token>)this.TokenQueue.begin());
            if (Native.$eq_ptr((void.ptr)((type.ptr)std.find(this.SimpleKeys.begin(), this.SimpleKeys.end(), (Object)SK)), this.SimpleKeys.end())) break;
            NeedMore = true;
        }
        return (Token)this.TokenQueue.front();
    }

    public Token getNext() {
        Token Ret = null;
        try {
            Ret = new Token(this.peekNext());
            if (!this.TokenQueue.empty()) {
                this.TokenQueue.pop_front();
            }
            if (this.TokenQueue.empty()) {
                // empty if block
            }
            Token token = new Token(JavaDifferentiators.JD.Move.INSTANCE, Ret);
            return token;
        }
        finally {
            if (Ret != null) {
                Ret.$destroy();
            }
        }
    }

    public void printError(SMLoc Loc, SourceMgr.DiagKind Kind2, Twine Message) {
        this.printError(Loc, Kind2, Message, new ArrayRef<NoneType>(llvm.None, false));
    }

    public void printError(SMLoc Loc, SourceMgr.DiagKind Kind2, Twine Message, ArrayRef<SMRange> Ranges) {
        this.SM.PrintMessage(new SMLoc(Loc), Kind2, Message, new ArrayRef<SMRange>(Ranges), new ArrayRef<NoneType>(llvm.None, false), this.ShowColors);
    }

    public void setError(Twine Message, char.ptr Position) {
        if (this.Current.$greatereq((Object)this.End)) {
            this.Current = Native.$tryClone((char.ptr)((char.ptr)this.End.$sub(1)));
        }
        if (!this.Failed) {
            this.printError(SMLoc.getFromPointer(this.Current), SourceMgr.DiagKind.DK_Error, Message);
        }
        this.Failed = true;
    }

    public void setError(Twine Message) {
        this.setError(Message, this.Current);
    }

    public boolean failed() {
        return this.Failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(MemoryBufferRef Buffer) {
        std_ptr.unique_ptr<MemoryBuffer> InputBufferOwner = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.InputBuffer.$assign(Buffer);
            this.Current = Native.$tryClone((char.ptr)this.InputBuffer.getBufferStart());
            this.End = Native.$tryClone((char.ptr)this.InputBuffer.getBufferEnd());
            this.Indent = -1;
            this.Column = 0;
            this.Line = 0;
            this.FlowLevel = 0;
            this.IsStartOfStream = true;
            this.IsSimpleKeyAllowed = true;
            this.Failed = false;
            InputBufferOwner = MemoryBuffer.getMemBuffer(new MemoryBufferRef(Buffer));
            $c$.clean(this.SM.AddNewSourceBuffer((std_ptr.unique_ptr<MemoryBuffer>)$c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move(InputBufferOwner))), new SMLoc()));
        }
        finally {
            if (InputBufferOwner != null) {
                InputBufferOwner.$destroy();
            }
            $c$.$destroy();
        }
    }

    private StringRef currentInput() {
        return new StringRef(this.Current, this.End.$sub((abstract_iterator)this.Current));
    }

    private std_pair.pairUIntUInt decodeUTF8(char.ptr Position) {
        return YAMLParserStatics.decodeUTF8(new StringRef(Position, this.End.$sub((abstract_iterator)Position)));
    }

    private char.ptr skip_nb_char(char.ptr Position) {
        if (Native.$eq_ptr((void.ptr)Position, (void.ptr)this.End)) {
            return Position;
        }
        if (Position.$star() == 9 || Position.$star() >= 32 && Position.$star() <= 126) {
            return (char.ptr)Position.$add(1);
        }
        if ((Unsigned.$uchar2int((byte)Position.$star()) & 0x80) != 0) {
            std_pair.pairUIntUInt u8d = this.decodeUTF8(Position);
            if (u8d.second != 0 && u8d.first != 65279 && (u8d.first == 133 || Unsigned.$greatereq_uint((int)u8d.first, (int)160) && Unsigned.$lesseq_uint((int)u8d.first, (int)55295) || Unsigned.$greatereq_uint((int)u8d.first, (int)57344) && Unsigned.$lesseq_uint((int)u8d.first, (int)65533) || Unsigned.$greatereq_uint((int)u8d.first, (int)65536) && Unsigned.$lesseq_uint((int)u8d.first, (int)0x10FFFF))) {
                return (char.ptr)Position.$add(u8d.second);
            }
        }
        return Position;
    }

    private char.ptr skip_b_break(char.ptr Position) {
        if (Native.$eq_ptr((void.ptr)Position, (void.ptr)this.End)) {
            return Position;
        }
        if (Position.$star() == 13) {
            if (Native.$noteq_ptr((void.ptr)((void.ptr)Position.$add(1)), (void.ptr)this.End) && ((char.ptr)Position.$add(1)).$star() == 10) {
                return (char.ptr)Position.$add(2);
            }
            return (char.ptr)Position.$add(1);
        }
        if (Position.$star() == 10) {
            return (char.ptr)Position.$add(1);
        }
        return Position;
    }

    private char.ptr skip_s_space(char.ptr Position) {
        if (Native.$eq_ptr((void.ptr)Position, (void.ptr)this.End)) {
            return Position;
        }
        if (Position.$star() == 32) {
            return (char.ptr)Position.$add(1);
        }
        return Position;
    }

    private char.ptr skip_s_white(char.ptr Position) {
        if (Native.$eq_ptr((void.ptr)Position, (void.ptr)this.End)) {
            return Position;
        }
        if (Position.$star() == 32 || Position.$star() == 9) {
            return (char.ptr)Position.$add(1);
        }
        return Position;
    }

    private char.ptr skip_ns_char(char.ptr Position) {
        if (Native.$eq_ptr((void.ptr)Position, (void.ptr)this.End)) {
            return Position;
        }
        if (Position.$star() == 32 || Position.$star() == 9) {
            return Position;
        }
        return this.skip_nb_char(Position);
    }

    private char.ptr skip_while(ADTFunctionPointers.Scanner.SkipWhileFunc Func, char.ptr Position) {
        char.ptr i;
        while (!Native.$eq_ptr((void.ptr)(i = Native.$tryClone((char.ptr)Func.$call(this, Position))), (void.ptr)Position)) {
            Position = Native.$tryClone((char.ptr)i);
        }
        return Position;
    }

    private void advanceWhile(ADTFunctionPointers.Scanner.SkipWhileFunc Func) {
        char.ptr Final = Native.$tryClone((char.ptr)this.skip_while(Func, this.Current));
        this.Column += Final.$sub((abstract_iterator)this.Current);
        this.Current = Native.$tryClone((char.ptr)Final);
    }

    private StringRef scan_ns_uri_char() {
        char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
        while (!Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End) && (this.Current.$star() == 37 && ((char.ptr)this.Current.$add(2)).$less((Object)this.End) && YAMLParserStatics.is_ns_hex_digit(((char.ptr)this.Current.$add(1)).$star()) && YAMLParserStatics.is_ns_hex_digit(((char.ptr)this.Current.$add(2)).$star()) || YAMLParserStatics.is_ns_word_char(this.Current.$star()) || new StringRef(this.Current, 1).find_first_of("#;/?:@&=+$,_.!~*'()[]") != StringRef.npos)) {
            this.Current.$preInc();
            ++this.Column;
        }
        return new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2));
    }

    private boolean consume(int Expected2) {
        if (Unsigned.$greatereq_uint((int)Expected2, (int)128)) {
            llvm.report_fatal_error(NativePointer.$((String)"Not dealing with this yet"));
        }
        if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End)) {
            return false;
        }
        if (Unsigned.$uchar2int((byte)this.Current.$star()) >= 128) {
            llvm.report_fatal_error(NativePointer.$((String)"Not dealing with this yet"));
        }
        if (Unsigned.$uchar2uint((byte)this.Current.$star()) == Expected2) {
            this.Current.$preInc();
            ++this.Column;
            return true;
        }
        return false;
    }

    private void skip(int Distance) {
        this.Current = (char.ptr)this.Current.$add(Distance);
        this.Column += Distance;
        assert (this.Current.$lesseq((Object)this.End)) : "Skipped past the end";
    }

    private boolean isBlankOrBreak(char.ptr Position) {
        if (Native.$eq_ptr((void.ptr)Position, (void.ptr)this.End)) {
            return false;
        }
        return Position.$star() == 32 || Position.$star() == 9 || Position.$star() == 13 || Position.$star() == 10;
    }

    private boolean consumeLineBreakIfPresent() {
        char.ptr Next = Native.$tryClone((char.ptr)this.skip_b_break(this.Current));
        if (Native.$eq_ptr((void.ptr)Next, (void.ptr)this.Current)) {
            return false;
        }
        this.Column = 0;
        ++this.Line;
        this.Current = Native.$tryClone((char.ptr)Next);
        return true;
    }

    private void saveSimpleKeyCandidate(ilist_iterator<Token> Tok, int AtColumn, boolean IsRequired) {
        if (this.IsSimpleKeyAllowed) {
            SimpleKey SK = new SimpleKey();
            SK.Tok.$assign(Tok);
            SK.Line = this.Line;
            SK.Column = AtColumn;
            SK.IsRequired = IsRequired;
            SK.FlowLevel = this.FlowLevel;
            this.SimpleKeys.push_back(SK);
        }
    }

    private void removeStaleSimpleKeyCandidates() {
        type.ptr i = (type.ptr)Native.$tryClone(this.SimpleKeys.begin());
        while (Native.$noteq_ptr((void.ptr)i, this.SimpleKeys.end())) {
            if (((SimpleKey)i.$star()).Line != this.Line || Unsigned.$less_uint((int)(((SimpleKey)i.$star()).Column + 1024), (int)this.Column)) {
                if (((SimpleKey)i.$star()).IsRequired) {
                    this.setError(new Twine("Could not find expected : for simple key"), ((Token)((SimpleKey)i.$star()).Tok.$arrow()).Range.begin());
                }
                i = (type.ptr)Native.$tryClone(this.SimpleKeys.erase((type.ptr<SimpleKey>)i));
                continue;
            }
            i.$preInc();
        }
    }

    private void removeSimpleKeyCandidatesOnFlowLevel(int Level2) {
        if (!this.SimpleKeys.empty() && ((SimpleKey)((type.ptr)this.SimpleKeys.end().$sub((int)1)).$star()).FlowLevel == Level2) {
            this.SimpleKeys.pop_back();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unrollIndent(int ToColumn) {
        Token T4 = null;
        try {
            T4 = new Token();
            if (this.FlowLevel != 0) {
                boolean bl = true;
                return bl;
            }
            while (this.Indent > ToColumn) {
                T4.Kind = Token.TokenKind.TK_BlockEnd;
                T4.Range.$assignMove(new StringRef(this.Current, 1));
                this.TokenQueue.push_back(T4);
                this.Indent = this.Indents.pop_back_val();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollIndent(int ToColumn, Token.TokenKind Kind2, ilist_iterator<Token> InsertPoint) {
        if (this.FlowLevel != 0) {
            return true;
        }
        if (this.Indent < ToColumn) {
            Token T4 = null;
            try {
                this.Indents.push_back(this.Indent);
                this.Indent = ToColumn;
                T4 = new Token();
                T4.Kind = Kind2;
                T4.Range.$assignMove(new StringRef(this.Current, 0));
                this.TokenQueue.insert(new ilist_iterator<Token>(InsertPoint), T4);
            }
            finally {
                if (T4 != null) {
                    T4.$destroy();
                }
            }
        }
        return true;
    }

    private void skipComment() {
        char.ptr I;
        if (this.Current.$star() != 35) {
            return;
        }
        while (!Native.$eq_ptr((void.ptr)(I = Native.$tryClone((char.ptr)this.skip_nb_char(this.Current))), (void.ptr)this.Current)) {
            this.Current = Native.$tryClone((char.ptr)I);
            ++this.Column;
        }
    }

    private void scanToNextToken() {
        while (true) {
            if (this.Current.$star() == 32 || this.Current.$star() == 9) {
                this.skip(1);
                continue;
            }
            this.skipComment();
            char.ptr i = Native.$tryClone((char.ptr)this.skip_b_break(this.Current));
            if (Native.$eq_ptr((void.ptr)i, (void.ptr)this.Current)) break;
            this.Current = Native.$tryClone((char.ptr)i);
            ++this.Line;
            this.Column = 0;
            if (this.FlowLevel != 0) continue;
            this.IsSimpleKeyAllowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanStreamStart() {
        Token T4 = null;
        try {
            this.IsStartOfStream = false;
            std_pair.pairTypeUInt<UnicodeEncodingForm> EI = YAMLParserStatics.getUnicodeEncoding(this.currentInput());
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_StreamStart;
            T4.Range.$assignMove(new StringRef(this.Current, EI.second));
            this.TokenQueue.push_back(T4);
            this.Current = (char.ptr)this.Current.$add(EI.second);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    private boolean scanStreamEnd() {
        Token T4 = null;
        try {
            if (this.Column != 0) {
                this.Column = 0;
                ++this.Line;
            }
            this.unrollIndent(-1);
            this.SimpleKeys.clear();
            this.IsSimpleKeyAllowed = false;
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_StreamEnd;
            T4.Range.$assignMove(new StringRef(this.Current, 0));
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanDirective() {
        Token T4 = null;
        try {
            this.unrollIndent(-1);
            this.SimpleKeys.clear();
            this.IsSimpleKeyAllowed = false;
            char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
            this.consume(Unsigned.$char2uint((byte)37));
            char.ptr NameStart = Native.$tryClone((char.ptr)this.Current);
            this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_ns_char, this.Current));
            StringRef Name2 = new StringRef(NameStart, this.Current.$sub((abstract_iterator)NameStart));
            this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_s_white, this.Current));
            T4 = new Token();
            if (llvm.$eq_StringRef(Name2, "YAML")) {
                this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_ns_char, this.Current));
                T4.Kind = Token.TokenKind.TK_VersionDirective;
                T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
                this.TokenQueue.push_back(T4);
                boolean bl = true;
                return bl;
            }
            if (llvm.$eq_StringRef(Name2, "TAG")) {
                this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_ns_char, this.Current));
                this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_s_white, this.Current));
                this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_ns_char, this.Current));
                T4.Kind = Token.TokenKind.TK_TagDirective;
                T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
                this.TokenQueue.push_back(T4);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanDocumentIndicator(boolean IsStart) {
        Token T4 = null;
        try {
            this.unrollIndent(-1);
            this.SimpleKeys.clear();
            this.IsSimpleKeyAllowed = false;
            T4 = new Token();
            T4.Kind = IsStart ? Token.TokenKind.TK_DocumentStart : Token.TokenKind.TK_DocumentEnd;
            T4.Range.$assignMove(new StringRef(this.Current, 3));
            this.skip(3);
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFlowCollectionStart(boolean IsSequence) {
        Token T4 = null;
        try {
            T4 = new Token();
            T4.Kind = IsSequence ? Token.TokenKind.TK_FlowSequenceStart : Token.TokenKind.TK_FlowMappingStart;
            T4.Range.$assignMove(new StringRef(this.Current, 1));
            this.skip(1);
            this.TokenQueue.push_back(T4);
            this.saveSimpleKeyCandidate(new ilist_iterator<Token>(((ilist_iterator)this.TokenQueue.end()).$preDec()), this.Column - 1, false);
            this.IsSimpleKeyAllowed = true;
            ++this.FlowLevel;
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFlowCollectionEnd(boolean IsSequence) {
        Token T4 = null;
        try {
            this.removeSimpleKeyCandidatesOnFlowLevel(this.FlowLevel);
            this.IsSimpleKeyAllowed = false;
            T4 = new Token();
            T4.Kind = IsSequence ? Token.TokenKind.TK_FlowSequenceEnd : Token.TokenKind.TK_FlowMappingEnd;
            T4.Range.$assignMove(new StringRef(this.Current, 1));
            this.skip(1);
            this.TokenQueue.push_back(T4);
            if (this.FlowLevel != 0) {
                --this.FlowLevel;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    private boolean scanFlowEntry() {
        Token T4 = null;
        try {
            this.removeSimpleKeyCandidatesOnFlowLevel(this.FlowLevel);
            this.IsSimpleKeyAllowed = true;
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_FlowEntry;
            T4.Range.$assignMove(new StringRef(this.Current, 1));
            this.skip(1);
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    private boolean scanBlockEntry() {
        Token T4 = null;
        try {
            this.rollIndent(this.Column, Token.TokenKind.TK_BlockSequenceStart, (ilist_iterator<Token>)this.TokenQueue.end());
            this.removeSimpleKeyCandidatesOnFlowLevel(this.FlowLevel);
            this.IsSimpleKeyAllowed = true;
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_BlockEntry;
            T4.Range.$assignMove(new StringRef(this.Current, 1));
            this.skip(1);
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    private boolean scanKey() {
        Token T4 = null;
        try {
            if (this.FlowLevel == 0) {
                this.rollIndent(this.Column, Token.TokenKind.TK_BlockMappingStart, (ilist_iterator<Token>)this.TokenQueue.end());
            }
            this.removeSimpleKeyCandidatesOnFlowLevel(this.FlowLevel);
            this.IsSimpleKeyAllowed = this.FlowLevel == 0;
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_Key;
            T4.Range.$assignMove(new StringRef(this.Current, 1));
            this.skip(1);
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanValue() {
        Token T4 = null;
        try {
            if (!this.SimpleKeys.empty()) {
                Token T$1 = null;
                try {
                    SimpleKey SK = (SimpleKey)this.SimpleKeys.pop_back_val();
                    T$1 = new Token();
                    T$1.Kind = Token.TokenKind.TK_Key;
                    T$1.Range.$assign(((Token)SK.Tok.$arrow()).Range);
                    ilist_iterator<Token> i = new ilist_iterator<Token>(new ilist_traitsToken());
                    ilist_iterator<Token> e = new ilist_iterator<Token>(new ilist_traitsToken());
                    i.$assignMove((ilist_iterator<Token>)this.TokenQueue.begin());
                    e.$assignMove((ilist_iterator<Token>)this.TokenQueue.end());
                    while (i.$noteq(e) && !i.$eq(SK.Tok)) {
                        i.$preInc();
                    }
                    assert (i.$noteq(e)) : "SimpleKey not in token queue!";
                    i.$assignMove(this.TokenQueue.insert(new ilist_iterator<Token>(i), T$1));
                    this.rollIndent(SK.Column, Token.TokenKind.TK_BlockMappingStart, new ilist_iterator<Token>(i));
                    this.IsSimpleKeyAllowed = false;
                }
                finally {
                    if (T$1 != null) {
                        T$1.$destroy();
                    }
                }
            } else {
                if (this.FlowLevel == 0) {
                    this.rollIndent(this.Column, Token.TokenKind.TK_BlockMappingStart, (ilist_iterator<Token>)this.TokenQueue.end());
                }
                this.IsSimpleKeyAllowed = this.FlowLevel == 0;
            }
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_Value;
            T4.Range.$assignMove(new StringRef(this.Current, 1));
            this.skip(1);
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFlowScalar(boolean IsDoubleQuoted) {
        Token T4 = null;
        try {
            char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
            int ColStart = this.Column;
            if (IsDoubleQuoted) {
                do {
                    this.Current.$preInc();
                    while (Native.$noteq_ptr((void.ptr)this.Current, (void.ptr)this.End) && this.Current.$star() != 34) {
                        this.Current.$preInc();
                    }
                } while (Native.$noteq_ptr((void.ptr)this.Current, (void.ptr)this.End) && ((char.ptr)this.Current.$sub(1)).$star() == 92 && YAMLParserStatics.wasEscaped((char.ptr)Start2.$add(1), this.Current));
            } else {
                this.skip(1);
                while (true) {
                    if (((char.ptr)this.Current.$add(1)).$less((Object)this.End) && this.Current.$star() == 39 && ((char.ptr)this.Current.$add(1)).$star() == 39) {
                        this.skip(2);
                        continue;
                    }
                    if (this.Current.$star() == 39) break;
                    char.ptr i = Native.$tryClone((char.ptr)this.skip_nb_char(this.Current));
                    if (Native.$eq_ptr((void.ptr)i, (void.ptr)this.Current)) {
                        i = Native.$tryClone((char.ptr)this.skip_b_break(this.Current));
                        if (Native.$eq_ptr((void.ptr)i, (void.ptr)this.Current)) break;
                        this.Current = Native.$tryClone((char.ptr)i);
                        this.Column = 0;
                        ++this.Line;
                        continue;
                    }
                    if (Native.$eq_ptr((void.ptr)i, (void.ptr)this.End)) break;
                    this.Current = Native.$tryClone((char.ptr)i);
                    ++this.Column;
                }
            }
            if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End)) {
                this.setError(new Twine("Expected quote at end of scalar"), this.Current);
                boolean bl = false;
                return bl;
            }
            this.skip(1);
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_Scalar;
            T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
            this.TokenQueue.push_back(T4);
            this.saveSimpleKeyCandidate(new ilist_iterator<Token>(((ilist_iterator)this.TokenQueue.end()).$preDec()), ColStart, false);
            this.IsSimpleKeyAllowed = false;
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanPlainScalar() {
        Token T4 = null;
        try {
            char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
            int ColStart = this.Column;
            boolean LeadingBlanks = false;
            assert (this.Indent >= -1) : "Indent must be >= -1 !";
            int indent = this.Indent + 1;
            while (this.Current.$star() != 35) {
                while (!this.isBlankOrBreak(this.Current)) {
                    char.ptr i;
                    if (this.FlowLevel != 0 && this.Current.$star() == 58 && !this.isBlankOrBreak((char.ptr)this.Current.$add(1)) && ((char.ptr)this.Current.$add(1)).$star() != 44) {
                        this.setError(new Twine("Found unexpected ':' while scanning a plain scalar"), this.Current);
                        boolean bl = false;
                        return bl;
                    }
                    if (this.Current.$star() == 58 && this.isBlankOrBreak((char.ptr)this.Current.$add(1)) || this.FlowLevel != 0 && new StringRef(this.Current, 1).find_first_of(",:?[]{}") != StringRef.npos || Native.$eq_ptr((void.ptr)(i = Native.$tryClone((char.ptr)this.skip_nb_char(this.Current))), (void.ptr)this.Current)) break;
                    this.Current = Native.$tryClone((char.ptr)i);
                    ++this.Column;
                }
                if (!this.isBlankOrBreak(this.Current)) break;
                char.ptr Tmp = Native.$tryClone((char.ptr)this.Current);
                while (this.isBlankOrBreak(Tmp)) {
                    char.ptr i = Native.$tryClone((char.ptr)this.skip_s_white(Tmp));
                    if (Native.$noteq_ptr((void.ptr)i, (void.ptr)Tmp)) {
                        if (LeadingBlanks && Unsigned.$less_uint((int)this.Column, (int)indent) && Tmp.$star() == 9) {
                            this.setError(new Twine("Found invalid tab character in indentation"), Tmp);
                            boolean bl = false;
                            return bl;
                        }
                        Tmp = Native.$tryClone((char.ptr)i);
                        ++this.Column;
                        continue;
                    }
                    i = Native.$tryClone((char.ptr)this.skip_b_break(Tmp));
                    if (!LeadingBlanks) {
                        LeadingBlanks = true;
                    }
                    Tmp = Native.$tryClone((char.ptr)i);
                    this.Column = 0;
                    ++this.Line;
                }
                if (this.FlowLevel == 0 && Unsigned.$less_uint((int)this.Column, (int)indent)) break;
                this.Current = Native.$tryClone((char.ptr)Tmp);
            }
            if (Native.$eq_ptr((void.ptr)Start2, (void.ptr)this.Current)) {
                this.setError(new Twine("Got empty plain scalar"), Start2);
                boolean bl = false;
                return bl;
            }
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_Scalar;
            T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
            this.TokenQueue.push_back(T4);
            this.saveSimpleKeyCandidate(new ilist_iterator<Token>(((ilist_iterator)this.TokenQueue.end()).$preDec()), ColStart, false);
            this.IsSimpleKeyAllowed = false;
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanAliasOrAnchor(boolean IsAlias) {
        Token T4 = null;
        try {
            char.ptr i;
            char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
            int ColStart = this.Column;
            this.skip(1);
            while (this.Current.$star() != 91 && this.Current.$star() != 93 && this.Current.$star() != 123 && this.Current.$star() != 125 && this.Current.$star() != 44 && this.Current.$star() != 58 && !Native.$eq_ptr((void.ptr)(i = Native.$tryClone((char.ptr)this.skip_ns_char(this.Current))), (void.ptr)this.Current)) {
                this.Current = Native.$tryClone((char.ptr)i);
                ++this.Column;
            }
            if (Native.$eq_ptr((void.ptr)Start2, (void.ptr)this.Current)) {
                this.setError(new Twine("Got empty alias or anchor"), Start2);
                boolean bl = false;
                return bl;
            }
            T4 = new Token();
            T4.Kind = IsAlias ? Token.TokenKind.TK_Alias : Token.TokenKind.TK_Anchor;
            T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
            this.TokenQueue.push_back(T4);
            this.saveSimpleKeyCandidate(new ilist_iterator<Token>(((ilist_iterator)this.TokenQueue.end()).$preDec()), ColStart, false);
            this.IsSimpleKeyAllowed = false;
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanBlockScalar(boolean IsLiteral) {
        Token T4 = null;
        try {
            assert (this.Current.$star() == 124 || this.Current.$star() == 62);
            this.skip(1);
            char.ref ChompingIndicator = NativePointer.create_char$ref((byte)0);
            uint.ref BlockIndent = NativePointer.create_uint$ref();
            bool.ref IsDone = NativePointer.create_bool$ref((boolean)false);
            if (!this.scanBlockScalarHeader(ChompingIndicator, BlockIndent, IsDone)) {
                boolean bl = false;
                return bl;
            }
            if (IsDone.$deref()) {
                boolean bl = true;
                return bl;
            }
            char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
            int BlockExitIndent = this.Indent < 0 ? 0 : this.Indent;
            uint.ref LineBreaks = NativePointer.create_uint$ref((int)0);
            if (BlockIndent.$deref() == 0 && !this.findBlockScalarIndent(BlockIndent, BlockExitIndent, LineBreaks, IsDone)) {
                boolean bl = false;
                return bl;
            }
            SmallString Str = new SmallString(256);
            while (!IsDone.$deref()) {
                if (!this.scanBlockScalarIndent(BlockIndent.$deref(), BlockExitIndent, IsDone)) {
                    boolean bl = false;
                    return bl;
                }
                if (IsDone.$deref()) break;
                char.ptr LineStart = Native.$tryClone((char.ptr)this.Current);
                this.advanceWhile(Scanner::skip_nb_char);
                if (Native.$noteq_ptr((void.ptr)LineStart, (void.ptr)this.Current)) {
                    Str.append(LineBreaks.$deref(), (byte)10);
                    Str.append(new StringRef(LineStart, this.Current.$sub((abstract_iterator)LineStart)));
                    LineBreaks.$set(0);
                }
                if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End) || !this.consumeLineBreakIfPresent()) break;
                LineBreaks.$set$preInc();
            }
            if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End) && LineBreaks.$deref() == 0) {
                LineBreaks.$set(1);
            }
            Str.append(YAMLParserStatics.getChompedLineBreaks(ChompingIndicator.$deref(), LineBreaks.$deref(), Str.$StringRef()), (byte)10);
            if (this.FlowLevel == 0) {
                this.IsSimpleKeyAllowed = true;
            }
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_BlockScalar;
            T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
            T4.Value.$assignMove(Str.str().str());
            this.TokenQueue.push_back(T4);
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    private byte scanBlockChompingIndicator() {
        byte Indicator = 32;
        if (Native.$noteq_ptr((void.ptr)this.Current, (void.ptr)this.End) && (this.Current.$star() == 43 || this.Current.$star() == 45)) {
            Indicator = this.Current.$star();
            this.skip(1);
        }
        return Indicator;
    }

    private int scanBlockIndentationIndicator() {
        int Indent = 0;
        if (Native.$noteq_ptr((void.ptr)this.Current, (void.ptr)this.End) && this.Current.$star() >= 49 && this.Current.$star() <= 57) {
            Indent = this.Current.$star() - 48;
            this.skip(1);
        }
        return Indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanBlockScalarHeader(char.ref ChompingIndicator, uint.ref IndentIndicator, bool.ref IsDone) {
        char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
        ChompingIndicator.$set(this.scanBlockChompingIndicator());
        IndentIndicator.$set(this.scanBlockIndentationIndicator());
        if (ChompingIndicator.$deref() == 32) {
            ChompingIndicator.$set(this.scanBlockChompingIndicator());
        }
        this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_s_white, this.Current));
        this.skipComment();
        if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End)) {
            Token T4 = null;
            try {
                T4 = new Token();
                T4.Kind = Token.TokenKind.TK_BlockScalar;
                T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
                this.TokenQueue.push_back(T4);
                IsDone.$set(true);
                boolean bl = true;
                return bl;
            }
            finally {
                if (T4 != null) {
                    T4.$destroy();
                }
            }
        }
        if (!this.consumeLineBreakIfPresent()) {
            this.setError(new Twine("Expected a line break after block scalar header"), this.Current);
            return false;
        }
        return true;
    }

    private boolean findBlockScalarIndent(uint.ref BlockIndent, int BlockExitIndent, uint.ref LineBreaks, bool.ref IsDone) {
        int MaxAllSpaceLineCharacters = 0;
        char.ptr LongestAllSpaceLine = NativePointer.create_char$ptr();
        while (true) {
            this.advanceWhile(Scanner::skip_s_space);
            if (Native.$noteq_ptr((void.ptr)this.skip_nb_char(this.Current), (void.ptr)this.Current)) {
                if (Unsigned.$lesseq_uint((int)this.Column, (int)BlockExitIndent)) {
                    IsDone.$set(true);
                    return true;
                }
                BlockIndent.$set(this.Column);
                if (Unsigned.$greater_uint((int)MaxAllSpaceLineCharacters, (int)BlockIndent.$deref())) {
                    this.setError(new Twine("Leading all-spaces line must be smaller than the block indent"), LongestAllSpaceLine);
                    return false;
                }
                return true;
            }
            if (Native.$noteq_ptr((void.ptr)this.skip_b_break(this.Current), (void.ptr)this.Current) && Unsigned.$greater_uint((int)this.Column, (int)MaxAllSpaceLineCharacters)) {
                MaxAllSpaceLineCharacters = this.Column;
                LongestAllSpaceLine = Native.$tryClone((char.ptr)this.Current);
            }
            if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End)) {
                IsDone.$set(true);
                return true;
            }
            if (!this.consumeLineBreakIfPresent()) {
                IsDone.$set(true);
                return true;
            }
            LineBreaks.$set$preInc();
        }
    }

    private boolean scanBlockScalarIndent(int BlockIndent, int BlockExitIndent, bool.ref IsDone) {
        char.ptr I;
        while (Unsigned.$less_uint((int)this.Column, (int)BlockIndent) && !Native.$eq_ptr((void.ptr)(I = Native.$tryClone((char.ptr)this.skip_s_space(this.Current))), (void.ptr)this.Current)) {
            this.Current = Native.$tryClone((char.ptr)I);
            ++this.Column;
        }
        if (Native.$eq_ptr((void.ptr)this.skip_nb_char(this.Current), (void.ptr)this.Current)) {
            return true;
        }
        if (Unsigned.$lesseq_uint((int)this.Column, (int)BlockExitIndent)) {
            IsDone.$set(true);
            return true;
        }
        if (Unsigned.$less_uint((int)this.Column, (int)BlockIndent)) {
            if (Native.$noteq_ptr((void.ptr)this.Current, (void.ptr)this.End) && this.Current.$star() == 35) {
                IsDone.$set(true);
                return true;
            }
            this.setError(new Twine("A text line is less indented than the block scalar"), this.Current);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanTag() {
        Token T4 = null;
        try {
            char.ptr Start2 = Native.$tryClone((char.ptr)this.Current);
            int ColStart = this.Column;
            this.skip(1);
            if (!Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End) && !this.isBlankOrBreak(this.Current)) {
                if (this.Current.$star() == 60) {
                    this.skip(1);
                    this.scan_ns_uri_char();
                    if (!this.consume(Unsigned.$char2uint((byte)62))) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.Current = Native.$tryClone((char.ptr)this.skip_while(Scanner::skip_ns_char, this.Current));
                }
            }
            T4 = new Token();
            T4.Kind = Token.TokenKind.TK_Tag;
            T4.Range.$assignMove(new StringRef(Start2, this.Current.$sub((abstract_iterator)Start2)));
            this.TokenQueue.push_back(T4);
            this.saveSimpleKeyCandidate(new ilist_iterator<Token>(((ilist_iterator)this.TokenQueue.end()).$preDec()), ColStart, false);
            this.IsSimpleKeyAllowed = false;
            boolean bl = true;
            return bl;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    private boolean fetchMoreTokens() {
        if (this.IsStartOfStream) {
            return this.scanStreamStart();
        }
        this.scanToNextToken();
        if (Native.$eq_ptr((void.ptr)this.Current, (void.ptr)this.End)) {
            return this.scanStreamEnd();
        }
        this.removeStaleSimpleKeyCandidates();
        this.unrollIndent(this.Column);
        if (this.Column == 0 && this.Current.$star() == 37) {
            return this.scanDirective();
        }
        if (this.Column == 0 && ((char.ptr)this.Current.$add(4)).$lesseq((Object)this.End) && this.Current.$star() == 45 && ((char.ptr)this.Current.$add(1)).$star() == 45 && ((char.ptr)this.Current.$add(2)).$star() == 45 && (Native.$eq_ptr((void.ptr)((char.ptr)this.Current.$add(3)), (void.ptr)this.End) || this.isBlankOrBreak((char.ptr)this.Current.$add(3)))) {
            return this.scanDocumentIndicator(true);
        }
        if (this.Column == 0 && ((char.ptr)this.Current.$add(4)).$lesseq((Object)this.End) && this.Current.$star() == 46 && ((char.ptr)this.Current.$add(1)).$star() == 46 && ((char.ptr)this.Current.$add(2)).$star() == 46 && (Native.$eq_ptr((void.ptr)((char.ptr)this.Current.$add(3)), (void.ptr)this.End) || this.isBlankOrBreak((char.ptr)this.Current.$add(3)))) {
            return this.scanDocumentIndicator(false);
        }
        if (this.Current.$star() == 91) {
            return this.scanFlowCollectionStart(true);
        }
        if (this.Current.$star() == 123) {
            return this.scanFlowCollectionStart(false);
        }
        if (this.Current.$star() == 93) {
            return this.scanFlowCollectionEnd(true);
        }
        if (this.Current.$star() == 125) {
            return this.scanFlowCollectionEnd(false);
        }
        if (this.Current.$star() == 44) {
            return this.scanFlowEntry();
        }
        if (this.Current.$star() == 45 && this.isBlankOrBreak((char.ptr)this.Current.$add(1))) {
            return this.scanBlockEntry();
        }
        if (this.Current.$star() == 63 && (this.FlowLevel != 0 || this.isBlankOrBreak((char.ptr)this.Current.$add(1)))) {
            return this.scanKey();
        }
        if (this.Current.$star() == 58 && (this.FlowLevel != 0 || this.isBlankOrBreak((char.ptr)this.Current.$add(1)))) {
            return this.scanValue();
        }
        if (this.Current.$star() == 42) {
            return this.scanAliasOrAnchor(true);
        }
        if (this.Current.$star() == 38) {
            return this.scanAliasOrAnchor(false);
        }
        if (this.Current.$star() == 33) {
            return this.scanTag();
        }
        if (this.Current.$star() == 124 && this.FlowLevel == 0) {
            return this.scanBlockScalar(true);
        }
        if (this.Current.$star() == 62 && this.FlowLevel == 0) {
            return this.scanBlockScalar(false);
        }
        if (this.Current.$star() == 39) {
            return this.scanFlowScalar(false);
        }
        if (this.Current.$star() == 34) {
            return this.scanFlowScalar(true);
        }
        StringRef FirstChar = new StringRef(this.Current, 1);
        if (!this.isBlankOrBreak(this.Current) && FirstChar.find_first_of("-?:,[]{}#&*!|>'\"%@`") == StringRef.npos || this.Current.$star() == 45 && !this.isBlankOrBreak((char.ptr)this.Current.$add(1)) || this.FlowLevel == 0 && (this.Current.$star() == 63 || this.Current.$star() == 58) && this.isBlankOrBreak((char.ptr)this.Current.$add(1)) || this.FlowLevel == 0 && this.Current.$star() == 58 && ((char.ptr)this.Current.$add(2)).$less((Object)this.End) && ((char.ptr)this.Current.$add(1)).$star() == 58 && !this.isBlankOrBreak((char.ptr)this.Current.$add(2))) {
            return this.scanPlainScalar();
        }
        this.setError(new Twine("Unrecognized character while tokenizing."));
        return false;
    }

    public void $destroy() {
        this.SimpleKeys.$destroy();
        this.Indents.$destroy();
        this.TokenQueue.$destroy();
    }

    public String toString() {
        return "SM=" + this.SM + ", InputBuffer=" + this.InputBuffer + ", Current=" + this.Current + ", End=" + this.End + ", Indent=" + this.Indent + ", Column=" + this.Column + ", Line=" + this.Line + ", FlowLevel=" + this.FlowLevel + ", IsStartOfStream=" + this.IsStartOfStream + ", IsSimpleKeyAllowed=" + this.IsSimpleKeyAllowed + ", Failed=" + this.Failed + ", ShowColors=" + this.ShowColors + ", TokenQueue=" + this.TokenQueue + ", Indents=" + this.Indents + ", SimpleKeys=" + this.SimpleKeys;
    }
}

