/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.yaml;

import java.util.Iterator;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.aliases.JavaIterator;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.java.MappingSequenceInterface;
import org.llvm.support.yaml.Document;
import org.llvm.support.yaml.Node;
import org.llvm.support.yaml.YamlGlobals;
import org.llvm.support.yaml.basic_collection_iterator;
import org.llvm.support.yaml.impl.Token;

public final class SequenceNode
extends Node
implements Iterable<Node>,
MappingSequenceInterface {
    private SequenceType SeqType;
    private boolean IsAtBeginning;
    private boolean IsAtEnd;
    private boolean WasPreviousTokenFlowEntry;
    private Node CurrentEntry;

    @Override
    protected void anchor() {
    }

    public SequenceNode(std_ptr.unique_ptr<Document> D, StringRef Anchor, StringRef Tag2, SequenceType ST) {
        super(Node.NodeKind.NK_Sequence.getValue(), D, new StringRef(Anchor), new StringRef(Tag2));
        this.SeqType = ST;
        this.IsAtBeginning = true;
        this.IsAtEnd = false;
        this.WasPreviousTokenFlowEntry = true;
        this.CurrentEntry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void increment() {
        Token T4;
        block40: {
            T4 = null;
            if (this.failed()) {
                this.IsAtEnd = true;
                this.CurrentEntry = null;
                return;
            }
            if (this.CurrentEntry != null) {
                this.CurrentEntry.skip();
            }
            T4 = new Token(this.peekNext());
            if (this.SeqType == SequenceType.ST_Block) {
                switch (T4.Kind) {
                    case TK_BlockEntry: {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                            this.CurrentEntry = this.parseBlockNode();
                            if (this.CurrentEntry != null) return;
                            this.IsAtEnd = true;
                            this.CurrentEntry = null;
                            return;
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                    case TK_BlockEnd: {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                            this.IsAtEnd = true;
                            this.CurrentEntry = null;
                            return;
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                    default: {
                        this.setError(new Twine("Unexpected token. Expected Block Entry or Block End."), T4);
                    }
                    case TK_Error: 
                }
                this.IsAtEnd = true;
                this.CurrentEntry = null;
                return;
            }
            if (this.SeqType == SequenceType.ST_Indentless) {
                switch (T4.Kind) {
                    case TK_BlockEntry: {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                            this.CurrentEntry = this.parseBlockNode();
                            if (this.CurrentEntry != null) return;
                            this.IsAtEnd = true;
                            this.CurrentEntry = null;
                            return;
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                }
                this.IsAtEnd = true;
                this.CurrentEntry = null;
                return;
            }
            if (this.SeqType != SequenceType.ST_Flow) return;
            switch (T4.Kind) {
                case TK_FlowEntry: {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                        this.WasPreviousTokenFlowEntry = true;
                        this.increment();
                        return;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                case TK_FlowSequenceEnd: {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                case TK_Error: {
                    this.IsAtEnd = true;
                    this.CurrentEntry = null;
                    return;
                }
                case TK_StreamEnd: 
                case TK_DocumentEnd: 
                case TK_DocumentStart: {
                    this.setError(new Twine("Could not find closing ]!"), T4);
                    this.IsAtEnd = true;
                    this.CurrentEntry = null;
                    return;
                }
            }
            if (this.WasPreviousTokenFlowEntry) break block40;
            this.setError(new Twine("Expected , between entries!"), T4);
            this.IsAtEnd = true;
            this.CurrentEntry = null;
            return;
        }
        this.CurrentEntry = this.parseBlockNode();
        if (this.CurrentEntry == null) {
            this.IsAtEnd = true;
        }
        this.WasPreviousTokenFlowEntry = false;
        return;
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    public basic_collection_iterator<SequenceNode, Node> begin() {
        return YamlGlobals.begin(this);
    }

    public basic_collection_iterator<SequenceNode, Node> end() {
        return new basic_collection_iterator<SequenceNode, Node>();
    }

    @Override
    public void skip() {
        YamlGlobals.skip(this);
    }

    public static boolean classof(Node N) {
        return N.getType() == Node.NodeKind.NK_Sequence.getValue();
    }

    @Override
    public Iterator<Node> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    @Override
    public boolean isAtBeginning() {
        return this.IsAtBeginning;
    }

    @Override
    public void setAtBeginning(boolean v) {
        this.IsAtBeginning = v;
    }

    @Override
    public boolean isAtEnd() {
        return this.IsAtEnd;
    }

    @Override
    public void setAtEnd(boolean v) {
        this.IsAtEnd = v;
    }

    @Override
    public Node getCurrentEntry() {
        return this.CurrentEntry;
    }

    @Override
    public String toString() {
        return "SeqType=" + (Object)((Object)this.SeqType) + ", IsAtBeginning=" + this.IsAtBeginning + ", IsAtEnd=" + this.IsAtEnd + ", WasPreviousTokenFlowEntry=" + this.WasPreviousTokenFlowEntry + ", CurrentEntry=" + this.CurrentEntry + super.toString();
    }

    public static final class SequenceType
    extends Enum<SequenceType>
    implements Native.NativeUIntEnum {
        public static final /* enum */ SequenceType ST_Block = new SequenceType(0);
        public static final /* enum */ SequenceType ST_Flow = new SequenceType(ST_Block.getValue() + 1);
        public static final /* enum */ SequenceType ST_Indentless = new SequenceType(ST_Flow.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SequenceType[] $VALUES;

        public static SequenceType[] values() {
            return (SequenceType[])$VALUES.clone();
        }

        public static SequenceType valueOf(String name) {
            return Enum.valueOf(SequenceType.class, name);
        }

        public static SequenceType valueOf(int val) {
            SequenceType out;
            SequenceType sequenceType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SequenceType(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new SequenceType[]{ST_Block, ST_Flow, ST_Indentless};
        }

        private static final class Values {
            private static final SequenceType[] VALUES;
            private static final SequenceType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SequenceType kind : SequenceType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SequenceType[min < 0 ? 1 - min : 0];
                VALUES = new SequenceType[max >= 0 ? 1 + max : 0];
                for (SequenceType kind : SequenceType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((SequenceType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((SequenceType)kind).value] = kind;
                }
            }
        }
    }
}

