/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.impl.LineIteratorStatics;

public class line_iterator
implements std.iterator<std.forward_iterator_tag, StringRef>,
type.iterator<line_iterator, StringRef> {
    private MemoryBuffer Buffer;
    private byte CommentMarker;
    private boolean SkipBlanks;
    private int LineNumber;
    private StringRef CurrentLine;

    public line_iterator() {
        this.$iterator();
        this.Buffer = null;
        this.CurrentLine = new StringRef();
    }

    public line_iterator(MemoryBuffer Buffer) {
        this(Buffer, true, 0);
    }

    public line_iterator(MemoryBuffer Buffer, boolean SkipBlanks) {
        this(Buffer, SkipBlanks, 0);
    }

    public line_iterator(MemoryBuffer Buffer, boolean SkipBlanks, byte CommentMarker) {
        this.$iterator();
        this.Buffer = Buffer.getBufferSize() != 0 ? (MemoryBuffer)Native.$AddrOf((Object)Buffer) : null;
        this.CommentMarker = CommentMarker;
        this.SkipBlanks = SkipBlanks;
        this.LineNumber = 1;
        this.CurrentLine = new StringRef(Buffer.getBufferSize() != 0 ? Buffer.getBufferStart() : (char.ptr)null, 0);
        if (Buffer.getBufferSize() != 0) {
            assert (Buffer.getBufferEnd().$at(0) == 0);
            if (SkipBlanks || !LineIteratorStatics.isAtLineEnd(Buffer.getBufferStart())) {
                this.advance();
            }
        }
    }

    public boolean is_at_eof() {
        return this.Buffer == null;
    }

    public boolean is_at_end() {
        return this.is_at_eof();
    }

    public long line_number() {
        return Unsigned.$uint2long((int)this.LineNumber);
    }

    public line_iterator $preInc() {
        this.advance();
        return this;
    }

    public line_iterator $postInc(int $Prm0) {
        line_iterator tmp = new line_iterator(this);
        this.advance();
        return tmp;
    }

    public StringRef $star() {
        return new StringRef(this.CurrentLine);
    }

    public StringRef $arrow() {
        return (StringRef)Native.$AddrOf((Object)this.CurrentLine);
    }

    public static boolean $eq_line_iterator$C(line_iterator LHS, line_iterator RHS) {
        return LHS.Buffer == RHS.Buffer && Native.$eq_ptr((void.ptr)LHS.CurrentLine.begin(), (void.ptr)RHS.CurrentLine.begin());
    }

    public static boolean $noteq_line_iterator$C(line_iterator LHS, line_iterator RHS) {
        return !line_iterator.$eq_line_iterator$C(LHS, RHS);
    }

    private void advance() {
        assert (this.Buffer != null) : "Cannot advance past the end!";
        char.ptr Pos2 = Native.$tryClone((char.ptr)this.CurrentLine.end());
        assert (Native.$eq_ptr((void.ptr)Pos2, (void.ptr)this.Buffer.getBufferStart()) || LineIteratorStatics.isAtLineEnd(Pos2) || Pos2.$star() == 0);
        if (LineIteratorStatics.skipIfAtLineEnd(Pos2)) {
            ++this.LineNumber;
        }
        if (this.SkipBlanks || !LineIteratorStatics.isAtLineEnd(Pos2)) {
            if (this.CommentMarker == 0) {
                while (LineIteratorStatics.skipIfAtLineEnd(Pos2)) {
                    ++this.LineNumber;
                }
            } else {
                while (!LineIteratorStatics.isAtLineEnd(Pos2) || this.SkipBlanks) {
                    if (Pos2.$star() == this.CommentMarker) {
                        do {
                            Pos2.$preInc();
                        } while (Pos2.$star() != 0 && !LineIteratorStatics.isAtLineEnd(Pos2));
                    }
                    if (LineIteratorStatics.skipIfAtLineEnd(Pos2)) {
                        ++this.LineNumber;
                        continue;
                    }
                    break;
                }
            }
        }
        if (Pos2.$star() == 0) {
            this.Buffer = null;
            this.CurrentLine.$assignMove(new StringRef());
            return;
        }
        int Length = 0;
        while (Pos2.$at(Length) != 0 && !LineIteratorStatics.isAtLineEnd((char.ptr)Pos2.$add(Length))) {
            ++Length;
        }
        this.CurrentLine.$assignMove(new StringRef(Pos2, Length));
    }

    public line_iterator(line_iterator $Prm0) {
        this.$iterator($Prm0);
        this.Buffer = $Prm0.Buffer;
        this.CommentMarker = $Prm0.CommentMarker;
        this.SkipBlanks = $Prm0.SkipBlanks;
        this.LineNumber = $Prm0.LineNumber;
        this.CurrentLine = new StringRef($Prm0.CurrentLine);
    }

    public line_iterator(JavaDifferentiators.JD.Move _dparam, line_iterator $Prm0) {
        this.$iterator(JavaDifferentiators.JD.Move.INSTANCE, $Prm0);
        this.Buffer = $Prm0.Buffer;
        this.CommentMarker = $Prm0.CommentMarker;
        this.SkipBlanks = $Prm0.SkipBlanks;
        this.LineNumber = $Prm0.LineNumber;
        this.CurrentLine = new StringRef(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.CurrentLine);
    }

    public boolean $eq(Object other) {
        return line_iterator.$eq_line_iterator$C(this, (line_iterator)other);
    }

    public line_iterator clone() {
        return new line_iterator(this);
    }

    public String toString() {
        return "Buffer=" + (this.Buffer != null ? this.Buffer.getBufferIdentifier() : "<null>") + ", CommentMarker=" + Casts.$char((byte)this.CommentMarker) + ", SkipBlanks=" + this.SkipBlanks + ", LineNumber=" + this.LineNumber + ", CurrentLine=\n[" + this.CurrentLine.toJavaString() + "]";
    }
}

