/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.sys;
import org.llvm.support.target.ARM;

public final class TripleStatics {
    public static Triple.ArchType parseBPFArch(StringRef ArchName) {
        if (ArchName.equals("bpf")) {
            if (sys.IsLittleEndianHost) {
                return Triple.ArchType.bpfel;
            }
            return Triple.ArchType.bpfeb;
        }
        if (ArchName.equals("bpf_be") || ArchName.equals("bpfeb")) {
            return Triple.ArchType.bpfeb;
        }
        if (ArchName.equals("bpf_le") || ArchName.equals("bpfel")) {
            return Triple.ArchType.bpfel;
        }
        return Triple.ArchType.UnknownArch;
    }

    public static Triple.ArchType parseARMArch(StringRef ArchName) {
        int ISA = ARM.parseArchISA(ArchName);
        int ENDIAN = ARM.parseArchEndian(ArchName);
        Triple.ArchType arch = Triple.ArchType.UnknownArch;
        block0 : switch (ARM.EndianKind.valueOf(ENDIAN)) {
            case EK_LITTLE: {
                switch (ARM.ISAKind.valueOf(ISA)) {
                    case IK_ARM: {
                        arch = Triple.ArchType.arm;
                        break;
                    }
                    case IK_THUMB: {
                        arch = Triple.ArchType.thumb;
                        break;
                    }
                    case IK_AARCH64: {
                        arch = Triple.ArchType.aarch64;
                    }
                }
                break;
            }
            case EK_BIG: {
                switch (ARM.ISAKind.valueOf(ISA)) {
                    case IK_ARM: {
                        arch = Triple.ArchType.armeb;
                        break block0;
                    }
                    case IK_THUMB: {
                        arch = Triple.ArchType.thumbeb;
                        break block0;
                    }
                    case IK_AARCH64: {
                        arch = Triple.ArchType.aarch64_be;
                    }
                }
            }
        }
        ArchName.$assignMove(ARM.getCanonicalArchName(ArchName));
        if (ArchName.empty()) {
            return Triple.ArchType.UnknownArch;
        }
        if (ISA == ARM.ISAKind.IK_THUMB.getValue() && (ArchName.startswith("v2") || ArchName.startswith("v3"))) {
            return Triple.ArchType.UnknownArch;
        }
        int Profile = ARM.parseArchProfile(ArchName);
        int Version = ARM.parseArchVersion(ArchName);
        if (Profile == ARM.ProfileKind.PK_M.getValue() && Version == 6) {
            if (ENDIAN == ARM.EndianKind.EK_BIG.getValue()) {
                return Triple.ArchType.thumbeb;
            }
            return Triple.ArchType.thumb;
        }
        return arch;
    }

    public static Triple.ArchType parseArch(StringRef ArchName) {
        Triple.ArchType AT = new StringSwitch<Triple.ArchType>(ArchName).Cases("i386", "i486", "i586", "i686", Triple.ArchType.x86).Cases("i786", "i886", "i986", Triple.ArchType.x86).Cases("amd64", "x86_64", "x86_64h", Triple.ArchType.x86_64).Cases("powerpc", "ppc32", Triple.ArchType.ppc).Cases("powerpc64", "ppu", "ppc64", Triple.ArchType.ppc64).Cases("powerpc64le", "ppc64le", Triple.ArchType.ppc64le).Case("xscale", Triple.ArchType.arm).Case("xscaleeb", Triple.ArchType.armeb).Case("aarch64", Triple.ArchType.aarch64).Case("aarch64_be", Triple.ArchType.aarch64_be).Case("arm64", Triple.ArchType.aarch64).Case("arm", Triple.ArchType.arm).Case("armeb", Triple.ArchType.armeb).Case("thumb", Triple.ArchType.thumb).Case("thumbeb", Triple.ArchType.thumbeb).Case("avr", Triple.ArchType.avr).Case("msp430", Triple.ArchType.msp430).Cases("mips", "mipseb", "mipsallegrex", Triple.ArchType.mips).Cases("mipsel", "mipsallegrexel", Triple.ArchType.mipsel).Cases("mips64", "mips64eb", Triple.ArchType.mips64).Case("mips64el", Triple.ArchType.mips64el).Case("r600", Triple.ArchType.r600).Case("amdgcn", Triple.ArchType.amdgcn).Case("hexagon", Triple.ArchType.hexagon).Cases("s390x", "systemz", Triple.ArchType.systemz).Case("sparc", Triple.ArchType.sparc).Case("sparcel", Triple.ArchType.sparcel).Cases("sparcv9", "sparc64", Triple.ArchType.sparcv9).Case("tce", Triple.ArchType.tce).Case("xcore", Triple.ArchType.xcore).Case("nvptx", Triple.ArchType.nvptx).Case("nvptx64", Triple.ArchType.nvptx64).Case("le32", Triple.ArchType.le32).Case("le64", Triple.ArchType.le64).Case("amdil", Triple.ArchType.amdil).Case("amdil64", Triple.ArchType.amdil64).Case("hsail", Triple.ArchType.hsail).Case("hsail64", Triple.ArchType.hsail64).Case("spir", Triple.ArchType.spir).Case("spir64", Triple.ArchType.spir64).StartsWith("kalimba", Triple.ArchType.kalimba).Case("lanai", Triple.ArchType.lanai).Case("shave", Triple.ArchType.shave).Case("wasm32", Triple.ArchType.wasm32).Case("wasm64", Triple.ArchType.wasm64).Case("renderscript32", Triple.ArchType.renderscript32).Case("renderscript64", Triple.ArchType.renderscript64).Default(Triple.ArchType.UnknownArch);
        if (AT == Triple.ArchType.UnknownArch) {
            if (ArchName.startswith("arm") || ArchName.startswith("thumb") || ArchName.startswith("aarch64")) {
                return TripleStatics.parseARMArch(new StringRef(ArchName));
            }
            if (ArchName.startswith("bpf")) {
                return TripleStatics.parseBPFArch(ArchName);
            }
        }
        return AT;
    }

    public static Triple.VendorType parseVendor(StringRef VendorName) {
        return new StringSwitch<Triple.VendorType>(VendorName).Case("apple", Triple.VendorType.Apple).Case("pc", Triple.VendorType.PC).Case("scei", Triple.VendorType.SCEI).Case("bgp", Triple.VendorType.BGP).Case("bgq", Triple.VendorType.BGQ).Case("fsl", Triple.VendorType.Freescale).Case("ibm", Triple.VendorType.IBM).Case("img", Triple.VendorType.ImaginationTechnologies).Case("mti", Triple.VendorType.MipsTechnologies).Case("nvidia", Triple.VendorType.NVIDIA).Case("csr", Triple.VendorType.CSR).Case("myriad", Triple.VendorType.Myriad).Case("amd", Triple.VendorType.AMD).Case("mesa", Triple.VendorType.Mesa).Default(Triple.VendorType.UnknownVendor);
    }

    public static Triple.OSType parseOS(StringRef OSName) {
        return new StringSwitch<Triple.OSType>(OSName).StartsWith("cloudabi", Triple.OSType.CloudABI).StartsWith("darwin", Triple.OSType.Darwin).StartsWith("dragonfly", Triple.OSType.DragonFly).StartsWith("freebsd", Triple.OSType.FreeBSD).StartsWith("ios", Triple.OSType.IOS).StartsWith("kfreebsd", Triple.OSType.KFreeBSD).StartsWith("linux", Triple.OSType.Linux).StartsWith("lv2", Triple.OSType.Lv2).StartsWith("macosx", Triple.OSType.MacOSX).StartsWith("netbsd", Triple.OSType.NetBSD).StartsWith("openbsd", Triple.OSType.OpenBSD).StartsWith("solaris", Triple.OSType.Solaris).StartsWith("win32", Triple.OSType.Win32).StartsWith("windows", Triple.OSType.Win32).StartsWith("haiku", Triple.OSType.Haiku).StartsWith("minix", Triple.OSType.Minix).StartsWith("rtems", Triple.OSType.RTEMS).StartsWith("nacl", Triple.OSType.NaCl).StartsWith("cnk", Triple.OSType.CNK).StartsWith("bitrig", Triple.OSType.Bitrig).StartsWith("aix", Triple.OSType.AIX).StartsWith("cuda", Triple.OSType.CUDA).StartsWith("nvcl", Triple.OSType.NVCL).StartsWith("amdhsa", Triple.OSType.AMDHSA).StartsWith("ps4", Triple.OSType.PS4).StartsWith("elfiamcu", Triple.OSType.ELFIAMCU).StartsWith("tvos", Triple.OSType.TvOS).StartsWith("watchos", Triple.OSType.WatchOS).StartsWith("mesa3d", Triple.OSType.Mesa3D).Default(Triple.OSType.UnknownOS);
    }

    public static Triple.EnvironmentType parseEnvironment(StringRef EnvironmentName) {
        return new StringSwitch<Triple.EnvironmentType>(EnvironmentName).StartsWith("eabihf", Triple.EnvironmentType.EABIHF).StartsWith("eabi", Triple.EnvironmentType.EABI).StartsWith("gnuabi64", Triple.EnvironmentType.GNUABI64).StartsWith("gnueabihf", Triple.EnvironmentType.GNUEABIHF).StartsWith("gnueabi", Triple.EnvironmentType.GNUEABI).StartsWith("gnux32", Triple.EnvironmentType.GNUX32).StartsWith("code16", Triple.EnvironmentType.CODE16).StartsWith("gnu", Triple.EnvironmentType.GNU).StartsWith("android", Triple.EnvironmentType.Android).StartsWith("musleabihf", Triple.EnvironmentType.MuslEABIHF).StartsWith("musleabi", Triple.EnvironmentType.MuslEABI).StartsWith("musl", Triple.EnvironmentType.Musl).StartsWith("msvc", Triple.EnvironmentType.MSVC).StartsWith("itanium", Triple.EnvironmentType.Itanium).StartsWith("cygnus", Triple.EnvironmentType.Cygnus).StartsWith("amdopencl", Triple.EnvironmentType.AMDOpenCL).StartsWith("coreclr", Triple.EnvironmentType.CoreCLR).Default(Triple.EnvironmentType.UnknownEnvironment);
    }

    public static Triple.ObjectFormatType parseFormat(StringRef EnvironmentName) {
        return new StringSwitch<Triple.ObjectFormatType>(EnvironmentName).EndsWith("coff", Triple.ObjectFormatType.COFF).EndsWith("elf", Triple.ObjectFormatType.ELF).EndsWith("macho", Triple.ObjectFormatType.MachO).Default(Triple.ObjectFormatType.UnknownObjectFormat);
    }

    public static Triple.SubArchType parseSubArch(StringRef SubArchName) {
        StringRef ARMSubArch = ARM.getCanonicalArchName(SubArchName);
        if (ARMSubArch.empty()) {
            return new StringSwitch<Triple.SubArchType>(SubArchName).EndsWith("kalimba3", Triple.SubArchType.KalimbaSubArch_v3).EndsWith("kalimba4", Triple.SubArchType.KalimbaSubArch_v4).EndsWith("kalimba5", Triple.SubArchType.KalimbaSubArch_v5).Default(Triple.SubArchType.NoSubArch);
        }
        switch (ARM.ArchKind.valueOf(ARM.parseArch(ARMSubArch))) {
            case AK_ARMV4: {
                return Triple.SubArchType.NoSubArch;
            }
            case AK_ARMV4T: {
                return Triple.SubArchType.ARMSubArch_v4t;
            }
            case AK_ARMV5T: {
                return Triple.SubArchType.ARMSubArch_v5;
            }
            case AK_ARMV5TE: 
            case AK_IWMMXT: 
            case AK_IWMMXT2: 
            case AK_XSCALE: 
            case AK_ARMV5TEJ: {
                return Triple.SubArchType.ARMSubArch_v5te;
            }
            case AK_ARMV6: {
                return Triple.SubArchType.ARMSubArch_v6;
            }
            case AK_ARMV6K: 
            case AK_ARMV6KZ: {
                return Triple.SubArchType.ARMSubArch_v6k;
            }
            case AK_ARMV6T2: {
                return Triple.SubArchType.ARMSubArch_v6t2;
            }
            case AK_ARMV6M: {
                return Triple.SubArchType.ARMSubArch_v6m;
            }
            case AK_ARMV7A: 
            case AK_ARMV7R: {
                return Triple.SubArchType.ARMSubArch_v7;
            }
            case AK_ARMV7K: {
                return Triple.SubArchType.ARMSubArch_v7k;
            }
            case AK_ARMV7M: {
                return Triple.SubArchType.ARMSubArch_v7m;
            }
            case AK_ARMV7S: {
                return Triple.SubArchType.ARMSubArch_v7s;
            }
            case AK_ARMV7EM: {
                return Triple.SubArchType.ARMSubArch_v7em;
            }
            case AK_ARMV8A: {
                return Triple.SubArchType.ARMSubArch_v8;
            }
            case AK_ARMV8_1A: {
                return Triple.SubArchType.ARMSubArch_v8_1a;
            }
            case AK_ARMV8_2A: {
                return Triple.SubArchType.ARMSubArch_v8_2a;
            }
            case AK_ARMV8MBaseline: {
                return Triple.SubArchType.ARMSubArch_v8m_baseline;
            }
            case AK_ARMV8MMainline: {
                return Triple.SubArchType.ARMSubArch_v8m_mainline;
            }
        }
        return Triple.SubArchType.NoSubArch;
    }

    public static char.ptr getObjectFormatTypeName(Triple.ObjectFormatType Kind2) {
        switch (Kind2) {
            case UnknownObjectFormat: {
                return NativePointer.$EMPTY;
            }
            case COFF: {
                return NativePointer.$((String)"coff");
            }
            case ELF: {
                return NativePointer.$((String)"elf");
            }
            case MachO: {
                return NativePointer.$((String)"macho");
            }
        }
        throw new llvm_unreachable("unknown object format type");
    }

    public static Triple.ObjectFormatType getDefaultFormat(Triple T4) {
        switch (T4.getArch()) {
            case UnknownArch: 
            case aarch64: 
            case arm: 
            case thumb: 
            case x86: 
            case x86_64: {
                if (T4.isOSDarwin()) {
                    return Triple.ObjectFormatType.MachO;
                }
                if (T4.isOSWindows()) {
                    return Triple.ObjectFormatType.COFF;
                }
                return Triple.ObjectFormatType.ELF;
            }
            case aarch64_be: 
            case amdgcn: 
            case amdil: 
            case amdil64: 
            case armeb: 
            case avr: 
            case bpfeb: 
            case bpfel: 
            case hexagon: 
            case lanai: 
            case hsail: 
            case hsail64: 
            case kalimba: 
            case le32: 
            case le64: 
            case mips: 
            case mips64: 
            case mips64el: 
            case mipsel: 
            case msp430: 
            case nvptx: 
            case nvptx64: 
            case ppc64le: 
            case r600: 
            case renderscript32: 
            case renderscript64: 
            case shave: 
            case sparc: 
            case sparcel: 
            case sparcv9: 
            case spir: 
            case spir64: 
            case systemz: 
            case tce: 
            case thumbeb: 
            case wasm32: 
            case wasm64: 
            case xcore: {
                return Triple.ObjectFormatType.ELF;
            }
            case ppc: 
            case ppc64: {
                if (T4.isOSDarwin()) {
                    return Triple.ObjectFormatType.MachO;
                }
                return Triple.ObjectFormatType.ELF;
            }
        }
        throw new llvm_unreachable("unknown architecture");
    }

    public static int EatNumber(StringRef Str) {
        assert (!Str.empty() && Str.$at(0) >= 48 && Str.$at(0) <= 57) : "Not a number";
        int Result = 0;
        do {
            Result = Result * 10 + (Str.$at(0) - 48);
            Str.$assignMove(Str.substr(1));
        } while (!Str.empty() && Str.$at(0) >= 48 && Str.$at(0) <= 57);
        return Result;
    }

    public static void parseVersionFromName(StringRef Name2, uint.ref Major, uint.ref Minor, uint.ref Micro) {
        Major.$set(Minor.$set(Micro.$set(0)));
        uint.ptr[] Components = new uint.ptr[]{Major.deref$ptr(), Minor.deref$ptr(), Micro.deref$ptr()};
        for (int i = 0; i != 3 && !Name2.empty() && Name2.$at(0) >= 48 && Name2.$at(0) <= 57; ++i) {
            Components[i].$set(TripleStatics.EatNumber(Name2));
            if (!Name2.startswith(".")) continue;
            Name2.$assignMove(Name2.substr(1));
        }
    }

    public static int getArchPointerBitWidth(Triple.ArchType Arch) {
        switch (Arch) {
            case UnknownArch: {
                return 0;
            }
            case avr: 
            case msp430: {
                return 16;
            }
            case arm: 
            case thumb: 
            case x86: 
            case amdil: 
            case armeb: 
            case hexagon: 
            case lanai: 
            case hsail: 
            case kalimba: 
            case le32: 
            case mips: 
            case mipsel: 
            case nvptx: 
            case r600: 
            case renderscript32: 
            case shave: 
            case sparc: 
            case sparcel: 
            case spir: 
            case tce: 
            case thumbeb: 
            case wasm32: 
            case xcore: 
            case ppc: {
                return 32;
            }
            case aarch64: 
            case x86_64: 
            case aarch64_be: 
            case amdgcn: 
            case amdil64: 
            case bpfeb: 
            case bpfel: 
            case hsail64: 
            case le64: 
            case mips64: 
            case mips64el: 
            case nvptx64: 
            case ppc64le: 
            case renderscript64: 
            case sparcv9: 
            case spir64: 
            case systemz: 
            case wasm64: 
            case ppc64: {
                return 64;
            }
        }
        throw new llvm_unreachable("Invalid architecture value");
    }
}

