/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.impl.MemoryBufferMMapFile;
import org.llvm.support.impl.NamedBufferAlloc;
import org.llvm.support.llvm;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.fs;

public final class MemoryBufferStatics {
    public static void CopyStringRef(char.ptr Memory2, StringRef Data) {
        std.memcpy((char.ptr)Memory2, (char.ptr)Data.data(), (int)Data.size());
        Memory2.$set(Data.size(), (byte)0);
        assert (std.strlen((char.ptr)Memory2) == Data.size()) : Memory2 + " vs. " + Data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char.ptr $new_uint_NamedBufferAlloc(int N, NamedBufferAlloc Alloc) {
        SmallString NameBuf = null;
        try {
            NameBuf = new SmallString(256);
            StringRef NameRef = Alloc.Name.toStringRef(NameBuf);
            char.ptr Mem = Native.$tryClone((char.ptr)std.$new_uint((int)(N + NameRef.size() + 1)));
            MemoryBufferStatics.CopyStringRef((char.ptr)Mem.$add(N), new StringRef(NameRef));
            char.ptr ptr2 = Mem;
            return ptr2;
        }
        finally {
            if (NameBuf != null) {
                NameBuf.$destroy();
            }
        }
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFileAux(Twine Filename, long FileSize, long MapSize, long Offset, boolean RequiresNullTerminator, boolean IsVolatileSize) {
        int.ref FD = NativePointer.create_int$ref();
        std_errors.error_code EC = fs.openFileForRead(Filename, FD);
        if (EC.$bool()) {
            return new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(new std_errors.error_code(EC));
        }
        ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> Ret = MemoryBufferStatics.getOpenFileImpl(FD.$deref(), Filename, FileSize, MapSize, Offset, RequiresNullTerminator, IsVolatileSize);
        std.close((int)FD.$deref());
        return Ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getMemoryBufferForStream(int FD, Twine BufferName) {
        SmallVectorImplChar Buffer = null;
        try {
            long ReadBytes;
            int ChunkSize = 16384;
            Buffer = new SmallString(ChunkSize);
            do {
                Buffer.reserve(Buffer.size() + ChunkSize);
                ReadBytes = std.read((int)FD, (char.iterator)Buffer.end(), (int)ChunkSize);
                if (ReadBytes == -1L) {
                    if (std.errno() == 4) continue;
                    ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(new std_errors.error_code(std.errno(), std.generic_category()));
                    return errorOr;
                }
                Buffer.set_size(Unsigned.$long2uint((long)((long)Buffer.size() + ReadBytes)));
            } while (ReadBytes != 0L);
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(MemoryBuffer.getMemBufferCopy(((SmallString)Buffer).$StringRef(), BufferName));
            return errorOr;
        }
        finally {
            if (Buffer != null) {
                Buffer.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getOpenFileImpl(int FD, Twine Filename, long FileSize, long MapSize, long Offset, boolean RequiresNullTerminator, boolean IsVolatileSize) {
        std_ptr.unique_ptr<MemoryBuffer> Buf;
        std_errors.error_code EC;
        int PageSize = Process.getPageSize();
        if (MapSize == -1L) {
            if (FileSize == -1L) {
                fs.file_status Status2 = new fs.file_status();
                EC = fs.status(FD, Status2);
                if (EC.$bool()) {
                    return new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(new std_errors.error_code(EC));
                }
                fs.file_type Type2 = Status2.type();
                if (Type2 != fs.file_type.regular_file && Type2 != fs.file_type.block_file) {
                    return MemoryBufferStatics.getMemoryBufferForStream(FD, Filename);
                }
                FileSize = Status2.getSize();
            }
            MapSize = FileSize;
        }
        if (MemoryBufferStatics.shouldUseMmap(FD, Unsigned.$long2uint((long)FileSize), Unsigned.$long2uint((long)MapSize), Offset, RequiresNullTerminator, PageSize, IsVolatileSize)) {
            std_ptr.unique_ptr Result = null;
            try {
                EC = new std_errors.error_code();
                char.ptr FilenameCopy = MemoryBufferStatics.$new_uint_NamedBufferAlloc(0, new NamedBufferAlloc(Filename));
                Result = new std_ptr.unique_ptr((Object)new MemoryBufferMMapFile(FilenameCopy, RequiresNullTerminator, FD, MapSize, Offset, EC));
                if (!EC.$bool()) {
                    ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(new std_ptr.unique_ptr((std_ptr.unique_ptr)std.move((Object)Result)));
                    return errorOr;
                }
            }
            finally {
                if (Result != null) {
                    Result.$destroy();
                }
            }
        }
        if (!(Buf = MemoryBuffer.getNewUninitMemBuffer(Unsigned.$long2uint((long)MapSize), Filename)).$bool()) {
            return new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(llvm.make_error_code(std_errors.errc.not_enough_memory));
        }
        char.ptr BufPtr = Native.$tryClone((char.ptr)((MemoryBuffer)Buf.$arrow()).getBufferStart());
        int BytesLeft = Unsigned.$long2uint((long)MapSize);
        while (BytesLeft != 0) {
            long NumRead = std.pread((int)FD, (char.iterator)BufPtr, (int)BytesLeft, (long)(MapSize - (long)BytesLeft + Offset));
            if (NumRead == -1L) {
                if (std.errno() == 4) continue;
                return new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(new std_errors.error_code(std.errno(), std.generic_category()));
            }
            if (NumRead == 0L) {
                std.memset((char.ptr)BufPtr, (byte)0, (int)BytesLeft);
                break;
            }
            BytesLeft -= Unsigned.$long2uint((long)NumRead);
            BufPtr.$inc(Unsigned.$long2uint((long)NumRead));
        }
        return new ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>(new std_ptr.unique_ptr((std_ptr.unique_ptr)std.move(Buf)));
    }

    public static boolean shouldUseMmap(int FD, int FileSize, int MapSize, long Offset, boolean RequiresNullTerminator, int PageSize, boolean IsVolatileSize) {
        if (IsVolatileSize) {
            return false;
        }
        if (MapSize < 16384 || MapSize < PageSize) {
            return false;
        }
        if (!RequiresNullTerminator) {
            return true;
        }
        if (FileSize == -1) {
            fs.file_status Status2 = new fs.file_status();
            if (fs.status(FD, Status2).$bool()) {
                return false;
            }
            FileSize = Unsigned.$long2uint((long)Status2.getSize());
        }
        int End2 = Unsigned.$long2uint((long)(Offset + (long)MapSize));
        assert (End2 <= FileSize);
        if (End2 != FileSize) {
            return false;
        }
        return (FileSize & PageSize - 1) != 0;
    }
}

