/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import java.util.ArrayList;
import java.util.List;
import org.clank.support.NativeTrace;
import org.llvm.support.llvm;
import org.llvm.support.simplify_type;

public final class CastingLlvmGlobals {
    private static final List<simplify_type> simplifiers = new ArrayList<simplify_type>();

    private static void initSimplifiers() {
    }

    private static void loadSimplifier(String qualName) {
        try {
            Class<?> cls = Class.forName(qualName, true, Thread.currentThread().getContextClassLoader());
            simplifiers.add((simplify_type)cls.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            NativeTrace.printStackTraceOnce((Throwable)ex);
            llvm.errs().$out(ex.getClass().getName()).$out(' ').$out(ex.getMessage()).$out("\n");
        }
    }

    public static <T> T getSimplifiedValue(Object Val) {
        if (Val instanceof simplify_type) {
            return CastingLlvmGlobals.getSimplifiedValue((simplify_type)Val);
        }
        return (T)Val;
    }

    public static <T> T getSimplifiedValue(simplify_type Val) {
        return (T)Val.getSimplifiedValue(Val);
    }

    public static <X, Y> boolean isa(Class<X> cls, Y Val) {
        return cls.isInstance(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y extends simplify_type> boolean isa(Class<X> cls, Y Val) {
        return cls.isInstance(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y extends simplify_type> X cast$NotSimpleType(Class<X> clsX, Y Val) {
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast<Ty>() argument of incompatible type!";
        return clsX.cast(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y> X cast(Class<X> clsX, Y Val) {
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast<Ty>() argument of incompatible type!";
        return clsX.cast(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y extends simplify_type> X cast(Class<X> clsX, Y Val) {
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast<Ty>() argument of incompatible type!";
        return clsX.cast(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y extends simplify_type> X cast_or_null$NotSimpleType(Class<X> clsX, Y Val) {
        if (CastingLlvmGlobals.getSimplifiedValue(Val) == null) {
            return null;
        }
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast_or_null<Ty>() argument of incompatible type!";
        return CastingLlvmGlobals.cast(clsX, Val);
    }

    public static <X, Y> X cast_or_null(Class<X> clsX, Y Val) {
        if (CastingLlvmGlobals.getSimplifiedValue(Val) == null) {
            return null;
        }
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast_or_null<Ty>() argument of incompatible type!";
        return CastingLlvmGlobals.cast(clsX, Val);
    }

    public static <X, Y extends simplify_type> X cast_or_null(Class<X> clsX, Y Val) {
        if (CastingLlvmGlobals.getSimplifiedValue(Val) == null) {
            return null;
        }
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast_or_null<Ty>() argument of incompatible type!";
        return CastingLlvmGlobals.cast(clsX, Val);
    }

    public static <X, Y extends simplify_type> X dyn_cast$NotSimpleType(Class<X> clsX, Y Val) {
        return CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y> X dyn_cast(Class<X> clsX, Y Val) {
        return CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y extends simplify_type> X dyn_cast(Class<X> clsX, Y Val) {
        return CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y extends simplify_type> X dyn_cast_or_null$NotSimpleType(Class<X> clsX, Y Val) {
        return Val != null && CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y> X dyn_cast_or_null(Class<X> clsX, Y Val) {
        return Val != null && CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y extends simplify_type> X dyn_cast_or_null(Class<X> clsX, Y Val) {
        return Val != null && CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    static {
        CastingLlvmGlobals.initSimplifiers();
    }
}

