/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.TimeRecord;
import org.llvm.support.TimerGroup;
import org.llvm.support.impl.TimerStatics;

public class Timer
implements Destructors.ClassWithDestructor {
    TimeRecord Time = new TimeRecord();
    private TimeRecord StartTime = new TimeRecord();
    std.string Name = new std.string();
    private boolean Running;
    private boolean Triggered;
    TimerGroup TG = null;
    Timer Prev;
    Timer Next;

    public Timer(StringRef N) {
        this.init(new StringRef(N));
    }

    public Timer(StringRef N, TimerGroup tg) {
        this.init(new StringRef(N), tg);
    }

    public Timer(Timer RHS) {
        assert (RHS.TG == null) : "Can only copy uninitialized timers";
    }

    public Timer $assign(Timer T4) {
        assert (this.TG == null && T4.TG == null) : "Can only assign uninit timers";
        return this;
    }

    public void $destroy() {
        if (this.TG == null) {
            return;
        }
        this.TG.removeTimer(this);
        this.Name.$destroy();
    }

    public Timer() {
    }

    public void init(StringRef N) {
        this.init(new StringRef(N), (TimerGroup)Native.$Deref((Object)TimerStatics.getDefaultTimerGroup()));
    }

    public void init(StringRef N, TimerGroup tg) {
        assert (this.TG == null) : "Timer already initialized";
        this.Name.assign$T((char.iterator)N.begin(), (char.iterator)N.end());
        this.Triggered = false;
        this.Running = false;
        this.TG = (TimerGroup)Native.$AddrOf((Object)tg);
        this.TG.addTimer(this);
    }

    public std.string getName() {
        return this.Name;
    }

    public boolean isInitialized() {
        return this.TG != null;
    }

    public boolean isRunning() {
        return this.Running;
    }

    public boolean hasTriggered() {
        return this.Triggered;
    }

    public void startTimer() {
        assert (!this.Running) : "Cannot start a running timer [" + this.Name.toJavaString() + "] from " + this.TG;
        this.Triggered = true;
        this.Running = true;
        this.StartTime.$assignMove(TimeRecord.getCurrentTime(true));
    }

    public void stopTimer() {
        assert (this.Running) : "Cannot stop a paused timer";
        this.Running = false;
        this.Time.$addassign(TimeRecord.getCurrentTime(false));
        this.Time.$minusassign(this.StartTime);
    }

    public void clear() {
        this.Triggered = false;
        this.Running = false;
        this.Time.$assign(this.StartTime.$assignMove(new TimeRecord()));
    }

    public TimeRecord getTotalTime() {
        return new TimeRecord(this.Time);
    }

    public Timer(char.ptr N) {
        this(new StringRef(N));
    }

    public Timer(char.ptr N, TimerGroup tg) {
        this(new StringRef(N), tg);
    }

    public String toString() {
        return "Time=" + this.Time + ", StartTime=" + this.StartTime + ", Name=" + this.Name.toJavaString() + ", Running=" + this.Running + ", Triggered=" + this.Triggered + ", TG=" + this.TG + ", Prev=" + (this.Prev == null ? "<null>" : this.Prev.Name.toJavaString()) + ", Next=" + (this.Next == null ? "<null>" : this.Next.Name.toJavaString());
    }
}

