/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.iterator_range;
import org.llvm.support.OnDiskChainedHashTable;
import org.llvm.support.llvm;

public class OnDiskIterableChainedHashTable<external_key_type, internal_key_type, data_type>
extends OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> {
    private final char.ptr Payload;
    private static final key_iterator KEY_END = new key_iterator();
    private static final data_iterator DATA_END = new data_iterator();

    public OnDiskIterableChainedHashTable(int NumBuckets, int NumEntries, char.ptr Buckets, char.ptr Payload, char.ptr Base, OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        super(NumBuckets, NumEntries, Buckets, Base, InfoObj);
        this.Payload = Native.$toConst((char.ptr)Payload);
    }

    public key_iterator<external_key_type, internal_key_type> key_begin() {
        return new key_iterator(this.Payload, 0, this.getNumEntries(), (OnDiskChainedHashTable.InfoInterface)Native.$AddrOf(this.getInfoObj()));
    }

    public key_iterator<external_key_type, internal_key_type> key_end() {
        return KEY_END;
    }

    public iterator_range<external_key_type> keys() {
        return llvm.make_range(this.key_begin(), this.key_end());
    }

    public data_iterator<internal_key_type, data_type> data_begin() {
        return new data_iterator(this.Payload, 0, this.getNumEntries(), (OnDiskChainedHashTable.InfoInterface)Native.$AddrOf(this.getInfoObj()));
    }

    public data_iterator<internal_key_type, data_type> data_end() {
        return DATA_END;
    }

    public iterator_range<data_type> data() {
        return llvm.make_range(this.data_begin(), this.data_end());
    }

    public static <Info extends OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type>, external_key_type, internal_key_type, data_type> OnDiskIterableChainedHashTable<external_key_type, internal_key_type, data_type> Create(char.ptr Buckets, char.ptr Payload, char.ptr Base, Info InfoObj) {
        assert (InfoObj != null);
        assert (Buckets.$greater((Object)Base)) : Buckets.$index() + " vs. " + Base.$index() + ":" + Base;
        long NumBucketsAndEntries = OnDiskIterableChainedHashTable.readNumBucketsAndEntries(Buckets);
        return new OnDiskIterableChainedHashTable<external_key_type, internal_key_type, data_type>(std_pair.$first_uint((long)NumBucketsAndEntries), std_pair.$second_uint((long)NumBucketsAndEntries), Native.$noClone((char.ptr)Buckets), Native.$noClone((char.ptr)Payload), Native.$noClone((char.ptr)Base), InfoObj);
    }

    private static int $sizeof_Hash_value_type$Info() {
        return OnDiskChainedHashTable.$sizeof_Hash_Value_type();
    }

    @Override
    public String toString() {
        return "Payload=[" + NativeTrace.getIdentityStr((Object)this.Payload) + "]" + super.toString();
    }

    public static final class data_iterator<internal_key_type, data_type>
    extends iterator_base
    implements type.iterator<data_iterator<internal_key_type, data_type>, data_type> {
        private final OnDiskChainedHashTable.InfoInterface<?, internal_key_type, data_type> InfoObj;

        public data_iterator(char.ptr Ptr2, int $PtrOffset, int NumEntries, OnDiskChainedHashTable.InfoInterface<?, internal_key_type, data_type> InfoObj) {
            super(Ptr2, $PtrOffset, NumEntries);
            this.InfoObj = InfoObj;
        }

        public data_iterator() {
            this.InfoObj = null;
        }

        public data_iterator<internal_key_type, data_type> $preInc() {
            this.advance(this.InfoObj);
            return this;
        }

        public data_iterator<internal_key_type, data_type> $postInc(int $Prm0) {
            data_iterator tmp = (data_iterator)Native.$Clone((NativeCloneable)this);
            this.$preInc();
            return tmp;
        }

        public data_type $star() {
            int LocalPtr = this.$getItem();
            long L = this.InfoObj.ReadKeyDataLength(this.$Ptr, LocalPtr);
            internal_key_type Key = this.InfoObj.ReadKey(this.$Ptr, LocalPtr += this.InfoObj.getReadKeyDataLengthBytes(), std_pair.$first_uint((long)L));
            return this.InfoObj.ReadData(Key, this.$Ptr, LocalPtr + std_pair.$first_uint((long)L), std_pair.$second_uint((long)L));
        }

        private data_iterator(data_iterator<internal_key_type, data_type> other) {
            super(other);
            this.InfoObj = other.InfoObj;
        }

        public data_iterator<internal_key_type, data_type> clone() {
            return new data_iterator<internal_key_type, data_type>(this);
        }

        public boolean $eq(Object other) {
            return iterator_base.$eq_iterator_base$C(this, (data_iterator)other);
        }

        @Override
        public String toString() {
            return "InfoObj=" + NativeTrace.getIdentityStr(this.InfoObj) + super.toString();
        }
    }

    public static final class key_iterator<external_key_type, internal_key_type>
    extends iterator_base
    implements type.iterator<key_iterator<external_key_type, internal_key_type>, external_key_type> {
        private final OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, ?> InfoObj;

        public key_iterator(char.ptr Ptr2, int $PtrOffset, int NumEntries, OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, ?> InfoObj) {
            super(Ptr2, $PtrOffset, NumEntries);
            this.InfoObj = InfoObj;
        }

        public key_iterator() {
            this.InfoObj = null;
        }

        public key_iterator $preInc() {
            this.advance(this.InfoObj);
            return this;
        }

        public key_iterator $postInc(int $Prm0) {
            key_iterator tmp = (key_iterator)Native.$Clone((NativeCloneable)this);
            this.$preInc();
            return tmp;
        }

        public internal_key_type getInternalKey() {
            int LocalPtr = this.$getItem();
            long L = this.InfoObj.ReadKeyDataLength(this.$Ptr, LocalPtr);
            return this.InfoObj.ReadKey(this.$Ptr, LocalPtr += this.InfoObj.getReadKeyDataLengthBytes(), std_pair.$first_uint((long)L));
        }

        public external_key_type $star() {
            return this.InfoObj.GetExternalKey(this.getInternalKey());
        }

        private key_iterator(key_iterator<external_key_type, internal_key_type> other) {
            super(other);
            this.InfoObj = other.InfoObj;
        }

        public key_iterator<external_key_type, internal_key_type> clone() {
            return new key_iterator<external_key_type, internal_key_type>(this);
        }

        public boolean $eq(Object other) {
            return iterator_base.$eq_iterator_base$C(this, (key_iterator)other);
        }

        public key_iterator<external_key_type, internal_key_type> $assignMove(key_iterator<external_key_type, internal_key_type> other) {
            super.$assignMove(other);
            assert (this.InfoObj == other.InfoObj);
            return this;
        }

        @Override
        public String toString() {
            return "InfoObj=" + NativeTrace.getIdentityStr(this.InfoObj) + super.toString();
        }
    }

    public static class iterator_base {
        protected final char.ptr $Ptr;
        private int Ptr;
        private int NumItemsInBucketLeft;
        private int NumEntriesLeft;

        public iterator_base(char.ptr Ptr2, int $PtrOffset, int NumEntries) {
            this.$Ptr = Native.$toConst((char.ptr)Ptr2);
            this.Ptr = $PtrOffset;
            this.NumItemsInBucketLeft = 0;
            this.NumEntriesLeft = NumEntries;
        }

        public iterator_base() {
            this.$Ptr = null;
            this.Ptr = 0;
            this.NumItemsInBucketLeft = 0;
            this.NumEntriesLeft = 0;
        }

        public static boolean $eq_iterator_base$C(iterator_base X2, iterator_base Y) {
            return Native.$eq((int)X2.NumEntriesLeft, (int)Y.NumEntriesLeft);
        }

        public static boolean $noteq_iterator_base$C(iterator_base X2, iterator_base Y) {
            return Native.$noteq((int)X2.NumEntriesLeft, (int)Y.NumEntriesLeft);
        }

        protected void advance(OnDiskChainedHashTable.InfoInterface<?, ?, ?> InfoObj) {
            if (Native.$not((int)this.NumItemsInBucketLeft)) {
                this.NumItemsInBucketLeft = llvm.support.endian.read_uint16(llvm.support.endianness.little, 1, this.$Ptr, this.Ptr);
                this.Ptr += NativeType.sizeof$uint16();
            }
            this.Ptr += OnDiskIterableChainedHashTable.$sizeof_Hash_value_type$Info();
            long L = InfoObj.ReadKeyDataLength(this.$Ptr, this.Ptr);
            this.Ptr += InfoObj.getReadKeyDataLengthBytes();
            this.Ptr += std_pair.$first_uint((long)L) + std_pair.$second_uint((long)L);
            assert (Native.$bool((int)this.NumItemsInBucketLeft));
            --this.NumItemsInBucketLeft;
            assert (Native.$bool((int)this.NumEntriesLeft));
            --this.NumEntriesLeft;
        }

        public char.ptr getItem() {
            return (char.ptr)this.$Ptr.$add(this.$getItem());
        }

        public int $getItem() {
            int ItemPtr = this.Ptr;
            if (this.NumItemsInBucketLeft == 0) {
                ItemPtr += 2;
            }
            return ItemPtr += OnDiskIterableChainedHashTable.$sizeof_Hash_value_type$Info();
        }

        public final char.ptr $PtrBase() {
            return this.$Ptr;
        }

        protected iterator_base(iterator_base $Prm0) {
            this.$Ptr = $Prm0.$Ptr;
            this.Ptr = $Prm0.Ptr;
            this.NumItemsInBucketLeft = $Prm0.NumItemsInBucketLeft;
            this.NumEntriesLeft = $Prm0.NumEntriesLeft;
        }

        protected iterator_base $assignMove(iterator_base $Prm0) {
            this.$Ptr.$assignMove((Object)$Prm0.$Ptr);
            this.Ptr = $Prm0.Ptr;
            this.NumItemsInBucketLeft = $Prm0.NumItemsInBucketLeft;
            this.NumEntriesLeft = $Prm0.NumEntriesLeft;
            return this;
        }

        public String toString() {
            if (this.$Ptr == null) {
                return "<END>";
            }
            return "Ptr=" + this.$Ptr.$add(this.Ptr) + ", NumItemsInBucketLeft=" + this.NumItemsInBucketLeft + ", NumEntriesLeft=" + this.NumEntriesLeft;
        }
    }
}

