/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.support.llvm;

public class OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> {
    protected final int NumBuckets;
    protected final int NumEntries;
    protected final char.ptr Buckets;
    protected final char.ptr Base;
    protected final InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;
    private static final iterator END_ITERATOR = new iterator();

    public OnDiskChainedHashTable(int NumBuckets, int NumEntries, char.ptr Buckets, char.ptr Base, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        this.NumBuckets = NumBuckets;
        this.NumEntries = NumEntries;
        this.Buckets = Native.$toConst((char.ptr)Buckets);
        this.Base = Native.$toConst((char.ptr)Base);
        this.InfoObj = InfoObj;
        assert (InfoObj != null);
        assert ((Buckets.$index() & 3) == 0) : "'buckets' must have a 4-byte alignment";
    }

    public static long readNumBucketsAndEntries(char.ptr Buckets) {
        assert ((Buckets.$index() & 3) == 0) : "'buckets' must have a 4-byte alignment";
        int NumBuckets = llvm.support.endian.readNext_uint32(llvm.support.endianness.little, 0, Buckets);
        int NumEntries = llvm.support.endian.readNext_uint32(llvm.support.endianness.little, 0, Buckets);
        return std_pair.wrap_uint_uint_pair((int)NumBuckets, (int)NumEntries);
    }

    public int getNumBuckets() {
        return this.NumBuckets;
    }

    public int getNumEntries() {
        return this.NumEntries;
    }

    public char.ptr getBase() {
        return this.Base;
    }

    public char.ptr getBuckets() {
        return this.Buckets;
    }

    public boolean isEmpty() {
        return this.NumEntries == 0;
    }

    public iterator find(external_key_type EKey) {
        return this.find(EKey, this.InfoObj);
    }

    public iterator find(external_key_type EKey, InfoInterface<external_key_type, internal_key_type, data_type> InfoPtr) {
        NativeTrace.assertTrueInConsole((boolean)false, (String)"Not Optimized version. Could $get(...) be used instead?", this.getClass());
        assert (InfoPtr != null);
        internal_key_type IKey = this.InfoObj.GetInternalKey(EKey);
        int KeyHash = this.InfoObj.ComputeHash(IKey);
        return this.find_hashed(IKey, KeyHash, InfoPtr);
    }

    public iterator find_hashed(internal_key_type IKey, int KeyHash) {
        return this.find_hashed(IKey, KeyHash, this.InfoObj);
    }

    public iterator find_hashed(internal_key_type IKey, int KeyHash, InfoInterface<external_key_type, internal_key_type, data_type> InfoPtr) {
        assert (InfoPtr != null);
        int Idx = KeyHash & this.NumBuckets - 1;
        assert (Idx >= 0) : "negative " + Idx + " for " + KeyHash + " with " + this.NumBuckets;
        int Bucket2 = OnDiskChainedHashTable.$sizeof_Offset_type() * Idx;
        int Offset = llvm.support.endian.read_uint32(llvm.support.endianness.little, 0, this.Buckets, Bucket2);
        if (Offset == 0) {
            return this.end();
        }
        int Items = Offset;
        int Len = Unsigned.$ushort2uint((char)llvm.support.endian.read_uint16(llvm.support.endianness.little, 1, this.Base, Items));
        Items += NativeType.sizeof$uint16();
        for (int i = 0; i < Len; ++i) {
            int ItemHash = llvm.support.endian.read_uint32(llvm.support.endianness.little, 1, this.Base, Items);
            long L = InfoPtr.ReadKeyDataLength(this.Base, Items += OnDiskChainedHashTable.$sizeof_Hash_Value_type());
            Items += InfoPtr.getReadKeyDataLengthBytes();
            int KeyLen = std_pair.$first_uint((long)L);
            int DataLen = std_pair.$second_uint((long)L);
            int ItemLen = KeyLen + DataLen;
            if (ItemHash != KeyHash) {
                Items += ItemLen;
                continue;
            }
            internal_key_type X2 = InfoPtr.ReadKey(this.Base, Items, KeyLen);
            if (!InfoPtr.EqualKey(X2, IKey)) {
                Items += ItemLen;
                continue;
            }
            return new iterator<external_key_type, internal_key_type, data_type>(X2, this.Base, Items + KeyLen, DataLen, InfoPtr);
        }
        return this.end();
    }

    public iterator end() {
        return END_ITERATOR;
    }

    public final InfoInterface<external_key_type, internal_key_type, data_type> getInfoObj() {
        return this.InfoObj;
    }

    public static <Info extends InfoInterface<external_key_type, internal_key_type, data_type>, external_key_type, internal_key_type, data_type> OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> Create(char.ptr Buckets, char.ptr Base, Info InfoObj) {
        assert (InfoObj != null);
        assert (Buckets.$greater((Object)Base)) : Buckets.$index() + " vs. " + Base.$index() + ":" + Base;
        long NumBucketsAndEntries = OnDiskChainedHashTable.readNumBucketsAndEntries(Buckets);
        return new OnDiskChainedHashTable<external_key_type, internal_key_type, data_type>(std_pair.$first_uint((long)NumBucketsAndEntries), std_pair.$second_uint((long)NumBucketsAndEntries), Native.$noClone((char.ptr)Buckets), Native.$noClone((char.ptr)Base), InfoObj);
    }

    public static int $sizeof_Offset_type() {
        return NativeType.sizeof$uint32();
    }

    public static int $sizeof_Hash_Value_type() {
        return NativeType.sizeof$uint32();
    }

    public final data_type $get(external_key_type EKey) {
        return this.$get(EKey, this.InfoObj);
    }

    public final data_type $get(external_key_type EKey, InfoInterface<external_key_type, internal_key_type, data_type> InfoPtr) {
        assert (InfoPtr != null);
        internal_key_type IKey = InfoPtr.GetInternalKey(EKey);
        int KeyHash = InfoPtr.ComputeHash(IKey);
        int Idx = KeyHash & this.NumBuckets - 1;
        assert (Idx >= 0) : "negative " + Idx + " for " + KeyHash + " with " + this.NumBuckets;
        int Bucket2 = OnDiskChainedHashTable.$sizeof_Offset_type() * Idx;
        int Offset = llvm.support.endian.read_uint32(llvm.support.endianness.little, 0, this.Buckets, Bucket2);
        if (Offset == 0) {
            return null;
        }
        int Items = Offset;
        int Len = llvm.support.endian.read_uint16(llvm.support.endianness.little, 1, this.Base, Items);
        Items += NativeType.sizeof$uint16();
        for (int i = 0; i < Len; ++i) {
            int ItemHash = llvm.support.endian.read_uint32(llvm.support.endianness.little, 1, this.Base, Items);
            long L = InfoPtr.ReadKeyDataLength(this.Base, Items += OnDiskChainedHashTable.$sizeof_Hash_Value_type());
            Items += InfoPtr.getReadKeyDataLengthBytes();
            int KeyLen = std_pair.$first_int((long)L);
            int DataLen = std_pair.$second_int((long)L);
            int ItemLen = KeyLen + DataLen;
            if (ItemHash != KeyHash) {
                Items += ItemLen;
                continue;
            }
            internal_key_type X2 = InfoPtr.ReadKey(this.Base, Items, KeyLen);
            if (!InfoPtr.EqualKey(X2, IKey)) {
                Items += ItemLen;
                continue;
            }
            return InfoPtr.ReadData(X2, this.Base, Items += KeyLen, DataLen);
        }
        return null;
    }

    public String toString() {
        return "NumBuckets=" + this.NumBuckets + ", NumEntries=" + this.NumEntries + ", Buckets=[" + NativeTrace.getIdentityStr((Object)this.Buckets) + "], Base=[" + NativeTrace.getIdentityStr((Object)this.Base) + "], InfoObj=" + NativeTrace.getIdentityStr(this.InfoObj);
    }

    public static interface InfoInterface<external_key_type, internal_key_type, data_type> {
        default public long ReadKeyDataLength(char.ptr Buf, int OffsetInBuf) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"Must be implemented for faster reads:", this.getClass());
            Buf = (char.ptr)Buf.$add(OffsetInBuf);
            std_pair.pairUIntUInt out = this.ReadKeyDataLength(Buf);
            if (!2.$assertionsDisabled && Buf.$index() - OffsetInBuf != this.getReadKeyDataLengthBytes()) {
                throw new AssertionError((Object)("expected to read " + this.getReadKeyDataLengthBytes() + ", but in reality shifted by " + (Buf.$index() - OffsetInBuf) + " from " + OffsetInBuf));
            }
            return std_pair.wrap_uint_uint_pair((int)out.first, (int)out.second);
        }

        default public int getReadKeyDataLengthBytes() {
            throw new UnsupportedOperationException("This methods must be implemented together with ReadKeyDataLength(Buf, OffsetInBuf) to return how many bytes were read without shifting:" + this.getClass());
        }

        default public std_pair.pairUIntUInt ReadKeyDataLength(char.ptr Buf) {
            throw new UnsupportedOperationException("ReadKeyDataLength(Buf, OffsetInBuf) or ReadKeyDataLength(Buf) must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        default public internal_key_type ReadKey(char.ptr Buf, int OffsetInBuf, int KeyLength) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"Must be implemented for faster reads:", this.getClass());
            Buf = (char.ptr)Buf.$add(OffsetInBuf);
            internal_key_type out = this.ReadKey(Buf, KeyLength);
            if (!2.$assertionsDisabled && Buf.$index() - OffsetInBuf != this.getReadKeyDataLengthBytes()) {
                throw new AssertionError((Object)("expected to read " + this.getReadKeyDataLengthBytes() + ", but in reality shifted by " + (Buf.$index() - OffsetInBuf) + " from " + OffsetInBuf));
            }
            return out;
        }

        default public internal_key_type ReadKey(char.ptr Buf, int KeyLength) {
            throw new UnsupportedOperationException("ReadKey(Buf, OffsetInBuf, KeyLength) or ReadKey(Buf, KeyLength) must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        default public data_type ReadData(internal_key_type key, char.ptr Buf, int OffsetInBuf, int DataLength) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"Must be implemented for faster reads:", this.getClass());
            Buf = (char.ptr)Buf.$add(OffsetInBuf);
            data_type out = this.ReadData(key, Buf, DataLength);
            if (!2.$assertionsDisabled && Buf.$index() - OffsetInBuf != DataLength) {
                throw new AssertionError((Object)("expected to read " + DataLength + ", but in reality shifted by " + (Buf.$index() - OffsetInBuf) + " from " + OffsetInBuf));
            }
            return out;
        }

        default public data_type ReadData(internal_key_type key, char.ptr Buf, int DataLength) {
            throw new UnsupportedOperationException("ReadData(key, Buf, OffsetInBuf, DataLength) or ReadData(key, Buf, OffsetInBuf, DataLength) must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        default public <file_type> file_type ReadFileRef(char.ptr Buf) {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass() + "? Forgot to remove static?");
        }

        default public internal_key_type GetInternalKey(external_key_type eKey) {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass() + "? Forgot to remove static?");
        }

        default public external_key_type GetExternalKey(internal_key_type x) {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass() + "? Forgot to remove static?");
        }

        default public int ComputeHash(internal_key_type iKey) {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass() + "? Forgot to remove static?");
        }

        default public boolean EqualKey(internal_key_type a, internal_key_type b) {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass() + "? Forgot to remove static?");
        }

        static {
            if (2.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    public static final class iterator<external_key_type, internal_key_type, data_type>
    implements Native.NativeComparable<iterator> {
        private final internal_key_type Key;
        private final char.ptr Data$Base;
        private final int Data$StartOffset;
        private final int Len;
        private final InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        private iterator() {
            this.Key = null;
            this.Data$Base = null;
            this.Data$StartOffset = 0;
            this.Len = 0;
            this.InfoObj = null;
        }

        public iterator(internal_key_type K, char.ptr D, int DOffset, int L, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.Key = K;
            this.Data$Base = Native.$toConst((char.ptr)D);
            this.Data$StartOffset = DOffset;
            this.Len = L;
            this.InfoObj = InfoObj;
        }

        public data_type $star() {
            return this.InfoObj.ReadData(this.Key, this.Data$Base, this.Data$StartOffset, this.Len);
        }

        public char.ptr getDataPtr() {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"Try to use faster getDataPtr*Base and getDataPtr$Offset");
            return this.Data$StartOffset == 0 ? this.Data$Base : (char.ptr)this.Data$Base.$add(this.Data$StartOffset);
        }

        public char.ptr getDataPtr$Base() {
            return this.Data$Base;
        }

        public int getDataPtr$Offset() {
            return this.Data$StartOffset;
        }

        public int getDataLen() {
            return this.Len;
        }

        public boolean $eq(iterator X2) {
            return Native.$eq_ptr((void.ptr)X2.Data$Base, (void.ptr)this.Data$Base);
        }

        public boolean $noteq(iterator X2) {
            return Native.$noteq_ptr((void.ptr)X2.Data$Base, (void.ptr)this.Data$Base);
        }

        public String toString() {
            if (this.Key == null && this.Data$Base == null && this.Len == 0 && this.InfoObj == null) {
                return "<End>";
            }
            return "Key=" + this.Key + ", Data=" + this.Data$Base.$add(this.Data$StartOffset) + ", Len=" + this.Len + ", InfoObj=" + this.InfoObj;
        }
    }
}

