/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.literal_constants;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.java.ADTFunctionPointers;
import org.llvm.adt.java.GraphTraits;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.DomTreeNodeBase;
import org.llvm.support.DominatorBase;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class DominatorTreeBase<NodeT>
extends DominatorBase<NodeT>
implements Destructors.ClassWithDestructor {
    public final DenseMap<NodeT, std_ptr.unique_ptr<DomTreeNodeBase<NodeT>>> DomTreeNodes;
    public DomTreeNodeBase<NodeT> RootNode;
    protected boolean DFSInfoValid;
    protected int SlowQueries;
    public final DenseMap<NodeT, NodeT> IDoms;
    public final std.vector<NodeT> Vertex;
    public final DenseMap<NodeT, InfoRec<NodeT>> Info;
    private final GraphTraits GraphTraits_NodeT;
    private final GraphTraits GraphTraits_InverseNodeT;
    private final ADTFunctionPointers.NodeType.GetParent<NodeT, ?> $getParent;
    private final ADTFunctionPointers.NodeType.GetParent.FrontEntry<NodeT, NodeT> $getParent$FrontEntry;

    protected DominatorTreeBase(DominatorTreeBase<NodeT> $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected DominatorTreeBase<NodeT> $assign(DominatorTreeBase<NodeT> $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private boolean dominatedBySlowTreeWalk(DomTreeNodeBase<NodeT> A, DomTreeNodeBase<NodeT> B) {
        DomTreeNodeBase<NodeT> IDom;
        assert (A != B);
        assert (this.isReachableFromEntry(B));
        assert (this.isReachableFromEntry(A));
        while ((IDom = B.getIDom()) != null && IDom != A && IDom != B) {
            B = IDom;
        }
        return IDom != null;
    }

    private void wipe() {
        this.DomTreeNodes.clear();
        this.IDoms.clear();
        this.Vertex.clear();
        this.Info.clear();
        this.RootNode = null;
    }

    protected void reset() {
        this.DomTreeNodes.clear();
        this.IDoms.clear();
        this.Roots.clear();
        this.Vertex.clear();
        this.RootNode = null;
        this.DFSInfoValid = false;
        this.SlowQueries = 0;
    }

    protected <N extends NodeT, NodeType extends NodeT> void Split(GraphTraits<?, NodeType, NodeType> GraphT, DominatorTreeBase<NodeT> DT, NodeType NewBB) {
        assert (Native.$bool((boolean)Native.$eq((int)std.distance(GraphT.child_begin(NewBB), GraphT.child_end(NewBB)), (int)1))) : "NewBB should have a single successor!";
        Object NewBBSucc = Native.$Deref(GraphT.child_begin(NewBB));
        std.vector PredBlocks = new std.vector(null);
        type.iterator PI = this.GraphTraits_InverseNodeT.child_begin(NewBB);
        type.iterator PE = this.GraphTraits_InverseNodeT.child_end(NewBB);
        while (Native.$noteq(PI, PE)) {
            PredBlocks.push_back(PI.$star());
            PI.$preInc();
        }
        assert (Native.$bool((boolean)Native.$not((boolean)PredBlocks.empty()))) : "No predblocks?";
        boolean NewBBDominatesNewBBSucc = true;
        type.iterator PI2 = this.GraphTraits_InverseNodeT.child_begin(NewBBSucc);
        type.iterator E = this.GraphTraits_InverseNodeT.child_end(NewBBSucc);
        while (Native.$noteq(PI2, E)) {
            Object ND = PI2.$star();
            if (Native.$bool((Native.$bool((boolean)Native.$noteq((Object)ND, NewBB)) && Native.$not((boolean)DT.dominates(NewBBSucc, ND)) ? 1 : 0) != 0) && Native.$bool((boolean)DT.isReachableFromEntry(ND))) {
                NewBBDominatesNewBBSucc = false;
                break;
            }
            PI2.$preInc();
        }
        Object NewBBIDom = null;
        int i = 0;
        i = 0;
        while (Native.$less((int)i, (int)PredBlocks.size())) {
            if (DT.isReachableFromEntry(PredBlocks.$at(i))) {
                NewBBIDom = PredBlocks.$at(i);
                break;
            }
            ++i;
        }
        if (Native.$not(NewBBIDom)) {
            return;
        }
        ++i;
        while (Native.$less((int)i, (int)PredBlocks.size())) {
            if (DT.isReachableFromEntry(PredBlocks.$at(i))) {
                NewBBIDom = DT.findNearestCommonDominator_T$P(NewBBIDom, PredBlocks.$at(i));
            }
            ++i;
        }
        DomTreeNodeBase<Object> NewBBNode = DT.addNewBlock(NewBB, NewBBIDom);
        if (NewBBDominatesNewBBSucc) {
            DomTreeNodeBase<Object> NewBBSuccNode = DT.getNode(NewBBSucc);
            DT.changeImmediateDominator((Object)NewBBSuccNode, (Object)NewBBNode);
        }
    }

    public DominatorTreeBase(GraphTraits GraphTraits_NodeT, GraphTraits GraphTraits_InverseNodeT, ADTFunctionPointers.NodeType.GetParent<NodeT, ?> GetParent2, ADTFunctionPointers.NodeType.GetParent.FrontEntry<NodeT, NodeT> GetParent$FrontEntry, boolean isPostDom) {
        super(isPostDom);
        this.DomTreeNodes = new DenseMap(DenseMapInfo$LikePtr.$Info(), new std_ptr.unique_ptr());
        this.DFSInfoValid = false;
        this.SlowQueries = 0;
        this.IDoms = new DenseMap(DenseMapInfo$LikePtr.$Info(), null);
        this.Vertex = new std.vector(null);
        this.Info = new DenseMap(DenseMapInfo$LikePtr.$Info(), new InfoRec());
        this.GraphTraits_NodeT = GraphTraits_NodeT;
        this.GraphTraits_InverseNodeT = GraphTraits_InverseNodeT;
        this.$getParent = GetParent2;
        this.$getParent$FrontEntry = GetParent$FrontEntry;
    }

    public DominatorTreeBase(JavaDifferentiators.JD.Move _dparam, DominatorTreeBase<NodeT> Arg) {
        super(JavaDifferentiators.JD.Move.INSTANCE, (DominatorBase)std.move(Arg));
        this.DomTreeNodes = new DenseMap(JavaDifferentiators.JD.Move.INSTANCE, (DenseMap)std.move(Arg.DomTreeNodes));
        this.RootNode = (DomTreeNodeBase)std.move(Arg.RootNode);
        this.DFSInfoValid = std.move((boolean)Arg.DFSInfoValid);
        this.SlowQueries = std.move((int)Arg.SlowQueries);
        this.IDoms = new DenseMap(JavaDifferentiators.JD.Move.INSTANCE, (DenseMap)std.move(Arg.IDoms));
        this.Vertex = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, (std.vector)std.move(Arg.Vertex));
        this.Info = new DenseMap(JavaDifferentiators.JD.Move.INSTANCE, (DenseMap)std.move(Arg.Info));
        this.GraphTraits_NodeT = Arg.GraphTraits_NodeT;
        this.GraphTraits_InverseNodeT = Arg.GraphTraits_InverseNodeT;
        this.$getParent = Arg.$getParent;
        this.$getParent$FrontEntry = Arg.$getParent$FrontEntry;
        super.wipe();
    }

    @Override
    public DominatorTreeBase<NodeT> $assignMove(DominatorTreeBase<NodeT> RHS) {
        super.$assignMove((DominatorBase)std.move(RHS));
        assert (this.GraphTraits_NodeT == RHS.GraphTraits_NodeT);
        assert (this.GraphTraits_InverseNodeT == RHS.GraphTraits_InverseNodeT);
        assert (this.$getParent == RHS.$getParent);
        assert (this.$getParent$FrontEntry == RHS.$getParent$FrontEntry);
        this.DomTreeNodes.$assignMove((DenseMap)std.move(RHS.DomTreeNodes));
        this.RootNode = (DomTreeNodeBase)std.move(RHS.RootNode);
        this.DFSInfoValid = std.move((boolean)RHS.DFSInfoValid);
        this.SlowQueries = std.move((int)RHS.SlowQueries);
        this.IDoms.$assignMove((DenseMap)std.move(RHS.IDoms));
        this.Vertex.$assignMove((std.vector)std.move(RHS.Vertex));
        this.Info.$assignMove((DenseMap)std.move(RHS.Info));
        super.wipe();
        return this;
    }

    public boolean compare(DominatorTreeBase<NodeT> Other) {
        DenseMap<NodeT, std_ptr.unique_ptr<DomTreeNodeBase<NodeT>>> OtherDomTreeNodes = Other.DomTreeNodes;
        if (this.DomTreeNodes.size() != OtherDomTreeNodes.size()) {
            return true;
        }
        for (std_pair.pair<NodeT, std_ptr.unique_ptr<DomTreeNodeBase<NodeT>>> pair2 : this.DomTreeNodes) {
            DomTreeNodeBase OtherNd;
            Object BB = pair2.first;
            DenseMapIterator OI = OtherDomTreeNodes.find$Const(BB);
            if (OI.$eq(OtherDomTreeNodes.end$Const())) {
                return true;
            }
            DomTreeNodeBase MyNd = (DomTreeNodeBase)((std_ptr.unique_ptr)pair2.second).$star();
            if (!MyNd.compare((DomTreeNodeBase)Native.$AddrOf((Object)(OtherNd = (DomTreeNodeBase)((std_ptr.unique_ptr)OI.$arrow().second).$star())))) continue;
            return true;
        }
        return false;
    }

    public void releaseMemory() {
        this.reset();
    }

    public DomTreeNodeBase<NodeT> getNode(NodeT BB) {
        DenseMapIterator I = this.DomTreeNodes.find$Const(BB);
        if (I.$noteq(this.DomTreeNodes.end$Const())) {
            return (DomTreeNodeBase)((std_ptr.unique_ptr)I.$arrow().second).get();
        }
        return null;
    }

    public DomTreeNodeBase<NodeT> $at(NodeT BB) {
        return this.getNode(BB);
    }

    public DomTreeNodeBase<NodeT> getRootNode() {
        return this.RootNode;
    }

    public DomTreeNodeBase<NodeT> getRootNode$Const() {
        return this.RootNode;
    }

    public void getDescendants(NodeT R2, SmallVectorImpl<NodeT> Result) {
        Result.clear();
        DomTreeNodeBase<NodeT> RN = this.getNode(R2);
        if (RN == null) {
            return;
        }
        SmallVector<DomTreeNodeBase> WL = new SmallVector<DomTreeNodeBase>(8, (DomTreeNodeBase)null);
        WL.push_back(RN);
        while (!WL.empty()) {
            DomTreeNodeBase N = (DomTreeNodeBase)WL.pop_back_val();
            Result.push_back(N.getBlock());
            WL.append_T((type.iterator<?, DomTreeNodeBase>)N.begin$Const(), (type.iterator<?, DomTreeNodeBase>)N.end$Const());
        }
    }

    public boolean properlyDominates(DomTreeNodeBase<NodeT> A, DomTreeNodeBase<NodeT> B) {
        if (A == null || B == null) {
            return false;
        }
        if (A == B) {
            return false;
        }
        return this.dominates((NodeT)A, (NodeT)B);
    }

    public boolean properlyDominates(NodeT A, NodeT B) {
        if (A == B) {
            return false;
        }
        return this.dominates((NodeT)this.getNode(A), (NodeT)this.getNode(B));
    }

    public boolean isReachableFromEntry(NodeT A) {
        assert (!super.isPostDominator()) : "This is not implemented for post dominators";
        return this.isReachableFromEntry(this.getNode(A));
    }

    public boolean isReachableFromEntry(DomTreeNodeBase<NodeT> A) {
        return A != null;
    }

    public boolean dominates(DomTreeNodeBase<NodeT> A, DomTreeNodeBase<NodeT> B) {
        if (B == A) {
            return true;
        }
        if (!this.isReachableFromEntry(B)) {
            return true;
        }
        if (!this.isReachableFromEntry(A)) {
            return false;
        }
        if (this.DFSInfoValid) {
            return B.DominatedBy(A);
        }
        ++this.SlowQueries;
        if (Unsigned.$greater_uint((int)this.SlowQueries, (int)32)) {
            this.updateDFSNumbers();
            return B.DominatedBy(A);
        }
        return this.dominatedBySlowTreeWalk(A, B);
    }

    public boolean dominates(NodeT A, NodeT B) {
        if (A == B) {
            return true;
        }
        return this.dominates((NodeT)this.getNode(A), (NodeT)this.getNode(B));
    }

    public NodeT getRoot() {
        assert (this.Roots.size() == 1) : "Should always have entry node!";
        return (NodeT)this.Roots.$at$Const(0);
    }

    public NodeT findNearestCommonDominator_T$P(NodeT A, NodeT B) {
        NodeT Entry2;
        assert (this.$getParent.$call(A) == this.$getParent.$call(B)) : "Two blocks are not in same function";
        if (!(super.isPostDominator() || A != Native.$AddrOf(Entry2 = this.$getParent$FrontEntry.$call(A)) && B != Native.$AddrOf(Entry2))) {
            return (NodeT)Native.$AddrOf(Entry2);
        }
        if (this.dominates(B, A)) {
            return B;
        }
        if (this.dominates(A, B)) {
            return A;
        }
        DomTreeNodeBase<NodeT> NodeA = this.getNode(A);
        DomTreeNodeBase<NodeT> NodeB = this.getNode(B);
        if (this.DFSInfoValid) {
            for (DomTreeNodeBase<NodeT> IDomA = NodeA.getIDom(); IDomA != null; IDomA = IDomA.getIDom()) {
                if (!NodeB.DominatedBy(IDomA)) continue;
                return IDomA.getBlock();
            }
            return null;
        }
        SmallPtrSet NodeADoms = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 16);
        NodeADoms.insert(NodeA);
        for (DomTreeNodeBase<NodeT> IDomA = NodeA.getIDom(); IDomA != null; IDomA = IDomA.getIDom()) {
            NodeADoms.insert(IDomA);
        }
        for (DomTreeNodeBase<NodeT> IDomB = NodeB.getIDom(); IDomB != null; IDomB = IDomB.getIDom()) {
            if (NodeADoms.count(IDomB) == 0) continue;
            return IDomB.getBlock();
        }
        return null;
    }

    public NodeT findNearestCommonDominator_T$C$P(NodeT A, NodeT B) {
        return this.findNearestCommonDominator_T$P(A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomTreeNodeBase<NodeT> addNewBlock(NodeT BB, NodeT DomBB) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            assert (this.getNode(BB) == null) : "Block already in dominator tree!";
            DomTreeNodeBase<NodeT> IDomNode = this.getNode(DomBB);
            assert (IDomNode != null) : "Not immediate dominator specified for block!";
            this.DFSInfoValid = false;
            DomTreeNodeBase domTreeNodeBase = (DomTreeNodeBase)$c$.clean((Object)((DomTreeNodeBase)((std_ptr.unique_ptr)this.DomTreeNodes.$at_T1$C$R(BB)).$assignMove($c$.track(IDomNode.addChild($c$.track(llvm.make_unique(new DomTreeNodeBase<NodeT>(BB, IDomNode)))))).get()));
            return domTreeNodeBase;
        }
        finally {
            $c$.$destroy();
        }
    }

    public void changeImmediateDominator(DomTreeNodeBase<NodeT> N, DomTreeNodeBase<NodeT> NewIDom) {
        assert (N != null && NewIDom != null) : "Cannot change null node pointers!";
        this.DFSInfoValid = false;
        N.setIDom(NewIDom);
    }

    public void changeImmediateDominator(NodeT BB, NodeT NewBB) {
        this.changeImmediateDominator((NodeT)this.getNode(BB), (NodeT)this.getNode(NewBB));
    }

    public void eraseNode(NodeT BB) {
        DomTreeNodeBase<NodeT> Node2 = this.getNode(BB);
        assert (Node2 != null) : "Removing node that isn't in dominator tree.";
        assert (Node2.getChildren().empty()) : "Node is not a leaf node.";
        DomTreeNodeBase<NodeT> IDom = Node2.getIDom();
        if (IDom != null) {
            StdVector.iterator I = (StdVector.iterator)std.find((type.iterator)IDom.Children.begin(), (type.iterator)IDom.Children.end(), Node2);
            assert (std.$noteq___normal_iterator$C((abstract_iterator)I, (abstract_iterator)IDom.Children.end())) : "Not in immediate dominator children set!";
            IDom.Children.erase(new StdVector.iterator(I));
        }
        this.DomTreeNodes.erase(BB);
    }

    public void splitBlock(NodeT NewBB) {
        if (this.IsPostDominators) {
            this.Split(this.GraphTraits_InverseNodeT, this, NewBB);
        } else {
            this.Split(this.GraphTraits_NodeT, this, NewBB);
        }
    }

    public void print(raw_ostream o) {
        o.$out("=============================--------------------------------\n");
        if (super.isPostDominator()) {
            o.$out("Inorder PostDominator Tree: ");
        } else {
            o.$out("Inorder Dominator Tree: ");
        }
        if (!this.DFSInfoValid) {
            o.$out("DFSNumbers invalid: ").$out_uint(this.SlowQueries).$out(" slow queries.");
        }
        o.$out(literal_constants.$LF);
        if (this.getRootNode$Const() != null) {
            AdtsupportLlvmGlobals.PrintDomTree(this.getRootNode$Const(), o, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomTreeNodeBase<NodeT> getNodeForBlock(NodeT BB) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            DomTreeNodeBase<NodeT> Node2 = this.getNode(BB);
            if (Node2 != null) {
                DomTreeNodeBase<NodeT> domTreeNodeBase = Node2;
                return domTreeNodeBase;
            }
            NodeT IDom = this.getIDom(BB);
            assert (IDom != null || ((std_ptr.unique_ptr)this.DomTreeNodes.$at_T1$RR(null)).$bool());
            DomTreeNodeBase<NodeT> IDomNode = this.getNodeForBlock(IDom);
            DomTreeNodeBase domTreeNodeBase = (DomTreeNodeBase)$c$.clean((Object)((DomTreeNodeBase)((std_ptr.unique_ptr)this.DomTreeNodes.$at_T1$C$R(BB)).$assignMove($c$.track(IDomNode.addChild($c$.track(llvm.make_unique(new DomTreeNodeBase<NodeT>(BB, IDomNode)))))).get()));
            return domTreeNodeBase;
        }
        finally {
            $c$.$destroy();
        }
    }

    public NodeT getIDom(NodeT BB) {
        return (NodeT)this.IDoms.lookup(BB);
    }

    protected void addRoot(NodeT BB) {
        this.Roots.push_back_T$C$R(BB);
    }

    public void updateDFSNumbers() {
        if (this.DFSInfoValid) {
            this.SlowQueries = 0;
            return;
        }
        int DFSNum = 0;
        SmallVector<std_pair.pairPtrType> WorkStack = new SmallVector<std_pair.pairPtrType>(32, new std_pair.pairPtrType());
        DomTreeNodeBase<NodeT> ThisRoot = this.getRootNode$Const();
        if (ThisRoot == null) {
            return;
        }
        WorkStack.push_back(std.make_pair_Ptr_T(ThisRoot, (Object)((StdVector.iterator)Native.$Move(ThisRoot.begin$Const()))));
        ThisRoot.DFSNumIn = DFSNum++;
        while (!WorkStack.empty()) {
            StdVector.iterator ChildIt = new StdVector.iterator((StdVector.iterator)((std_pair.pairPtrType)WorkStack.back()).second);
            DomTreeNodeBase Node2 = (DomTreeNodeBase)((std_pair.pairPtrType)WorkStack.back()).first;
            if (std.$eq___normal_iterator$C((StdVector.iterator)ChildIt, Node2.end$Const())) {
                Node2.DFSNumOut = DFSNum++;
                WorkStack.pop_back();
                continue;
            }
            DomTreeNodeBase Child2 = (DomTreeNodeBase)ChildIt.$star();
            ((StdVector.iterator)((std_pair.pairPtrType)WorkStack.back()).second).$preInc();
            WorkStack.push_back(std.make_pair_Ptr_T((Object)Child2, (Object)((StdVector.iterator)Native.$Move(Child2.begin$Const()))));
            Child2.DFSNumIn = DFSNum++;
        }
        this.SlowQueries = 0;
        this.DFSInfoValid = true;
    }

    public <FT, ChildNode> void recalculate(GraphTraits<FT, NodeT, ChildNode> GraphTraits$FT, FT F) {
        this.reset();
        this.Vertex.push_back_T$RR(null);
        if (this.IsPostDominators) {
            type.iterator<?, NodeT> I = GraphTraits$FT.nodes_begin(Native.$AddrOf(F));
            type.iterator<?, NodeT> E = GraphTraits$FT.nodes_end(Native.$AddrOf(F));
            while (I.$noteq(E)) {
                if (GraphTraits$FT.child_begin(Native.$AddrOf((Object)I.$star())).$eq(GraphTraits$FT.child_end(Native.$AddrOf((Object)I.$star())))) {
                    this.addRoot(Native.$AddrOf((Object)I.$star()));
                }
                I.$preInc();
            }
            throw new UnsupportedOperationException("Debug from here with Native and fix Inverse<NodeT> call below");
        }
        NodeT entry = GraphTraits$FT.getEntryNode(Native.$AddrOf(F));
        this.addRoot(entry);
        AdtsupportLlvmGlobals.Calculate(GraphTraits$FT, this.GraphTraits_NodeT, this.GraphTraits_InverseNodeT, this, F);
    }

    @Override
    public void $destroy() {
        this.Info.$destroy();
        this.Vertex.$destroy();
        this.IDoms.$destroy();
        this.DomTreeNodes.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "DomTreeNodes=" + this.DomTreeNodes + ", RootNode=" + this.RootNode + ", DFSInfoValid=" + this.DFSInfoValid + ", SlowQueries=" + this.SlowQueries + ", IDoms=" + this.IDoms + ", Vertex=" + this.Vertex + ", Info=" + this.Info + super.toString();
    }

    public static class InfoRec<NodeT>
    implements NativeCloneable<InfoRec<NodeT>>,
    NativeMoveable<InfoRec<NodeT>> {
        public int DFSNum;
        public int Parent;
        public int Semi;
        public NodeT Label;

        public InfoRec() {
            this.DFSNum = 0;
            this.Parent = 0;
            this.Semi = 0;
            this.Label = null;
        }

        public InfoRec(JavaDifferentiators.JD.Move _dparam, InfoRec<NodeT> $Prm0) {
            this.DFSNum = $Prm0.DFSNum;
            this.Parent = $Prm0.Parent;
            this.Semi = $Prm0.Semi;
            this.Label = $Prm0.Label;
        }

        public InfoRec(InfoRec<NodeT> $Prm0) {
            this.DFSNum = $Prm0.DFSNum;
            this.Parent = $Prm0.Parent;
            this.Semi = $Prm0.Semi;
            this.Label = $Prm0.Label;
        }

        public InfoRec<NodeT> clone() {
            return new InfoRec<NodeT>(this);
        }

        public InfoRec<NodeT> move() {
            return new InfoRec<NodeT>(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        public String toString() {
            return "DFSNum=" + this.DFSNum + ", Parent=" + this.Parent + ", Semi=" + this.Semi + ", Label=" + this.Label;
        }
    }
}

