/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.llvm.support.impl.ConvertUTFStatics;

public final class ConvertUTFGlobals {
    public static final int UNI_REPLACEMENT_CHAR = 65533;
    public static final int UNI_MAX_BMP = 65535;
    public static final int UNI_MAX_UTF16 = 0x10FFFF;
    public static final int UNI_MAX_UTF32 = Integer.MAX_VALUE;
    public static final int UNI_MAX_LEGAL_UTF32 = 0x10FFFF;
    public static final int UNI_MAX_UTF8_BYTES_PER_CODE_POINT = 4;
    public static final int UNI_UTF16_BYTE_ORDER_MARK_NATIVE = 65279;
    public static final int UNI_UTF16_BYTE_ORDER_MARK_SWAPPED = 65534;

    public static ConversionResult ConvertUTF8toUTF16(type.ptr<char.ptr> sourceStart, char.ptr sourceEnd, type.ptr<ushort.ptr> targetStart, ushort.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        char.ptr source = Native.$tryClone((char.ptr)((char.ptr)sourceStart.$star()));
        ushort.ptr target = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch = 0;
            int extraBytesToRead = ConvertUTFStatics.trailingBytesForUTF8[Unsigned.$uchar2int((byte)source.$star())];
            if (extraBytesToRead >= sourceEnd.$sub((abstract_iterator)source)) {
                result = ConversionResult.sourceExhausted;
                break;
            }
            if (ConvertUTFStatics.isLegalUTF8(source, extraBytesToRead + 1) == 0) {
                result = ConversionResult.sourceIllegal;
                break;
            }
            switch (extraBytesToRead) {
                case 5: {
                    ch += Unsigned.$uchar2uint((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 4: {
                    ch += Unsigned.$uchar2uint((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 3: {
                    ch += Unsigned.$uchar2uint((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 2: {
                    ch += Unsigned.$uchar2uint((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 1: {
                    ch += Unsigned.$uchar2uint((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 0: {
                    ch += Unsigned.$uchar2uint((byte)source.$star());
                    source.$preInc();
                }
            }
            ch -= ConvertUTFStatics.offsetsFromUTF8[extraBytesToRead];
            if (target.$greatereq((Object)targetEnd)) {
                source.$dec(extraBytesToRead + 1);
                result = ConversionResult.targetExhausted;
                break;
            }
            if (Unsigned.$lesseq_uint((int)ch, (int)65535)) {
                if (Unsigned.$greatereq_uint((int)ch, (int)55296) && Unsigned.$lesseq_uint((int)ch, (int)57343)) {
                    if (flags == ConversionFlags.strictConversion) {
                        source.$dec(extraBytesToRead + 1);
                        result = ConversionResult.sourceIllegal;
                        break;
                    }
                    target.$set(Unsigned.$uint2ushort((int)65533));
                    target.$preInc();
                    continue;
                }
                target.$set(Unsigned.$uint2ushort((int)ch));
                target.$preInc();
                continue;
            }
            if (Unsigned.$greater_uint((int)ch, (int)0x10FFFF)) {
                if (flags == ConversionFlags.strictConversion) {
                    result = ConversionResult.sourceIllegal;
                    source.$dec(extraBytesToRead + 1);
                    break;
                }
                target.$set(Unsigned.$uint2ushort((int)65533));
                target.$preInc();
                continue;
            }
            if (((ushort.ptr)target.$add(1)).$greatereq((Object)targetEnd)) {
                source.$dec(extraBytesToRead + 1);
                result = ConversionResult.targetExhausted;
                break;
            }
            target.$set(Unsigned.$uint2ushort((int)(((ch -= 65536) >>> 10) + 55296)));
            target.$preInc();
            target.$set(Unsigned.$uint2ushort((int)((ch & 0x3FF) + 56320)));
            target.$preInc();
        }
        sourceStart.$set((Object)Native.$tryClone((char.ptr)source));
        targetStart.$set((Object)((ushort.ptr)Native.$tryClone((NativeCloneable)target)));
        return result;
    }

    public static ConversionResult ConvertUTF8toUTF32Partial(type.ptr<char.ptr> sourceStart, char.ptr sourceEnd, type.ptr<uint.ptr> targetStart, uint.ptr targetEnd, ConversionFlags flags) {
        return ConvertUTFStatics.ConvertUTF8toUTF32Impl(sourceStart, sourceEnd, targetStart, targetEnd, flags, true);
    }

    public static ConversionResult ConvertUTF8toUTF32(type.ptr<char.ptr> sourceStart, char.ptr sourceEnd, type.ptr<uint.ptr> targetStart, uint.ptr targetEnd, ConversionFlags flags) {
        return ConvertUTFStatics.ConvertUTF8toUTF32Impl(sourceStart, sourceEnd, targetStart, targetEnd, flags, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ConversionResult ConvertUTF16toUTF8(type.ptr<ushort.ptr> sourceStart, ushort.ptr sourceEnd, type.ptr<char.ptr> targetStart, char.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        ushort.ptr source = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)sourceStart.$star()));
        char.ptr target = Native.$tryClone((char.ptr)((char.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch;
            ushort.ptr oldSource;
            int byteMark;
            int byteMask;
            int bytesToWrite;
            block22: {
                block23: {
                    bytesToWrite = 0;
                    byteMask = 191;
                    byteMark = 128;
                    oldSource = (ushort.ptr)Native.$tryClone((NativeCloneable)source);
                    ch = Unsigned.$ushort2uint((char)source.$star());
                    source.$preInc();
                    if (!Unsigned.$greatereq_uint((int)ch, (int)55296) || !Unsigned.$lesseq_uint((int)ch, (int)56319)) break block23;
                    if (source.$less((Object)sourceEnd)) {
                        int ch2 = Unsigned.$ushort2uint((char)source.$star());
                        if (Unsigned.$greatereq_uint((int)ch2, (int)56320) && Unsigned.$lesseq_uint((int)ch2, (int)57343)) {
                            ch = (ch - 55296 << 10) + (ch2 - 56320) + 65536;
                            source.$preInc();
                            break block22;
                        } else if (flags == ConversionFlags.strictConversion) {
                            source.$preDec();
                            result = ConversionResult.sourceIllegal;
                            break;
                        }
                        break block22;
                    } else {
                        source.$preDec();
                        result = ConversionResult.sourceExhausted;
                        break;
                    }
                }
                if (flags == ConversionFlags.strictConversion && Unsigned.$greatereq_uint((int)ch, (int)56320) && Unsigned.$lesseq_uint((int)ch, (int)57343)) {
                    source.$preDec();
                    result = ConversionResult.sourceIllegal;
                    break;
                }
            }
            if (Unsigned.$less_uint((int)ch, (int)128)) {
                bytesToWrite = 1;
            } else if (Unsigned.$less_uint((int)ch, (int)2048)) {
                bytesToWrite = 2;
            } else if (Unsigned.$less_uint((int)ch, (int)65536)) {
                bytesToWrite = 3;
            } else if (Unsigned.$less_uint((int)ch, (int)0x110000)) {
                bytesToWrite = 4;
            } else {
                bytesToWrite = 3;
                ch = 65533;
            }
            target.$inc(bytesToWrite);
            if (target.$greater((Object)targetEnd)) {
                source = (ushort.ptr)Native.$tryClone((NativeCloneable)oldSource);
                target.$dec(bytesToWrite);
                result = ConversionResult.targetExhausted;
                break;
            }
            switch (bytesToWrite) {
                case 4: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)((ch | byteMark) & byteMask)));
                    ch >>>= 6;
                }
                case 3: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)((ch | byteMark) & byteMask)));
                    ch >>>= 6;
                }
                case 2: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)((ch | byteMark) & byteMask)));
                    ch >>>= 6;
                }
                case 1: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)(ch | Unsigned.$uchar2uint((byte)ConvertUTFStatics.firstByteMark[bytesToWrite]))));
                    break;
                }
            }
            target.$inc(bytesToWrite);
        }
        sourceStart.$set((Object)((ushort.ptr)Native.$tryClone((NativeCloneable)source)));
        targetStart.$set((Object)Native.$tryClone((char.ptr)target));
        return result;
    }

    public static ConversionResult ConvertUTF32toUTF8(type.ptr<uint.ptr> sourceStart, uint.ptr sourceEnd, type.ptr<char.ptr> targetStart, char.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        uint.ptr source = (uint.ptr)Native.$tryClone((NativeCloneable)((uint.ptr)sourceStart.$star()));
        char.ptr target = Native.$tryClone((char.ptr)((char.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int bytesToWrite = 0;
            int byteMask = 191;
            int byteMark = 128;
            int ch = source.$star();
            source.$preInc();
            if (flags == ConversionFlags.strictConversion && Unsigned.$greatereq_uint((int)ch, (int)55296) && Unsigned.$lesseq_uint((int)ch, (int)57343)) {
                source.$preDec();
                result = ConversionResult.sourceIllegal;
                break;
            }
            if (Unsigned.$less_uint((int)ch, (int)128)) {
                bytesToWrite = 1;
            } else if (Unsigned.$less_uint((int)ch, (int)2048)) {
                bytesToWrite = 2;
            } else if (Unsigned.$less_uint((int)ch, (int)65536)) {
                bytesToWrite = 3;
            } else if (Unsigned.$lesseq_uint((int)ch, (int)0x10FFFF)) {
                bytesToWrite = 4;
            } else {
                bytesToWrite = 3;
                ch = 65533;
                result = ConversionResult.sourceIllegal;
            }
            target.$inc(bytesToWrite);
            if (target.$greater((Object)targetEnd)) {
                source.$preDec();
                target.$dec(bytesToWrite);
                result = ConversionResult.targetExhausted;
                break;
            }
            switch (bytesToWrite) {
                case 4: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)((ch | byteMark) & byteMask)));
                    ch >>>= 6;
                }
                case 3: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)((ch | byteMark) & byteMask)));
                    ch >>>= 6;
                }
                case 2: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)((ch | byteMark) & byteMask)));
                    ch >>>= 6;
                }
                case 1: {
                    ((char.ptr)target.$preDec()).$set(Unsigned.$uint2uchar((int)(ch | Unsigned.$uchar2uint((byte)ConvertUTFStatics.firstByteMark[bytesToWrite]))));
                }
            }
            target.$inc(bytesToWrite);
        }
        sourceStart.$set((Object)((uint.ptr)Native.$tryClone((NativeCloneable)source)));
        targetStart.$set((Object)Native.$tryClone((char.ptr)target));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ConversionResult ConvertUTF16toUTF32(type.ptr<ushort.ptr> sourceStart, ushort.ptr sourceEnd, type.ptr<uint.ptr> targetStart, uint.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        ushort.ptr source = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)sourceStart.$star()));
        uint.ptr target = (uint.ptr)Native.$tryClone((NativeCloneable)((uint.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch;
            ushort.ptr oldSource;
            block8: {
                block9: {
                    oldSource = (ushort.ptr)Native.$tryClone((NativeCloneable)source);
                    ch = Unsigned.$ushort2uint((char)source.$star());
                    source.$preInc();
                    if (!Unsigned.$greatereq_uint((int)ch, (int)55296) || !Unsigned.$lesseq_uint((int)ch, (int)56319)) break block9;
                    if (source.$less((Object)sourceEnd)) {
                        int ch2 = Unsigned.$ushort2uint((char)source.$star());
                        if (Unsigned.$greatereq_uint((int)ch2, (int)56320) && Unsigned.$lesseq_uint((int)ch2, (int)57343)) {
                            ch = (ch - 55296 << 10) + (ch2 - 56320) + 65536;
                            source.$preInc();
                            break block8;
                        } else if (flags == ConversionFlags.strictConversion) {
                            source.$preDec();
                            result = ConversionResult.sourceIllegal;
                            break;
                        }
                        break block8;
                    } else {
                        source.$preDec();
                        result = ConversionResult.sourceExhausted;
                        break;
                    }
                }
                if (flags == ConversionFlags.strictConversion && Unsigned.$greatereq_uint((int)ch, (int)56320) && Unsigned.$lesseq_uint((int)ch, (int)57343)) {
                    source.$preDec();
                    result = ConversionResult.sourceIllegal;
                    break;
                }
            }
            if (target.$greatereq((Object)targetEnd)) {
                source = (ushort.ptr)Native.$tryClone((NativeCloneable)oldSource);
                result = ConversionResult.targetExhausted;
                break;
            }
            target.$set(ch);
            target.$preInc();
        }
        sourceStart.$set((Object)((ushort.ptr)Native.$tryClone((NativeCloneable)source)));
        targetStart.$set((Object)((uint.ptr)Native.$tryClone((NativeCloneable)target)));
        return result;
    }

    public static ConversionResult ConvertUTF32toUTF16(type.ptr<uint.ptr> sourceStart, uint.ptr sourceEnd, type.ptr<ushort.ptr> targetStart, ushort.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        uint.ptr source = (uint.ptr)Native.$tryClone((NativeCloneable)((uint.ptr)sourceStart.$star()));
        ushort.ptr target = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            if (target.$greatereq((Object)targetEnd)) {
                result = ConversionResult.targetExhausted;
                break;
            }
            int ch = source.$star();
            source.$preInc();
            if (Unsigned.$lesseq_uint((int)ch, (int)65535)) {
                if (Unsigned.$greatereq_uint((int)ch, (int)55296) && Unsigned.$lesseq_uint((int)ch, (int)57343)) {
                    if (flags == ConversionFlags.strictConversion) {
                        source.$preDec();
                        result = ConversionResult.sourceIllegal;
                        break;
                    }
                    target.$set(Unsigned.$uint2ushort((int)65533));
                    target.$preInc();
                    continue;
                }
                target.$set(Unsigned.$uint2ushort((int)ch));
                target.$preInc();
                continue;
            }
            if (Unsigned.$greater_uint((int)ch, (int)0x10FFFF)) {
                if (flags == ConversionFlags.strictConversion) {
                    result = ConversionResult.sourceIllegal;
                    continue;
                }
                target.$set(Unsigned.$uint2ushort((int)65533));
                target.$preInc();
                continue;
            }
            if (((ushort.ptr)target.$add(1)).$greatereq((Object)targetEnd)) {
                source.$preDec();
                result = ConversionResult.targetExhausted;
                break;
            }
            target.$set(Unsigned.$uint2ushort((int)(((ch -= 65536) >>> 10) + 55296)));
            target.$preInc();
            target.$set(Unsigned.$uint2ushort((int)((ch & 0x3FF) + 56320)));
            target.$preInc();
        }
        sourceStart.$set((Object)((uint.ptr)Native.$tryClone((NativeCloneable)source)));
        targetStart.$set((Object)((ushort.ptr)Native.$tryClone((NativeCloneable)target)));
        return result;
    }

    public static int isLegalUTF8Sequence(char.ptr source, char.ptr sourceEnd) {
        int length = ConvertUTFStatics.trailingBytesForUTF8[Unsigned.$uchar2int((byte)source.$star())] + 1;
        if (length > sourceEnd.$sub((abstract_iterator)source)) {
            return 0;
        }
        return ConvertUTFStatics.isLegalUTF8(source, length);
    }

    public static int isLegalUTF8String(type.ptr<char.ptr> source, char.ptr sourceEnd) {
        while (((char.ptr)source.$star()).$noteq((Object)sourceEnd)) {
            int length = ConvertUTFStatics.trailingBytesForUTF8[Unsigned.$uchar2int((byte)((char.ptr)source.$star()).$star())] + 1;
            if (length > sourceEnd.$sub((abstract_iterator)((char.ptr)source.$star())) || ConvertUTFStatics.isLegalUTF8((char.ptr)source.$star(), length) == 0) {
                return 0;
            }
            ((char.ptr)source.$star()).$inc(length);
        }
        return 1;
    }

    public static int getNumBytesForUTF8(byte first) {
        return ConvertUTFStatics.trailingBytesForUTF8[Unsigned.$uchar2int((byte)first)] + 1;
    }

    public static final class ConversionFlags
    extends Enum<ConversionFlags>
    implements Native.ComparableLower {
        public static final /* enum */ ConversionFlags strictConversion = new ConversionFlags(0);
        public static final /* enum */ ConversionFlags lenientConversion = new ConversionFlags(strictConversion.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ConversionFlags[] $VALUES;

        public static ConversionFlags[] values() {
            return (ConversionFlags[])$VALUES.clone();
        }

        public static ConversionFlags valueOf(String name) {
            return Enum.valueOf(ConversionFlags.class, name);
        }

        public static ConversionFlags valueOf(int val) {
            ConversionFlags out;
            ConversionFlags conversionFlags = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ConversionFlags(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ConversionFlags)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ConversionFlags)((Object)obj)).value);
        }

        static {
            $VALUES = new ConversionFlags[]{strictConversion, lenientConversion};
        }

        private static final class Values {
            private static final ConversionFlags[] VALUES;
            private static final ConversionFlags[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ConversionFlags kind : ConversionFlags.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ConversionFlags[min < 0 ? 1 - min : 0];
                VALUES = new ConversionFlags[max >= 0 ? 1 + max : 0];
                for (ConversionFlags kind : ConversionFlags.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ConversionFlags)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ConversionFlags)kind).value] = kind;
                }
            }
        }
    }

    public static final class ConversionResult
    extends Enum<ConversionResult>
    implements Native.ComparableLower {
        public static final /* enum */ ConversionResult conversionOK = new ConversionResult(0);
        public static final /* enum */ ConversionResult sourceExhausted = new ConversionResult(conversionOK.getValue() + 1);
        public static final /* enum */ ConversionResult targetExhausted = new ConversionResult(sourceExhausted.getValue() + 1);
        public static final /* enum */ ConversionResult sourceIllegal = new ConversionResult(targetExhausted.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ConversionResult[] $VALUES;

        public static ConversionResult[] values() {
            return (ConversionResult[])$VALUES.clone();
        }

        public static ConversionResult valueOf(String name) {
            return Enum.valueOf(ConversionResult.class, name);
        }

        public static ConversionResult valueOf(int val) {
            ConversionResult out;
            ConversionResult conversionResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ConversionResult(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ConversionResult)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ConversionResult)((Object)obj)).value);
        }

        static {
            $VALUES = new ConversionResult[]{conversionOK, sourceExhausted, targetExhausted, sourceIllegal};
        }

        private static final class Values {
            private static final ConversionResult[] VALUES;
            private static final ConversionResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ConversionResult kind : ConversionResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ConversionResult[min < 0 ? 1 - min : 0];
                VALUES = new ConversionResult[max >= 0 ? 1 + max : 0];
                for (ConversionResult kind : ConversionResult.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ConversionResult)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ConversionResult)kind).value] = kind;
                }
            }
        }
    }
}

