/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc.impl;

import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.SetVector;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCBinaryExpr;
import org.llvm.mc.MCConstantExpr;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDwarfFile;
import org.llvm.mc.MCDwarfLineEntry;
import org.llvm.mc.MCDwarfLineTableParams;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCGenDwarfLabelEntry;
import org.llvm.mc.MCObjectStreamer;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public final class MCDwarfStatics {
    public static long ScaleAddrDelta(MCContext Context, long AddrDelta) {
        int MinInsnLength = Context.getAsmInfo().getMinInstAlignment();
        if (MinInsnLength == 1) {
            return AddrDelta;
        }
        if (Unsigned.$rem_ulong_uint((long)AddrDelta, (int)MinInsnLength) != Unsigned.$int2ullong((int)0)) {
            // empty if block
        }
        return Unsigned.$div_ulong_uint((long)AddrDelta, (int)MinInsnLength);
    }

    public static MCExpr MakeStartMinusEndExpr(MCStreamer MCOS, MCSymbol Start, MCSymbol End, int IntVal) {
        MCSymbolRefExpr.VariantKind Variant = MCSymbolRefExpr.VariantKind.VK_None;
        MCSymbolRefExpr Res = MCSymbolRefExpr.create((MCSymbol)Native.$AddrOf((Object)End), Variant, MCOS.getContext());
        MCSymbolRefExpr RHS = MCSymbolRefExpr.create((MCSymbol)Native.$AddrOf((Object)Start), Variant, MCOS.getContext());
        MCBinaryExpr Res1 = MCBinaryExpr.create(MCBinaryExpr.Opcode.Sub, Res, RHS, MCOS.getContext());
        MCConstantExpr Res2 = MCConstantExpr.create(IntVal, MCOS.getContext());
        MCBinaryExpr Res3 = MCBinaryExpr.create(MCBinaryExpr.Opcode.Sub, Res1, Res2, MCOS.getContext());
        return Res3;
    }

    public static void EmitDwarfLineTable(MCObjectStreamer MCOS, MCSection Section, std.vector<MCDwarfLineEntry> LineEntries) {
        int FileNum = 1;
        int LastLine = 1;
        int Column = 0;
        int Flags = 1;
        int Isa = 0;
        int Discriminator = 0;
        MCSymbol LastLabel = null;
        for (MCDwarfLineEntry LineEntry : LineEntries) {
            long LineDelta = Unsigned.$uint2long((int)LineEntry.getLine()) - Unsigned.$uint2llong((int)LastLine);
            if (FileNum != LineEntry.getFileNum()) {
                FileNum = LineEntry.getFileNum();
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)4), 1);
                MCOS.EmitULEB128IntValue(Unsigned.$uint2ulong((int)FileNum));
            }
            if (Column != LineEntry.getColumn()) {
                Column = LineEntry.getColumn();
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)5), 1);
                MCOS.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Column));
            }
            if (Discriminator != LineEntry.getDiscriminator()) {
                Discriminator = LineEntry.getDiscriminator();
                int Size = AdtsupportLlvmGlobals.getULEB128Size(Unsigned.$uint2ulong((int)Discriminator));
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)0), 1);
                MCOS.EmitULEB128IntValue(Unsigned.$uint2ulong((int)(Size + 1)));
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)4), 1);
                MCOS.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Discriminator));
            }
            if (Isa != LineEntry.getIsa()) {
                Isa = LineEntry.getIsa();
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)12), 1);
                MCOS.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Isa));
            }
            if (((LineEntry.getFlags() ^ Flags) & 1) != 0) {
                Flags = LineEntry.getFlags();
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)6), 1);
            }
            if ((LineEntry.getFlags() & 2) != 0) {
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)7), 1);
            }
            if ((LineEntry.getFlags() & 4) != 0) {
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)10), 1);
            }
            if ((LineEntry.getFlags() & 8) != 0) {
                MCOS.EmitIntValue(Unsigned.$uint2ulong((int)11), 1);
            }
            MCSymbol Label = LineEntry.getLabel();
            MCAsmInfo asmInfo = MCOS.getContext().getAsmInfo();
            MCOS.EmitDwarfAdvanceLineAddr(LineDelta, LastLabel, Label, asmInfo.getPointerSize());
            Discriminator = 0;
            LastLine = LineEntry.getLine();
            LastLabel = Label;
        }
        MCSymbol SectionEnd = MCOS.endSection(Section);
        MCContext Ctx = MCOS.getContext();
        MCOS.SwitchSection(Ctx.getObjectFileInfo().getDwarfLineSection());
        MCAsmInfo AsmInfo = Ctx.getAsmInfo();
        MCOS.EmitDwarfAdvanceLineAddr(Long.MAX_VALUE, LastLabel, SectionEnd, AsmInfo.getPointerSize());
    }

    public static MCExpr forceExpAbs(MCStreamer OS, MCExpr Expr) {
        MCContext Context = OS.getContext();
        assert (!ADTRTTI.isa_MCSymbolRefExpr(Expr));
        if (Context.getAsmInfo().hasAggressiveSymbolFolding()) {
            return Expr;
        }
        MCSymbol ABS = Context.createTempSymbol();
        OS.EmitAssignment(ABS, Expr);
        return MCSymbolRefExpr.create(ABS, Context);
    }

    public static void emitAbsValue(MCStreamer OS, MCExpr Value, int Size) {
        MCExpr ABS = MCDwarfStatics.forceExpAbs(OS, Value);
        OS.EmitValue(ABS, Size);
    }

    public static long SpecialAddr(MCDwarfLineTableParams Params, long op) {
        return Unsigned.$div_ullong_uchar((long)(op - Unsigned.$uchar2ullong((byte)Params.DWARF2LineOpcodeBase)), (byte)Params.DWARF2LineRange);
    }

    public static void EmitAbbrev(MCStreamer MCOS, long Name2, long Form2) {
        MCOS.EmitULEB128IntValue(Name2);
        MCOS.EmitULEB128IntValue(Form2);
    }

    public static void EmitGenDwarfAbbrev(MCStreamer MCOS) {
        StringRef DwarfDebugFlags;
        MCContext context = MCOS.getContext();
        MCOS.SwitchSection(context.getObjectFileInfo().getDwarfAbbrevSection());
        MCOS.EmitULEB128IntValue(Unsigned.$int2ulong((int)1));
        MCOS.EmitULEB128IntValue(Unsigned.$ushort2ulong((char)'\u0011'));
        MCOS.EmitIntValue(Unsigned.$uint2ulong((int)1), 1);
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0010'), Unsigned.$ushort2ulong((char)(Unsigned.$ushort2int((char)context.getDwarfVersion()) >= 4 ? (char)'\u0017' : '\u0006')));
        if (Unsigned.$greater_uint((int)context.getGenDwarfSectionSyms().size(), (int)1) && Unsigned.$ushort2int((char)context.getDwarfVersion()) >= 3) {
            MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'U'), Unsigned.$ushort2ulong((char)(Unsigned.$ushort2int((char)context.getDwarfVersion()) >= 4 ? (char)'\u0017' : '\u0006')));
        } else {
            MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0011'), Unsigned.$ushort2ulong((char)'\u0001'));
            MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0012'), Unsigned.$ushort2ulong((char)'\u0001'));
        }
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0003'), Unsigned.$ushort2ulong((char)'\b'));
        if (!context.getCompilationDir().empty()) {
            MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u001b'), Unsigned.$ushort2ulong((char)'\b'));
        }
        if (!(DwarfDebugFlags = context.getDwarfDebugFlags()).empty()) {
            MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u3fe2'), Unsigned.$ushort2ulong((char)'\b'));
        }
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'%'), Unsigned.$ushort2ulong((char)'\b'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0013'), Unsigned.$ushort2ulong((char)'\u0005'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$int2ulong((int)0), Unsigned.$int2ulong((int)0));
        MCOS.EmitULEB128IntValue(Unsigned.$int2ulong((int)2));
        MCOS.EmitULEB128IntValue(Unsigned.$ushort2ulong((char)'\n'));
        MCOS.EmitIntValue(Unsigned.$uint2ulong((int)1), 1);
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0003'), Unsigned.$ushort2ulong((char)'\b'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)':'), Unsigned.$ushort2ulong((char)'\u0006'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)';'), Unsigned.$ushort2ulong((char)'\u0006'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\u0011'), Unsigned.$ushort2ulong((char)'\u0001'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$ushort2ulong((char)'\''), Unsigned.$ushort2ulong((char)'\f'));
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$int2ulong((int)0), Unsigned.$int2ulong((int)0));
        MCOS.EmitULEB128IntValue(Unsigned.$int2ulong((int)3));
        MCOS.EmitULEB128IntValue(Unsigned.$ushort2ulong((char)'\u0018'));
        MCOS.EmitIntValue(Unsigned.$uint2ulong((int)0), 1);
        MCDwarfStatics.EmitAbbrev(MCOS, Unsigned.$int2ulong((int)0), Unsigned.$int2ulong((int)0));
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
    }

    public static void EmitGenDwarfAranges(MCStreamer MCOS, MCSymbol InfoSectionSymbol) {
        MCContext context = MCOS.getContext();
        SetVector<MCSection> Sections = context.getGenDwarfSectionSyms();
        MCOS.SwitchSection(context.getObjectFileInfo().getDwarfARangesSection());
        int Length = 12;
        MCAsmInfo asmInfo = context.getAsmInfo();
        int AddrSize = asmInfo.getPointerSize();
        int Pad = 2 * AddrSize - (Length & 2 * AddrSize - 1);
        if (Pad == 2 * AddrSize) {
            Pad = 0;
        }
        Length += Pad;
        Length += 2 * AddrSize * Sections.size();
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)((Length += 2 * AddrSize) - 4)), 4);
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)2), 2);
        if (InfoSectionSymbol != null) {
            MCOS.EmitSymbolValue(InfoSectionSymbol, 4, asmInfo.needsDwarfSectionOffsetDirective());
        } else {
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 4);
        }
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)AddrSize), 1);
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        for (int i = 0; i < Pad; ++i) {
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        }
        for (MCSection Sec : Sections) {
            MCSymbol StartSymbol = Sec.getBeginSymbol();
            MCSymbol EndSymbol = Sec.getEndSymbol(context);
            assert (StartSymbol != null) : "StartSymbol must not be NULL";
            assert (EndSymbol != null) : "EndSymbol must not be NULL";
            MCSymbolRefExpr Addr = MCSymbolRefExpr.create(StartSymbol, MCSymbolRefExpr.VariantKind.VK_None, context);
            MCExpr Size = MCDwarfStatics.MakeStartMinusEndExpr((MCStreamer)Native.$Deref((Object)MCOS), (MCSymbol)Native.$Deref((Object)StartSymbol), (MCSymbol)Native.$Deref((Object)EndSymbol), 0);
            MCOS.EmitValue(Addr, AddrSize);
            MCDwarfStatics.emitAbsValue((MCStreamer)Native.$Deref((Object)MCOS), Size, AddrSize);
        }
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), AddrSize);
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), AddrSize);
    }

    public static void EmitGenDwarfInfo(MCStreamer MCOS, MCSymbol AbbrevSectionSymbol, MCSymbol LineSectionSymbol, MCSymbol RangesSectionSymbol) {
        StringRef DwarfDebugProducer;
        StringRef DwarfDebugFlags;
        MCContext context = MCOS.getContext();
        MCOS.SwitchSection(context.getObjectFileInfo().getDwarfInfoSection());
        MCSymbol InfoStart = context.createTempSymbol();
        MCOS.EmitLabel(InfoStart);
        MCSymbol InfoEnd = context.createTempSymbol();
        MCExpr Length = MCDwarfStatics.MakeStartMinusEndExpr((MCStreamer)Native.$Deref((Object)MCOS), (MCSymbol)Native.$Deref((Object)InfoStart), (MCSymbol)Native.$Deref((Object)InfoEnd), 4);
        MCDwarfStatics.emitAbsValue((MCStreamer)Native.$Deref((Object)MCOS), Length, 4);
        MCOS.EmitIntValue(Unsigned.$ushort2ulong((char)context.getDwarfVersion()), 2);
        MCAsmInfo AsmInfo = (MCAsmInfo)Native.$Deref((Object)context.getAsmInfo());
        if (AbbrevSectionSymbol == null) {
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 4);
        } else {
            MCOS.EmitSymbolValue(AbbrevSectionSymbol, 4, AsmInfo.needsDwarfSectionOffsetDirective());
        }
        MCAsmInfo asmInfo = context.getAsmInfo();
        int AddrSize = asmInfo.getPointerSize();
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)AddrSize), 1);
        MCOS.EmitULEB128IntValue(Unsigned.$int2ulong((int)1));
        if (LineSectionSymbol != null) {
            MCOS.EmitSymbolValue(LineSectionSymbol, 4, AsmInfo.needsDwarfSectionOffsetDirective());
        } else {
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 4);
        }
        if (RangesSectionSymbol != null) {
            MCOS.EmitSymbolValue(RangesSectionSymbol, 4);
        } else {
            SetVector<MCSection> Sections = context.getGenDwarfSectionSyms();
            StdVector.iterator<MCSection> TextSection = Sections.begin$Const();
            assert (std.$noteq___normal_iterator$C(TextSection, Sections.end$Const())) : "No text section found";
            MCSymbol StartSymbol = ((MCSection)TextSection.$star()).getBeginSymbol();
            MCSymbol EndSymbol = ((MCSection)TextSection.$star()).getEndSymbol(context);
            assert (StartSymbol != null) : "StartSymbol must not be NULL";
            assert (EndSymbol != null) : "EndSymbol must not be NULL";
            MCSymbolRefExpr Start = MCSymbolRefExpr.create(StartSymbol, MCSymbolRefExpr.VariantKind.VK_None, context);
            MCOS.EmitValue(Start, AddrSize);
            MCSymbolRefExpr End = MCSymbolRefExpr.create(EndSymbol, MCSymbolRefExpr.VariantKind.VK_None, context);
            MCOS.EmitValue(End, AddrSize);
        }
        SmallVectorImpl<std.string> MCDwarfDirs = context.getMCDwarfDirs();
        if (Unsigned.$greater_uint((int)MCDwarfDirs.size(), (int)0)) {
            MCOS.EmitBytes(new StringRef(MCDwarfDirs.$at$Const(0)));
            MCOS.EmitBytes(path.get_separator());
        }
        SmallVectorImpl<MCDwarfFile> MCDwarfFiles = MCOS.getContext().getMCDwarfFiles();
        MCOS.EmitBytes(new StringRef(MCDwarfFiles.$at$Const((int)1).Name));
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        if (!context.getCompilationDir().empty()) {
            MCOS.EmitBytes(context.getCompilationDir());
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        }
        if (!(DwarfDebugFlags = context.getDwarfDebugFlags()).empty()) {
            MCOS.EmitBytes(new StringRef(DwarfDebugFlags));
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        }
        if (!(DwarfDebugProducer = context.getDwarfDebugProducer()).empty()) {
            MCOS.EmitBytes(new StringRef(DwarfDebugProducer));
        } else {
            MCOS.EmitBytes(new StringRef("llvm-mc (based on LLVM 3.9.0)"));
        }
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        MCOS.EmitIntValue(Unsigned.$uint2ulong((int)32769), 2);
        std.vector<MCGenDwarfLabelEntry> Entries = MCOS.getContext().getMCGenDwarfLabelEntries();
        for (MCGenDwarfLabelEntry Entry2 : Entries) {
            MCOS.EmitULEB128IntValue(Unsigned.$int2ulong((int)2));
            MCOS.EmitBytes(Entry2.getName());
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
            MCOS.EmitIntValue(Unsigned.$uint2ulong((int)Entry2.getFileNumber()), 4);
            MCOS.EmitIntValue(Unsigned.$uint2ulong((int)Entry2.getLineNumber()), 4);
            MCSymbolRefExpr AT_low_pc = MCSymbolRefExpr.create(Entry2.getLabel(), MCSymbolRefExpr.VariantKind.VK_None, context);
            MCOS.EmitValue(AT_low_pc, AddrSize);
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
            MCOS.EmitULEB128IntValue(Unsigned.$int2ulong((int)3));
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        }
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        MCOS.EmitLabel(InfoEnd);
    }

    public static void EmitGenDwarfRanges(MCStreamer MCOS) {
        MCContext context = MCOS.getContext();
        SetVector<MCSection> Sections = context.getGenDwarfSectionSyms();
        MCAsmInfo AsmInfo = context.getAsmInfo();
        int AddrSize = AsmInfo.getPointerSize();
        MCOS.SwitchSection(context.getObjectFileInfo().getDwarfRangesSection());
        for (MCSection Sec : Sections) {
            MCSymbol StartSymbol = Sec.getBeginSymbol();
            MCSymbol EndSymbol = Sec.getEndSymbol(context);
            assert (StartSymbol != null) : "StartSymbol must not be NULL";
            assert (EndSymbol != null) : "EndSymbol must not be NULL";
            MCSymbolRefExpr SectionStartAddr = MCSymbolRefExpr.create(StartSymbol, MCSymbolRefExpr.VariantKind.VK_None, context);
            MCOS.emitFill(Unsigned.$int2ulong((int)AddrSize), Unsigned.$int2uchar((int)255));
            MCOS.EmitValue(SectionStartAddr, AddrSize);
            MCExpr SectionSize = MCDwarfStatics.MakeStartMinusEndExpr((MCStreamer)Native.$Deref((Object)MCOS), (MCSymbol)Native.$Deref((Object)StartSymbol), (MCSymbol)Native.$Deref((Object)EndSymbol), 0);
            MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), AddrSize);
            MCDwarfStatics.emitAbsValue((MCStreamer)Native.$Deref((Object)MCOS), SectionSize, AddrSize);
        }
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), AddrSize);
        MCOS.EmitIntValue(Unsigned.$int2ulong((int)0), AddrSize);
    }

    public static int getDataAlignmentFactor(MCStreamer streamer) {
        MCContext context = streamer.getContext();
        MCAsmInfo asmInfo = context.getAsmInfo();
        int size = asmInfo.getCalleeSaveStackSlotSize();
        if (asmInfo.isStackGrowthDirectionUp()) {
            return size;
        }
        return -size;
    }

    public static int getSizeForEncoding(MCStreamer streamer, int symbolEncoding) {
        MCContext context = streamer.getContext();
        int format = symbolEncoding & 0xF;
        switch (format) {
            default: {
                throw new llvm_unreachable("Unknown Encoding");
            }
            case 0: 
            case 8: {
                return context.getAsmInfo().getPointerSize();
            }
            case 2: 
            case 10: {
                return 2;
            }
            case 3: 
            case 11: {
                return 4;
            }
            case 4: 
            case 12: 
        }
        return 8;
    }

    public static void emitFDESymbol(MCObjectStreamer streamer, MCSymbol symbol2, int symbolEncoding, boolean isEH) {
        MCContext context = streamer.getContext();
        MCAsmInfo asmInfo = context.getAsmInfo();
        MCExpr v = asmInfo.getExprForFDESymbol((MCSymbol)Native.$AddrOf((Object)symbol2), symbolEncoding, streamer);
        int size = MCDwarfStatics.getSizeForEncoding(streamer, symbolEncoding);
        if (asmInfo.doDwarfFDESymbolsUseAbsDiff() && isEH) {
            MCDwarfStatics.emitAbsValue(streamer, v, size);
        } else {
            streamer.EmitValue(v, size);
        }
    }

    public static void EmitPersonality(MCStreamer streamer, MCSymbol symbol2, int symbolEncoding) {
        MCContext context = streamer.getContext();
        MCAsmInfo asmInfo = context.getAsmInfo();
        MCExpr v = asmInfo.getExprForPersonalitySymbol((MCSymbol)Native.$AddrOf((Object)symbol2), symbolEncoding, streamer);
        int size = MCDwarfStatics.getSizeForEncoding(streamer, symbolEncoding);
        streamer.EmitValue(v, size);
    }

    public static void emitEncodingByte(MCObjectStreamer Streamer, int Encoding) {
        Streamer.EmitIntValue(Unsigned.$uint2ulong((int)Encoding), 1);
    }

    public static int getCIEVersion(boolean IsEH, int DwarfVersion) {
        if (IsEH) {
            return 1;
        }
        switch (DwarfVersion) {
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: 
            case 5: {
                return 4;
            }
        }
        throw new llvm_unreachable("Unknown version");
    }
}

