/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.uchar;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAlignFragment;
import org.llvm.mc.MCAsmLayout;
import org.llvm.mc.MCAssembler;
import org.llvm.mc.MCCVDefRangeFragment;
import org.llvm.mc.MCCVInlineLineTableFragment;
import org.llvm.mc.MCDwarfCallFrameFragment;
import org.llvm.mc.MCDwarfLineAddrFragment;
import org.llvm.mc.MCFillFragment;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCLEBFragment;
import org.llvm.mc.MCObjectWriter;
import org.llvm.mc.MCOrgFragment;
import org.llvm.mc.MCSafeSEHFragment;
import org.llvm.mc.stats.impl.StatsStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class MCAssemblerStatics {
    public static void writeFragment(MCAssembler Asm, MCAsmLayout Layout, MCFragment F) {
        MCObjectWriter OW = (MCObjectWriter)Native.$AddrOf((Object)Asm.getWriter());
        long FragmentSize = Asm.computeFragmentSize(Layout, F);
        Asm.writeFragmentPadding(F, FragmentSize, OW);
        long Start = OW.getStream().tell();
        StatsStatics.EmittedFragments.$preInc();
        switch (F.getKind()) {
            case FT_Align: {
                StatsStatics.EmittedAlignFragments.$preInc();
                MCAlignFragment AF = ADTRTTI.cast_MCAlignFragment(F);
                assert (AF.getValueSize() != 0) : "Invalid virtual align in concrete fragment!";
                long Count = Unsigned.$div_ulong_uint((long)FragmentSize, (int)AF.getValueSize());
                if (Count * Unsigned.$uint2ullong((int)AF.getValueSize()) != FragmentSize) {
                    llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_Twine$C(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("undefined .align directive, value size '"), new Twine(JavaDifferentiators.JD.UInt.INSTANCE, AF.getValueSize())), new Twine("' is not a divisor of padding size '")), new Twine(JavaDifferentiators.JD.ConstULLongRef.INSTANCE, FragmentSize)), new Twine(NativePointer.$SGL_QUOTE)));
                }
                if (AF.hasEmitNops()) {
                    if (Asm.getBackend().writeNopData(Count, OW)) break;
                    llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("unable to write nop sequence of "), new Twine(JavaDifferentiators.JD.ConstULLongRef.INSTANCE, Count)), new Twine(" bytes")));
                    break;
                }
                block21: for (long i = Unsigned.$int2ulong((int)0); i != Count; ++i) {
                    switch (AF.getValueSize()) {
                        default: {
                            throw new llvm_unreachable("Invalid size!");
                        }
                        case 1: {
                            OW.write8(Unsigned.$long2uchar((long)AF.getValue()));
                            continue block21;
                        }
                        case 2: {
                            OW.write16(Unsigned.$long2ushort((long)AF.getValue()));
                            continue block21;
                        }
                        case 4: {
                            OW.write32(Unsigned.$long2uint((long)AF.getValue()));
                            continue block21;
                        }
                        case 8: {
                            OW.write64(AF.getValue());
                        }
                    }
                }
                break;
            }
            case FT_Data: {
                StatsStatics.EmittedDataFragments.$preInc();
                OW.writeBytes(ADTRTTI.cast_MCDataFragment(F).getContents$Const());
                break;
            }
            case FT_Relaxable: {
                StatsStatics.EmittedRelaxableFragments.$preInc();
                OW.writeBytes(ADTRTTI.cast_MCRelaxableFragment(F).getContents$Const());
                break;
            }
            case FT_CompactEncodedInst: {
                StatsStatics.EmittedCompactEncodedInstFragments.$preInc();
                OW.writeBytes(ADTRTTI.cast_MCCompactEncodedInstFragment(F).getContents$Const());
                break;
            }
            case FT_Fill: {
                StatsStatics.EmittedFillFragments.$preInc();
                MCFillFragment FF = ADTRTTI.cast_MCFillFragment(F);
                uchar.ptr V = NativePointer.create_uchar$ptr((byte[])new byte[]{FF.getValue()});
                int MaxChunkSize = 16;
                byte[] Data = NativePointer.new$char((int)16, (byte[])new byte[0]);
                std.memcpy((byte[])Data, (uchar.ptr)((uchar.ptr)Native.$AddrOf((Object)V)), (int)1);
                int I = 1;
                while (Unsigned.$less_uint((int)I, (int)MaxChunkSize)) {
                    Data[I] = Data[0];
                    ++I;
                }
                long Size = FF.getSize();
                int ChunkSize = MaxChunkSize;
                while (ChunkSize != 0) {
                    StringRef Ref = new StringRef(Data, ChunkSize);
                    long E = Unsigned.$div_ulong_uint((long)Size, (int)ChunkSize);
                    for (long I2 = Unsigned.$int2ulong((int)0); I2 != E; ++I2) {
                        OW.writeBytes(new StringRef(Ref));
                    }
                    Size = Unsigned.$rem_ulong_uint((long)Size, (int)ChunkSize);
                    ChunkSize = Unsigned.$div_uint((int)ChunkSize, (int)2);
                }
                break;
            }
            case FT_LEB: {
                MCLEBFragment LF = ADTRTTI.cast_MCLEBFragment(F);
                OW.writeBytes(LF.getContents$Const());
                break;
            }
            case FT_SafeSEH: {
                MCSafeSEHFragment SF = ADTRTTI.cast_MCSafeSEHFragment(F);
                OW.write32(SF.getSymbol$Const().getIndex());
                break;
            }
            case FT_Org: {
                StatsStatics.EmittedOrgFragments.$preInc();
                MCOrgFragment OF = ADTRTTI.cast_MCOrgFragment(F);
                long e = FragmentSize;
                for (long i = Unsigned.$int2ulong((int)0); i != e; ++i) {
                    OW.write8(OF.getValue());
                }
                break;
            }
            case FT_Dwarf: {
                MCDwarfLineAddrFragment OF = ADTRTTI.cast_MCDwarfLineAddrFragment(F);
                OW.writeBytes(OF.getContents$Const());
                break;
            }
            case FT_DwarfFrame: {
                MCDwarfCallFrameFragment CF = ADTRTTI.cast_MCDwarfCallFrameFragment(F);
                OW.writeBytes(CF.getContents$Const());
                break;
            }
            case FT_CVInlineLines: {
                MCCVInlineLineTableFragment OF = ADTRTTI.cast_MCCVInlineLineTableFragment(F);
                OW.writeBytes(OF.getContents$Const());
                break;
            }
            case FT_CVDefRange: {
                MCCVDefRangeFragment DRF = ADTRTTI.cast_MCCVDefRangeFragment(F);
                OW.writeBytes(DRF.getContents$Const());
                break;
            }
            case FT_Dummy: {
                throw new llvm_unreachable("Should not have been added");
            }
        }
        assert (OW.getStream().tell() - Start == FragmentSize) : "The stream should advance by fragment size";
    }
}

