/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.SmallString;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCCFIInstruction;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDwarfFrameInfo;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCObjectFileInfo;
import org.llvm.mc.MCObjectStreamer;
import org.llvm.mc.MCRegisterInfo;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.impl.MCDwarfStatics;
import org.llvm.support.llvm_unreachable;

public class FrameEmitterImpl {
    private int CFAOffset = 0;
    private int InitialCFAOffset = 0;
    private boolean IsEH;
    private final MCObjectStreamer Streamer;

    public FrameEmitterImpl(boolean IsEH, MCObjectStreamer Streamer) {
        this.IsEH = IsEH;
        this.Streamer = Streamer;
    }

    public void EmitCompactUnwind(MCDwarfFrameInfo Frame) {
        boolean DwarfEHFrameOnly;
        MCContext Context = this.Streamer.getContext();
        MCObjectFileInfo MOFI = Context.getObjectFileInfo();
        int Encoding = Frame.CompactUnwindEncoding;
        if (Encoding == 0) {
            return;
        }
        boolean bl = DwarfEHFrameOnly = Encoding == MOFI.getCompactUnwindDwarfEHFrameOnly();
        if (!DwarfEHFrameOnly && Frame.Lsda != null) {
            Encoding |= 0x40000000;
        }
        int FDEEncoding = MOFI.getFDEEncoding();
        int Size = MCDwarfStatics.getSizeForEncoding(this.Streamer, FDEEncoding);
        this.Streamer.EmitSymbolValue(Frame.Begin, Size);
        MCExpr Range = MCDwarfStatics.MakeStartMinusEndExpr(this.Streamer, (MCSymbol)Native.$Deref((Object)Frame.Begin), (MCSymbol)Native.$Deref((Object)Frame.End), 0);
        MCDwarfStatics.emitAbsValue(this.Streamer, Range, 4);
        Size = MCDwarfStatics.getSizeForEncoding(this.Streamer, 3);
        this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)Encoding), Size);
        Size = MCDwarfStatics.getSizeForEncoding(this.Streamer, 0);
        if (!DwarfEHFrameOnly && Frame.Personality != null) {
            this.Streamer.EmitSymbolValue(Frame.Personality, Size);
        } else {
            this.Streamer.EmitIntValue(Unsigned.$int2ulong((int)0), Size);
        }
        Size = MCDwarfStatics.getSizeForEncoding(this.Streamer, Frame.LsdaEncoding);
        if (!DwarfEHFrameOnly && Frame.Lsda != null) {
            this.Streamer.EmitSymbolValue(Frame.Lsda, Size);
        } else {
            this.Streamer.EmitIntValue(Unsigned.$int2ulong((int)0), Size);
        }
    }

    public MCSymbol EmitCIE(MCSymbol personality, int personalityEncoding, MCSymbol lsda, boolean IsSignalFrame, int lsdaEncoding, boolean IsSimple) {
        MCContext context = this.Streamer.getContext();
        MCRegisterInfo MRI = context.getRegisterInfo();
        MCObjectFileInfo MOFI = context.getObjectFileInfo();
        MCSymbol sectionStart = context.createTempSymbol();
        this.Streamer.EmitLabel(sectionStart);
        MCSymbol sectionEnd = context.createTempSymbol();
        MCExpr Length = MCDwarfStatics.MakeStartMinusEndExpr(this.Streamer, (MCSymbol)Native.$Deref((Object)sectionStart), (MCSymbol)Native.$Deref((Object)sectionEnd), 4);
        MCDwarfStatics.emitAbsValue(this.Streamer, Length, 4);
        int CIE_ID = this.IsEH ? 0 : -1;
        this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)CIE_ID), 4);
        byte CIEVersion = Unsigned.$uint2uchar((int)MCDwarfStatics.getCIEVersion(this.IsEH, Unsigned.$ushort2uint((char)context.getDwarfVersion())));
        this.Streamer.EmitIntValue(Unsigned.$uchar2ulong((byte)CIEVersion), 1);
        SmallString Augmentation = new SmallString(8);
        if (this.IsEH) {
            Augmentation.$addassign("z");
            if (personality != null) {
                Augmentation.$addassign("P");
            }
            if (lsda != null) {
                Augmentation.$addassign("L");
            }
            Augmentation.$addassign("R");
            if (IsSignalFrame) {
                Augmentation.$addassign("S");
            }
            this.Streamer.EmitBytes(Augmentation.$StringRef());
        }
        this.Streamer.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        if (Unsigned.$uchar2int((byte)CIEVersion) >= 4) {
            this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)context.getAsmInfo().getPointerSize()), 1);
            this.Streamer.EmitIntValue(Unsigned.$int2ulong((int)0), 1);
        }
        this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)context.getAsmInfo().getMinInstAlignment()));
        this.Streamer.EmitSLEB128IntValue(MCDwarfStatics.getDataAlignmentFactor(this.Streamer));
        if (Unsigned.$uchar2int((byte)CIEVersion) == 1) {
            assert (Unsigned.$lesseq_uint((int)MRI.getRARegister(), (int)255)) : "DWARF 2 encodes return_address_register in one byte";
            this.Streamer.EmitIntValue(Unsigned.$int2ulong((int)MRI.getDwarfRegNum(MRI.getRARegister(), this.IsEH)), 1);
        } else {
            this.Streamer.EmitULEB128IntValue(Unsigned.$int2ulong((int)MRI.getDwarfRegNum(MRI.getRARegister(), this.IsEH)));
        }
        int augmentationLength = 0;
        if (this.IsEH) {
            if (personality != null) {
                ++augmentationLength;
                augmentationLength += MCDwarfStatics.getSizeForEncoding(this.Streamer, personalityEncoding);
            }
            if (lsda != null) {
                ++augmentationLength;
            }
            this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)(++augmentationLength)));
            if (personality != null) {
                MCDwarfStatics.emitEncodingByte(this.Streamer, personalityEncoding);
                MCDwarfStatics.EmitPersonality(this.Streamer, (MCSymbol)Native.$Deref((Object)personality), personalityEncoding);
            }
            if (lsda != null) {
                MCDwarfStatics.emitEncodingByte(this.Streamer, lsdaEncoding);
            }
            MCDwarfStatics.emitEncodingByte(this.Streamer, MOFI.getFDEEncoding());
        }
        MCAsmInfo MAI = context.getAsmInfo();
        if (!IsSimple) {
            std.vector<MCCFIInstruction> Instructions = MAI.getInitialFrameState();
            this.EmitCFIInstructions(new ArrayRef<MCCFIInstruction>(Instructions, false), null);
        }
        this.InitialCFAOffset = this.CFAOffset;
        this.Streamer.EmitValueToAlignment(this.IsEH ? 4 : MAI.getPointerSize());
        this.Streamer.EmitLabel(sectionEnd);
        return (MCSymbol)Native.$Deref((Object)sectionStart);
    }

    public void EmitFDE(MCSymbol cieStart, MCDwarfFrameInfo frame, boolean LastInSection, MCSymbol SectionStart) {
        MCExpr offset;
        MCContext context = this.Streamer.getContext();
        MCSymbol fdeStart = context.createTempSymbol();
        MCSymbol fdeEnd = context.createTempSymbol();
        MCObjectFileInfo MOFI = context.getObjectFileInfo();
        this.CFAOffset = this.InitialCFAOffset;
        MCExpr Length = MCDwarfStatics.MakeStartMinusEndExpr(this.Streamer, (MCSymbol)Native.$Deref((Object)fdeStart), (MCSymbol)Native.$Deref((Object)fdeEnd), 0);
        MCDwarfStatics.emitAbsValue(this.Streamer, Length, 4);
        this.Streamer.EmitLabel(fdeStart);
        MCAsmInfo asmInfo = context.getAsmInfo();
        if (this.IsEH) {
            offset = MCDwarfStatics.MakeStartMinusEndExpr(this.Streamer, cieStart, (MCSymbol)Native.$Deref((Object)fdeStart), 0);
            MCDwarfStatics.emitAbsValue(this.Streamer, offset, 4);
        } else if (!asmInfo.doesDwarfUseRelocationsAcrossSections()) {
            offset = MCDwarfStatics.MakeStartMinusEndExpr(this.Streamer, SectionStart, cieStart, 0);
            MCDwarfStatics.emitAbsValue(this.Streamer, offset, 4);
        } else {
            this.Streamer.EmitSymbolValue((MCSymbol)Native.$AddrOf((Object)cieStart), 4);
        }
        int PCEncoding = this.IsEH ? MOFI.getFDEEncoding() : 0;
        int PCSize = MCDwarfStatics.getSizeForEncoding(this.Streamer, PCEncoding);
        MCDwarfStatics.emitFDESymbol(this.Streamer, (MCSymbol)Native.$Deref((Object)frame.Begin), PCEncoding, this.IsEH);
        MCExpr Range = MCDwarfStatics.MakeStartMinusEndExpr(this.Streamer, (MCSymbol)Native.$Deref((Object)frame.Begin), (MCSymbol)Native.$Deref((Object)frame.End), 0);
        MCDwarfStatics.emitAbsValue(this.Streamer, Range, PCSize);
        if (this.IsEH) {
            int augmentationLength = 0;
            if (frame.Lsda != null) {
                augmentationLength += MCDwarfStatics.getSizeForEncoding(this.Streamer, frame.LsdaEncoding);
            }
            this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)augmentationLength));
            if (frame.Lsda != null) {
                MCDwarfStatics.emitFDESymbol(this.Streamer, (MCSymbol)Native.$Deref((Object)frame.Lsda), frame.LsdaEncoding, true);
            }
        }
        this.EmitCFIInstructions(new ArrayRef<MCCFIInstruction>(frame.Instructions, false), frame.Begin);
        int Align = LastInSection ? asmInfo.getPointerSize() : PCSize;
        this.Streamer.EmitValueToAlignment(Align);
        this.Streamer.EmitLabel(fdeEnd);
    }

    public void EmitCFIInstructions(ArrayRef<MCCFIInstruction> Instrs, MCSymbol BaseLabel) {
        for (MCCFIInstruction Instr : Instrs) {
            MCSymbol ThisSym;
            MCSymbol Label = Instr.getLabel();
            if (Label != null && !Label.isDefined()) continue;
            if (BaseLabel != null && Label != null && (ThisSym = Label) != BaseLabel) {
                this.Streamer.EmitDwarfAdvanceFrameAddr(BaseLabel, ThisSym);
                BaseLabel = ThisSym;
            }
            this.EmitCFIInstruction(Instr);
        }
    }

    public void EmitCFIInstruction(MCCFIInstruction Instr) {
        int dataAlignmentFactor = MCDwarfStatics.getDataAlignmentFactor(this.Streamer);
        MCRegisterInfo MRI = this.Streamer.getContext().getRegisterInfo();
        switch (Instr.getOperation()) {
            case OpRegister: {
                int Reg1 = Instr.getRegister();
                int Reg2 = Instr.getRegister2();
                if (!this.IsEH) {
                    Reg1 = MRI.getDwarfRegNum(MRI.getLLVMRegNum(Reg1, true), false);
                    Reg2 = MRI.getDwarfRegNum(MRI.getLLVMRegNum(Reg2, true), false);
                }
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)9), 1);
                this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg1));
                this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg2));
                return;
            }
            case OpWindowSave: {
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)45), 1);
                return;
            }
            case OpUndefined: {
                int Reg = Instr.getRegister();
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)7), 1);
                this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg));
                return;
            }
            case OpAdjustCfaOffset: 
            case OpDefCfaOffset: {
                boolean IsRelative = Instr.getOperation() == MCCFIInstruction.OpType.OpAdjustCfaOffset;
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)14), 1);
                this.CFAOffset = IsRelative ? (this.CFAOffset += Instr.getOffset()) : -Instr.getOffset();
                this.Streamer.EmitULEB128IntValue(Unsigned.$int2ulong((int)this.CFAOffset));
                return;
            }
            case OpDefCfa: {
                int Reg = Instr.getRegister();
                if (!this.IsEH) {
                    Reg = MRI.getDwarfRegNum(MRI.getLLVMRegNum(Reg, true), false);
                }
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)12), 1);
                this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg));
                this.CFAOffset = -Instr.getOffset();
                this.Streamer.EmitULEB128IntValue(Unsigned.$int2ulong((int)this.CFAOffset));
                return;
            }
            case OpDefCfaRegister: {
                int Reg = Instr.getRegister();
                if (!this.IsEH) {
                    Reg = MRI.getDwarfRegNum(MRI.getLLVMRegNum(Reg, true), false);
                }
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)13), 1);
                this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg));
                return;
            }
            case OpOffset: 
            case OpRelOffset: {
                boolean IsRelative = Instr.getOperation() == MCCFIInstruction.OpType.OpRelOffset;
                int Reg = Instr.getRegister();
                if (!this.IsEH) {
                    Reg = MRI.getDwarfRegNum(MRI.getLLVMRegNum(Reg, true), false);
                }
                int Offset = Instr.getOffset();
                if (IsRelative) {
                    Offset -= this.CFAOffset;
                }
                if ((Offset /= dataAlignmentFactor) < 0) {
                    this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)17), 1);
                    this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg));
                    this.Streamer.EmitSLEB128IntValue(Offset);
                } else if (Unsigned.$less_uint((int)Reg, (int)64)) {
                    this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)(128 + Reg)), 1);
                    this.Streamer.EmitULEB128IntValue(Unsigned.$int2ulong((int)Offset));
                } else {
                    this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)5), 1);
                    this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg));
                    this.Streamer.EmitULEB128IntValue(Unsigned.$int2ulong((int)Offset));
                }
                return;
            }
            case OpRememberState: {
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)10), 1);
                return;
            }
            case OpRestoreState: {
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)11), 1);
                return;
            }
            case OpSameValue: {
                int Reg = Instr.getRegister();
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)8), 1);
                this.Streamer.EmitULEB128IntValue(Unsigned.$uint2ulong((int)Reg));
                return;
            }
            case OpRestore: {
                int Reg = Instr.getRegister();
                if (!this.IsEH) {
                    Reg = MRI.getDwarfRegNum(MRI.getLLVMRegNum(Reg, true), false);
                }
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)(0xC0 | Reg)), 1);
                return;
            }
            case OpGnuArgsSize: {
                this.Streamer.EmitIntValue(Unsigned.$uint2ulong((int)46), 1);
                this.Streamer.EmitULEB128IntValue(Unsigned.$int2ulong((int)Instr.getOffset()));
                return;
            }
            case OpEscape: {
                this.Streamer.EmitBytes(Instr.getValues());
                return;
            }
        }
        throw new llvm_unreachable("Unhandled case in switch");
    }

    public String toString() {
        return "CFAOffset=" + this.CFAOffset + ", InitialCFAOffset=" + this.InitialCFAOffset + ", IsEH=" + this.IsEH + ", Streamer=" + this.Streamer;
    }
}

