/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Twine;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCContextGlobals;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCSymbol;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class MCSymbolRefExpr
extends MCExpr {
    private VariantKind Kind;
    private boolean UseParensForSymbolVariant;
    private boolean HasSubsectionsViaSymbols;
    private MCSymbol Symbol;

    private MCSymbolRefExpr(MCSymbol Symbol, VariantKind Kind2, MCAsmInfo MAI) {
        super(MCExpr.ExprKind.SymbolRef);
        this.Kind = Kind2;
        this.UseParensForSymbolVariant = MAI.useParensForSymbolVariant();
        this.HasSubsectionsViaSymbols = MAI.hasSubsectionsViaSymbols();
        this.Symbol = Symbol;
        assert (Native.$bool((Object)Symbol));
    }

    public static MCSymbolRefExpr create(MCSymbol Symbol, MCContext Ctx) {
        return MCSymbolRefExpr.create(Symbol, VariantKind.VK_None, Ctx);
    }

    public static MCSymbolRefExpr create(MCSymbol Sym, VariantKind Kind2, MCContext Ctx) {
        return (MCSymbolRefExpr)MCContextGlobals.$new_uint_MCContext_uint(Ctx, New$Mem -> new MCSymbolRefExpr(Sym, Kind2, Ctx.getAsmInfo()));
    }

    public static MCSymbolRefExpr create(StringRef Name2, VariantKind Kind2, MCContext Ctx) {
        return MCSymbolRefExpr.create(Ctx.getOrCreateSymbol(new Twine(Name2)), Kind2, Ctx);
    }

    public MCSymbol getSymbol() {
        return (MCSymbol)Native.$Deref((Object)this.Symbol);
    }

    @Override
    public Native.NativeUShortEnum getKind() {
        return this.Kind;
    }

    public void printVariantKind(raw_ostream OS) {
        if (this.UseParensForSymbolVariant) {
            OS.$out_char((byte)40).$out(MCSymbolRefExpr.getVariantKindName((VariantKind)this.getKind())).$out_char((byte)41);
        } else {
            OS.$out_char((byte)64).$out(MCSymbolRefExpr.getVariantKindName((VariantKind)this.getKind()));
        }
    }

    public boolean hasSubsectionsViaSymbols() {
        return this.HasSubsectionsViaSymbols;
    }

    public static StringRef getVariantKindName(VariantKind Kind2) {
        switch (Kind2) {
            case VK_Invalid: {
                return new StringRef("<<invalid>>");
            }
            case VK_None: {
                return new StringRef("<<none>>");
            }
            case VK_DTPOFF: {
                return new StringRef("DTPOFF");
            }
            case VK_DTPREL: {
                return new StringRef("DTPREL");
            }
            case VK_GOT: {
                return new StringRef("GOT");
            }
            case VK_GOTOFF: {
                return new StringRef("GOTOFF");
            }
            case VK_GOTREL: {
                return new StringRef("GOTREL");
            }
            case VK_GOTPCREL: {
                return new StringRef("GOTPCREL");
            }
            case VK_GOTTPOFF: {
                return new StringRef("GOTTPOFF");
            }
            case VK_INDNTPOFF: {
                return new StringRef("INDNTPOFF");
            }
            case VK_NTPOFF: {
                return new StringRef("NTPOFF");
            }
            case VK_GOTNTPOFF: {
                return new StringRef("GOTNTPOFF");
            }
            case VK_PLT: {
                return new StringRef("PLT");
            }
            case VK_TLSGD: {
                return new StringRef("TLSGD");
            }
            case VK_TLSLD: {
                return new StringRef("TLSLD");
            }
            case VK_TLSLDM: {
                return new StringRef("TLSLDM");
            }
            case VK_TPOFF: {
                return new StringRef("TPOFF");
            }
            case VK_TPREL: {
                return new StringRef("TPREL");
            }
            case VK_TLSCALL: {
                return new StringRef("tlscall");
            }
            case VK_TLSDESC: {
                return new StringRef("tlsdesc");
            }
            case VK_TLVP: {
                return new StringRef("TLVP");
            }
            case VK_TLVPPAGE: {
                return new StringRef("TLVPPAGE");
            }
            case VK_TLVPPAGEOFF: {
                return new StringRef("TLVPPAGEOFF");
            }
            case VK_PAGE: {
                return new StringRef("PAGE");
            }
            case VK_PAGEOFF: {
                return new StringRef("PAGEOFF");
            }
            case VK_GOTPAGE: {
                return new StringRef("GOTPAGE");
            }
            case VK_GOTPAGEOFF: {
                return new StringRef("GOTPAGEOFF");
            }
            case VK_SECREL: {
                return new StringRef("SECREL32");
            }
            case VK_SIZE: {
                return new StringRef("SIZE");
            }
            case VK_WEAKREF: {
                return new StringRef("WEAKREF");
            }
            case VK_ARM_NONE: {
                return new StringRef("none");
            }
            case VK_ARM_GOT_PREL: {
                return new StringRef("GOT_PREL");
            }
            case VK_ARM_TARGET1: {
                return new StringRef("target1");
            }
            case VK_ARM_TARGET2: {
                return new StringRef("target2");
            }
            case VK_ARM_PREL31: {
                return new StringRef("prel31");
            }
            case VK_ARM_SBREL: {
                return new StringRef("sbrel");
            }
            case VK_ARM_TLSLDO: {
                return new StringRef("tlsldo");
            }
            case VK_ARM_TLSDESCSEQ: {
                return new StringRef("tlsdescseq");
            }
            case VK_PPC_LO: {
                return new StringRef(NativePointer.$l);
            }
            case VK_PPC_HI: {
                return new StringRef(NativePointer.$h);
            }
            case VK_PPC_HA: {
                return new StringRef("ha");
            }
            case VK_PPC_HIGHER: {
                return new StringRef("higher");
            }
            case VK_PPC_HIGHERA: {
                return new StringRef("highera");
            }
            case VK_PPC_HIGHEST: {
                return new StringRef("highest");
            }
            case VK_PPC_HIGHESTA: {
                return new StringRef("highesta");
            }
            case VK_PPC_GOT_LO: {
                return new StringRef("got@l");
            }
            case VK_PPC_GOT_HI: {
                return new StringRef("got@h");
            }
            case VK_PPC_GOT_HA: {
                return new StringRef("got@ha");
            }
            case VK_PPC_TOCBASE: {
                return new StringRef("tocbase");
            }
            case VK_PPC_TOC: {
                return new StringRef("toc");
            }
            case VK_PPC_TOC_LO: {
                return new StringRef("toc@l");
            }
            case VK_PPC_TOC_HI: {
                return new StringRef("toc@h");
            }
            case VK_PPC_TOC_HA: {
                return new StringRef("toc@ha");
            }
            case VK_PPC_DTPMOD: {
                return new StringRef("dtpmod");
            }
            case VK_PPC_TPREL_LO: {
                return new StringRef("tprel@l");
            }
            case VK_PPC_TPREL_HI: {
                return new StringRef("tprel@h");
            }
            case VK_PPC_TPREL_HA: {
                return new StringRef("tprel@ha");
            }
            case VK_PPC_TPREL_HIGHER: {
                return new StringRef("tprel@higher");
            }
            case VK_PPC_TPREL_HIGHERA: {
                return new StringRef("tprel@highera");
            }
            case VK_PPC_TPREL_HIGHEST: {
                return new StringRef("tprel@highest");
            }
            case VK_PPC_TPREL_HIGHESTA: {
                return new StringRef("tprel@highesta");
            }
            case VK_PPC_DTPREL_LO: {
                return new StringRef("dtprel@l");
            }
            case VK_PPC_DTPREL_HI: {
                return new StringRef("dtprel@h");
            }
            case VK_PPC_DTPREL_HA: {
                return new StringRef("dtprel@ha");
            }
            case VK_PPC_DTPREL_HIGHER: {
                return new StringRef("dtprel@higher");
            }
            case VK_PPC_DTPREL_HIGHERA: {
                return new StringRef("dtprel@highera");
            }
            case VK_PPC_DTPREL_HIGHEST: {
                return new StringRef("dtprel@highest");
            }
            case VK_PPC_DTPREL_HIGHESTA: {
                return new StringRef("dtprel@highesta");
            }
            case VK_PPC_GOT_TPREL: {
                return new StringRef("got@tprel");
            }
            case VK_PPC_GOT_TPREL_LO: {
                return new StringRef("got@tprel@l");
            }
            case VK_PPC_GOT_TPREL_HI: {
                return new StringRef("got@tprel@h");
            }
            case VK_PPC_GOT_TPREL_HA: {
                return new StringRef("got@tprel@ha");
            }
            case VK_PPC_GOT_DTPREL: {
                return new StringRef("got@dtprel");
            }
            case VK_PPC_GOT_DTPREL_LO: {
                return new StringRef("got@dtprel@l");
            }
            case VK_PPC_GOT_DTPREL_HI: {
                return new StringRef("got@dtprel@h");
            }
            case VK_PPC_GOT_DTPREL_HA: {
                return new StringRef("got@dtprel@ha");
            }
            case VK_PPC_TLS: {
                return new StringRef("tls");
            }
            case VK_PPC_GOT_TLSGD: {
                return new StringRef("got@tlsgd");
            }
            case VK_PPC_GOT_TLSGD_LO: {
                return new StringRef("got@tlsgd@l");
            }
            case VK_PPC_GOT_TLSGD_HI: {
                return new StringRef("got@tlsgd@h");
            }
            case VK_PPC_GOT_TLSGD_HA: {
                return new StringRef("got@tlsgd@ha");
            }
            case VK_PPC_TLSGD: {
                return new StringRef("tlsgd");
            }
            case VK_PPC_GOT_TLSLD: {
                return new StringRef("got@tlsld");
            }
            case VK_PPC_GOT_TLSLD_LO: {
                return new StringRef("got@tlsld@l");
            }
            case VK_PPC_GOT_TLSLD_HI: {
                return new StringRef("got@tlsld@h");
            }
            case VK_PPC_GOT_TLSLD_HA: {
                return new StringRef("got@tlsld@ha");
            }
            case VK_PPC_TLSLD: {
                return new StringRef("tlsld");
            }
            case VK_PPC_LOCAL: {
                return new StringRef(NativePointer.$local);
            }
            case VK_COFF_IMGREL32: {
                return new StringRef("IMGREL");
            }
            case VK_Hexagon_PCREL: {
                return new StringRef("PCREL");
            }
            case VK_Hexagon_LO16: {
                return new StringRef("LO16");
            }
            case VK_Hexagon_HI16: {
                return new StringRef("HI16");
            }
            case VK_Hexagon_GPREL: {
                return new StringRef("GPREL");
            }
            case VK_Hexagon_GD_GOT: {
                return new StringRef("GDGOT");
            }
            case VK_Hexagon_LD_GOT: {
                return new StringRef("LDGOT");
            }
            case VK_Hexagon_GD_PLT: {
                return new StringRef("GDPLT");
            }
            case VK_Hexagon_LD_PLT: {
                return new StringRef("LDPLT");
            }
            case VK_Hexagon_IE: {
                return new StringRef("IE");
            }
            case VK_Hexagon_IE_GOT: {
                return new StringRef("IEGOT");
            }
            case VK_WebAssembly_FUNCTION: {
                return new StringRef("FUNCTION");
            }
        }
        throw new llvm_unreachable("Invalid variant kind");
    }

    public static VariantKind getVariantKindForName(StringRef Name2) {
        return new StringSwitch<VariantKind>(new StringRef(Name2.lower())).Case("dtprel", VariantKind.VK_DTPREL).Case("dtpoff", VariantKind.VK_DTPOFF).Case("got", VariantKind.VK_GOT).Case("gotoff", VariantKind.VK_GOTOFF).Case("gotrel", VariantKind.VK_GOTREL).Case("gotpcrel", VariantKind.VK_GOTPCREL).Case("gottpoff", VariantKind.VK_GOTTPOFF).Case("indntpoff", VariantKind.VK_INDNTPOFF).Case("ntpoff", VariantKind.VK_NTPOFF).Case("gotntpoff", VariantKind.VK_GOTNTPOFF).Case("plt", VariantKind.VK_PLT).Case("tlscall", VariantKind.VK_TLSCALL).Case("tlsdesc", VariantKind.VK_TLSDESC).Case("tlsgd", VariantKind.VK_TLSGD).Case("tlsld", VariantKind.VK_TLSLD).Case("tlsldm", VariantKind.VK_TLSLDM).Case("tpoff", VariantKind.VK_TPOFF).Case("tprel", VariantKind.VK_TPREL).Case("tlvp", VariantKind.VK_TLVP).Case("tlvppage", VariantKind.VK_TLVPPAGE).Case("tlvppageoff", VariantKind.VK_TLVPPAGEOFF).Case("page", VariantKind.VK_PAGE).Case("pageoff", VariantKind.VK_PAGEOFF).Case("gotpage", VariantKind.VK_GOTPAGE).Case("gotpageoff", VariantKind.VK_GOTPAGEOFF).Case("imgrel", VariantKind.VK_COFF_IMGREL32).Case("secrel32", VariantKind.VK_SECREL).Case("size", VariantKind.VK_SIZE).Case("l", VariantKind.VK_PPC_LO).Case("h", VariantKind.VK_PPC_HI).Case("ha", VariantKind.VK_PPC_HA).Case("higher", VariantKind.VK_PPC_HIGHER).Case("highera", VariantKind.VK_PPC_HIGHERA).Case("highest", VariantKind.VK_PPC_HIGHEST).Case("highesta", VariantKind.VK_PPC_HIGHESTA).Case("got@l", VariantKind.VK_PPC_GOT_LO).Case("got@h", VariantKind.VK_PPC_GOT_HI).Case("got@ha", VariantKind.VK_PPC_GOT_HA).Case("local", VariantKind.VK_PPC_LOCAL).Case("tocbase", VariantKind.VK_PPC_TOCBASE).Case("toc", VariantKind.VK_PPC_TOC).Case("toc@l", VariantKind.VK_PPC_TOC_LO).Case("toc@h", VariantKind.VK_PPC_TOC_HI).Case("toc@ha", VariantKind.VK_PPC_TOC_HA).Case("tls", VariantKind.VK_PPC_TLS).Case("dtpmod", VariantKind.VK_PPC_DTPMOD).Case("tprel@l", VariantKind.VK_PPC_TPREL_LO).Case("tprel@h", VariantKind.VK_PPC_TPREL_HI).Case("tprel@ha", VariantKind.VK_PPC_TPREL_HA).Case("tprel@higher", VariantKind.VK_PPC_TPREL_HIGHER).Case("tprel@highera", VariantKind.VK_PPC_TPREL_HIGHERA).Case("tprel@highest", VariantKind.VK_PPC_TPREL_HIGHEST).Case("tprel@highesta", VariantKind.VK_PPC_TPREL_HIGHESTA).Case("dtprel@l", VariantKind.VK_PPC_DTPREL_LO).Case("dtprel@h", VariantKind.VK_PPC_DTPREL_HI).Case("dtprel@ha", VariantKind.VK_PPC_DTPREL_HA).Case("dtprel@higher", VariantKind.VK_PPC_DTPREL_HIGHER).Case("dtprel@highera", VariantKind.VK_PPC_DTPREL_HIGHERA).Case("dtprel@highest", VariantKind.VK_PPC_DTPREL_HIGHEST).Case("dtprel@highesta", VariantKind.VK_PPC_DTPREL_HIGHESTA).Case("got@tprel", VariantKind.VK_PPC_GOT_TPREL).Case("got@tprel@l", VariantKind.VK_PPC_GOT_TPREL_LO).Case("got@tprel@h", VariantKind.VK_PPC_GOT_TPREL_HI).Case("got@tprel@ha", VariantKind.VK_PPC_GOT_TPREL_HA).Case("got@dtprel", VariantKind.VK_PPC_GOT_DTPREL).Case("got@dtprel@l", VariantKind.VK_PPC_GOT_DTPREL_LO).Case("got@dtprel@h", VariantKind.VK_PPC_GOT_DTPREL_HI).Case("got@dtprel@ha", VariantKind.VK_PPC_GOT_DTPREL_HA).Case("got@tlsgd", VariantKind.VK_PPC_GOT_TLSGD).Case("got@tlsgd@l", VariantKind.VK_PPC_GOT_TLSGD_LO).Case("got@tlsgd@h", VariantKind.VK_PPC_GOT_TLSGD_HI).Case("got@tlsgd@ha", VariantKind.VK_PPC_GOT_TLSGD_HA).Case("got@tlsld", VariantKind.VK_PPC_GOT_TLSLD).Case("got@tlsld@l", VariantKind.VK_PPC_GOT_TLSLD_LO).Case("got@tlsld@h", VariantKind.VK_PPC_GOT_TLSLD_HI).Case("got@tlsld@ha", VariantKind.VK_PPC_GOT_TLSLD_HA).Case("gdgot", VariantKind.VK_Hexagon_GD_GOT).Case("gdplt", VariantKind.VK_Hexagon_GD_PLT).Case("iegot", VariantKind.VK_Hexagon_IE_GOT).Case("ie", VariantKind.VK_Hexagon_IE).Case("ldgot", VariantKind.VK_Hexagon_LD_GOT).Case("ldplt", VariantKind.VK_Hexagon_LD_PLT).Case("pcrel", VariantKind.VK_Hexagon_PCREL).Case("none", VariantKind.VK_ARM_NONE).Case("got_prel", VariantKind.VK_ARM_GOT_PREL).Case("target1", VariantKind.VK_ARM_TARGET1).Case("target2", VariantKind.VK_ARM_TARGET2).Case("prel31", VariantKind.VK_ARM_PREL31).Case("sbrel", VariantKind.VK_ARM_SBREL).Case("tlsldo", VariantKind.VK_ARM_TLSLDO).Default(VariantKind.VK_Invalid);
    }

    public static boolean classof(MCExpr E) {
        return E.getKind() == MCExpr.ExprKind.SymbolRef;
    }

    @Override
    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind) + ", UseParensForSymbolVariant=" + this.UseParensForSymbolVariant + ", HasSubsectionsViaSymbols=" + this.HasSubsectionsViaSymbols + ", Symbol=" + this.Symbol + super.toString();
    }

    public static final class VariantKind
    extends Enum<VariantKind>
    implements Native.NativeUShortEnum {
        public static final /* enum */ VariantKind VK_None = new VariantKind(0);
        public static final /* enum */ VariantKind VK_Invalid = new VariantKind(VK_None.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOT = new VariantKind(VK_Invalid.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTOFF = new VariantKind(VK_GOT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTREL = new VariantKind(VK_GOTOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTPCREL = new VariantKind(VK_GOTREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTTPOFF = new VariantKind(VK_GOTPCREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_INDNTPOFF = new VariantKind(VK_GOTTPOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_NTPOFF = new VariantKind(VK_INDNTPOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTNTPOFF = new VariantKind(VK_NTPOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PLT = new VariantKind(VK_GOTNTPOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLSGD = new VariantKind(VK_PLT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLSLD = new VariantKind(VK_TLSGD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLSLDM = new VariantKind(VK_TLSLD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TPOFF = new VariantKind(VK_TLSLDM.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_DTPOFF = new VariantKind(VK_TPOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLSCALL = new VariantKind(VK_DTPOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLSDESC = new VariantKind(VK_TLSCALL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLVP = new VariantKind(VK_TLSDESC.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLVPPAGE = new VariantKind(VK_TLVP.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TLVPPAGEOFF = new VariantKind(VK_TLVPPAGE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PAGE = new VariantKind(VK_TLVPPAGEOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PAGEOFF = new VariantKind(VK_PAGE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTPAGE = new VariantKind(VK_PAGEOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_GOTPAGEOFF = new VariantKind(VK_GOTPAGE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_SECREL = new VariantKind(VK_GOTPAGEOFF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_SIZE = new VariantKind(VK_SECREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_WEAKREF = new VariantKind(VK_SIZE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_NONE = new VariantKind(VK_WEAKREF.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_GOT_PREL = new VariantKind(VK_ARM_NONE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_TARGET1 = new VariantKind(VK_ARM_GOT_PREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_TARGET2 = new VariantKind(VK_ARM_TARGET1.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_PREL31 = new VariantKind(VK_ARM_TARGET2.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_SBREL = new VariantKind(VK_ARM_PREL31.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_TLSLDO = new VariantKind(VK_ARM_SBREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_ARM_TLSDESCSEQ = new VariantKind(VK_ARM_TLSLDO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_LO = new VariantKind(VK_ARM_TLSDESCSEQ.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_HI = new VariantKind(VK_PPC_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_HA = new VariantKind(VK_PPC_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_HIGHER = new VariantKind(VK_PPC_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_HIGHERA = new VariantKind(VK_PPC_HIGHER.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_HIGHEST = new VariantKind(VK_PPC_HIGHERA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_HIGHESTA = new VariantKind(VK_PPC_HIGHEST.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_LO = new VariantKind(VK_PPC_HIGHESTA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_HI = new VariantKind(VK_PPC_GOT_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_HA = new VariantKind(VK_PPC_GOT_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TOCBASE = new VariantKind(VK_PPC_GOT_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TOC = new VariantKind(VK_PPC_TOCBASE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TOC_LO = new VariantKind(VK_PPC_TOC.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TOC_HI = new VariantKind(VK_PPC_TOC_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TOC_HA = new VariantKind(VK_PPC_TOC_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPMOD = new VariantKind(VK_PPC_TOC_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_LO = new VariantKind(VK_PPC_DTPMOD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_HI = new VariantKind(VK_PPC_TPREL_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_HA = new VariantKind(VK_PPC_TPREL_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_HIGHER = new VariantKind(VK_PPC_TPREL_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_HIGHERA = new VariantKind(VK_PPC_TPREL_HIGHER.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_HIGHEST = new VariantKind(VK_PPC_TPREL_HIGHERA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TPREL_HIGHESTA = new VariantKind(VK_PPC_TPREL_HIGHEST.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_LO = new VariantKind(VK_PPC_TPREL_HIGHESTA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_HI = new VariantKind(VK_PPC_DTPREL_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_HA = new VariantKind(VK_PPC_DTPREL_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_HIGHER = new VariantKind(VK_PPC_DTPREL_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_HIGHERA = new VariantKind(VK_PPC_DTPREL_HIGHER.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_HIGHEST = new VariantKind(VK_PPC_DTPREL_HIGHERA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_DTPREL_HIGHESTA = new VariantKind(VK_PPC_DTPREL_HIGHEST.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TPREL = new VariantKind(VK_PPC_DTPREL_HIGHESTA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TPREL_LO = new VariantKind(VK_PPC_GOT_TPREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TPREL_HI = new VariantKind(VK_PPC_GOT_TPREL_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TPREL_HA = new VariantKind(VK_PPC_GOT_TPREL_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_DTPREL = new VariantKind(VK_PPC_GOT_TPREL_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_DTPREL_LO = new VariantKind(VK_PPC_GOT_DTPREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_DTPREL_HI = new VariantKind(VK_PPC_GOT_DTPREL_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_DTPREL_HA = new VariantKind(VK_PPC_GOT_DTPREL_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TLS = new VariantKind(VK_PPC_GOT_DTPREL_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSGD = new VariantKind(VK_PPC_TLS.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSGD_LO = new VariantKind(VK_PPC_GOT_TLSGD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSGD_HI = new VariantKind(VK_PPC_GOT_TLSGD_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSGD_HA = new VariantKind(VK_PPC_GOT_TLSGD_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TLSGD = new VariantKind(VK_PPC_GOT_TLSGD_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSLD = new VariantKind(VK_PPC_TLSGD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSLD_LO = new VariantKind(VK_PPC_GOT_TLSLD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSLD_HI = new VariantKind(VK_PPC_GOT_TLSLD_LO.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_GOT_TLSLD_HA = new VariantKind(VK_PPC_GOT_TLSLD_HI.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_TLSLD = new VariantKind(VK_PPC_GOT_TLSLD_HA.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_PPC_LOCAL = new VariantKind(VK_PPC_TLSLD.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_COFF_IMGREL32 = new VariantKind(VK_PPC_LOCAL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_PCREL = new VariantKind(VK_COFF_IMGREL32.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_LO16 = new VariantKind(VK_Hexagon_PCREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_HI16 = new VariantKind(VK_Hexagon_LO16.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_GPREL = new VariantKind(VK_Hexagon_HI16.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_GD_GOT = new VariantKind(VK_Hexagon_GPREL.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_LD_GOT = new VariantKind(VK_Hexagon_GD_GOT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_GD_PLT = new VariantKind(VK_Hexagon_LD_GOT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_LD_PLT = new VariantKind(VK_Hexagon_GD_PLT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_IE = new VariantKind(VK_Hexagon_LD_PLT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_Hexagon_IE_GOT = new VariantKind(VK_Hexagon_IE.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_WebAssembly_FUNCTION = new VariantKind(VK_Hexagon_IE_GOT.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_TPREL = new VariantKind(VK_WebAssembly_FUNCTION.getValue() + '\u0001');
        public static final /* enum */ VariantKind VK_DTPREL = new VariantKind(VK_TPREL.getValue() + '\u0001');
        private final char value;
        private static final /* synthetic */ VariantKind[] $VALUES;

        public static VariantKind[] values() {
            return (VariantKind[])$VALUES.clone();
        }

        public static VariantKind valueOf(String name) {
            return Enum.valueOf(VariantKind.class, name);
        }

        public static VariantKind valueOf(char val) {
            VariantKind out = VariantKind.valueOf((int)val);
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]. Int not capable to keep values?";
            return out;
        }

        public static VariantKind valueOf(int val) {
            VariantKind out;
            VariantKind variantKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private VariantKind(int val) {
            this.value = (char)val;
        }

        public final char getValue() {
            return this.value;
        }

        static {
            $VALUES = new VariantKind[]{VK_None, VK_Invalid, VK_GOT, VK_GOTOFF, VK_GOTREL, VK_GOTPCREL, VK_GOTTPOFF, VK_INDNTPOFF, VK_NTPOFF, VK_GOTNTPOFF, VK_PLT, VK_TLSGD, VK_TLSLD, VK_TLSLDM, VK_TPOFF, VK_DTPOFF, VK_TLSCALL, VK_TLSDESC, VK_TLVP, VK_TLVPPAGE, VK_TLVPPAGEOFF, VK_PAGE, VK_PAGEOFF, VK_GOTPAGE, VK_GOTPAGEOFF, VK_SECREL, VK_SIZE, VK_WEAKREF, VK_ARM_NONE, VK_ARM_GOT_PREL, VK_ARM_TARGET1, VK_ARM_TARGET2, VK_ARM_PREL31, VK_ARM_SBREL, VK_ARM_TLSLDO, VK_ARM_TLSDESCSEQ, VK_PPC_LO, VK_PPC_HI, VK_PPC_HA, VK_PPC_HIGHER, VK_PPC_HIGHERA, VK_PPC_HIGHEST, VK_PPC_HIGHESTA, VK_PPC_GOT_LO, VK_PPC_GOT_HI, VK_PPC_GOT_HA, VK_PPC_TOCBASE, VK_PPC_TOC, VK_PPC_TOC_LO, VK_PPC_TOC_HI, VK_PPC_TOC_HA, VK_PPC_DTPMOD, VK_PPC_TPREL_LO, VK_PPC_TPREL_HI, VK_PPC_TPREL_HA, VK_PPC_TPREL_HIGHER, VK_PPC_TPREL_HIGHERA, VK_PPC_TPREL_HIGHEST, VK_PPC_TPREL_HIGHESTA, VK_PPC_DTPREL_LO, VK_PPC_DTPREL_HI, VK_PPC_DTPREL_HA, VK_PPC_DTPREL_HIGHER, VK_PPC_DTPREL_HIGHERA, VK_PPC_DTPREL_HIGHEST, VK_PPC_DTPREL_HIGHESTA, VK_PPC_GOT_TPREL, VK_PPC_GOT_TPREL_LO, VK_PPC_GOT_TPREL_HI, VK_PPC_GOT_TPREL_HA, VK_PPC_GOT_DTPREL, VK_PPC_GOT_DTPREL_LO, VK_PPC_GOT_DTPREL_HI, VK_PPC_GOT_DTPREL_HA, VK_PPC_TLS, VK_PPC_GOT_TLSGD, VK_PPC_GOT_TLSGD_LO, VK_PPC_GOT_TLSGD_HI, VK_PPC_GOT_TLSGD_HA, VK_PPC_TLSGD, VK_PPC_GOT_TLSLD, VK_PPC_GOT_TLSLD_LO, VK_PPC_GOT_TLSLD_HI, VK_PPC_GOT_TLSLD_HA, VK_PPC_TLSLD, VK_PPC_LOCAL, VK_COFF_IMGREL32, VK_Hexagon_PCREL, VK_Hexagon_LO16, VK_Hexagon_HI16, VK_Hexagon_GPREL, VK_Hexagon_GD_GOT, VK_Hexagon_LD_GOT, VK_Hexagon_GD_PLT, VK_Hexagon_LD_PLT, VK_Hexagon_IE, VK_Hexagon_IE_GOT, VK_WebAssembly_FUNCTION, VK_TPREL, VK_DTPREL};
        }

        private static final class Values {
            private static final VariantKind[] VALUES;
            private static final VariantKind[] _VALUES;

            private Values() {
            }

            static {
                char max = '\u0000';
                char min = '\u0000';
                for (VariantKind kind : VariantKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new VariantKind[min < '\u0000' ? 1 - min : 0];
                VALUES = new VariantKind[max >= '\u0000' ? '\u0001' + max : 0];
                for (VariantKind kind : VariantKind.values()) {
                    if (kind.value < '\u0000') {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((VariantKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((VariantKind)kind).value] = kind;
                }
            }
        }
    }
}

