/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.ADTFunctionPointers;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.SectionKind;
import org.llvm.mc.impl.MCSectionMachOStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class MCSectionMachO
extends MCSection
implements Destructors.ClassWithDestructor {
    private byte[] SegmentName = NativePointer.new$char((int)16, (byte[])new byte[0]);
    private byte[] SectionName = NativePointer.new$char((int)16, (byte[])new byte[0]);
    private int TypeAndAttributes;
    private int Reserved2;

    public MCSectionMachO(StringRef Segment, StringRef Section, int TAA, int reserved2, SectionKind K, MCSymbol Begin) {
        super(MCSection.SectionVariant.SV_MachO, new SectionKind(K), Begin);
        this.TypeAndAttributes = TAA;
        this.Reserved2 = reserved2;
        assert (Unsigned.$lesseq_uint((int)Segment.size(), (int)16) && Unsigned.$lesseq_uint((int)Section.size(), (int)16)) : "Segment or section string too long";
        for (int i = 0; i != 16; ++i) {
            this.SegmentName[i] = Unsigned.$less_uint((int)i, (int)Segment.size()) ? Segment.$at(i) : (byte)0;
            this.SectionName[i] = Unsigned.$less_uint((int)i, (int)Section.size()) ? Section.$at(i) : (byte)0;
        }
    }

    public StringRef getSegmentName() {
        if (this.SegmentName[15] != 0) {
            return new StringRef(this.SegmentName, 16);
        }
        return new StringRef(this.SegmentName);
    }

    public StringRef getSectionName() {
        if (this.SectionName[15] != 0) {
            return new StringRef(this.SectionName, 16);
        }
        return new StringRef(this.SectionName);
    }

    public int getTypeAndAttributes() {
        return this.TypeAndAttributes;
    }

    public int getStubSize() {
        return this.Reserved2;
    }

    public int getType() {
        return this.TypeAndAttributes & 0xFF;
    }

    public boolean hasAttribute(int Value) {
        return (this.TypeAndAttributes & Value) != 0;
    }

    public static std.string ParseSectionSpecifier(StringRef Spec, StringRef Segment, StringRef Section, uint.ref TAA, bool.ref TAAParsed, uint.ref StubSize) {
        TAAParsed.$set(false);
        SmallVector<StringRef> SplitSpec = new SmallVector<StringRef>(5, new StringRef());
        Spec.split(SplitSpec, (byte)44);
        ADTFunctionPointers.UInt2StringRef GetEmptyOrTrim = Idx -> Unsigned.$greater_uint((int)SplitSpec.size(), (int)Idx) ? ((StringRef)SplitSpec.$at(Idx)).trim() : new StringRef();
        Segment.$assignMove(GetEmptyOrTrim.$call(0));
        Section.$assignMove(GetEmptyOrTrim.$call(1));
        StringRef SectionType2 = GetEmptyOrTrim.$call(2);
        StringRef Attrs = GetEmptyOrTrim.$call(3);
        StringRef StubSizeStr = GetEmptyOrTrim.$call(4);
        if (Segment.empty() || Unsigned.$greater_uint((int)Segment.size(), (int)16)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier requires a segment whose length is between 1 and 16 characters");
        }
        if (Section.empty()) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier requires a segment and section separated by a comma");
        }
        if (Unsigned.$greater_uint((int)Section.size(), (int)16)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier requires a section whose length is between 1 and 16 characters");
        }
        TAA.$set(0);
        StubSize.$set(0);
        if (SectionType2.empty()) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$EMPTY);
        }
        type.ptr TypeDescriptor2 = (type.ptr)std.find_if((type.iterator)std.begin((Object[])MCSectionMachOStatics.SectionTypeDescriptors), (type.iterator)std.end((Object[])MCSectionMachOStatics.SectionTypeDescriptors), Descriptor -> Native.$bool((Native.Native$Bool)Descriptor.AssemblerName) && llvm.$eq_StringRef(SectionType2, Descriptor.AssemblerName));
        if (TypeDescriptor2 == std.end((Object[])MCSectionMachOStatics.SectionTypeDescriptors)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier uses an unknown section type");
        }
        TAA.$set(TypeDescriptor2.$sub((abstract_iterator)std.begin((Object[])MCSectionMachOStatics.SectionTypeDescriptors)));
        TAAParsed.$set(true);
        if (Attrs.empty()) {
            if (TAA.$deref() == 8) {
                return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier of type 'symbol_stubs' requires a size specifier");
            }
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$EMPTY);
        }
        SmallVector<StringRef> SectionAttrs = new SmallVector<StringRef>(1, new StringRef());
        Attrs.split(SectionAttrs, (byte)43, -1, false);
        for (StringRef SectionAttr : SectionAttrs) {
            type.ptr AttrDescriptorI = (type.ptr)std.find_if((type.iterator)std.begin((Object[])MCSectionMachOStatics.SectionAttrDescriptors), (type.iterator)std.end((Object[])MCSectionMachOStatics.SectionAttrDescriptors), Descriptor -> Native.$bool((Native.Native$Bool)Descriptor.AssemblerName) && llvm.$eq_StringRef(SectionAttr.trim(), Descriptor.AssemblerName));
            if (AttrDescriptorI == std.end((Object[])MCSectionMachOStatics.SectionAttrDescriptors)) {
                return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier has invalid attribute");
            }
            TAA.$set$orassign(((MCSectionMachOStatics.Unnamed_struct2)AttrDescriptorI.$star()).AttrFlag);
        }
        if (StubSizeStr.empty()) {
            if (TAA.$deref() == 8) {
                return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier of type 'symbol_stubs' requires a size specifier");
            }
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$EMPTY);
        }
        if ((TAA.$deref() & 0xFF) != 8) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier cannot have a stub size specified because it does not have type 'symbol_stubs'");
        }
        if (StubSizeStr.getAsInteger$NotSigned(0, StubSize)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"mach-o section specifier has a malformed stub size");
        }
        return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$EMPTY);
    }

    @Override
    public void PrintSwitchToSection(MCAsmInfo MAI, raw_ostream OS, MCExpr Subsection) {
        OS.$out("\t.section\t").$out(this.getSegmentName()).$out_char((byte)44).$out(this.getSectionName());
        int TAA = this.getTypeAndAttributes();
        if (TAA == 0) {
            OS.$out_char((byte)10);
            return;
        }
        int SectionType2 = this.getType();
        assert (Unsigned.$lesseq_uint((int)SectionType2, (int)21)) : "Invalid SectionType specified!";
        if (!Native.$bool((Native.Native$Bool)MCSectionMachOStatics.SectionTypeDescriptors[SectionType2].AssemblerName)) {
            OS.$out_char((byte)10);
            return;
        }
        OS.$out_char((byte)44);
        OS.$out(MCSectionMachOStatics.SectionTypeDescriptors[SectionType2].AssemblerName);
        int SectionAttrs = TAA & 0xFFFFFF00;
        if (SectionAttrs == 0) {
            if (this.Reserved2 != 0) {
                OS.$out(",none,").$out_uint(this.Reserved2);
            }
            OS.$out_char((byte)10);
            return;
        }
        int Separator = 44;
        int i = 0;
        while (SectionAttrs != 0 && MCSectionMachOStatics.SectionAttrDescriptors[i].AttrFlag != 0) {
            if ((MCSectionMachOStatics.SectionAttrDescriptors[i].AttrFlag & SectionAttrs) != 0) {
                SectionAttrs &= ~MCSectionMachOStatics.SectionAttrDescriptors[i].AttrFlag;
                OS.$out_char((byte)Separator);
                if (Native.$bool((Native.Native$Bool)MCSectionMachOStatics.SectionAttrDescriptors[i].AssemblerName)) {
                    OS.$out(MCSectionMachOStatics.SectionAttrDescriptors[i].AssemblerName);
                } else {
                    OS.$out(NativePointer.$LT_LT).$out(MCSectionMachOStatics.SectionAttrDescriptors[i].EnumName).$out(NativePointer.$GT_GT);
                }
                Separator = 43;
            }
            ++i;
        }
        assert (SectionAttrs == 0) : "Unknown section attributes!";
        if (this.Reserved2 != 0) {
            OS.$out_char((byte)44).$out_uint(this.Reserved2);
        }
        OS.$out_char((byte)10);
    }

    @Override
    public boolean UseCodeAlign() {
        return this.hasAttribute(Integer.MIN_VALUE);
    }

    @Override
    public boolean isVirtualSection() {
        return this.getType() == 1 || this.getType() == 12 || this.getType() == 18;
    }

    public static boolean classof(MCSection S2) {
        return S2.getVariant() == MCSection.SectionVariant.SV_MachO;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "SegmentName=" + this.SegmentName + ", SectionName=" + this.SectionName + ", TypeAndAttributes=" + this.TypeAndAttributes + ", Reserved2=" + this.Reserved2 + super.toString();
    }
}

