/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.JavaDifferentiators;
import org.llvm.adt.StringRef;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.MCSymbol;
import org.llvm.support.SMLoc;
import org.llvm.support.SourceMgr;

public class MCGenDwarfLabelEntry {
    private StringRef Name;
    private int FileNumber;
    private int LineNumber;
    private MCSymbol Label;

    public MCGenDwarfLabelEntry(StringRef name, int fileNumber, int lineNumber, MCSymbol label) {
        this.Name = new StringRef(name);
        this.FileNumber = fileNumber;
        this.LineNumber = lineNumber;
        this.Label = label;
    }

    public StringRef getName() {
        return new StringRef(this.Name);
    }

    public int getFileNumber() {
        return this.FileNumber;
    }

    public int getLineNumber() {
        return this.LineNumber;
    }

    public MCSymbol getLabel() {
        return this.Label;
    }

    public static void Make(MCSymbol Symbol, MCStreamer MCOS, SourceMgr SrcMgr, SMLoc Loc) {
        if (Symbol.isTemporary()) {
            return;
        }
        MCContext context = MCOS.getContext();
        if (context.getGenDwarfSectionSyms().count((MCSection)MCOS.getCurrentSection().first) == 0) {
            return;
        }
        StringRef Name2 = Symbol.getName();
        if (Name2.startswith("_")) {
            Name2.$assignMove(Name2.substr(1, Name2.size() - 1));
        }
        int FileNumber = context.getGenDwarfFileNumber();
        int CurBuffer = SrcMgr.FindBufferContainingLoc(new SMLoc(Loc));
        int LineNumber = SrcMgr.FindLineNumber(new SMLoc(Loc), CurBuffer);
        MCSymbol Label = context.createTempSymbol();
        MCOS.EmitLabel(Label);
        MCOS.getContext().addMCGenDwarfLabelEntry(new MCGenDwarfLabelEntry(new StringRef(Name2), FileNumber, LineNumber, Label));
    }

    public MCGenDwarfLabelEntry(MCGenDwarfLabelEntry $Prm0) {
        this.Name = new StringRef($Prm0.Name);
        this.FileNumber = $Prm0.FileNumber;
        this.LineNumber = $Prm0.LineNumber;
        this.Label = $Prm0.Label;
    }

    public MCGenDwarfLabelEntry(JavaDifferentiators.JD.Move _dparam, MCGenDwarfLabelEntry $Prm0) {
        this.Name = new StringRef(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Name);
        this.FileNumber = $Prm0.FileNumber;
        this.LineNumber = $Prm0.LineNumber;
        this.Label = $Prm0.Label;
    }

    public MCGenDwarfLabelEntry() {
    }

    public String toString() {
        return "Name=" + this.Name + ", FileNumber=" + this.FileNumber + ", LineNumber=" + this.LineNumber + ", Label=" + this.Label;
    }
}

