/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std_pair;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.ilist_node;
import org.llvm.adt.ilist_node_with_parent;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAlignFragment;
import org.llvm.mc.MCCVDefRangeFragment;
import org.llvm.mc.MCCVInlineLineTableFragment;
import org.llvm.mc.MCCompactEncodedInstFragment;
import org.llvm.mc.MCDataFragment;
import org.llvm.mc.MCDwarfCallFrameFragment;
import org.llvm.mc.MCDwarfLineAddrFragment;
import org.llvm.mc.MCFillFragment;
import org.llvm.mc.MCFixup;
import org.llvm.mc.MCLEBFragment;
import org.llvm.mc.MCOrgFragment;
import org.llvm.mc.MCRelaxableFragment;
import org.llvm.mc.MCSafeSEHFragment;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.impl.MCFragmentLlvmStatics;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class MCFragment
implements ilist_node_with_parent<MCFragment, MCSection>,
Destructors.ClassWithDestructor {
    private FragmentType Kind;
    protected boolean HasInstructions;
    private boolean AlignToBundleEnd;
    private byte BundlePadding;
    private int LayoutOrder;
    private MCSection Parent;
    private MCSymbol Atom;
    public long Offset;
    private final ilist_node.ilist_node.Fields ilist_node$Flds;

    protected MCFragment(MCFragment $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(MCFragment $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected MCFragment(FragmentType Kind2, boolean HasInstructions, byte BundlePadding) {
        this(Kind2, HasInstructions, BundlePadding, null);
    }

    protected MCFragment(FragmentType Kind2, boolean HasInstructions, byte BundlePadding, MCSection Parent) {
        this.ilist_node$Flds = this.$ilist_node_with_parent();
        this.Kind = Kind2;
        this.HasInstructions = HasInstructions;
        this.AlignToBundleEnd = false;
        this.BundlePadding = BundlePadding;
        this.Parent = Parent;
        this.Atom = null;
        this.Offset = -1L;
        if (Parent != null && !this.isDummy()) {
            Parent.getFragmentList().push_back(this);
        }
    }

    public void $destroy() {
        ilist_node_with_parent.super.$destroy$ilist_node();
    }

    public MCFragment() {
        this.ilist_node$Flds = this.$ilist_node_with_parent();
        this.Kind = FragmentType.valueOf(-1);
        this.HasInstructions = false;
        this.AlignToBundleEnd = false;
        this.BundlePadding = Unsigned.$int2uchar((int)0);
    }

    public void destroy() {
        if (this.Kind == FragmentType.valueOf(-1)) {
            if (this != null) {
                this.$destroy();
            }
            return;
        }
        switch (this.Kind) {
            case FT_Align: {
                if (ADTRTTI.cast_MCAlignFragment(this) != null) {
                    ADTRTTI.cast_MCAlignFragment(this).$destroy();
                }
                return;
            }
            case FT_Data: {
                if (ADTRTTI.cast_MCDataFragment(this) != null) {
                    ADTRTTI.cast_MCDataFragment(this).$destroy();
                }
                return;
            }
            case FT_CompactEncodedInst: {
                if (ADTRTTI.cast_MCCompactEncodedInstFragment(this) != null) {
                    ADTRTTI.cast_MCCompactEncodedInstFragment(this).$destroy();
                }
                return;
            }
            case FT_Fill: {
                if (ADTRTTI.cast_MCFillFragment(this) != null) {
                    ADTRTTI.cast_MCFillFragment(this).$destroy();
                }
                return;
            }
            case FT_Relaxable: {
                if (ADTRTTI.cast_MCRelaxableFragment(this) != null) {
                    ADTRTTI.cast_MCRelaxableFragment(this).$destroy();
                }
                return;
            }
            case FT_Org: {
                if (ADTRTTI.cast_MCOrgFragment(this) != null) {
                    ADTRTTI.cast_MCOrgFragment(this).$destroy();
                }
                return;
            }
            case FT_Dwarf: {
                if (ADTRTTI.cast_MCDwarfLineAddrFragment(this) != null) {
                    ADTRTTI.cast_MCDwarfLineAddrFragment(this).$destroy();
                }
                return;
            }
            case FT_DwarfFrame: {
                if (ADTRTTI.cast_MCDwarfCallFrameFragment(this) != null) {
                    ADTRTTI.cast_MCDwarfCallFrameFragment(this).$destroy();
                }
                return;
            }
            case FT_LEB: {
                if (ADTRTTI.cast_MCLEBFragment(this) != null) {
                    ADTRTTI.cast_MCLEBFragment(this).$destroy();
                }
                return;
            }
            case FT_SafeSEH: {
                if (ADTRTTI.cast_MCSafeSEHFragment(this) != null) {
                    ADTRTTI.cast_MCSafeSEHFragment(this).$destroy();
                }
                return;
            }
            case FT_CVInlineLines: {
                if (ADTRTTI.cast_MCCVInlineLineTableFragment(this) != null) {
                    ADTRTTI.cast_MCCVInlineLineTableFragment(this).$destroy();
                }
                return;
            }
            case FT_CVDefRange: {
                if (ADTRTTI.cast_MCCVDefRangeFragment(this) != null) {
                    ADTRTTI.cast_MCCVDefRangeFragment(this).$destroy();
                }
                return;
            }
            case FT_Dummy: {
                if (ADTRTTI.cast_MCDummyFragment(this) != null) {
                    ADTRTTI.cast_MCDummyFragment(this).$destroy();
                }
                return;
            }
        }
    }

    public FragmentType getKind() {
        return this.Kind;
    }

    public MCSection getParent() {
        return this.Parent;
    }

    public void setParent(MCSection Value) {
        this.Parent = Value;
    }

    public MCSymbol getAtom() {
        return this.Atom;
    }

    public void setAtom(MCSymbol Value) {
        this.Atom = Value;
    }

    public int getLayoutOrder() {
        return this.LayoutOrder;
    }

    public void setLayoutOrder(int Value) {
        this.LayoutOrder = Value;
    }

    public boolean hasInstructions() {
        return this.HasInstructions;
    }

    public boolean alignToBundleEnd() {
        return this.AlignToBundleEnd;
    }

    public void setAlignToBundleEnd(boolean V) {
        this.AlignToBundleEnd = V;
    }

    public byte getBundlePadding() {
        return this.BundlePadding;
    }

    public void setBundlePadding(byte N) {
        this.BundlePadding = N;
    }

    public boolean isDummy() {
        return this.Kind == FragmentType.FT_Dummy;
    }

    public void dump() {
        raw_ostream OS = llvm.errs();
        OS.$out(NativePointer.$LT);
        switch (this.getKind()) {
            case FT_Align: {
                OS.$out("MCAlignFragment");
                break;
            }
            case FT_Data: {
                OS.$out("MCDataFragment");
                break;
            }
            case FT_CompactEncodedInst: {
                OS.$out("MCCompactEncodedInstFragment");
                break;
            }
            case FT_Fill: {
                OS.$out("MCFillFragment");
                break;
            }
            case FT_Relaxable: {
                OS.$out("MCRelaxableFragment");
                break;
            }
            case FT_Org: {
                OS.$out("MCOrgFragment");
                break;
            }
            case FT_Dwarf: {
                OS.$out("MCDwarfFragment");
                break;
            }
            case FT_DwarfFrame: {
                OS.$out("MCDwarfCallFrameFragment");
                break;
            }
            case FT_LEB: {
                OS.$out("MCLEBFragment");
                break;
            }
            case FT_SafeSEH: {
                OS.$out("MCSafeSEHFragment");
                break;
            }
            case FT_CVInlineLines: {
                OS.$out("MCCVInlineLineTableFragment");
                break;
            }
            case FT_CVDefRange: {
                OS.$out("MCCVDefRangeTableFragment");
                break;
            }
            case FT_Dummy: {
                OS.$out("MCDummyFragment");
            }
        }
        OS.$out("<MCFragment ").$out(Casts.reinterpret_cast(Object.class, (Object)this)).$out(" LayoutOrder:").$out_uint(this.LayoutOrder).$out(" Offset:").$out_ullong(this.Offset).$out(" HasInstructions:").$out_int(this.hasInstructions() ? 1 : 0).$out(" BundlePadding:").$out_uint(Unsigned.$uchar2uint((byte)this.getBundlePadding())).$out(NativePointer.$GT);
        switch (this.getKind()) {
            case FT_Align: {
                MCAlignFragment AF = ADTRTTI.cast_MCAlignFragment(this);
                if (AF.hasEmitNops()) {
                    OS.$out(" (emit nops)");
                }
                OS.$out("\n       ");
                OS.$out(" Alignment:").$out_uint(AF.getAlignment()).$out(" Value:").$out_llong(AF.getValue()).$out(" ValueSize:").$out_uint(AF.getValueSize()).$out(" MaxBytesToEmit:").$out_uint(AF.getMaxBytesToEmit()).$out(NativePointer.$GT);
                break;
            }
            case FT_Data: {
                MCDataFragment DF = ADTRTTI.cast_MCDataFragment(this);
                OS.$out("\n       ");
                OS.$out(" Contents:[");
                SmallString Contents2 = DF.getContents$Const();
                int e = Contents2.size();
                for (int i = 0; i != e; ++i) {
                    if (i != 0) {
                        OS.$out(NativePointer.$COMMA);
                    }
                    OS.$out_char(AdtsupportLlvmGlobals.hexdigit(Contents2.$at$Const(i) >> 4 & 0xF)).$out_char(AdtsupportLlvmGlobals.hexdigit(Contents2.$at$Const(i) & 0xF));
                }
                OS.$out("] (").$out_uint(Contents2.size()).$out(" bytes)");
                if (!Native.$noteq_ptr(DF.fixup_begin$Const(), DF.fixup_end$Const())) break;
                OS.$out(",\n       ");
                OS.$out(" Fixups:[");
                type.ptr it = (type.ptr)Native.$tryClone(DF.fixup_begin$Const());
                type.ptr ie = (type.ptr)Native.$tryClone(DF.fixup_end$Const());
                while (Native.$noteq_ptr((void.ptr)it, (void.ptr)ie)) {
                    if (Native.$noteq_ptr((void.ptr)it, DF.fixup_begin$Const())) {
                        OS.$out(",\n                ");
                    }
                    MCFragmentLlvmStatics.$out_raw_ostream_MCFixup$C(OS, (MCFixup)it.$star());
                    it.$preInc();
                }
                OS.$out(NativePointer.$RSQUARE);
                break;
            }
            case FT_CompactEncodedInst: {
                MCCompactEncodedInstFragment CEIF = ADTRTTI.cast_MCCompactEncodedInstFragment(this);
                OS.$out("\n       ");
                OS.$out(" Contents:[");
                SmallString Contents3 = CEIF.getContents$Const();
                int e = Contents3.size();
                for (int i = 0; i != e; ++i) {
                    if (i != 0) {
                        OS.$out(NativePointer.$COMMA);
                    }
                    OS.$out_char(AdtsupportLlvmGlobals.hexdigit(Contents3.$at$Const(i) >> 4 & 0xF)).$out_char(AdtsupportLlvmGlobals.hexdigit(Contents3.$at$Const(i) & 0xF));
                }
                OS.$out("] (").$out_uint(Contents3.size()).$out(" bytes)");
                break;
            }
            case FT_Fill: {
                MCFillFragment FF = ADTRTTI.cast_MCFillFragment(this);
                OS.$out(" Value:").$out_uchar(FF.getValue()).$out(" Size:").$out_ullong(FF.getSize());
                break;
            }
            case FT_Relaxable: {
                MCRelaxableFragment F = ADTRTTI.cast_MCRelaxableFragment(this);
                OS.$out("\n       ");
                OS.$out(" Inst:");
                F.getInst().dump_pretty(OS);
                break;
            }
            case FT_Org: {
                MCOrgFragment OF = ADTRTTI.cast_MCOrgFragment(this);
                OS.$out("\n       ");
                AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS.$out(" Offset:"), OF.getOffset()).$out(" Value:").$out_uchar(OF.getValue());
                break;
            }
            case FT_Dwarf: {
                MCDwarfLineAddrFragment OF = ADTRTTI.cast_MCDwarfLineAddrFragment(this);
                OS.$out("\n       ");
                AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS.$out(" AddrDelta:"), OF.getAddrDelta()).$out(" LineDelta:").$out_llong(OF.getLineDelta());
                break;
            }
            case FT_DwarfFrame: {
                MCDwarfCallFrameFragment CF = ADTRTTI.cast_MCDwarfCallFrameFragment(this);
                OS.$out("\n       ");
                AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS.$out(" AddrDelta:"), CF.getAddrDelta());
                break;
            }
            case FT_LEB: {
                MCLEBFragment LF = ADTRTTI.cast_MCLEBFragment(this);
                OS.$out("\n       ");
                AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS.$out(" Value:"), LF.getValue()).$out(" Signed:").$out_int(LF.isSigned() ? 1 : 0);
                break;
            }
            case FT_SafeSEH: {
                MCSafeSEHFragment F = ADTRTTI.cast_MCSafeSEHFragment(this);
                OS.$out("\n       ");
                OS.$out(" Sym:").$out(F.getSymbol$Const());
                break;
            }
            case FT_CVInlineLines: {
                MCCVInlineLineTableFragment F = ADTRTTI.cast_MCCVInlineLineTableFragment(this);
                OS.$out("\n       ");
                AdtsupportLlvmGlobals.$out_raw_ostream_MCSymbol$C(OS.$out(" Sym:"), (MCSymbol)Native.$Deref((Object)F.getFnStartSym()));
                break;
            }
            case FT_CVDefRange: {
                MCCVDefRangeFragment F = ADTRTTI.cast_MCCVDefRangeFragment(this);
                OS.$out("\n       ");
                for (std_pair.pairPtrPtr<MCSymbol, MCSymbol> RangeStartEnd : F.getRanges()) {
                    OS.$out(" RangeStart:").$out(RangeStartEnd.first);
                    OS.$out(" RangeEnd:").$out(RangeStartEnd.second);
                }
                break;
            }
        }
        OS.$out(NativePointer.$GT);
    }

    @Override
    public final ilist_node.ilist_node.Fields $ilist_node$Fields() {
        return this.ilist_node$Flds;
    }

    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind) + ", HasInstructions=" + this.HasInstructions + ", AlignToBundleEnd=" + this.AlignToBundleEnd + ", BundlePadding=" + Unsigned.$uchar2uint((byte)this.BundlePadding) + ", LayoutOrder=" + this.LayoutOrder + ", Parent=" + this.Parent + ", Atom=" + this.Atom + ", Offset=" + this.Offset + super.toString();
    }

    public static final class FragmentType
    extends Enum<FragmentType>
    implements Native.NativeUCharEnum {
        public static final /* enum */ FragmentType FT_Align = new FragmentType(0);
        public static final /* enum */ FragmentType FT_Data = new FragmentType(FT_Align.getValue() + 1);
        public static final /* enum */ FragmentType FT_CompactEncodedInst = new FragmentType(FT_Data.getValue() + 1);
        public static final /* enum */ FragmentType FT_Fill = new FragmentType(FT_CompactEncodedInst.getValue() + 1);
        public static final /* enum */ FragmentType FT_Relaxable = new FragmentType(FT_Fill.getValue() + 1);
        public static final /* enum */ FragmentType FT_Org = new FragmentType(FT_Relaxable.getValue() + 1);
        public static final /* enum */ FragmentType FT_Dwarf = new FragmentType(FT_Org.getValue() + 1);
        public static final /* enum */ FragmentType FT_DwarfFrame = new FragmentType(FT_Dwarf.getValue() + 1);
        public static final /* enum */ FragmentType FT_LEB = new FragmentType(FT_DwarfFrame.getValue() + 1);
        public static final /* enum */ FragmentType FT_SafeSEH = new FragmentType(FT_LEB.getValue() + 1);
        public static final /* enum */ FragmentType FT_CVInlineLines = new FragmentType(FT_SafeSEH.getValue() + 1);
        public static final /* enum */ FragmentType FT_CVDefRange = new FragmentType(FT_CVInlineLines.getValue() + 1);
        public static final /* enum */ FragmentType FT_Dummy = new FragmentType(FT_CVDefRange.getValue() + 1);
        private final byte value;
        private static final /* synthetic */ FragmentType[] $VALUES;

        public static FragmentType[] values() {
            return (FragmentType[])$VALUES.clone();
        }

        public static FragmentType valueOf(String name) {
            return Enum.valueOf(FragmentType.class, name);
        }

        public static FragmentType valueOf(byte val) {
            FragmentType out = FragmentType.valueOf((int)val);
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]. Int not capable to keep values?";
            return out;
        }

        public static FragmentType valueOf(int val) {
            FragmentType out;
            FragmentType fragmentType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private FragmentType(int val) {
            this.value = (byte)val;
        }

        public final byte getValue() {
            return this.value;
        }

        static {
            $VALUES = new FragmentType[]{FT_Align, FT_Data, FT_CompactEncodedInst, FT_Fill, FT_Relaxable, FT_Org, FT_Dwarf, FT_DwarfFrame, FT_LEB, FT_SafeSEH, FT_CVInlineLines, FT_CVDefRange, FT_Dummy};
        }

        private static final class Values {
            private static final FragmentType[] VALUES;
            private static final FragmentType[] _VALUES;

            private Values() {
            }

            static {
                byte max = 0;
                byte min = 0;
                for (FragmentType kind : FragmentType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new FragmentType[min < 0 ? 1 - min : 0];
                VALUES = new FragmentType[max >= 0 ? 1 + max : 0];
                for (FragmentType kind : FragmentType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((FragmentType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((FragmentType)kind).value] = kind;
                }
            }
        }
    }
}

