/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.long;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ulong;
import org.llvm.adt.MutableArrayRefChar;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.iterator_range;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.adt.pointee_iterator;
import org.llvm.mc.DataRegionData;
import org.llvm.mc.IndirectSymbolData;
import org.llvm.mc.MCAlignFragment;
import org.llvm.mc.MCAsmBackend;
import org.llvm.mc.MCAsmLayout;
import org.llvm.mc.MCCVDefRangeFragment;
import org.llvm.mc.MCCVInlineLineTableFragment;
import org.llvm.mc.MCCodeEmitter;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDataFragment;
import org.llvm.mc.MCDwarfCallFrameFragment;
import org.llvm.mc.MCDwarfFrameEmitter;
import org.llvm.mc.MCDwarfLineAddr;
import org.llvm.mc.MCDwarfLineAddrFragment;
import org.llvm.mc.MCDwarfLineTableParams;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCFixup;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCInst;
import org.llvm.mc.MCLEBFragment;
import org.llvm.mc.MCLOHContainer;
import org.llvm.mc.MCObjectWriter;
import org.llvm.mc.MCOrgFragment;
import org.llvm.mc.MCRelaxableFragment;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSectionELF;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.MCValue;
import org.llvm.mc.MCVersionMinType;
import org.llvm.mc.impl.MCAssemblerStatics;
import org.llvm.mc.stats.impl.StatsStatics;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_pwrite_stream;
import org.llvm.support.raw_svector_ostream;

public class MCAssembler
implements Destructors.ClassWithDestructor,
Iterable<MCSection> {
    private final MCContext Context;
    private final MCAsmBackend Backend;
    private final MCCodeEmitter Emitter;
    private final MCObjectWriter Writer;
    private std.vector<MCSection> Sections;
    private std.vector<MCSymbol> Symbols;
    private std.vector<IndirectSymbolData> IndirectSymbols;
    private std.vector<DataRegionData> DataRegions;
    private std.vector<std.vectorString> LinkerOptions;
    private std.vectorString FileNames;
    private MCDwarfLineTableParams LTParams;
    private SmallPtrSet<MCSymbol> ThumbFuncs;
    private int BundleAlignSize;
    private boolean RelaxAll;
    private boolean SubsectionsViaSymbols;
    private boolean IncrementalLinkerCompatible;
    private int ELFHeaderEFlags;
    private MCLOHContainer LOHContainer;
    private VersionMinInfoType VersionMinInfo = new VersionMinInfoType();

    protected MCAssembler(MCAssembler $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(MCAssembler $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private boolean evaluateFixup(MCAsmLayout Layout, MCFixup Fixup, MCFragment DF, MCValue Target2, ulong.ref Value) {
        boolean ShouldAlignPC;
        MCSymbolRefExpr B;
        MCSymbol Sym;
        MCSymbolRefExpr A;
        StatsStatics.evaluateFixup.$preInc();
        MCExpr Expr = Fixup.getValue();
        if (!Expr.evaluateAsRelocatable(Target2, (MCAsmLayout)Native.$AddrOf((Object)Layout), (MCFixup)Native.$AddrOf((Object)Fixup))) {
            this.getContext().reportError(Fixup.getLoc(), new Twine("expected relocatable expression"));
            Value.$set(Unsigned.$int2ulong((int)0));
            return true;
        }
        boolean IsPCRel = (this.Backend.getFixupKindInfo((int)Fixup.getKind()).Flags & 1) != 0;
        bool.ref IsResolved = NativePointer.create_bool$ref();
        if (IsPCRel) {
            if (Target2.getSymB() != null) {
                IsResolved.$set(false);
            } else if (Target2.getSymA() == null) {
                IsResolved.$set(false);
            } else {
                A = Target2.getSymA();
                MCSymbol SA = A.getSymbol();
                if (A.getKind() != MCSymbolRefExpr.VariantKind.VK_None || SA.isUndefined()) {
                    IsResolved.$set(false);
                } else {
                    IsResolved.$set(this.getWriter().isSymbolRefDifferenceFullyResolvedImpl(this, SA, (MCFragment)Native.$Deref((Object)DF), false, true));
                }
            }
        } else {
            IsResolved.$set(Target2.isAbsolute());
        }
        Value.$set(Target2.getConstant());
        A = Target2.getSymA();
        if (A != null && (Sym = A.getSymbol()).isDefined()) {
            Value.$set$addassign(Layout.getSymbolOffset(Sym));
        }
        if ((B = Target2.getSymB()) != null && (Sym = B.getSymbol()).isDefined()) {
            Value.$set$minusassign(Layout.getSymbolOffset(Sym));
        }
        boolean bl = ShouldAlignPC = (this.Backend.getFixupKindInfo((int)Fixup.getKind()).Flags & 2) != 0;
        assert (!ShouldAlignPC || IsPCRel) : "FKF_IsAlignedDownTo32Bits is only allowed on PC-relative fixups!";
        if (IsPCRel) {
            int Offset = Unsigned.$ullong2uint((long)(Layout.getFragmentOffset(DF) + Unsigned.$uint2ullong((int)Fixup.getOffset())));
            if (ShouldAlignPC) {
                Offset &= 0xFFFFFFFC;
            }
            Value.$set$minusassign(Unsigned.$uint2ullong((int)Offset));
        }
        this.Backend.processFixupValue(this, Layout, Fixup, DF, Target2, Value, IsResolved);
        return IsResolved.$deref();
    }

    private boolean fixupNeedsRelaxation(MCFixup Fixup, MCRelaxableFragment DF, MCAsmLayout Layout) {
        MCValue Target2 = new MCValue();
        ulong.ref Value = NativePointer.create_ulong$ref();
        boolean Resolved = this.evaluateFixup(Layout, Fixup, DF, Target2, Value);
        return this.getBackend().fixupNeedsRelaxationAdvanced(Fixup, Resolved, Value.$deref(), DF, Layout);
    }

    private boolean fragmentNeedsRelaxation(MCRelaxableFragment F, MCAsmLayout Layout) {
        if (!this.getBackend().mayNeedRelaxation(F.getInst())) {
            return false;
        }
        for (MCFixup Fixup : F.getFixups$Const()) {
            if (!this.fixupNeedsRelaxation(Fixup, F, Layout)) continue;
            return true;
        }
        return false;
    }

    private boolean layoutOnce(MCAsmLayout Layout) {
        StatsStatics.RelaxationSteps.$preInc();
        boolean WasRelaxed = false;
        pointee_iterator<MCSection> it = this.begin();
        pointee_iterator<MCSection> ie = this.end();
        while (it.$noteq(ie)) {
            MCSection Sec = it.$star();
            while (this.layoutSectionOnce(Layout, Sec)) {
                WasRelaxed = true;
            }
            it.$preInc();
        }
        return WasRelaxed;
    }

    private boolean layoutSectionOnce(MCAsmLayout Layout, MCSection Sec) {
        MCFragment FirstRelaxedFragment = null;
        ilist_iterator<MCFragment> I = Sec.begin();
        ilist_iterator<MCFragment> IE = Sec.end();
        while (I.$noteq(IE)) {
            boolean RelaxedFrag = false;
            switch (((MCFragment)I.$arrow()).getKind()) {
                default: {
                    break;
                }
                case FT_Relaxable: {
                    assert (!this.getRelaxAll()) : "Did not expect a MCRelaxableFragment in RelaxAll mode";
                    RelaxedFrag = this.relaxInstruction(Layout, ADTRTTI.cast_MCRelaxableFragment((MCFragment)I.$star()));
                    break;
                }
                case FT_Dwarf: {
                    RelaxedFrag = this.relaxDwarfLineAddr(Layout, ADTRTTI.cast_MCDwarfLineAddrFragment((MCFragment)I.$star()));
                    break;
                }
                case FT_DwarfFrame: {
                    RelaxedFrag = this.relaxDwarfCallFrameFragment(Layout, ADTRTTI.cast_MCDwarfCallFrameFragment((MCFragment)I.$star()));
                    break;
                }
                case FT_LEB: {
                    RelaxedFrag = this.relaxLEB(Layout, ADTRTTI.cast_MCLEBFragment((MCFragment)I.$star()));
                    break;
                }
                case FT_CVInlineLines: {
                    RelaxedFrag = this.relaxCVInlineLineTable(Layout, ADTRTTI.cast_MCCVInlineLineTableFragment((MCFragment)I.$star()));
                    break;
                }
                case FT_CVDefRange: {
                    RelaxedFrag = this.relaxCVDefRange(Layout, ADTRTTI.cast_MCCVDefRangeFragment((MCFragment)I.$star()));
                }
            }
            if (RelaxedFrag && FirstRelaxedFragment == null) {
                FirstRelaxedFragment = (MCFragment)Native.$AddrOf((Object)((MCFragment)I.$star()));
            }
            I.$preInc();
        }
        if (FirstRelaxedFragment != null) {
            Layout.invalidateFragmentsFrom(FirstRelaxedFragment);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean relaxInstruction(MCAsmLayout Layout, MCRelaxableFragment F) {
        MCInst Relaxed = null;
        raw_svector_ostream VecOS = null;
        try {
            if (!this.fragmentNeedsRelaxation((MCRelaxableFragment)Native.$AddrOf((Object)F), Layout)) {
                boolean bl = false;
                return bl;
            }
            StatsStatics.RelaxedInstructions.$preInc();
            Relaxed = new MCInst();
            this.getBackend().relaxInstruction(F.getInst(), F.getSubtargetInfo(), Relaxed);
            SmallVector<MCFixup> Fixups = new SmallVector<MCFixup>(4, new MCFixup());
            SmallString Code = new SmallString(256);
            VecOS = new raw_svector_ostream(Code);
            this.getEmitter().encodeInstruction(Relaxed, VecOS, Fixups, F.getSubtargetInfo());
            F.setInst(Relaxed);
            F.getContents().$assign(Code);
            F.getFixups().$assign(Fixups);
            boolean bl = true;
            return bl;
        }
        finally {
            if (VecOS != null) {
                VecOS.$destroy();
            }
            if (Relaxed != null) {
                Relaxed.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean relaxLEB(MCAsmLayout Layout, MCLEBFragment LF) {
        raw_svector_ostream OSE = null;
        try {
            long OldSize = Unsigned.$uint2ulong((int)LF.getContents().size());
            long.ref Value = NativePointer.create_long$ref();
            boolean Abs = LF.getValue().evaluateKnownAbsolute(Value, Layout);
            if (!Abs) {
                llvm.report_fatal_error(NativePointer.$((String)"sleb128 and uleb128 expressions must be absolute"));
            }
            SmallString Data = LF.getContents();
            Data.clear();
            OSE = new raw_svector_ostream(Data);
            if (LF.isSigned()) {
                AdtsupportLlvmGlobals.encodeSLEB128(Value.$deref(), OSE);
            } else {
                AdtsupportLlvmGlobals.encodeULEB128(Value.$deref(), OSE);
            }
            boolean bl = OldSize != Unsigned.$uint2ullong((int)LF.getContents().size());
            return bl;
        }
        finally {
            if (OSE != null) {
                OSE.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean relaxDwarfLineAddr(MCAsmLayout Layout, MCDwarfLineAddrFragment DF) {
        raw_svector_ostream OSE = null;
        try {
            MCContext Context = Layout.getAssembler().getContext();
            long OldSize = Unsigned.$uint2ulong((int)DF.getContents().size());
            long.ref AddrDelta = NativePointer.create_long$ref();
            boolean Abs = DF.getAddrDelta().evaluateKnownAbsolute(AddrDelta, Layout);
            assert (Abs) : "We created a line delta with an invalid expression";
            long LineDelta = DF.getLineDelta();
            SmallString Data = DF.getContents();
            Data.clear();
            OSE = new raw_svector_ostream(Data);
            MCDwarfLineAddr.Encode(Context, this.getDWARFLinetableParams(), LineDelta, AddrDelta.$deref(), OSE);
            boolean bl = OldSize != Unsigned.$uint2ullong((int)Data.size());
            return bl;
        }
        finally {
            if (OSE != null) {
                OSE.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean relaxDwarfCallFrameFragment(MCAsmLayout Layout, MCDwarfCallFrameFragment DF) {
        raw_svector_ostream OSE = null;
        try {
            MCContext Context = Layout.getAssembler().getContext();
            long OldSize = Unsigned.$uint2ulong((int)DF.getContents().size());
            long.ref AddrDelta = NativePointer.create_long$ref();
            boolean Abs = DF.getAddrDelta().evaluateKnownAbsolute(AddrDelta, Layout);
            assert (Abs) : "We created call frame with an invalid expression";
            SmallString Data = DF.getContents();
            Data.clear();
            OSE = new raw_svector_ostream(Data);
            MCDwarfFrameEmitter.EncodeAdvanceLoc(Context, AddrDelta.$deref(), OSE);
            boolean bl = OldSize != Unsigned.$uint2ullong((int)Data.size());
            return bl;
        }
        finally {
            if (OSE != null) {
                OSE.$destroy();
            }
        }
    }

    private boolean relaxCVInlineLineTable(MCAsmLayout Layout, MCCVInlineLineTableFragment F) {
        int OldSize = F.getContents().size();
        this.getContext().getCVContext().encodeInlineLineTable(Layout, F);
        return OldSize != F.getContents().size();
    }

    private boolean relaxCVDefRange(MCAsmLayout Layout, MCCVDefRangeFragment F) {
        int OldSize = F.getContents().size();
        this.getContext().getCVContext().encodeDefRange(Layout, F);
        return OldSize != F.getContents().size();
    }

    private void finishLayout(MCAsmLayout Layout) {
        int n = Layout.getSectionOrder().size();
        for (int i = 0; i != n; ++i) {
            Layout.getFragmentOffset((MCFragment)Native.$AddrOf((Object)((MCFragment)Layout.getSectionOrder().$at(i).rbegin().$star())));
        }
        this.getBackend().finishLayout(this, Layout);
    }

    private std_pair.pairULongBool handleFixup(MCAsmLayout Layout, MCFragment F, MCFixup Fixup) {
        MCValue Target2 = new MCValue();
        ulong.ref FixedValue = NativePointer.create_ulong$ref();
        bool.ref IsPCRel = NativePointer.create_bool$ref(((this.Backend.getFixupKindInfo((int)Fixup.getKind()).Flags & 1) != 0 ? 1 : 0) != 0);
        if (!this.evaluateFixup(Layout, Fixup, (MCFragment)Native.$AddrOf((Object)F), Target2, FixedValue)) {
            this.getWriter().recordRelocation(this, Layout, (MCFragment)Native.$AddrOf((Object)F), Fixup, new MCValue(Target2), IsPCRel, FixedValue);
        }
        return std.make_pair_ullong_bool((long)FixedValue.$deref(), (boolean)IsPCRel.$deref());
    }

    public long computeFragmentSize(MCAsmLayout Layout, MCFragment F) {
        switch (F.getKind()) {
            case FT_Data: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCDataFragment(F).getContents$Const().size());
            }
            case FT_Relaxable: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCRelaxableFragment(F).getContents$Const().size());
            }
            case FT_CompactEncodedInst: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCCompactEncodedInstFragment(F).getContents$Const().size());
            }
            case FT_Fill: {
                return ADTRTTI.cast_MCFillFragment(F).getSize();
            }
            case FT_LEB: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCLEBFragment(F).getContents$Const().size());
            }
            case FT_SafeSEH: {
                return Unsigned.$int2ulong((int)4);
            }
            case FT_Align: {
                MCAlignFragment AF = ADTRTTI.cast_MCAlignFragment(F);
                int Offset = Unsigned.$ulong2uint((long)Layout.getFragmentOffset((MCFragment)Native.$AddrOf((Object)AF)));
                int Size = Unsigned.$ulong2uint((long)llvm.OffsetToAlignment(Unsigned.$uint2ulong((int)Offset), Unsigned.$uint2ulong((int)AF.getAlignment())));
                if (Unsigned.$greater_uint((int)Size, (int)0) && AF.hasEmitNops()) {
                    while (Unsigned.$rem_uint((int)Size, (int)this.getBackend().getMinimumNopSize()) != 0) {
                        Size += AF.getAlignment();
                    }
                }
                if (Unsigned.$greater_uint((int)Size, (int)AF.getMaxBytesToEmit())) {
                    return Unsigned.$int2ulong((int)0);
                }
                return Unsigned.$uint2ulong((int)Size);
            }
            case FT_Org: {
                long Size;
                MCOrgFragment OF = ADTRTTI.cast_MCOrgFragment(F);
                MCValue Value = new MCValue();
                if (!OF.getOffset().evaluateAsValue(Value, Layout)) {
                    llvm.report_fatal_error(NativePointer.$((String)"expected assembly-time absolute expression"));
                }
                long FragmentOffset = Layout.getFragmentOffset((MCFragment)Native.$AddrOf((Object)OF));
                long TargetLocation = Value.getConstant();
                MCSymbolRefExpr A = Value.getSymA();
                if (A != null) {
                    ulong.ref Val = NativePointer.create_ulong$ref();
                    if (!Layout.getSymbolOffset(A.getSymbol(), Val)) {
                        llvm.report_fatal_error(NativePointer.$((String)"expected absolute expression"));
                    }
                    TargetLocation += Val.$deref();
                }
                if ((Size = TargetLocation - FragmentOffset) < 0L || Size >= 0x40000000L) {
                    llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_Twine$C(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("invalid .org offset '"), new Twine(JavaDifferentiators.JD.Long.C.INSTANCE, TargetLocation)), new Twine("' (at offset '")), new Twine(JavaDifferentiators.JD.ConstULLongRef.INSTANCE, FragmentOffset)), new Twine("')")));
                }
                return Size;
            }
            case FT_Dwarf: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCDwarfLineAddrFragment(F).getContents$Const().size());
            }
            case FT_DwarfFrame: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCDwarfCallFrameFragment(F).getContents$Const().size());
            }
            case FT_CVInlineLines: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCCVInlineLineTableFragment(F).getContents$Const().size());
            }
            case FT_CVDefRange: {
                return Unsigned.$uint2ulong((int)ADTRTTI.cast_MCCVDefRangeFragment(F).getContents$Const().size());
            }
            case FT_Dummy: {
                throw new llvm_unreachable("Should not have been added");
            }
        }
        throw new llvm_unreachable("invalid fragment kind");
    }

    public MCSymbol getAtom(MCSymbol S2) {
        if (this.isSymbolLinkerVisible(S2)) {
            return (MCSymbol)Native.$AddrOf((Object)S2);
        }
        if (!S2.isInSection()) {
            return null;
        }
        if (!this.getContext().getAsmInfo().isSectionAtomizableBySymbols((MCSection)Native.$Deref((Object)S2.getFragment().getParent()))) {
            return null;
        }
        return S2.getFragment().getAtom();
    }

    public boolean isSymbolLinkerVisible(MCSymbol Symbol) {
        if (!Symbol.isTemporary()) {
            return true;
        }
        if (!Symbol.isInSection()) {
            return false;
        }
        return Symbol.isUsedInReloc();
    }

    public void writeSectionData(MCSection Sec, MCAsmLayout Layout) {
        if (Sec.isVirtualSection()) {
            assert (Layout.getSectionFileSize(Sec) == Unsigned.$int2ullong((int)0)) : "Invalid size for section!";
            block5: for (MCFragment F : (MCSection)Native.$Deref((Object)Sec)) {
                switch (F.getKind()) {
                    default: {
                        throw new llvm_unreachable("Invalid fragment in virtual section!");
                    }
                    case FT_Data: {
                        MCDataFragment DF = ADTRTTI.cast_MCDataFragment(F);
                        assert (Native.$eq_ptr(DF.fixup_begin$Const(), DF.fixup_end$Const())) : "Cannot have fixups in virtual section!";
                        int e = DF.getContents$Const().size();
                        for (int i = 0; i != e; ++i) {
                            if (DF.getContents$Const().$at$Const(i) == 0) continue;
                            MCSectionELF ELFSec = ADTRTTI.dyn_cast_MCSectionELF(Sec);
                            if (ELFSec != null) {
                                llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_char$ptr$C_StringRef$C("non-zero initializer found in section '", ELFSec.getSectionName()), new Twine(NativePointer.$SGL_QUOTE)));
                                continue;
                            }
                            llvm.report_fatal_error(NativePointer.$((String)"non-zero initializer found in virtual section"));
                        }
                        continue block5;
                    }
                    case FT_Align: {
                        assert (ADTRTTI.cast_MCAlignFragment(F).getValueSize() == 0 || ADTRTTI.cast_MCAlignFragment(F).getValue() == 0L) : "Invalid align in virtual section!";
                        continue block5;
                    }
                    case FT_Fill: {
                        assert (Unsigned.$uchar2int((byte)ADTRTTI.cast_MCFillFragment(F).getValue()) == 0) : "Invalid fill in virtual section!";
                        continue block5;
                    }
                }
            }
            return;
        }
        long Start = this.getWriter().getStream().tell();
        for (MCFragment F : (MCSection)Native.$Deref((Object)Sec)) {
            MCAssemblerStatics.writeFragment(this, Layout, F);
        }
        assert (this.getWriter().getStream().tell() - Start == Layout.getSectionAddressSize(Sec));
    }

    public boolean isThumbFunc(MCSymbol Symbol) {
        if (this.ThumbFuncs.count(Symbol) != 0) {
            return true;
        }
        if (!Symbol.isVariable()) {
            return false;
        }
        MCExpr Expr = Symbol.getVariableValue();
        MCSymbolRefExpr Ref = ADTRTTI.dyn_cast_MCSymbolRefExpr(Expr);
        if (Ref == null) {
            return false;
        }
        if (Ref.getKind() != MCSymbolRefExpr.VariantKind.VK_None) {
            return false;
        }
        MCSymbol Sym = Ref.getSymbol();
        if (!this.isThumbFunc((MCSymbol)Native.$AddrOf((Object)Sym))) {
            return false;
        }
        this.ThumbFuncs.insert(Symbol);
        return true;
    }

    public void setIsThumbFunc(MCSymbol Func) {
        this.ThumbFuncs.insert(Func);
    }

    public int getELFHeaderEFlags() {
        return this.ELFHeaderEFlags;
    }

    public void setELFHeaderEFlags(int Flags) {
        this.ELFHeaderEFlags = Flags;
    }

    public VersionMinInfoType getVersionMinInfo() {
        return this.VersionMinInfo;
    }

    public void setVersionMinInfo(MCVersionMinType Kind2, int Major, int Minor, int Update) {
        this.VersionMinInfo.Kind = Kind2;
        this.VersionMinInfo.Major = Major;
        this.VersionMinInfo.Minor = Minor;
        this.VersionMinInfo.Update = Update;
    }

    public MCAssembler(MCContext Context, MCAsmBackend Backend, MCCodeEmitter Emitter, MCObjectWriter Writer2) {
        this.Context = Context;
        this.Backend = Backend;
        this.Emitter = Emitter;
        this.Writer = Writer2;
        this.Sections = new std.vector((Object)null);
        this.Symbols = new std.vector((Object)null);
        this.IndirectSymbols = new std.vector((Object)new IndirectSymbolData());
        this.DataRegions = new std.vector((Object)new DataRegionData());
        this.LinkerOptions = new std.vector((Object)new std.vectorString(std.string.EMPTY));
        this.FileNames = new std.vectorString(std.string.EMPTY);
        this.LTParams = new MCDwarfLineTableParams();
        this.ThumbFuncs = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 32);
        this.BundleAlignSize = 0;
        this.RelaxAll = false;
        this.SubsectionsViaSymbols = false;
        this.IncrementalLinkerCompatible = false;
        this.ELFHeaderEFlags = 0;
        this.LOHContainer = new MCLOHContainer();
        this.VersionMinInfo = new VersionMinInfoType();
        this.VersionMinInfo.Major = 0;
    }

    public void $destroy() {
        this.LOHContainer.$destroy();
        this.ThumbFuncs.$destroy();
        this.FileNames.$destroy();
        this.LinkerOptions.$destroy();
        this.DataRegions.$destroy();
        this.IndirectSymbols.$destroy();
        this.Symbols.$destroy();
        this.Sections.$destroy();
    }

    public void reset() {
        this.Sections.clear();
        this.Symbols.clear();
        this.IndirectSymbols.clear();
        this.DataRegions.clear();
        this.LinkerOptions.clear();
        this.FileNames.clear();
        this.ThumbFuncs.clear();
        this.BundleAlignSize = 0;
        this.RelaxAll = false;
        this.SubsectionsViaSymbols = false;
        this.IncrementalLinkerCompatible = false;
        this.ELFHeaderEFlags = 0;
        this.LOHContainer.reset();
        this.VersionMinInfo.Major = 0;
        this.getBackend().reset();
        this.getEmitter().reset();
        this.getWriter().reset();
        this.getLOHContainer().reset();
    }

    public MCContext getContext() {
        return this.Context;
    }

    public MCAsmBackend getBackend() {
        return this.Backend;
    }

    public MCCodeEmitter getEmitter() {
        return this.Emitter;
    }

    public MCObjectWriter getWriter() {
        return this.Writer;
    }

    public MCDwarfLineTableParams getDWARFLinetableParams() {
        return new MCDwarfLineTableParams(this.LTParams);
    }

    public void setDWARFLinetableParams(MCDwarfLineTableParams P2) {
        this.LTParams.$assign(P2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Finish() {
        MCAsmLayout Layout = null;
        try {
            Layout = new MCAsmLayout(this);
            this.layout(Layout);
            raw_pwrite_stream OS = this.getWriter().getStream();
            long StartOffset = OS.tell();
            this.getWriter().writeObject(this, Layout);
            StatsStatics.ObjectBytes.$addassign(Unsigned.$ullong2uint((long)(OS.tell() - StartOffset)));
        }
        finally {
            if (Layout != null) {
                Layout.$destroy();
            }
        }
    }

    public void layout(MCAsmLayout Layout) {
        int SectionIndex = 0;
        for (MCSection Sec : this) {
            if (Sec.getFragmentList().empty()) {
                new MCDataFragment((MCSection)Native.$AddrOf((Object)Sec));
            }
            Sec.setOrdinal(SectionIndex++);
        }
        int e = Layout.getSectionOrder().size();
        for (int i = 0; i != e; ++i) {
            MCSection Sec = Layout.getSectionOrder().$at(i);
            Sec.setLayoutOrder(i);
            int FragmentIndex = 0;
            for (MCFragment Frag : (MCSection)Native.$Deref((Object)Sec)) {
                Frag.setLayoutOrder(FragmentIndex++);
            }
        }
        while (this.layoutOnce(Layout)) {
        }
        this.finishLayout(Layout);
        this.getWriter().executePostLayoutBinding(this, Layout);
        for (MCSection Sec : this) {
            for (MCFragment Frag : Sec) {
                if (ADTRTTI.isa_MCEncodedFragment((MCFragment)Native.$AddrOf((Object)Frag)) && ADTRTTI.isa_MCCompactEncodedInstFragment((MCFragment)Native.$AddrOf((Object)Frag)) || !ADTRTTI.isa_MCEncodedFragment((MCFragment)Native.$AddrOf((Object)Frag)) && !ADTRTTI.isa_MCCVDefRangeFragment((MCFragment)Native.$AddrOf((Object)Frag))) continue;
                ArrayRef<boolean> Fixups = new ArrayRef<boolean>(false);
                MutableArrayRefChar Contents2 = new MutableArrayRefChar();
                MCDataFragment FragWithFixups = ADTRTTI.dyn_cast_MCDataFragment((MCFragment)Native.$AddrOf((Object)Frag));
                if (FragWithFixups != null) {
                    Fixups.$assignMove(new ArrayRef<MCFixup>(FragWithFixups.getFixups(), false));
                    Contents2.$assignMove(new MutableArrayRefChar(FragWithFixups.getContents()));
                } else {
                    MCRelaxableFragment mCRelaxableFragment = ADTRTTI.dyn_cast_MCRelaxableFragment((MCFragment)Native.$AddrOf((Object)Frag));
                    if (mCRelaxableFragment != null) {
                        Fixups.$assignMove(new ArrayRef<MCFixup>(mCRelaxableFragment.getFixups(), false));
                        Contents2.$assignMove(new MutableArrayRefChar(mCRelaxableFragment.getContents()));
                    } else {
                        MCCVDefRangeFragment FragWithFixups$2 = ADTRTTI.dyn_cast_MCCVDefRangeFragment((MCFragment)Native.$AddrOf((Object)Frag));
                        if (FragWithFixups$2 != null) {
                            Fixups.$assignMove(new ArrayRef<MCFixup>(FragWithFixups$2.getFixups(), false));
                            Contents2.$assignMove(new MutableArrayRefChar(FragWithFixups$2.getContents()));
                        } else {
                            throw new llvm_unreachable("Unknown fragment with fixups!");
                        }
                    }
                }
                for (MCFixup mCFixup : Fixups) {
                    std_pair.pairULongBool tmp = this.handleFixup(Layout, Frag, mCFixup);
                    long FixedValue = tmp.first;
                    boolean IsPCRel = tmp.second;
                    this.getBackend().applyFixup(mCFixup, Contents2.data(), Contents2.size(), FixedValue, IsPCRel);
                }
            }
        }
    }

    public boolean getSubsectionsViaSymbols() {
        return this.SubsectionsViaSymbols;
    }

    public void setSubsectionsViaSymbols(boolean Value) {
        this.SubsectionsViaSymbols = Value;
    }

    public boolean isIncrementalLinkerCompatible() {
        return this.IncrementalLinkerCompatible;
    }

    public void setIncrementalLinkerCompatible(boolean Value) {
        this.IncrementalLinkerCompatible = Value;
    }

    public boolean getRelaxAll() {
        return this.RelaxAll;
    }

    public void setRelaxAll(boolean Value) {
        this.RelaxAll = Value;
    }

    public boolean isBundlingEnabled() {
        return this.BundleAlignSize != 0;
    }

    public int getBundleAlignSize() {
        return this.BundleAlignSize;
    }

    public void setBundleAlignSize(int Size) {
        assert (Size == 0 || (Size & Size - 1) == 0) : "Expect a power-of-two bundle align size";
        this.BundleAlignSize = Size;
    }

    public pointee_iterator<MCSection> begin() {
        return new pointee_iterator<MCSection>((type.iterator<?, MCSection>)this.Sections.begin());
    }

    public pointee_iterator<MCSection> begin$Const() {
        return new pointee_iterator<MCSection>((type.iterator<?, MCSection>)this.Sections.begin$Const());
    }

    public pointee_iterator<MCSection> end() {
        return new pointee_iterator<MCSection>((type.iterator<?, MCSection>)this.Sections.end());
    }

    public pointee_iterator<MCSection> end$Const() {
        return new pointee_iterator<MCSection>((type.iterator<?, MCSection>)this.Sections.end$Const());
    }

    public int size() {
        return this.Sections.size();
    }

    public pointee_iterator<MCSymbol> symbol_begin() {
        return new pointee_iterator<MCSymbol>((type.iterator<?, MCSymbol>)this.Symbols.begin());
    }

    public pointee_iterator<MCSymbol> symbol_begin$Const() {
        return new pointee_iterator<MCSymbol>((type.iterator<?, MCSymbol>)this.Symbols.begin$Const());
    }

    public pointee_iterator<MCSymbol> symbol_end() {
        return new pointee_iterator<MCSymbol>((type.iterator<?, MCSymbol>)this.Symbols.end());
    }

    public pointee_iterator<MCSymbol> symbol_end$Const() {
        return new pointee_iterator<MCSymbol>((type.iterator<?, MCSymbol>)this.Symbols.end$Const());
    }

    public iterator_range<MCSymbol> symbols() {
        return llvm.make_range(this.symbol_begin(), this.symbol_end());
    }

    public iterator_range<MCSymbol> symbols$Const() {
        return llvm.make_range(this.symbol_begin$Const(), this.symbol_end$Const());
    }

    public int symbol_size() {
        return this.Symbols.size();
    }

    public std.vector<IndirectSymbolData> getIndirectSymbols() {
        return this.IndirectSymbols;
    }

    public StdVector.iterator<IndirectSymbolData> indirect_symbol_begin() {
        return this.IndirectSymbols.begin();
    }

    public StdVector.iterator<IndirectSymbolData> indirect_symbol_begin$Const() {
        return this.IndirectSymbols.begin$Const();
    }

    public StdVector.iterator<IndirectSymbolData> indirect_symbol_end() {
        return this.IndirectSymbols.end();
    }

    public StdVector.iterator<IndirectSymbolData> indirect_symbol_end$Const() {
        return this.IndirectSymbols.end$Const();
    }

    public int indirect_symbol_size() {
        return this.IndirectSymbols.size();
    }

    public std.vector<std.vectorString> getLinkerOptions() {
        return this.LinkerOptions;
    }

    public std.vector<DataRegionData> getDataRegions() {
        return this.DataRegions;
    }

    public StdVector.iterator<DataRegionData> data_region_begin() {
        return this.DataRegions.begin();
    }

    public StdVector.iterator<DataRegionData> data_region_begin$Const() {
        return this.DataRegions.begin$Const();
    }

    public StdVector.iterator<DataRegionData> data_region_end() {
        return this.DataRegions.end();
    }

    public StdVector.iterator<DataRegionData> data_region_end$Const() {
        return this.DataRegions.end$Const();
    }

    public int data_region_size() {
        return this.DataRegions.size();
    }

    public MCLOHContainer getLOHContainer() {
        return this.LOHContainer;
    }

    public MCLOHContainer getLOHContainer$Const() {
        return this.getLOHContainer();
    }

    public boolean registerSection(MCSection Section) {
        if (Section.isRegistered()) {
            return false;
        }
        this.Sections.push_back_T$RR((Object)((MCSection)Native.$AddrOf((Object)Section)));
        Section.setIsRegistered(true);
        return true;
    }

    public void registerSymbol(MCSymbol Symbol) {
        this.registerSymbol(Symbol, null);
    }

    public void registerSymbol(MCSymbol Symbol, bool.ptr Created) {
        boolean New2;
        boolean bl = New2 = !Symbol.isRegistered();
        if (Native.$bool((Native.Native$Bool)Created)) {
            Created.$set(New2);
        }
        if (New2) {
            Symbol.setIsRegistered(true);
            this.Symbols.push_back_T$RR((Object)((MCSymbol)Native.$AddrOf((Object)Symbol)));
        }
    }

    public ArrayRef<std.string> getFileNames() {
        return new ArrayRef<std.string>(this.FileNames, false);
    }

    public void addFileName(StringRef FileName) {
        if (std.$eq___normal_iterator$C((StdVectorString.iterator)((StdVectorString.iterator)std.find((type.iterator)this.FileNames.begin(), (type.iterator)this.FileNames.end(), (Object)FileName)), (StdVectorString.iterator)this.FileNames.end())) {
            this.FileNames.push_back_T$RR(FileName.$string());
        }
    }

    public void writeFragmentPadding(MCFragment F, long FSize, MCObjectWriter OW) {
        int BundlePadding = Unsigned.$uchar2uint((byte)F.getBundlePadding());
        if (Unsigned.$greater_uint((int)BundlePadding, (int)0)) {
            assert (this.isBundlingEnabled()) : "Writing bundle padding with disabled bundling";
            assert (F.hasInstructions()) : "Writing bundle padding for a fragment without instructions";
            int TotalLength = BundlePadding + Unsigned.$ulong2uint((long)FSize);
            if (F.alignToBundleEnd() && Unsigned.$greater_uint((int)TotalLength, (int)this.getBundleAlignSize())) {
                int DistanceToBoundary = TotalLength - this.getBundleAlignSize();
                if (!this.getBackend().writeNopData(Unsigned.$uint2ulong((int)DistanceToBoundary), OW)) {
                    llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("unable to write NOP sequence of "), new Twine(JavaDifferentiators.JD.UInt.INSTANCE, DistanceToBoundary)), new Twine(" bytes")));
                }
                BundlePadding -= DistanceToBoundary;
            }
            if (!this.getBackend().writeNopData(Unsigned.$uint2ulong((int)BundlePadding), OW)) {
                llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("unable to write NOP sequence of "), new Twine(JavaDifferentiators.JD.UInt.INSTANCE, BundlePadding)), new Twine(" bytes")));
            }
        }
    }

    public void dump() {
        raw_ostream OS = llvm.errs();
        OS.$out("<MCAssembler\n");
        OS.$out("  Sections:[\n    ");
        pointee_iterator<Object> it = this.begin();
        pointee_iterator<Object> ie = this.end();
        while (it.$noteq(ie)) {
            if (it.$noteq(this.begin())) {
                OS.$out(",\n    ");
            }
            ((MCSection)it.$arrow()).dump();
            it.$preInc();
        }
        OS.$out("],\n");
        OS.$out("  Symbols:[");
        it = this.symbol_begin();
        ie = this.symbol_end();
        while (it.$noteq(ie)) {
            if (it.$noteq(this.symbol_begin())) {
                OS.$out(",\n           ");
            }
            OS.$out(NativePointer.$LPAREN);
            ((MCSymbol)it.$arrow()).dump();
            OS.$out(", Index:").$out_uint(((MCSymbol)it.$arrow()).getIndex()).$out(NativePointer.$COMMA_SPACE);
            OS.$out(NativePointer.$RPAREN);
            it.$preInc();
        }
        OS.$out("]>\n");
    }

    @Override
    public Iterator<MCSection> iterator() {
        return new JavaIterator((type.iterator)this.Sections.begin(), (type.iterator)this.Sections.end());
    }

    public String toString() {
        return "Context=[MCContext], Backend=" + this.Backend + ", Emitter=" + this.Emitter + ", Writer=" + this.Writer + ", Sections=" + this.Sections + ", Symbols=" + this.Symbols + ", IndirectSymbols=" + this.IndirectSymbols + ", DataRegions=" + this.DataRegions + ", LinkerOptions=" + this.LinkerOptions + ", FileNames=" + this.FileNames + ", LTParams=" + this.LTParams + ", ThumbFuncs=" + this.ThumbFuncs + ", BundleAlignSize=" + this.BundleAlignSize + ", RelaxAll=" + this.RelaxAll + ", SubsectionsViaSymbols=" + this.SubsectionsViaSymbols + ", IncrementalLinkerCompatible=" + this.IncrementalLinkerCompatible + ", ELFHeaderEFlags=" + this.ELFHeaderEFlags + ", LOHContainer=" + this.LOHContainer + ", VersionMinInfo=" + this.VersionMinInfo;
    }

    public static class VersionMinInfoType {
        public MCVersionMinType Kind;
        public int Major;
        public int Minor;
        public int Update;

        public String toString() {
            return "Kind=" + (Object)((Object)this.Kind) + ", Major=" + this.Major + ", Minor=" + this.Minor + ", Update=" + this.Update;
        }
    }
}

