/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryBool;
import org.llvm.adt.aliases.StringMapIteratorBool;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapBool
extends StringMapImpl
implements Destructors.ClassWithDestructor,
Iterable<StringMapEntryBool>,
NativeCloneable<StringMapBool> {
    private NativeMemory.Allocator Allocator;
    private final boolean defaultValue;
    private final boolean isDataPointerLike;

    public StringMapBool(boolean defaultValue) {
        super(StringMapEntryBool.$sizeof_StringMapEntryBool());
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapBool(int InitialSize, boolean defaultValue) {
        super(InitialSize, StringMapEntryBool.$sizeof_StringMapEntryBool());
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapBool(NativeMemory.Allocator A, boolean defaultValue) {
        super(StringMapEntryBool.$sizeof_StringMapEntryBool());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
    }

    public StringMapBool(int InitialSize, NativeMemory.Allocator A, boolean defaultValue) {
        super(InitialSize, StringMapEntryBool.$sizeof_StringMapEntryBool());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
    }

    public StringMapBool(StringMapBool RHS, boolean defaultValue) {
        super(StringMapEntryBool.$sizeof_StringMapEntryBool());
        assert (RHS.checkAlive());
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapBool(JavaDifferentiators.JD.Move _dparam, StringMapBool RHS) {
        super((StringMapImpl)((Object)std.move((Object)RHS)));
        assert (RHS.checkAlive());
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
        this.isDataPointerLike = false;
    }

    public StringMapBool $assign(StringMapBool RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        super.swap(RHS);
        assert (RHS.isDataPointerLike == this.isDataPointerLike) : RHS.isDataPointerLike + " vs. " + this.isDataPointerLike;
        NativeMemory.Allocator tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public NativeMemory.Allocator getAllocator() {
        assert (this.checkAlive());
        return this.Allocator;
    }

    public StringMapIteratorBool begin() {
        assert (this.checkAlive());
        return new StringMapIteratorBool(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorBool end() {
        assert (this.checkAlive());
        return new StringMapIteratorBool(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorBool begin$Const() {
        assert (this.checkAlive());
        return this.begin();
    }

    public StringMapIteratorBool end$Const() {
        assert (this.checkAlive());
        return this.end();
    }

    public StringMapIteratorBool find(StringRef Key) {
        assert (this.checkAlive());
        int Bucket2 = this.FindKey(Key);
        if (Bucket2 == -1) {
            return this.end();
        }
        return new StringMapIteratorBool(this.TheTable, Bucket2, true);
    }

    public StringMapIteratorBool find(String Key) {
        assert (this.checkAlive());
        return this.find(new StringRef(Key));
    }

    public StringMapIteratorBool find(char.ptr Key) {
        assert (this.checkAlive());
        int Bucket2 = this.FindKey(Key, std.strlen((char.ptr)Key));
        if (Bucket2 == -1) {
            return this.end();
        }
        return new StringMapIteratorBool(this.TheTable, Bucket2, true);
    }

    public StringMapIteratorBool find$Const(StringRef Key) {
        assert (this.checkAlive());
        return this.find(Key);
    }

    public boolean lookup(StringRef Key) {
        assert (this.checkAlive());
        return this.lookup(Key.data(), Key.size());
    }

    public boolean lookup(char.ptr Key, int KeyLen) {
        assert (this.checkAlive());
        int Bucket2 = this.FindKey(Key, KeyLen);
        if (Bucket2 != -1) {
            return ((StringMapEntryBool)this.TheTable[Bucket2]).getValue();
        }
        return Native.$tryClone((boolean)this.defaultValue);
    }

    public boolean $at(String Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key).getValue();
    }

    public boolean $at(StringRef Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key).getValue();
    }

    public boolean $at(char.ptr Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key).getValue();
    }

    public bool.ref ref$at(String Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public bool.ref ref$at(StringRef Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public bool.ref ref$at(char.ptr Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public boolean $set(StringRef Key, boolean Val) {
        assert (this.checkAlive());
        this.GetOrCreateValue((StringRef)Key, (boolean)false).second = Val;
        return this.GetOrCreateValue((StringRef)Key, (boolean)false).second;
    }

    public boolean $set(String Key, boolean Val) {
        assert (this.checkAlive());
        this.GetOrCreateValue((String)Key, (boolean)false).second = Val;
        return this.GetOrCreateValue((String)Key, (boolean)false).second;
    }

    public boolean $set(char.ptr Key, boolean Val) {
        assert (this.checkAlive());
        this.GetOrCreateValue((char.ptr)Key, (int)std.strlen((char.ptr)Key), (boolean)false).second = Val;
        return this.GetOrCreateValue((char.ptr)Key, (int)std.strlen((char.ptr)Key), (boolean)false).second;
    }

    public int count(StringRef Key) {
        assert (this.checkAlive());
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std_pair.pairTypeBool<StringMapIteratorBool> insert(std_pair.pairTypeBool<StringRef> KV) {
        int FullHashValue;
        int keyLength;
        assert (this.checkAlive());
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapBool.getTombstoneVal()) {
            return std.make_pair_T_bool((Object)new StringMapIteratorBool(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket2 == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = StringMapEntryBool.Create(keyData, keyLength, FullHashValue, this.Allocator, std.move((boolean)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair_T_bool((Object)new StringMapIteratorBool(this.TheTable, BucketNo, false), (boolean)true);
    }

    public std_pair.pairTypeBool<StringMapIteratorBool> emplace_second(StringRef Key, boolean ValueToMove) {
        int FullHashValue;
        int keyLength;
        assert (this.checkAlive());
        char.ptr keyData = Key.data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = Key.size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapBool.getTombstoneVal()) {
            return std.make_pair_T_bool((Object)new StringMapIteratorBool(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket2 == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = StringMapEntryBool.Create(keyData, keyLength, FullHashValue, this.Allocator, Native.$tryMove((boolean)std.move((boolean)ValueToMove)));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair_T_bool((Object)new StringMapIteratorBool(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntryBool KeyValue) {
        int FullHashValue;
        int keyLength;
        assert (this.checkAlive());
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapBool.getTombstoneVal()) {
            return false;
        }
        if (Bucket2 == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        assert (this.checkAlive());
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket2 = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntryBool GetOrCreateValue(StringRef Key, boolean Val) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntryBool GetOrCreateValue(String Key, boolean Val) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(new StringRef(Key), Val);
    }

    public StringMapEntryBool GetOrCreateValue(char.ptr Key, int Len, boolean Val) {
        assert (this.checkAlive());
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapBool.getTombstoneVal()) {
            return (StringMapEntryBool)Bucket2;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((boolean)Val);
        }
        StringMapEntryBool NewItem = StringMapEntryBool.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket2 == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket2 = NewItem;
        this.RehashTable();
        return (StringMapEntryBool)Bucket2;
    }

    private StringMapEntryBool GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, boolean Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapBool.getTombstoneVal()) {
            return (StringMapEntryBool)Bucket2;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((boolean)Val);
        }
        StringMapEntryBool NewItem = StringMapEntryBool.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket2 == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket2 = NewItem;
        this.RehashTable();
        return (StringMapEntryBool)Bucket2;
    }

    public StringMapEntryBool GetOrCreateValue(StringRef Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntryBool GetOrCreateValue(String Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(new StringRef(Key), this.defaultValue);
    }

    public StringMapEntryBool GetOrCreateValue(char.ptr Key) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key, std.strlen((char.ptr)Key), this.defaultValue);
    }

    public StringMapEntryBool GetOrCreateValue(char.ptr Key, int Len) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntryBool GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        assert (this.checkAlive());
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntryBool KeyValue) {
        assert (this.checkAlive());
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIteratorBool I) {
        assert (this.checkAlive());
        StringMapEntryBool V = I.$star();
        this.remove(V);
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        assert (this.checkAlive());
        StringMapIteratorBool I = this.find(Key);
        if (Native.$eq_iter((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        assert (this.checkAlive());
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy((Object)this.Allocator);
        super.set$destroyed();
    }

    public String toString() {
        StringBuilder out = new StringBuilder(super.is$destroyed() ? "DESTROYED\n" : "");
        StringMapIteratorBool B = this.begin();
        StringMapIteratorBool E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(B.$star().first()).append("=>").append(B.$star().getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }

    @Override
    public Iterator<StringMapEntryBool> iterator() {
        assert (this.checkAlive());
        return new JavaIterator((type.iterator)this.begin(), (type.iterator)this.end());
    }

    public StringMapBool clone() {
        assert (this.checkAlive());
        StringMapBool out = new StringMapBool(this, this.defaultValue);
        assert (this.getClass() == out.getClass()) : "clone must be overridden in " + this.getClass();
        return out;
    }
}

