/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.NativeContainer;
import org.clank.support.aliases.type;
import org.llvm.adt.java.SmallVectorImplCommon;

public abstract class SmallVectorImplWithoutDestroy<T>
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplWithoutDestroy<T>>,
Native.NativeComparable<SmallVectorImplWithoutDestroy<T>>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<T>,
Native.NativeIterable<type.ptr<T>>,
Native.NativeReverseIterable<std.reverse_iterator<T>>,
NativeContainer<T>,
SmallVectorImplCommon<T> {
    protected final T defaultValue;
    private T[] array;
    private static final Object[] EMPTY = new Object[0];
    private int end;

    public final T[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplWithoutDestroy(int capacity, T defaultValue) {
        this.array = capacity == 0 ? EMPTY : new Object[capacity];
        this.end = 0;
        assert (NativeTrace.assertDefaultValue(defaultValue));
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplWithoutDestroy(int capacity, int initialSize, T defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplWithoutDestroy(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, T defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplWithoutDestroy(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, T value, T defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplWithoutDestroy(T[] array2, T defaultValue) {
        this.array = array2;
        int n = this.end = array2 == null ? 0 : array2.length;
        assert (NativeTrace.assertDefaultValue(defaultValue));
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplWithoutDestroy(int capacity, type.iterator<?, ? extends T> iter, int length, T defaultValue) {
        this(capacity, iter, (type.iterator<?, ? extends T>)((type.iterator)iter.$add(length)), (T)defaultValue);
    }

    protected SmallVectorImplWithoutDestroy(int capacity, type.iterator<?, ? extends T> begin, type.iterator<?, ? extends T> end, T defaultValue) {
        this(capacity, (T)defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplWithoutDestroy(SmallVectorImplWithoutDestroy<T> other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : new Object[capacity];
        this.append_T((type.iterator<?, ? extends T>)other.begin(), (type.iterator<?, ? extends T>)other.end());
    }

    protected SmallVectorImplWithoutDestroy(JavaDifferentiators.JD.Move _dparam, SmallVectorImplWithoutDestroy<T> other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplWithoutDestroy<T> $assign(SmallVectorImplWithoutDestroy<T> other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((type.iterator<?, ? extends T>)other.begin(), (type.iterator<?, ? extends T>)other.end());
        return this;
    }

    public final SmallVectorImplWithoutDestroy<T> $assignMove(SmallVectorImplWithoutDestroy<T> other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, T defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, T Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(type.iterator<?, ? extends T> __first, type.iterator<?, ? extends T> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplWithoutDestroy RHS = (SmallVectorImplWithoutDestroy)_RHS;
        T[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(Object elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(Object elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], (Object)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(Object elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(Object elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((Object[])this.array, (int)(index + 1), (Object[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final type.ptr<T> erase(type.ptr<T> I) {
        assert (this.checkAlive());
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        type.ptr<T> N = I;
        std.copy((type.iterator)((type.iterator)I.$add(1)), this.end(), I, (boolean)this.isDataPointerLike());
        this.pop_back();
        return N;
    }

    public final type.ptr<T> erase(type.ptr<T> S2, type.ptr<T> E) {
        assert (this.checkAlive());
        assert (S2.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        type.ptr<T> N = S2;
        type.ptr I = (type.ptr)std.copy(E, this.end(), S2, (boolean)this.isDataPointerLike());
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public type.ptr<T> insert_iterator$T$value_T$RR(type.ptr<T> I, T Elt) {
        assert (this.checkAlive());
        if (I.$eq(this.end())) {
            this.push_back_T$RR(Elt);
            return (type.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = (type.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((type.iterator)I, (type.iterator)((type.iterator)this.end().$sub(1)), this.end(), (boolean)this.isDataPointerLike());
        I.$set(Native.$tryMove((Object)I.$star(), Elt, (boolean)this.isDataPointerLike()));
        return I;
    }

    public type.ptr<T> insert_iterator$T_T$C$R(type.ptr<T> I, T Elt) {
        return this.insert(I, Elt);
    }

    public type.ptr<T> insert_iterator$T$value_T$C$R(type.ptr<T> I, T Elt) {
        return this.insert(I, Elt);
    }

    public final type.ptr<T> insert(type.ptr<T> I, T Elt) {
        assert (this.checkAlive());
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return (type.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = (type.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((type.iterator)I, (type.iterator)((type.iterator)this.end().$sub(1)), this.end(), (boolean)this.isDataPointerLike());
        I.$set(Native.$tryAssign(null, Elt, (boolean)this.isDataPointerLike()));
        return I;
    }

    public final type.ptr<T> insert(type.ptr<T> I, int NumToInsert, T Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return (type.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (type.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            type.ptr<T> OldEnd = this.end();
            this.append_T((type.iterator<?, ? extends T>)((type.iterator)this.end().$sub(NumToInsert)), (type.iterator<?, ? extends T>)this.end());
            std.copy_backward((type.iterator)I, (type.iterator)((type.iterator)OldEnd.$sub(NumToInsert)), OldEnd, (boolean)this.isDataPointerLike());
            std.fill_n((type.iterator)I, (int)NumToInsert, Elt);
            return I;
        }
        type.ptr<T> OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((type.iterator)I, OldEnd, (type.iterator)((type.ptr)this.end().$sub(NumOverwritten)), (boolean)this.isDataPointerLike());
        std.fill_n((type.iterator)I, (int)NumOverwritten, Elt);
        std.fill_n(OldEnd, (int)(NumToInsert - NumOverwritten), Elt);
        return I;
    }

    public final type.ptr<T> insert$T(type.ptr<T> I, type.iterator<?, ? extends T> From, type.iterator<?, ? extends T> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final type.ptr<T> insert$T$value_T(type.ptr<T> I, type.iterator<?, ? extends T> From, type.iterator<?, ? extends T> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final type.ptr<T> insert_iterator$T_T(type.ptr<T> I, type.iterator<?, ? extends T> From, type.iterator<?, ? extends T> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final type.ptr<T> insert(type.ptr<T> I, type.iterator<?, ? extends T> From, type.iterator<?, ? extends T> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final type.ptr<T> insert_iterator$T$value_T(type.ptr<T> I, type.iterator<?, ? extends T> From, type.iterator<?, ? extends T> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append_T(From, To);
            return (type.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (type.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            type.ptr<T> OldEnd = this.end();
            this.append_T((type.iterator<?, ? extends T>)((type.iterator)this.end().$sub(NumToInsert)), (type.iterator<?, ? extends T>)this.end());
            std.copy_backward((type.iterator)I, (type.iterator)((type.iterator)OldEnd.$sub(NumToInsert)), OldEnd, (boolean)this.isDataPointerLike());
            std.copy(From, To, (type.iterator)I, (boolean)this.isDataPointerLike());
            return I;
        }
        type.ptr<T> OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((type.iterator)I, OldEnd, (type.iterator)((type.ptr)this.end().$sub(NumOverwritten)), (boolean)this.isDataPointerLike());
        if (NumOverwritten > 0) {
            From = (type.iterator)Native.$Clone(From);
            type.ptr J = (type.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((type.iterator)From, To, OldEnd, (boolean)this.isDataPointerLike());
        return I;
    }

    public final void append_T(type.iterator<?, ? extends T> in_start, type.iterator<?, ? extends T> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, T> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(T[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(T[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            T el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, T Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, T Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, T Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplWithoutDestroy<T> RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq(this.array[i], RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplWithoutDestroy<T> RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplWithoutDestroy)obj).checkAlive());
        return std.lexicographical_compare(this.begin(), this.end(), ((SmallVectorImplWithoutDestroy)obj).begin(), ((SmallVectorImplWithoutDestroy)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplWithoutDestroy)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplWithoutDestroy)obj);
    }

    public final type.ref<T> ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_type$ref((Object[])this.array, (int)idx);
    }

    public final T $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final T $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final T $set(int idx, T value) {
        assert (this.checkAlive());
        this.array[idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[idx], value, (boolean)this.isDataPointerLike());
        return this.array[idx];
    }

    protected final T $set$move(int idx, T value) {
        assert (this.checkAlive());
        this.array[idx] = this.defaultValue == null ? value : Native.$tryMove(this.array[idx], value, (boolean)this.isDataPointerLike());
        return this.array[idx];
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(T val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(T val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(T val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(T val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final T pop_back_val() {
        assert (this.checkAlive());
        T val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final type.ptr<T> begin() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final type.ptr<T> begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final type.ptr<T> end() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array, (int)this.end);
    }

    public final type.ptr<T> end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array, (int)this.end);
    }

    public final std.reverse_iterator<T> rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array, (int)this.end));
    }

    public final std.reverse_iterator<T> rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array, (int)this.end));
    }

    public final std.reverse_iterator<T> rend() {
        assert (this.checkAlive());
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array));
    }

    public final std.reverse_iterator<T> rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array));
    }

    @Override
    public final type.ptr<T> data() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final type.ptr<T> data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final T front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final T front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final T back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final T back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final type.ref<T> ref$front() {
        assert (this.checkAlive());
        return new type.ref<T>(){
            private final int index = 0;

            public T $deref() {
                assert (SmallVectorImplWithoutDestroy.this.checkAlive());
                return SmallVectorImplWithoutDestroy.this.array[0];
            }

            public T $set(T value) {
                assert (SmallVectorImplWithoutDestroy.this.checkAlive());
                ((SmallVectorImplWithoutDestroy)SmallVectorImplWithoutDestroy.this).array[0] = SmallVectorImplWithoutDestroy.this.defaultValue == null ? value : Native.$tryAssign((Object)SmallVectorImplWithoutDestroy.this.array[0], value, (boolean)SmallVectorImplWithoutDestroy.this.isDataPointerLike());
                return SmallVectorImplWithoutDestroy.this.array[0];
            }

            public type.ptr<T> deref$ptr() {
                assert (SmallVectorImplWithoutDestroy.this.checkAlive());
                return (type.ptr)SmallVectorImplWithoutDestroy.this.data().$add(0);
            }
        };
    }

    public final type.ref<T> ref$back() {
        assert (this.checkAlive());
        return new type.ref<T>(){
            private final int index;
            {
                this.index = SmallVectorImplWithoutDestroy.this.end - 1;
            }

            public T $deref() {
                assert (SmallVectorImplWithoutDestroy.this.checkAlive());
                return SmallVectorImplWithoutDestroy.this.array[this.index];
            }

            public T $set(T value) {
                assert (SmallVectorImplWithoutDestroy.this.checkAlive());
                ((SmallVectorImplWithoutDestroy)SmallVectorImplWithoutDestroy.this).array[this.index] = SmallVectorImplWithoutDestroy.this.defaultValue == null ? value : Native.$tryAssign((Object)SmallVectorImplWithoutDestroy.this.array[this.index], value, (boolean)SmallVectorImplWithoutDestroy.this.isDataPointerLike());
                return SmallVectorImplWithoutDestroy.this.array[this.index];
            }

            public type.ptr<T> deref$ptr() {
                assert (SmallVectorImplWithoutDestroy.this.checkAlive());
                return (type.ptr)SmallVectorImplWithoutDestroy.this.data().$add(this.index);
            }
        };
    }

    @Override
    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (T elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final type.ptr<T> ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.defaultValue != null) {
                Native.destroy(this.array[i]);
            }
            this.array[i] = null;
        }
    }

    private void destroy_range(type.ptr<T> _from, type.ptr<T> _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        Object[] oldArray = this.array;
        this.array = new Object[capacity];
        NativePointer.copy$Object((Object[])oldArray, (int)0, (Object[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(type.ptr<T> to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<T> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(this.begin(), this.end());
    }

    @Override
    public boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplWithoutDestroy{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            T element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplWithoutDestroy}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

