/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorUChar;
import org.clank.support.aliases.NativeContainerUChar;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uchar;

public abstract class SmallVectorImplUChar
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplUChar>,
Native.NativeComparable<SmallVectorImplUChar>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Byte>,
Native.NativeIterable<uchar.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorUChar>,
NativeContainerUChar {
    protected final byte defaultValue;
    private byte[] array;
    private static final byte[] EMPTY = NativePointer.new$uchar((int)0);
    private int end;

    public final byte[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplUChar(int capacity, byte defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$uchar((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplUChar(int capacity, int initialSize, byte defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplUChar(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, byte defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplUChar(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, byte value, byte defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplUChar(byte[] array2, byte defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplUChar(int capacity, uchar.iterator<?> iter, int length, byte defaultValue) {
        this(capacity, iter, (uchar.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplUChar(int capacity, uchar.iterator<?> begin, uchar.iterator<?> end, byte defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplUChar(SmallVectorImplUChar other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$uchar((int)capacity);
        this.append_T((uchar.iterator<?>)other.begin(), (uchar.iterator<?>)other.end());
    }

    protected SmallVectorImplUChar(JavaDifferentiators.JD.Move _dparam, SmallVectorImplUChar other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplUChar $assign(SmallVectorImplUChar other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((uchar.iterator<?>)other.begin(), (uchar.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplUChar $assignMove(SmallVectorImplUChar other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, byte defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((byte)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, byte Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(uchar.iterator<?> __first, uchar.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplUChar RHS = (SmallVectorImplUChar)_RHS;
        byte[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(byte elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(byte elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((byte)this.array[i], (byte)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(byte elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(byte elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((byte[])this.array, (int)(index + 1), (byte[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final uchar.ptr erase(uchar.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        uchar.ptr N = I;
        std.copy((uchar.iterator)((uchar.iterator)I.$add(1)), (uchar.iterator)this.end(), (uchar.iterator)I);
        this.pop_back();
        return N;
    }

    public final uchar.ptr erase(uchar.ptr S2, uchar.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        uchar.ptr N = S2;
        uchar.ptr I = (uchar.ptr)std.copy((uchar.iterator)E, (uchar.iterator)this.end(), (uchar.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public uchar.ptr insert_iterator$T$value_T$RR(uchar.ptr I, byte Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (uchar.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (uchar.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((uchar.iterator)I, (uchar.iterator)((uchar.iterator)this.end().$sub(1)), (uchar.iterator)this.end());
        I.$set(((Byte)Native.$tryMove((Object)I.$star(), (Object)Elt, (boolean)this.isDataPointerLike())).byteValue());
        return I;
    }

    public uchar.ptr insert_iterator$T_T$C$R(uchar.ptr I, byte Elt) {
        return this.insert(I, Elt);
    }

    public uchar.ptr insert_iterator$T$value_T$C$R(uchar.ptr I, byte Elt) {
        return this.insert(I, Elt);
    }

    public final uchar.ptr insert(uchar.ptr I, byte Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (uchar.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (uchar.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((uchar.iterator)I, (uchar.iterator)((uchar.iterator)this.end().$sub(1)), (uchar.iterator)this.end());
        I.$set(((Byte)Native.$tryAssign(null, (Object)Elt, (boolean)this.isDataPointerLike())).byteValue());
        return I;
    }

    public final uchar.ptr insert(uchar.ptr I, int NumToInsert, byte Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (uchar.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (uchar.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            uchar.ptr OldEnd = this.end();
            this.append_T((uchar.iterator<?>)((uchar.iterator)this.end().$sub(NumToInsert)), (uchar.iterator<?>)this.end());
            std.copy_backward((uchar.iterator)I, (uchar.iterator)((uchar.iterator)OldEnd.$sub(NumToInsert)), (uchar.iterator)OldEnd);
            std.fill_n((uchar.iterator)I, (int)NumToInsert, (byte)Elt);
            return I;
        }
        uchar.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((uchar.iterator)I, (uchar.iterator)OldEnd, (uchar.iterator)((uchar.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((uchar.iterator)I, (int)NumOverwritten, (byte)Elt);
        std.fill_n((uchar.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (byte)Elt);
        return I;
    }

    public final uchar.ptr insert$T(uchar.ptr I, uchar.iterator<?> From, uchar.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final uchar.ptr insert$T$value_T(uchar.ptr I, uchar.iterator<?> From, uchar.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final uchar.ptr insert_iterator$T_T(uchar.ptr I, uchar.iterator<?> From, uchar.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final uchar.ptr insert(uchar.ptr I, uchar.iterator<?> From, uchar.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final uchar.ptr insert_iterator$T$value_T(uchar.ptr I, uchar.iterator<?> From, uchar.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (uchar.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (uchar.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            uchar.ptr OldEnd = this.end();
            this.append_T((uchar.iterator<?>)((uchar.iterator)this.end().$sub(NumToInsert)), (uchar.iterator<?>)this.end());
            std.copy_backward((uchar.iterator)I, (uchar.iterator)((uchar.iterator)OldEnd.$sub(NumToInsert)), (uchar.iterator)OldEnd);
            std.copy(From, To, (uchar.iterator)I);
            return I;
        }
        uchar.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((uchar.iterator)I, (uchar.iterator)OldEnd, (uchar.iterator)((uchar.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (uchar.iterator)Native.$Clone(From);
            uchar.ptr J = (uchar.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((uchar.iterator)From, To, (uchar.iterator)OldEnd);
        return I;
    }

    public final void append_T(uchar.iterator<?> in_start, uchar.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        uchar.iterator iter = (uchar.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Byte> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (Byte)converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(byte[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(byte[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            byte el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, byte Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, byte Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, byte Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplUChar RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((byte)this.array[i], (byte)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplUChar RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplUChar)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplUChar)obj).begin(), (Object)((SmallVectorImplUChar)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplUChar)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplUChar)obj);
    }

    public final uchar.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ref((byte[])this.array, (int)idx);
    }

    public final byte $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final byte $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final byte $set(int idx, byte value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final byte $set$move(int idx, byte value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(byte val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(byte val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(byte val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(byte val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final byte pop_back_val() {
        assert (this.checkAlive());
        byte val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final uchar.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array);
    }

    public final uchar.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array);
    }

    public final uchar.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array, (int)this.end);
    }

    public final uchar.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorUChar rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUChar((uchar.iterator)NativePointer.create_uchar$ptr((byte[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorUChar rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUChar((uchar.iterator)NativePointer.create_uchar$ptr((byte[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorUChar rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUChar((uchar.iterator)NativePointer.create_uchar$ptr((byte[])this.array));
    }

    public final std.reverse_iteratorUChar rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUChar((uchar.iterator)NativePointer.create_uchar$ptr((byte[])this.array));
    }

    public final uchar.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array);
    }

    public final uchar.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array);
    }

    public final byte front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final byte front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final byte back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final byte back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final uchar.ref ref$front() {
        assert (this.checkAlive());
        return new uchar.ref(){
            private final int index = 0;

            public byte $deref() {
                assert (SmallVectorImplUChar.this.checkAlive());
                return SmallVectorImplUChar.this.array[0];
            }

            public byte $set(byte value) {
                assert (SmallVectorImplUChar.this.checkAlive());
                ((SmallVectorImplUChar)SmallVectorImplUChar.this).array[0] = value;
                return value;
            }

            public uchar.ptr deref$ptr() {
                assert (SmallVectorImplUChar.this.checkAlive());
                return (uchar.ptr)SmallVectorImplUChar.this.data().$add(0);
            }
        };
    }

    public final uchar.ref ref$back() {
        assert (this.checkAlive());
        return new uchar.ref(){
            private final int index;
            {
                this.index = SmallVectorImplUChar.this.end - 1;
            }

            public byte $deref() {
                assert (SmallVectorImplUChar.this.checkAlive());
                return SmallVectorImplUChar.this.array[this.index];
            }

            public byte $set(byte value) {
                assert (SmallVectorImplUChar.this.checkAlive());
                ((SmallVectorImplUChar)SmallVectorImplUChar.this).array[this.index] = value;
                return value;
            }

            public uchar.ptr deref$ptr() {
                assert (SmallVectorImplUChar.this.checkAlive());
                return (uchar.ptr)SmallVectorImplUChar.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((byte)this.defaultValue);
        for (byte elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((byte)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final uchar.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_uchar$ptr((byte[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(uchar.ptr _from, uchar.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        byte[] oldArray = this.array;
        this.array = NativePointer.new$uchar((int)capacity);
        NativePointer.copy$Object((byte[])oldArray, (int)0, (byte[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(uchar.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Byte> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorUChar((uchar.iterator)this.begin(), (uchar.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplUChar{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            byte element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element == 0 ? "<EOF>" : Character.valueOf((char)element)).append('\n');
        }
        out.append("}SmallVectorImplUChar}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

