/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorInt;
import org.clank.support.aliases.NativeContainerInt;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;

public abstract class SmallVectorImplInt
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplInt>,
Native.NativeComparable<SmallVectorImplInt>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Integer>,
Native.NativeIterable<int.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorInt>,
NativeContainerInt {
    protected final int defaultValue;
    private int[] array;
    private static final int[] EMPTY = NativePointer.new$int((int)0);
    private int end;

    public final int[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplInt(int capacity, int defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$int((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplInt(int capacity, int initialSize, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplInt(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplInt(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, int value, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplInt(int[] array2, int defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplInt(int capacity, int.iterator<?> iter, int length, int defaultValue) {
        this(capacity, iter, (int.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplInt(int capacity, int.iterator<?> begin, int.iterator<?> end, int defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplInt(SmallVectorImplInt other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$int((int)capacity);
        this.append_T((int.iterator<?>)other.begin(), (int.iterator<?>)other.end());
    }

    protected SmallVectorImplInt(JavaDifferentiators.JD.Move _dparam, SmallVectorImplInt other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplInt $assign(SmallVectorImplInt other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((int.iterator<?>)other.begin(), (int.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplInt $assignMove(SmallVectorImplInt other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, int defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((int)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, int Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(int.iterator<?> __first, int.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplInt RHS = (SmallVectorImplInt)_RHS;
        int[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(int elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(int elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((int)this.array[i], (int)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(int elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(int elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((int[])this.array, (int)(index + 1), (int[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final int.ptr erase(int.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        int.ptr N = I;
        std.copy((int.iterator)((int.iterator)I.$add(1)), (int.iterator)this.end(), (int.iterator)I);
        this.pop_back();
        return N;
    }

    public final int.ptr erase(int.ptr S2, int.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        int.ptr N = S2;
        int.ptr I = (int.ptr)std.copy((int.iterator)E, (int.iterator)this.end(), (int.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public int.ptr insert_iterator$T$value_T$RR(int.ptr I, int Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (int.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (int.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((int.iterator)I, (int.iterator)((int.iterator)this.end().$sub(1)), (int.iterator)this.end());
        I.$set(((Integer)Native.$tryMove((Object)I.$star(), (Object)Elt, (boolean)this.isDataPointerLike())).intValue());
        return I;
    }

    public int.ptr insert_iterator$T_T$C$R(int.ptr I, int Elt) {
        return this.insert(I, Elt);
    }

    public int.ptr insert_iterator$T$value_T$C$R(int.ptr I, int Elt) {
        return this.insert(I, Elt);
    }

    public final int.ptr insert(int.ptr I, int Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (int.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (int.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((int.iterator)I, (int.iterator)((int.iterator)this.end().$sub(1)), (int.iterator)this.end());
        I.$set(((Integer)Native.$tryAssign(null, (Object)Elt, (boolean)this.isDataPointerLike())).intValue());
        return I;
    }

    public final int.ptr insert(int.ptr I, int NumToInsert, int Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (int.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (int.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            int.ptr OldEnd = this.end();
            this.append_T((int.iterator<?>)((int.iterator)this.end().$sub(NumToInsert)), (int.iterator<?>)this.end());
            std.copy_backward((int.iterator)I, (int.iterator)((int.iterator)OldEnd.$sub(NumToInsert)), (int.iterator)OldEnd);
            std.fill_n((int.iterator)I, (int)NumToInsert, (int)Elt);
            return I;
        }
        int.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((int.iterator)I, (int.iterator)OldEnd, (int.iterator)((int.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((int.iterator)I, (int)NumOverwritten, (int)Elt);
        std.fill_n((int.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (int)Elt);
        return I;
    }

    public final int.ptr insert$T(int.ptr I, int.iterator<?> From, int.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final int.ptr insert$T$value_T(int.ptr I, int.iterator<?> From, int.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final int.ptr insert_iterator$T_T(int.ptr I, int.iterator<?> From, int.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final int.ptr insert(int.ptr I, int.iterator<?> From, int.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final int.ptr insert_iterator$T$value_T(int.ptr I, int.iterator<?> From, int.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (int.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (int.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            int.ptr OldEnd = this.end();
            this.append_T((int.iterator<?>)((int.iterator)this.end().$sub(NumToInsert)), (int.iterator<?>)this.end());
            std.copy_backward((int.iterator)I, (int.iterator)((int.iterator)OldEnd.$sub(NumToInsert)), (int.iterator)OldEnd);
            std.copy(From, To, (int.iterator)I);
            return I;
        }
        int.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((int.iterator)I, (int.iterator)OldEnd, (int.iterator)((int.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (int.iterator)Native.$Clone(From);
            int.ptr J = (int.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((int.iterator)From, To, (int.iterator)OldEnd);
        return I;
    }

    public final void append_T(int.iterator<?> in_start, int.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        int.iterator iter = (int.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Integer> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (Integer)converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(int[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(int[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            int el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, int Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, int Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, int Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplInt RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((int)this.array[i], (int)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplInt RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplInt)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplInt)obj).begin(), (Object)((SmallVectorImplInt)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplInt)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplInt)obj);
    }

    public final int.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_int$ref((int[])this.array, (int)idx);
    }

    public final int $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final int $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final int $set(int idx, int value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final int $set$move(int idx, int value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(int val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(int val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(int val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(int val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final int pop_back_val() {
        assert (this.checkAlive());
        int val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final int.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array);
    }

    public final int.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array);
    }

    public final int.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array, (int)this.end);
    }

    public final int.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorInt rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorInt((int.iterator)NativePointer.create_int$ptr((int[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorInt rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorInt((int.iterator)NativePointer.create_int$ptr((int[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorInt rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorInt((int.iterator)NativePointer.create_int$ptr((int[])this.array));
    }

    public final std.reverse_iteratorInt rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorInt((int.iterator)NativePointer.create_int$ptr((int[])this.array));
    }

    public final int.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array);
    }

    public final int.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array);
    }

    public final int front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final int front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final int back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final int back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final int.ref ref$front() {
        assert (this.checkAlive());
        return new int.ref(){
            private final int index = 0;

            public int $deref() {
                assert (SmallVectorImplInt.this.checkAlive());
                return SmallVectorImplInt.this.array[0];
            }

            public int $set(int value) {
                assert (SmallVectorImplInt.this.checkAlive());
                ((SmallVectorImplInt)SmallVectorImplInt.this).array[0] = value;
                return value;
            }

            public int.ptr deref$ptr() {
                assert (SmallVectorImplInt.this.checkAlive());
                return (int.ptr)SmallVectorImplInt.this.data().$add(0);
            }
        };
    }

    public final int.ref ref$back() {
        assert (this.checkAlive());
        return new int.ref(){
            private final int index;
            {
                this.index = SmallVectorImplInt.this.end - 1;
            }

            public int $deref() {
                assert (SmallVectorImplInt.this.checkAlive());
                return SmallVectorImplInt.this.array[this.index];
            }

            public int $set(int value) {
                assert (SmallVectorImplInt.this.checkAlive());
                ((SmallVectorImplInt)SmallVectorImplInt.this).array[this.index] = value;
                return value;
            }

            public int.ptr deref$ptr() {
                assert (SmallVectorImplInt.this.checkAlive());
                return (int.ptr)SmallVectorImplInt.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((int)this.defaultValue);
        for (int elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((int)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final int.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_int$ptr((int[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(int.ptr _from, int.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        int[] oldArray = this.array;
        this.array = NativePointer.new$int((int)capacity);
        NativePointer.copy$Object((int[])oldArray, (int)0, (int[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(int.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Integer> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorInt((int.iterator)this.begin(), (int.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplInt{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            int element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplInt}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

