/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapBaseUIntType;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.support.llvm;

public class SmallDenseMapUIntType<ValueT>
extends DenseMapBaseUIntType<SmallDenseMapUIntType<ValueT>, ValueT>
implements Native.assignable<SmallDenseMapUIntType<ValueT>>,
NativeMoveable<SmallDenseMapUIntType<ValueT>>,
Iterable<std_pair.pairUIntType<ValueT>>,
Destructors.ClassWithDestructor {
    private std_pair.pairUIntType<ValueT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;

    public SmallDenseMapUIntType(DenseMapInfoUInt keyInfo, ValueT defaultValue) {
        this(keyInfo, 0, defaultValue);
    }

    public SmallDenseMapUIntType(DenseMapInfoUInt keyInfo, int NumInitBuckets, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public SmallDenseMapUIntType(JavaDifferentiators.JD.Move INSTANCE, SmallDenseMapUIntType<ValueT> other) {
        super(other.keyInfoT, other.defaultValue);
        assert (other.checkAlive());
        this.init(0);
        this.swap(other);
    }

    public SmallDenseMapUIntType(SmallDenseMapUIntType<ValueT> other) {
        super(other.keyInfoT, other.defaultValue);
        assert (other.checkAlive());
        this.init(0);
        this.copyFrom(other);
    }

    public SmallDenseMapUIntType(DenseMapInfoUInt keyInfo, type.iterator<?, std_pair.pairUIntType<ValueT>> I, type.iterator<?, std_pair.pairUIntType<ValueT>> E, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        assert (this.checkAlive());
        this.destroyAll();
        this.set$destroyed();
    }

    public void swap(SmallDenseMapUIntType<ValueT> RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        std_pair.pairUIntType<ValueT>[] aBuckets = this.Buckets;
        this.Buckets = RHS.Buckets;
        RHS.Buckets = aBuckets;
        int aNumEntries = this.NumEntries;
        this.NumEntries = RHS.NumEntries;
        RHS.NumEntries = aNumEntries;
        int aNumTombstones = this.NumTombstones;
        this.NumTombstones = RHS.NumTombstones;
        RHS.NumTombstones = aNumTombstones;
        int aNumBuckets = this.NumBuckets;
        this.NumBuckets = RHS.NumBuckets;
        RHS.NumBuckets = aNumBuckets;
    }

    public SmallDenseMapUIntType<ValueT> $assign(SmallDenseMapUIntType<ValueT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(SmallDenseMapUIntType<ValueT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(int InitBuckets) {
        assert (this.checkAlive());
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(int AtLeast) {
        assert (this.checkAlive());
        int OldNumBuckets = this.NumBuckets;
        std_pair.pairUIntType<ValueT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)llvm.NextPowerOf2(AtLeast - 1)));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        assert (this.checkAlive());
        int OldNumEntries = this.NumEntries;
        this.destroyAll();
        int NewNumBuckets = 0;
        if (OldNumEntries != 0) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        assert (this.checkAlive());
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        assert (this.checkAlive());
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        assert (this.checkAlive());
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        assert (this.checkAlive());
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std_pair.pairUIntType<ValueT>> getBuckets() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std_pair.pairUIntType<ValueT>[] $Buckets() {
        assert (this.checkAlive());
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        assert (this.checkAlive());
        return this.NumBuckets;
    }

    private boolean allocateBuckets(int Num) {
        assert (this.checkAlive());
        this.NumBuckets = Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std_pair.pairUIntType[] bucketsArray = new std_pair.pairUIntType[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std_pair.pairUIntType();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    public String toString() {
        return "DenseMap{" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + ", Buckets=[\n" + this.BucketsToString(this.Buckets) + "\n]}";
    }

    @Override
    public Iterator<std_pair.pairUIntType<ValueT>> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(super.begin(), super.end());
    }

    public SmallDenseMapUIntType<ValueT> move() {
        assert (this.getClass() == SmallDenseMapUIntType.class) : "must be overridden in derived " + this.getClass();
        return new SmallDenseMapUIntType<ValueT>(JavaDifferentiators.JD.Move.INSTANCE, this);
    }
}

