/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.aliases.ImutAVLFactoryCharBoolChar;
import org.llvm.adt.aliases.ImutAVLTreeInOrderIteratorCharBoolChar;
import org.llvm.adt.aliases.ImutAVLTreeInfoCharBoolChar;

public class ImutAVLTreeCharBoolChar
extends NativeTrace.CreateDestroy$Tracker {
    private final ImutAVLTreeInfoCharBoolChar ImutInfo;
    private ImutAVLFactoryCharBoolChar factory;
    private ImutAVLTreeCharBoolChar left;
    private ImutAVLTreeCharBoolChar right;
    ImutAVLTreeCharBoolChar prev;
    ImutAVLTreeCharBoolChar next;
    private int height;
    private boolean IsMutable;
    private boolean IsDigestCached;
    boolean IsCanonicalized;
    byte value;
    private int digest;
    int refCount;

    public ImutAVLTreeCharBoolChar(ImutAVLTreeInfoCharBoolChar ImutInfo) {
        this.ImutInfo = ImutInfo;
    }

    public ImutAVLTreeCharBoolChar getLeft() {
        assert (this.checkAlive());
        return this.left;
    }

    public ImutAVLTreeCharBoolChar getRight() {
        assert (this.checkAlive());
        return this.right;
    }

    public int getHeight() {
        assert (this.checkAlive());
        return this.height;
    }

    public byte getValue() {
        assert (this.checkAlive());
        return this.value;
    }

    public ImutAVLTreeCharBoolChar find(byte $K) {
        assert (this.checkAlive());
        ImutAVLTreeCharBoolChar T4 = this;
        while (T4 != null) {
            byte CurrentKey = this.ImutInfo.KeyOfValue(T4.getValue());
            if (this.ImutInfo.isEqual($K, CurrentKey)) {
                return T4;
            }
            if (this.ImutInfo.isLess($K, CurrentKey)) {
                T4 = T4.getLeft();
                continue;
            }
            T4 = T4.getRight();
        }
        return null;
    }

    public ImutAVLTreeCharBoolChar getMaxElement() {
        assert (this.checkAlive());
        ImutAVLTreeCharBoolChar T4 = this;
        ImutAVLTreeCharBoolChar Right = T4.getRight();
        while (Right != null) {
            T4 = Right;
            Right = T4.getRight();
        }
        return T4;
    }

    public int size() {
        ImutAVLTreeCharBoolChar R2;
        assert (this.checkAlive());
        int n = 1;
        ImutAVLTreeCharBoolChar L = this.getLeft();
        if (L != null) {
            n += L.size();
        }
        if ((R2 = this.getRight()) != null) {
            n += R2.size();
        }
        return n;
    }

    public ImutAVLTreeInOrderIteratorCharBoolChar begin() {
        assert (this.checkAlive());
        return new ImutAVLTreeInOrderIteratorCharBoolChar(this);
    }

    public ImutAVLTreeInOrderIteratorCharBoolChar end() {
        assert (this.checkAlive());
        return new ImutAVLTreeInOrderIteratorCharBoolChar();
    }

    public boolean isElementEqual(byte V) {
        assert (this.checkAlive());
        if (Native.$not((boolean)this.ImutInfo.isEqual(this.ImutInfo.KeyOfValue(this.getValue()), this.ImutInfo.KeyOfValue(V)))) {
            return false;
        }
        return !Native.$not((boolean)this.ImutInfo.isDataEqual(this.ImutInfo.DataOfValue(this.getValue()), this.ImutInfo.DataOfValue(V)));
    }

    public boolean isElementEqual(ImutAVLTreeCharBoolChar RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        return this.isElementEqual(RHS.getValue());
    }

    public boolean isEqual(ImutAVLTreeCharBoolChar RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        if (RHS == this) {
            return true;
        }
        ImutAVLTreeInOrderIteratorCharBoolChar LItr = this.begin();
        ImutAVLTreeInOrderIteratorCharBoolChar LEnd = this.end();
        ImutAVLTreeInOrderIteratorCharBoolChar RItr = RHS.begin();
        ImutAVLTreeInOrderIteratorCharBoolChar REnd = RHS.end();
        while (Native.$bool((boolean)Native.$noteq_iter((abstract_iterator)LItr, (abstract_iterator)LEnd)) && Native.$bool((boolean)Native.$noteq_iter((abstract_iterator)RItr, (abstract_iterator)REnd))) {
            if (Native.$star((type.iterator)LItr) == Native.$star((type.iterator)RItr)) {
                LItr.skipSubTree();
                RItr.skipSubTree();
                continue;
            }
            if (Native.$not((boolean)LItr.$arrow().isElementEqual(RItr.$star()))) {
                return false;
            }
            LItr.$preInc();
            RItr.$preInc();
        }
        return Native.$bool((boolean)Native.$eq_iter((abstract_iterator)LItr, (abstract_iterator)LEnd)) && Native.$bool((boolean)Native.$eq_iter((abstract_iterator)RItr, (abstract_iterator)REnd));
    }

    public boolean isNotEqual(ImutAVLTreeCharBoolChar RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        return !this.isEqual(RHS);
    }

    public boolean contains(byte $K) {
        assert (this.checkAlive());
        return this.find($K) != null;
    }

    public void foreach(NativeCallback.Char2Void C2) {
        assert (this.checkAlive());
        ImutAVLTreeCharBoolChar L = this.getLeft();
        if (L != null) {
            L.foreach(C2);
        }
        C2.$call(this.value);
        ImutAVLTreeCharBoolChar R2 = this.getRight();
        if (R2 != null) {
            R2.foreach(C2);
        }
    }

    public int validateTree() {
        int HR;
        assert (this.checkAlive());
        int HL = this.getLeft() != null ? this.getLeft().validateTree() : 0;
        int n = HR = this.getRight() != null ? this.getRight().validateTree() : 0;
        assert (Native.$bool((boolean)Native.$eq((int)this.getHeight(), (int)((Unsigned.$greater_uint((int)HL, (int)HR) ? HL : HR) + 1)))) : "Height calculation wrong";
        assert (Unsigned.$lesseq_uint((int)(Unsigned.$greater_uint((int)HL, (int)HR) ? HL - HR : HR - HL), (int)2)) : "Balancing invariant violated";
        assert (Native.$bool((Native.$not((Object)((Object)this.getLeft())) || Native.$bool((boolean)this.ImutInfo.isLess(this.ImutInfo.KeyOfValue(this.getLeft().getValue()), this.ImutInfo.KeyOfValue(this.getValue()))) ? 1 : 0) != 0)) : "Value in left child is not less that current value";
        assert (Native.$bool((boolean)Native.$not((Native.$bool((Object)((Object)this.getRight())) || Native.$bool((boolean)this.ImutInfo.isLess(this.ImutInfo.KeyOfValue(this.getValue()), this.ImutInfo.KeyOfValue(this.getRight().getValue()))) ? 1 : 0) != 0))) : "Current value is not less that value of right child";
        return this.getHeight();
    }

    ImutAVLTreeCharBoolChar $ImutAVLTree(ImutAVLFactoryCharBoolChar f, ImutAVLTreeCharBoolChar l, ImutAVLTreeCharBoolChar r, byte v, int height) {
        this.factory = f;
        this.left = l;
        this.right = r;
        this.prev = null;
        this.next = null;
        this.height = height;
        this.IsMutable = true;
        this.IsDigestCached = false;
        this.IsCanonicalized = false;
        this.value = this.$cloneIfNeeded(v);
        this.digest = 0;
        this.refCount = 0;
        if (this.left != null) {
            this.left.retain();
        }
        if (this.right != null) {
            this.right.retain();
        }
        return this;
    }

    boolean isMutable() {
        assert (this.checkAlive());
        return this.IsMutable;
    }

    private boolean hasCachedDigest() {
        assert (this.checkAlive());
        return this.IsDigestCached;
    }

    void markImmutable() {
        assert (this.checkAlive());
        assert (Native.$bool((boolean)this.isMutable())) : "Mutable flag already removed.";
        this.IsMutable = false;
    }

    private void markedCachedDigest() {
        assert (this.checkAlive());
        assert (Native.$bool((boolean)Native.$not((boolean)this.hasCachedDigest()))) : "NoCachedDigest flag already removed.";
        this.IsDigestCached = true;
    }

    private void setHeight(int h) {
        assert (this.checkAlive());
        assert (Native.$bool((boolean)this.isMutable())) : "Only a mutable tree can have its height changed.";
        this.height = h;
    }

    private int computeDigest(ImutAVLTreeCharBoolChar L, ImutAVLTreeCharBoolChar R2, byte V) {
        assert (this.checkAlive());
        int digest = 0;
        if (L != null) {
            digest += L.computeDigest();
        }
        FoldingSetNodeID ID = new FoldingSetNodeID();
        this.ImutInfo.Profile(ID, V);
        digest += ID.ComputeHash();
        if (R2 != null) {
            digest += R2.computeDigest();
        }
        return digest;
    }

    int computeDigest() {
        int X2;
        assert (this.checkAlive());
        if (this.hasCachedDigest()) {
            return this.digest;
        }
        this.digest = X2 = this.computeDigest(this.getLeft(), this.getRight(), this.getValue());
        this.markedCachedDigest();
        return X2;
    }

    public void retain() {
        assert (this.checkAlive());
        ++this.refCount;
    }

    public void release() {
        assert (this.checkAlive());
        assert (Native.$bool((boolean)Native.$greater((int)this.refCount, (int)0))) : "Already released " + ((Object)((Object)this)).getClass();
        if (Native.$eq((int)(--this.refCount), (int)0)) {
            this.destroy();
        }
    }

    public void destroy() {
        assert (this.checkAlive());
        if (this.left != null) {
            this.left.release();
        }
        if (this.right != null) {
            this.right.release();
        }
        if (this.IsCanonicalized) {
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            } else {
                this.factory.Cache.$set(ImutAVLFactoryCharBoolChar.maskCacheIndex(this.computeDigest()), this.next);
            }
        }
        this.IsMutable = false;
        super.set$destroyed();
        this.factory.pushBackDestroyedNode(this);
    }

    private byte $cloneIfNeeded(byte V) {
        assert (this.checkAlive());
        return Native.$tryClone((byte)V);
    }

    public String toString() {
        return (super.is$destroyed() ? "DESTROYED " : "") + ", height=" + this.height + ", IsMutable=" + this.IsMutable + ", IsDigestCached=" + this.IsDigestCached + ", IsCanonicalized=" + this.IsCanonicalized + ", value=" + this.value + ", digest=" + this.digest + ", refCount=" + this.refCount;
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    protected final boolean is$Destroyed() {
        return this.is$destroyed();
    }

    final void reset$Destroyed() {
        assert (this.is$destroyed());
        super.clear$destroyed();
    }
}

