/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.float;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplFloat;
import org.llvm.support.llvm;

public class ArrayRefFloat
implements Iterable<Float>,
Native.NativePOD<ArrayRefFloat>,
Native.NativeIterable<float.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorFloat>,
NativeMoveable<ArrayRefFloat> {
    private static final ArrayRefFloat NONE;
    private float.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefFloat None() {
        return NONE;
    }

    public ArrayRefFloat move() {
        return new ArrayRefFloat(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefFloat() {
        this(false);
    }

    public ArrayRefFloat(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_float$ptr((float[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefFloat(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefFloat(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_float$ptr((float[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefFloat(float OneElt) {
        this(OneElt, false);
    }

    public ArrayRefFloat(float OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefFloat(/*const*/float$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefFloat(float OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_float$ptr((float[])NativePointer.new$float$elem((float)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefFloat(float[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefFloat(float[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_float$ptr((float[])data), length, isDataPointerLike);
    }

    public ArrayRefFloat(float.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefFloat(float.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefFloat(float.ptr begin, float.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefFloat(float.ptr begin, float.ptr end, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefFloat(SmallVectorImplFloat Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefFloat(SmallVectorImplFloat Vec, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefFloat(std.vectorFloat Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefFloat(std.vectorFloat Vec, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefFloat(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefFloat(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)((float.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefFloat(float[] Arr) {
        this(Arr, false);
    }

    public ArrayRefFloat(float[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_float$ptr((float[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefFloat(ArrayRefFloat other) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefFloat(JavaDifferentiators.JD.Convertible _param, ArrayRefFloat other, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefFloat(JavaDifferentiators.JD.Convertible _param, SmallVectorImplFloat Vec, boolean isDataPointerLike) {
        this.Data = (float.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefFloat(JavaDifferentiators.JD.Move _dparam, ArrayRefFloat other) {
        assert (other != NONE) : "use new ArrayRefFloat<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public float.ptr begin() {
        return this.Data;
    }

    public float.ptr end() {
        return this.Length == 0 ? this.Data : (float.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorFloat rbegin() {
        return new std.reverse_iteratorFloat((float.iterator)this.end());
    }

    public std.reverse_iteratorFloat rend() {
        return new std.reverse_iteratorFloat((float.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public float.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public float front() {
        return this.Data.$at(0);
    }

    public float back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefFloat copy(Class<Float> cls, NativeMemory.Allocator A) {
        float.ptr Buff = NativePointer.create_const_float$ptr((float[])NativePointer.new$float(cls, (int)this.Length));
        std.copy((float.iterator)this.begin(), (float.iterator)this.end(), (float.iterator)Buff);
        return new ArrayRefFloat(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefFloat RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        float.ptr L = (float.ptr)Native.$tryClone((NativeCloneable)this.begin());
        float.ptr LE = this.end();
        float.ptr R2 = (float.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((Object)Float.valueOf(L.$star()), (Object)Float.valueOf(R2.$star()), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefFloat slice(int N) {
        return new ArrayRefFloat((float.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefFloat slice(int N, int M) {
        return new ArrayRefFloat((float.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefFloat drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefFloat drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public float $at(int Index) {
        return this.Data.$at(Index);
    }

    public float $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public float.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public float.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (float.ptr)this.Data.$add(Index);
    }

    public float.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public float.ref ref$at(int Index) {
        return ((float.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorFloat vec() {
        return new std.vectorFloat((float.iterator)this.Data, (float.iterator)this.end(), 0.0f);
    }

    public std.vectorFloat $vector() {
        return new std.vectorFloat((float.iterator)this.Data, (float.iterator)this.end(), 0.0f);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((Object)Float.valueOf(this.$at(i)), (Object)Float.valueOf(Args[i].TPtr), (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefFloat $assign(ArrayRefFloat other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefFloat $assignMove(ArrayRefFloat other) {
        assert (other != NONE) : "use new ArrayRefFloat<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        float.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefFloat clone() {
        if (this.getClass() != ArrayRefFloat.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefFloat(this);
    }

    public boolean $eq(ArrayRefFloat other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Float> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefFloat obj;
        NONE = obj = new ArrayRefFloat(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Float> {
        private final float.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(float.ptr Data, int Length) {
            this.localData = (float.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Float next() {
            Float val = Float.valueOf(this.localData.$star());
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public float TPtr;

        public TRefOrNothing() {
            this.TPtr = 0.0f;
        }

        public TRefOrNothing(float TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

