/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.support.llvm;

public class ArrayRef<T>
implements Iterable<T>,
Native.NativePOD<ArrayRef<T>>,
Native.NativeIterable<type.ptr<T>>,
Native.NativeReverseIterable<std.reverse_iterator<T>>,
NativeMoveable<ArrayRef<T>> {
    private static final ArrayRef NONE;
    private type.ptr<T> Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static <T> ArrayRef<T> None() {
        return NONE;
    }

    public ArrayRef<T> move() {
        return new ArrayRef<T>(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRef() {
        this(false);
    }

    public ArrayRef(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_type$ptr((Object[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRef(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_type$ptr((Object[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(T OneElt) {
        this(OneElt, false);
    }

    public ArrayRef(T OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRef(/*const*/type$ptr<T> /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRef(T OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_type$ptr((Object[])Arrays.asList(OneElt).toArray());
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(T[] data, int length) {
        this(data, length, false);
    }

    public ArrayRef(T[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_type$ptr((Object[])data), length, isDataPointerLike);
    }

    public ArrayRef(type.ptr<T> data, int length) {
        this(data, length, false);
    }

    public ArrayRef(type.ptr<T> data, int length, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone(data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(type.ptr<T> begin, type.ptr<T> end) {
        this(begin, end, false);
    }

    public ArrayRef(type.ptr<T> begin, type.ptr<T> end, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone(begin);
        this.Length = std.distance(begin, end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRef(SmallVectorImplCommon<T> Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRef(SmallVectorImplCommon<T> Vec, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone(Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRef(std.vector<T> Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRef(std.vector<T> Vec, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRef(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRef(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRef(T[] Arr) {
        this(Arr, false);
    }

    public ArrayRef(T[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_type$ptr((Object[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(ArrayRef<T> other) {
        this.Data = (type.ptr)Native.$tryConstClone(other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRef(JavaDifferentiators.JD.Convertible _param, ArrayRef other, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone(other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRef(JavaDifferentiators.JD.Convertible _param, SmallVectorImplCommon<T> Vec, boolean isDataPointerLike) {
        this.Data = (type.ptr)Native.$tryConstClone(Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRef(JavaDifferentiators.JD.Move _dparam, ArrayRef<T> other) {
        assert (other != NONE) : "use new ArrayRef<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public type.ptr<T> begin() {
        return this.Data;
    }

    public type.ptr<T> end() {
        return this.Length == 0 ? this.Data : (type.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iterator<T> rbegin() {
        return new std.reverse_iterator(this.end());
    }

    public std.reverse_iterator<T> rend() {
        return new std.reverse_iterator(this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public type.ptr<T> data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public T front() {
        return (T)this.Data.$at(0);
    }

    public T back() {
        return (T)this.Data.$at(this.Length - 1);
    }

    public ArrayRef<T> copy(Class<T> cls, NativeMemory.Allocator A) {
        type.ptr Buff = NativePointer.create_const_type$ptr((Object[])NativePointer.new$T(cls, (int)this.Length));
        std.copy(this.begin(), this.end(), (type.iterator)Buff, (boolean)this.isDataPointerLike);
        return new ArrayRef<T>(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRef<T> RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        type.ptr L = (type.ptr)Native.$tryClone(this.begin());
        type.ptr<T> LE = this.end();
        type.ptr R2 = (type.ptr)Native.$tryClone(RHS.begin());
        while (L.$noteq(LE)) {
            if (!Native.$eq((Object)L.$star(), (Object)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRef<T> slice(int N) {
        return new ArrayRef<T>((type.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRef<T> slice(int N, int M) {
        return new ArrayRef<T>((type.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRef<T> drop_back() {
        return this.drop_back(1);
    }

    public ArrayRef<T> drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public T $at(int Index) {
        return (T)this.Data.$at(Index);
    }

    public T $at(uint.ref Index) {
        return (T)this.Data.$at(Index.$deref());
    }

    public type.ptr<T> ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public type.ptr<T> ptr$at(int Index) {
        return Index == 0 ? this.Data : (type.ptr)this.Data.$add(Index);
    }

    public type.ref<T> ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public type.ref<T> ref$at(int Index) {
        return ((type.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vector<T> vec() {
        return new std.vector(this.Data, this.end(), null);
    }

    public std.vector<T> $vector() {
        return new std.vector(this.Data, this.end(), null);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq(this.$at(i), (Object)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRef<T> $assign(ArrayRef<T> other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRef<T> $assignMove(ArrayRef<T> other) {
        assert (other != NONE) : "use new ArrayRef<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        type.ptr<T> DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRef<T> clone() {
        if (this.getClass() != ArrayRef.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRef<T>(this);
    }

    public boolean $eq(ArrayRef<T> other) {
        return this.equals(other);
    }

    @Override
    public Iterator<T> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator<T>(this.Data, this.Length);
    }

    static {
        ArrayRef obj;
        NONE = obj = new ArrayRef(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator<T>
    implements Iterator<T> {
        private final type.ptr<T> localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(type.ptr<T> Data, int Length) {
            this.localData = (type.ptr)Native.$tryClone(Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public T next() {
            Object val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return (T)val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public Object TPtr;

        public TRefOrNothing() {
            this.TPtr = null;
        }

        public TRefOrNothing(Object TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

