/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Unsigned;
import org.llvm.adt.DenseMapInfo;

public class DenseMapInfoPairPtrType<T, U>
implements DenseMapInfo<std_pair.pairPtrType<T, U>> {
    private final DenseMapInfo<T> FirstInfo;
    private final DenseMapInfo<U> SecondInfo;
    private final std_pair.pairPtrType emptyKey;
    private final std_pair.pairPtrType tombstoneKey;

    public DenseMapInfoPairPtrType(DenseMapInfo<T> FirstInfo, DenseMapInfo<U> SecondInfo) {
        this.FirstInfo = FirstInfo;
        this.SecondInfo = SecondInfo;
        this.emptyKey = std.make_pair_Ptr_T((Object)FirstInfo.getEmptyKey(), (Object)SecondInfo.getEmptyKey());
        this.tombstoneKey = std.make_pair_Ptr_T((Object)FirstInfo.getTombstoneKey(), (Object)SecondInfo.getTombstoneKey());
        assert (this.emptyKey.first != null && this.emptyKey.second != null) : "emptyKey marker must not have nulls";
        assert (this.tombstoneKey.first != null && this.tombstoneKey.second != null) : "tombstoneKey marker must not have nulls";
        assert (this.tombstoneKey.first != this.emptyKey.first || this.tombstoneKey.second != this.emptyKey.second) : "emptyKey [" + this.emptyKey + "] must be different from tombstoneKey [" + this.tombstoneKey + "]";
    }

    @Override
    public Object getEmptyKey() {
        return this.emptyKey;
    }

    @Override
    public Object getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public int getHashValue(std_pair.pairPtrType<T, U> PairVal) {
        assert (PairVal != this.emptyKey) : "must not be called for emptyKey";
        assert (PairVal != this.tombstoneKey) : "must not be called for tombstoneKey";
        return DenseMapInfoPairPtrType.combineTwoHashes(this.FirstInfo.getHashValue(PairVal.first), this.SecondInfo.getHashValue(PairVal.second));
    }

    public static int combineTwoHashes(int firstHash, int secondHash) {
        long key = (long)firstHash << 32 | Unsigned.$uint2ulong((int)secondHash);
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 8;
        key += key << 3;
        key ^= key >>> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 31;
        return (int)key;
    }

    @Override
    public boolean isEqual(std_pair.pairPtrType<T, U> LHS, std_pair.pairPtrType<T, U> RHS) {
        assert (LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        assert (RHS != this.emptyKey) : "RHS: must not be called for emptyKey";
        assert (RHS != this.tombstoneKey) : "RHS: must not be called for tombstoneKey";
        return this.FirstInfo.isEqual(LHS.first, RHS.first) && this.SecondInfo.isEqual(LHS.second, RHS.second);
    }

    @Override
    public boolean isKeyPointerLike() {
        return false;
    }
}

