/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.ulong;
import org.clank.support.ulong;
import org.clank.support.void;
import org.llvm.adt.APInt;
import org.llvm.adt.APSInt;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefULong;
import org.llvm.adt.aliases.SmallVectorULong;
import org.llvm.adt.lostFraction;
import org.llvm.support.fltSemantics;
import org.llvm.support.impl.APFloatStatics;
import org.llvm.support.impl.decimalInfo;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class APFloat
implements FoldingSetTrait.Profilable,
NativeMoveable<APFloat>,
Destructors.ClassWithDestructor,
Native.NativeComparable<APFloat> {
    public static fltSemantics IEEEhalf = new fltSemantics(15, -14, 11, 16);
    public static fltSemantics IEEEsingle = new fltSemantics(127, -126, 24, 32);
    public static fltSemantics IEEEdouble = new fltSemantics(1023, -1022, 53, 64);
    public static fltSemantics IEEEquad = new fltSemantics(16383, -16382, 113, 128);
    public static fltSemantics PPCDoubleDouble = new fltSemantics(1023, -969, 106, 128);
    public static fltSemantics x87DoubleExtended = new fltSemantics(16383, -16382, 64, 80);
    public static fltSemantics Bogus = new fltSemantics(0, 0, 0, 0);
    private static final int fcInfinity = 0;
    private static final int fcNaN = 1;
    private static final int fcNormal = 2;
    private static final int fcZero = 3;
    public fltSemantics semantics;
    private Significand significand;
    public short exponent;
    public fltCategory category;
    public boolean sign;

    public static int semanticsPrecision(fltSemantics semantics) {
        return semantics.precision;
    }

    public static short semanticsMinExponent(fltSemantics semantics) {
        return semantics.minExponent;
    }

    public static short semanticsMaxExponent(fltSemantics semantics) {
        return semantics.maxExponent;
    }

    public static int semanticsSizeInBits(fltSemantics semantics) {
        return semantics.sizeInBits;
    }

    public APFloat(fltSemantics ourSemantics) {
        this.significand = new Significand();
        this.initialize((fltSemantics)Native.$AddrOf((Object)ourSemantics));
        this.category = fltCategory.fcZero;
        this.sign = false;
    }

    public APFloat(fltSemantics ourSemantics, StringRef text) {
        this.significand = new Significand();
        this.initialize((fltSemantics)Native.$AddrOf((Object)ourSemantics));
        this.convertFromString(text, roundingMode.rmNearestTiesToEven);
    }

    public APFloat(fltSemantics ourSemantics, long value) {
        this.significand = new Significand();
        this.initialize((fltSemantics)Native.$AddrOf((Object)ourSemantics));
        this.sign = false;
        this.category = fltCategory.fcNormal;
        this.zeroSignificand();
        this.exponent = Unsigned.$uint2short((int)(ourSemantics.precision - 1));
        this.significandParts().$set(0, value);
        this.normalize(roundingMode.rmNearestTiesToEven, lostFraction.lfExactlyZero);
    }

    public APFloat(fltSemantics ourSemantics, uninitializedTag tag) {
        this.significand = new Significand();
        this.initialize((fltSemantics)Native.$AddrOf((Object)ourSemantics));
    }

    public APFloat(fltSemantics Sem, APInt API) {
        this.significand = new Significand();
        this.initFromAPInt((fltSemantics)Native.$AddrOf((Object)Sem), API);
    }

    public APFloat(double d) {
        this.significand = new Significand();
        this.initFromAPInt((fltSemantics)Native.$AddrOf((Object)IEEEdouble), APInt.doubleToBits(d));
    }

    public APFloat(float f) {
        this.significand = new Significand();
        this.initFromAPInt((fltSemantics)Native.$AddrOf((Object)IEEEsingle), APInt.floatToBits(f));
    }

    public APFloat(APFloat rhs) {
        this.significand = new Significand();
        this.initialize(rhs.semantics);
        this.assign(rhs);
    }

    public APFloat(JavaDifferentiators.JD.Move _dparam, APFloat rhs) {
        this.semantics = (fltSemantics)Native.$AddrOf((Object)Bogus);
        this.significand = new Significand();
        this.$assignMove((APFloat)std.move((Object)rhs));
    }

    public void $destroy() {
        this.freeSignificand();
    }

    public boolean needsCleanup() {
        return Unsigned.$greater_uint((int)this.partCount(), (int)1);
    }

    public static APFloat getZero(fltSemantics Sem) {
        return APFloat.getZero(Sem, false);
    }

    public static APFloat getZero(fltSemantics Sem, boolean Negative) {
        APFloat Val = new APFloat(Sem, uninitializedTag.uninitialized);
        Val.makeZero(Negative);
        return Val;
    }

    public static APFloat getInf(fltSemantics Sem) {
        return APFloat.getInf(Sem, false);
    }

    public static APFloat getInf(fltSemantics Sem, boolean Negative) {
        APFloat Val = new APFloat(Sem, uninitializedTag.uninitialized);
        Val.makeInf(Negative);
        return Val;
    }

    public static APFloat getNaN(fltSemantics Sem) {
        return APFloat.getNaN(Sem, false, 0);
    }

    public static APFloat getNaN(fltSemantics Sem, boolean Negative) {
        return APFloat.getNaN(Sem, Negative, 0);
    }

    public static APFloat getNaN(fltSemantics Sem, boolean Negative, int type2) {
        if (type2 != 0) {
            APInt fill = new APInt(64, Unsigned.$uint2ulong((int)type2));
            return APFloat.getQNaN(Sem, Negative, (APInt)Native.$AddrOf(fill));
        }
        return APFloat.getQNaN(Sem, Negative, null);
    }

    public static APFloat getQNaN(fltSemantics Sem) {
        return APFloat.getQNaN(Sem, false, null);
    }

    public static APFloat getQNaN(fltSemantics Sem, boolean Negative) {
        return APFloat.getQNaN(Sem, Negative, null);
    }

    public static APFloat getQNaN(fltSemantics Sem, boolean Negative, APInt payload) {
        return APFloat.makeNaN(Sem, false, Negative, payload);
    }

    public static APFloat getSNaN(fltSemantics Sem) {
        return APFloat.getSNaN(Sem, false, null);
    }

    public static APFloat getSNaN(fltSemantics Sem, boolean Negative) {
        return APFloat.getSNaN(Sem, Negative, null);
    }

    public static APFloat getSNaN(fltSemantics Sem, boolean Negative, APInt payload) {
        return APFloat.makeNaN(Sem, true, Negative, payload);
    }

    public static APFloat getLargest(fltSemantics Sem) {
        return APFloat.getLargest(Sem, false);
    }

    public static APFloat getLargest(fltSemantics Sem, boolean Negative) {
        APFloat Val = new APFloat(Sem, uninitializedTag.uninitialized);
        Val.makeLargest(Negative);
        return Val;
    }

    public static APFloat getSmallest(fltSemantics Sem) {
        return APFloat.getSmallest(Sem, false);
    }

    public static APFloat getSmallest(fltSemantics Sem, boolean Negative) {
        APFloat Val = new APFloat(Sem, uninitializedTag.uninitialized);
        Val.makeSmallest(Negative);
        return Val;
    }

    public static APFloat getSmallestNormalized(fltSemantics Sem) {
        return APFloat.getSmallestNormalized(Sem, false);
    }

    public static APFloat getSmallestNormalized(fltSemantics Sem, boolean Negative) {
        APFloat Val = new APFloat(Sem, uninitializedTag.uninitialized);
        Val.category = fltCategory.fcNormal;
        Val.zeroSignificand();
        Val.sign = Negative;
        Val.exponent = Sem.minExponent;
        Val.significandParts().$set$orassign(APFloatStatics.partCountForBits(Sem.precision) - 1, Unsigned.$int2ulong((int)1) << Unsigned.$rem_uint((int)(Sem.precision - 1), (int)llvm.integerPartWidth));
        return Val;
    }

    public static APFloat getAllOnesValue(int BitWidth) {
        return APFloat.getAllOnesValue(BitWidth, false);
    }

    public static APFloat getAllOnesValue(int BitWidth, boolean isIEEE) {
        switch (BitWidth) {
            case 16: {
                return new APFloat(IEEEhalf, APInt.getAllOnesValue(BitWidth));
            }
            case 32: {
                return new APFloat(IEEEsingle, APInt.getAllOnesValue(BitWidth));
            }
            case 64: {
                return new APFloat(IEEEdouble, APInt.getAllOnesValue(BitWidth));
            }
            case 80: {
                return new APFloat(x87DoubleExtended, APInt.getAllOnesValue(BitWidth));
            }
            case 128: {
                if (isIEEE) {
                    return new APFloat(IEEEquad, APInt.getAllOnesValue(BitWidth));
                }
                return new APFloat(PPCDoubleDouble, APInt.getAllOnesValue(BitWidth));
            }
        }
        throw new llvm_unreachable("Unknown floating bit width");
    }

    public static int getSizeInBits(fltSemantics Sem) {
        return Sem.sizeInBits;
    }

    @Override
    public void Profile(FoldingSetNodeID ID) {
        ID.Add(this.bitcastToAPInt());
    }

    public int add(APFloat rhs, roundingMode rounding_mode) {
        return this.addOrSubtract(rhs, rounding_mode, false);
    }

    public int subtract(APFloat rhs, roundingMode rounding_mode) {
        return this.addOrSubtract(rhs, rounding_mode, true);
    }

    public int multiply(APFloat rhs, roundingMode rounding_mode) {
        this.sign ^= rhs.sign;
        int fs2 = this.multiplySpecials(rhs);
        if (this.isFiniteNonZero()) {
            lostFraction lost_fraction = this.multiplySignificand(rhs, null);
            fs2 = this.normalize(rounding_mode, lost_fraction);
            if (lost_fraction != lostFraction.lfExactlyZero) {
                fs2 |= 0x10;
            }
        }
        return fs2;
    }

    public int divide(APFloat rhs, roundingMode rounding_mode) {
        this.sign ^= rhs.sign;
        int fs2 = this.divideSpecials(rhs);
        if (this.isFiniteNonZero()) {
            lostFraction lost_fraction = this.divideSignificand(rhs);
            fs2 = this.normalize(rounding_mode, lost_fraction);
            if (lost_fraction != lostFraction.lfExactlyZero) {
                fs2 |= 0x10;
            }
        }
        return fs2;
    }

    public int remainder(APFloat rhs) {
        bool.ptr ignored;
        APFloat V = new APFloat(this);
        int origSign = Unsigned.$bool2uint((boolean)this.sign);
        int fs2 = V.divide(rhs, roundingMode.rmNearestTiesToEven);
        if (fs2 == 2) {
            return fs2;
        }
        int parts = this.partCount();
        ulong.ptr x = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)parts));
        fs2 = V.convertToInteger(x, parts * llvm.integerPartWidth, true, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)(ignored = NativePointer.create_bool$ptr())));
        if (fs2 == 1) {
            return fs2;
        }
        fs2 = V.convertFromZeroExtendedInteger(x, parts * llvm.integerPartWidth, true, roundingMode.rmNearestTiesToEven);
        assert (fs2 == 0);
        fs2 = V.multiply(rhs, roundingMode.rmNearestTiesToEven);
        assert (fs2 == 0 || fs2 == 16);
        fs2 = this.subtract(V, roundingMode.rmNearestTiesToEven);
        assert (fs2 == 0 || fs2 == 16);
        if (this.isZero()) {
            this.sign = Unsigned.$uint2uint_1bit((int)origSign);
        }
        Destructors.$destroyArray((Object)x);
        return fs2;
    }

    public int mod(APFloat rhs) {
        int fs2 = this.modSpecials(rhs);
        if (this.isFiniteNonZero() && rhs.isFiniteNonZero()) {
            bool.ptr ignored;
            APFloat V = new APFloat(this);
            int origSign = Unsigned.$bool2uint((boolean)this.sign);
            fs2 = V.divide(rhs, roundingMode.rmNearestTiesToEven);
            if (fs2 == 2) {
                return fs2;
            }
            int parts = this.partCount();
            ulong.ptr x = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)parts));
            fs2 = V.convertToInteger(x, parts * llvm.integerPartWidth, true, roundingMode.rmTowardZero, (bool.ptr)Native.$AddrOf((Object)(ignored = NativePointer.create_bool$ptr())));
            if (fs2 == 1) {
                return fs2;
            }
            fs2 = V.convertFromZeroExtendedInteger(x, parts * llvm.integerPartWidth, true, roundingMode.rmNearestTiesToEven);
            assert (fs2 == 0);
            fs2 = V.multiply(rhs, roundingMode.rmNearestTiesToEven);
            assert (fs2 == 0 || fs2 == 16);
            fs2 = this.subtract(V, roundingMode.rmNearestTiesToEven);
            assert (fs2 == 0 || fs2 == 16);
            if (this.isZero()) {
                this.sign = Unsigned.$uint2uint_1bit((int)origSign);
            }
            Destructors.$destroyArray((Object)x);
        }
        return fs2;
    }

    public int fusedMultiplyAdd(APFloat multiplicand, APFloat addend, roundingMode rounding_mode) {
        int fs2;
        this.sign ^= multiplicand.sign;
        if (this.isFiniteNonZero() && multiplicand.isFiniteNonZero() && addend.isFinite()) {
            lostFraction lost_fraction = this.multiplySignificand(multiplicand, (APFloat)Native.$AddrOf((Object)addend));
            fs2 = this.normalize(rounding_mode, lost_fraction);
            if (lost_fraction != lostFraction.lfExactlyZero) {
                fs2 |= 0x10;
            }
            if (this.category == fltCategory.fcZero && (fs2 & 8) == 0 && this.sign != addend.sign) {
                this.sign = rounding_mode == roundingMode.rmTowardNegative;
            }
        } else {
            fs2 = this.multiplySpecials(multiplicand);
            if (fs2 == 0) {
                fs2 = this.addOrSubtract(addend, rounding_mode, false);
            }
        }
        return fs2;
    }

    public int roundToIntegral(roundingMode rounding_mode) {
        if (this.isFiniteNonZero() && this.exponent + 1 >= APFloat.semanticsPrecision((fltSemantics)Native.$Deref((Object)this.semantics))) {
            return 0;
        }
        APInt IntegerConstant = new APInt(Unsigned.$ulong2uint((long)llvm.NextPowerOf2(Unsigned.$uint2ulong((int)APFloat.semanticsPrecision((fltSemantics)Native.$Deref((Object)this.semantics))))), Unsigned.$int2ulong((int)1));
        IntegerConstant.$lshiftassign(APFloat.semanticsPrecision((fltSemantics)Native.$Deref((Object)this.semantics)) - 1);
        APFloat MagicConstant = new APFloat((fltSemantics)Native.$Deref((Object)this.semantics));
        int fs2 = MagicConstant.convertFromAPInt(IntegerConstant, false, roundingMode.rmNearestTiesToEven);
        MagicConstant.copySign(this);
        if (fs2 != 0) {
            return fs2;
        }
        boolean inputSign = this.isNegative();
        fs2 = this.add(MagicConstant, rounding_mode);
        if (fs2 != 0 && fs2 != 16) {
            return fs2;
        }
        fs2 = this.subtract(MagicConstant, rounding_mode);
        if (inputSign != this.isNegative()) {
            this.changeSign();
        }
        return fs2;
    }

    public int next(boolean nextDown) {
        if (nextDown) {
            this.changeSign();
        }
        int result = 0;
        switch (this.category) {
            case fcInfinity: {
                if (!this.isNegative()) break;
                this.makeLargest(true);
                break;
            }
            case fcNaN: {
                if (!this.isSignaling()) break;
                result = 1;
                this.makeNaN(false, this.isNegative(), null);
                break;
            }
            case fcZero: {
                this.makeSmallest(false);
                break;
            }
            case fcNormal: {
                boolean WillCrossBinadeBoundary;
                if (this.isSmallest() && this.isNegative()) {
                    APInt.tcSet(this.significandParts(), Unsigned.$int2ulong((int)0), this.partCount());
                    this.category = fltCategory.fcZero;
                    this.exponent = 0;
                    break;
                }
                if (this.isLargest() && !this.isNegative()) {
                    APInt.tcSet(this.significandParts(), Unsigned.$int2ulong((int)0), this.partCount());
                    this.category = fltCategory.fcInfinity;
                    this.exponent = Unsigned.$uint2short((int)(Unsigned.$short2uint((short)this.semantics.maxExponent) + 1));
                    break;
                }
                if (this.isNegative()) {
                    boolean WillCrossBinadeBoundary2 = this.exponent != this.semantics.minExponent && this.isSignificandAllZeros();
                    ulong.ptr Parts = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
                    APInt.tcDecrement(Parts, this.partCount());
                    if (!WillCrossBinadeBoundary2) break;
                    APInt.tcSetBit(Parts, this.semantics.precision - 1);
                    this.exponent = (short)(this.exponent - 1);
                    break;
                }
                boolean bl = WillCrossBinadeBoundary = !this.isDenormal() && this.isSignificandAllOnes();
                if (WillCrossBinadeBoundary) {
                    ulong.ptr Parts = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
                    APInt.tcSet(Parts, Unsigned.$int2ulong((int)0), this.partCount());
                    APInt.tcSetBit(Parts, this.semantics.precision - 1);
                    assert (this.exponent != this.semantics.maxExponent) : "We can not increment an exponent beyond the maxExponent allowed by the given floating point semantics.";
                    this.exponent = (short)(this.exponent + 1);
                    break;
                }
                this.incrementSignificand();
            }
        }
        if (nextDown) {
            this.changeSign();
        }
        return result;
    }

    public APFloat $add(APFloat RHS) {
        APFloat Result = new APFloat(this);
        Result.add(RHS, roundingMode.rmNearestTiesToEven);
        return Result;
    }

    public APFloat $sub(APFloat RHS) {
        APFloat Result = new APFloat(this);
        Result.subtract(RHS, roundingMode.rmNearestTiesToEven);
        return Result;
    }

    public APFloat $star(APFloat RHS) {
        APFloat Result = new APFloat(this);
        Result.multiply(RHS, roundingMode.rmNearestTiesToEven);
        return Result;
    }

    public APFloat $slash(APFloat RHS) {
        APFloat Result = new APFloat(this);
        Result.divide(RHS, roundingMode.rmNearestTiesToEven);
        return Result;
    }

    public void changeSign() {
        this.sign = !this.sign;
    }

    public void clearSign() {
        this.sign = false;
    }

    public void copySign(APFloat rhs) {
        this.sign = rhs.sign;
    }

    public static APFloat copySign(APFloat Value, APFloat Sign) {
        Value.copySign(Sign);
        return new APFloat(JavaDifferentiators.JD.Move.INSTANCE, Value);
    }

    public int convert(fltSemantics toSemantics, roundingMode rounding_mode, bool.ptr losesInfo) {
        int fs2;
        fltSemantics fromSemantics = (fltSemantics)Native.$Deref((Object)this.semantics);
        lostFraction $lostFraction = lostFraction.lfExactlyZero;
        int newPartCount = APFloatStatics.partCountForBits(toSemantics.precision + 1);
        int oldPartCount = this.partCount();
        int shift = toSemantics.precision - fromSemantics.precision;
        boolean X86SpecialNan = false;
        if (Native.$AddrOf((Object)fromSemantics) == Native.$AddrOf((Object)x87DoubleExtended) && Native.$AddrOf((Object)toSemantics) != Native.$AddrOf((Object)x87DoubleExtended) && this.category == fltCategory.fcNaN && ((this.significandParts().$star() & Long.MIN_VALUE) == 0L || (this.significandParts().$star() & 0x4000000000000000L) == 0L)) {
            X86SpecialNan = true;
        }
        if (shift < 0 && this.isFiniteNonZero()) {
            int exponentChange = this.significandMSB() + 1 - fromSemantics.precision;
            if (this.exponent + exponentChange < toSemantics.minExponent) {
                exponentChange = toSemantics.minExponent - this.exponent;
            }
            if (exponentChange < shift) {
                exponentChange = shift;
            }
            if (exponentChange < 0) {
                shift -= exponentChange;
                this.exponent = (short)(this.exponent + exponentChange);
            }
        }
        if (shift < 0 && (this.isFiniteNonZero() || this.category == fltCategory.fcNaN)) {
            $lostFraction = APFloatStatics.shiftRight(this.significandParts(), oldPartCount, -shift);
        }
        if (Unsigned.$greater_uint((int)newPartCount, (int)oldPartCount)) {
            ulong.ptr newParts = NativePointer.create_ulong$ptr();
            newParts = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)newPartCount));
            APInt.tcSet(newParts, Unsigned.$int2ulong((int)0), newPartCount);
            if (this.isFiniteNonZero() || this.category == fltCategory.fcNaN) {
                APInt.tcAssign(newParts, this.significandParts(), oldPartCount);
            }
            this.freeSignificand();
            this.significand.parts = (ulong.ptr)Native.$tryClone((NativeCloneable)newParts);
        } else if (newPartCount == 1 && oldPartCount != 1) {
            long newPart = Unsigned.$int2ulong((int)0);
            if (this.isFiniteNonZero() || this.category == fltCategory.fcNaN) {
                newPart = this.significandParts().$at(0);
            }
            this.freeSignificand();
            this.significand.part = newPart;
        }
        this.semantics = (fltSemantics)Native.$AddrOf((Object)toSemantics);
        if (shift > 0 && (this.isFiniteNonZero() || this.category == fltCategory.fcNaN)) {
            APInt.tcShiftLeft(this.significandParts(), newPartCount, shift);
        }
        if (this.isFiniteNonZero()) {
            fs2 = this.normalize(rounding_mode, $lostFraction);
            losesInfo.$set(fs2 != 0);
        } else if (this.category == fltCategory.fcNaN) {
            losesInfo.$set($lostFraction != lostFraction.lfExactlyZero || X86SpecialNan);
            if (!X86SpecialNan && this.semantics == Native.$AddrOf((Object)x87DoubleExtended)) {
                APInt.tcSetBit(this.significandParts(), this.semantics.precision - 1);
            }
            fs2 = 0;
        } else {
            losesInfo.$set(false);
            fs2 = 0;
        }
        return fs2;
    }

    public int convertToInteger(ulong.ptr parts, int width, boolean isSigned, roundingMode rounding_mode, bool.ptr isExact) {
        int fs2 = this.convertToSignExtendedInteger(parts, width, isSigned, rounding_mode, isExact);
        if (fs2 == 1) {
            int dstPartsCount = APFloatStatics.partCountForBits(width);
            int bits = this.category == fltCategory.fcNaN ? 0 : (this.sign ? (isSigned ? 1 : 0) : width - (isSigned ? 1 : 0));
            APInt.tcSetLeastSignificantBits(parts, dstPartsCount, bits);
            if (this.sign && isSigned) {
                APInt.tcShiftLeft(parts, dstPartsCount, width - 1);
            }
        }
        return fs2;
    }

    public int convertToInteger(APSInt result, roundingMode rounding_mode, bool.ptr isExact) {
        int bitWidth = result.getBitWidth();
        SmallVectorULong parts = new SmallVectorULong(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 4, result.getNumWords(), 0L);
        int status = this.convertToInteger(parts.data(), bitWidth, result.isSigned(), rounding_mode, isExact);
        result.$assign(new APInt(bitWidth, new ArrayRefULong(parts)));
        return status;
    }

    public int convertFromAPInt(APInt Val, boolean isSigned, roundingMode rounding_mode) {
        int partCount = Val.getNumWords();
        APInt api = new APInt(Val);
        this.sign = false;
        if (isSigned && api.isNegative()) {
            this.sign = true;
            api.$assignMove(api.$sub());
        }
        return this.convertFromUnsignedParts(api.getRawData(), partCount, rounding_mode);
    }

    public int convertFromSignExtendedInteger(ulong.ptr src, int srcCount, boolean isSigned, roundingMode rounding_mode) {
        int status;
        if (isSigned && APInt.tcExtractBit(src, srcCount * llvm.integerPartWidth - 1) != 0) {
            ulong.ptr copy = NativePointer.create_ulong$ptr();
            this.sign = true;
            copy = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)srcCount));
            APInt.tcAssign(copy, src, srcCount);
            APInt.tcNegate(copy, srcCount);
            status = this.convertFromUnsignedParts(copy, srcCount, rounding_mode);
            Destructors.$destroyArray((Object)copy);
        } else {
            this.sign = false;
            status = this.convertFromUnsignedParts(src, srcCount, rounding_mode);
        }
        return status;
    }

    public int convertFromZeroExtendedInteger(ulong.ptr parts, int width, boolean isSigned, roundingMode rounding_mode) {
        int partCount = APFloatStatics.partCountForBits(width);
        APInt api = new APInt(width, llvm.makeArrayRef(parts, partCount));
        this.sign = false;
        if (isSigned && APInt.tcExtractBit(parts, width - 1) != 0) {
            this.sign = true;
            api.$assignMove(api.$sub());
        }
        return this.convertFromUnsignedParts(api.getRawData(), partCount, rounding_mode);
    }

    public int convertFromString(StringRef str, roundingMode rounding_mode) {
        assert (!str.empty()) : "Invalid string length";
        if (this.convertFromStringSpecials(new StringRef(str))) {
            return 0;
        }
        char.ptr p = Native.$tryClone((char.ptr)str.begin());
        int slen = str.size();
        this.sign = Unsigned.$uint2uint_1bit((int)(p.$star() == 45 ? 1 : 0));
        if (p.$star() == 45 || p.$star() == 43) {
            p.$postInc();
            assert (--slen != 0) : "String has no digits";
        }
        if (Unsigned.$greatereq_uint((int)slen, (int)2) && p.$at(0) == 48 && (p.$at(1) == 120 || p.$at(1) == 88)) {
            assert (slen - 2 != 0) : "Invalid string";
            return this.convertFromHexadecimalString(new StringRef((char.ptr)p.$add(2), slen - 2), rounding_mode);
        }
        return this.convertFromDecimalString(new StringRef(p, slen), rounding_mode);
    }

    public APInt bitcastToAPInt() {
        if (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEhalf)) {
            return this.convertHalfAPFloatToAPInt();
        }
        if (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEsingle)) {
            return this.convertFloatAPFloatToAPInt();
        }
        if (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEdouble)) {
            return this.convertDoubleAPFloatToAPInt();
        }
        if (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEquad)) {
            return this.convertQuadrupleAPFloatToAPInt();
        }
        if (this.semantics == (fltSemantics)Native.$AddrOf((Object)PPCDoubleDouble)) {
            return this.convertPPCDoubleDoubleAPFloatToAPInt();
        }
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)x87DoubleExtended)) : "unknown format!";
        return this.convertF80LongDoubleAPFloatToAPInt();
    }

    public double convertToDouble() {
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEdouble)) : "Float semantics are not IEEEdouble";
        APInt api = this.bitcastToAPInt();
        return api.bitsToDouble();
    }

    public float convertToFloat() {
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEsingle)) : "Float semantics are not IEEEsingle";
        APInt api = this.bitcastToAPInt();
        return api.bitsToFloat();
    }

    public boolean $eq(APFloat $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public cmpResult compare(APFloat rhs) {
        cmpResult result;
        assert (this.semantics == rhs.semantics);
        switch (this.category.getValue() * 4 + rhs.category.getValue()) {
            default: {
                throw new llvm_unreachable(null);
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                return cmpResult.cmpUnordered;
            }
            case 2: 
            case 3: 
            case 11: {
                if (this.sign) {
                    return cmpResult.cmpLessThan;
                }
                return cmpResult.cmpGreaterThan;
            }
            case 8: 
            case 12: 
            case 14: {
                if (rhs.sign) {
                    return cmpResult.cmpGreaterThan;
                }
                return cmpResult.cmpLessThan;
            }
            case 0: {
                if (this.sign == rhs.sign) {
                    return cmpResult.cmpEqual;
                }
                if (this.sign) {
                    return cmpResult.cmpLessThan;
                }
                return cmpResult.cmpGreaterThan;
            }
            case 15: {
                return cmpResult.cmpEqual;
            }
            case 10: 
        }
        if (this.sign != rhs.sign) {
            result = this.sign ? cmpResult.cmpLessThan : cmpResult.cmpGreaterThan;
        } else {
            result = this.compareAbsoluteValue(rhs);
            if (this.sign) {
                if (result == cmpResult.cmpLessThan) {
                    result = cmpResult.cmpGreaterThan;
                } else if (result == cmpResult.cmpGreaterThan) {
                    result = cmpResult.cmpLessThan;
                }
            }
        }
        return result;
    }

    public boolean bitwiseIsEqual(APFloat rhs) {
        if (this == Native.$AddrOf((Object)rhs)) {
            return true;
        }
        if (this.semantics != rhs.semantics || this.category != rhs.category || this.sign != rhs.sign) {
            return false;
        }
        if (this.category == fltCategory.fcZero || this.category == fltCategory.fcInfinity) {
            return true;
        }
        if (this.isFiniteNonZero() && this.exponent != rhs.exponent) {
            return false;
        }
        return std.equal((ulong.iterator)this.significandParts$Const(), (ulong.iterator)((ulong.iterator)this.significandParts$Const().$add(this.partCount())), (ulong.iterator)rhs.significandParts$Const());
    }

    public int convertToHexString(char.ptr dst, int hexDigits, boolean upperCase, roundingMode rounding_mode) {
        char.ptr p = NativePointer.create_char$ptr();
        p = Native.$tryClone((char.ptr)dst);
        if (this.sign) {
            ((char.ptr)dst.$postInc()).$set((byte)45);
        }
        switch (this.category) {
            case fcInfinity: {
                std.memcpy((char.ptr)dst, (char.ptr)(upperCase ? APFloatStatics.infinityU : APFloatStatics.infinityL), (int)(NativeType.sizeof((Object)APFloatStatics.infinityU) - 1));
                dst.$inc(NativeType.sizeof((Object)APFloatStatics.infinityL) - 1);
                break;
            }
            case fcNaN: {
                std.memcpy((char.ptr)dst, (char.ptr)(upperCase ? APFloatStatics.NaNU : APFloatStatics.NaNL), (int)(NativeType.sizeof((Object)APFloatStatics.NaNU) - 1));
                dst.$inc(NativeType.sizeof((Object)APFloatStatics.NaNU) - 1);
                break;
            }
            case fcZero: {
                ((char.ptr)dst.$postInc()).$set((byte)48);
                ((char.ptr)dst.$postInc()).$set(upperCase ? (byte)88 : 120);
                ((char.ptr)dst.$postInc()).$set((byte)48);
                if (Unsigned.$greater_uint((int)hexDigits, (int)1)) {
                    ((char.ptr)dst.$postInc()).$set((byte)46);
                    std.memset((char.ptr)dst, (byte)48, (int)(hexDigits - 1));
                    dst.$inc(hexDigits - 1);
                }
                ((char.ptr)dst.$postInc()).$set(upperCase ? (byte)80 : 112);
                ((char.ptr)dst.$postInc()).$set((byte)48);
                break;
            }
            case fcNormal: {
                dst = Native.$tryClone((char.ptr)this.convertNormalToHexString(dst, hexDigits, upperCase, rounding_mode));
            }
        }
        dst.$set(Unsigned.$uint2uchar((int)0));
        return dst.$sub((abstract_iterator)p);
    }

    public boolean isNegative() {
        return this.sign;
    }

    public boolean isNormal() {
        return !this.isDenormal() && this.isFiniteNonZero();
    }

    public boolean isFinite() {
        return !this.isNaN() && !this.isInfinity();
    }

    public boolean isZero() {
        return this.category == fltCategory.fcZero;
    }

    public boolean isDenormal() {
        return this.isFiniteNonZero() && this.exponent == this.semantics.minExponent && APInt.tcExtractBit(this.significandParts$Const(), this.semantics.precision - 1) == 0;
    }

    public boolean isInfinity() {
        return this.category == fltCategory.fcInfinity;
    }

    public boolean isNaN() {
        return this.category == fltCategory.fcNaN;
    }

    public boolean isSignaling() {
        if (!this.isNaN()) {
            return false;
        }
        return APInt.tcExtractBit(this.significandParts$Const(), this.semantics.precision - 2) == 0;
    }

    public fltCategory getCategory() {
        return this.category;
    }

    public fltSemantics getSemantics() {
        return (fltSemantics)Native.$Deref((Object)this.semantics);
    }

    public boolean isNonZero() {
        return this.category != fltCategory.fcZero;
    }

    public boolean isFiniteNonZero() {
        return this.isFinite() && !this.isZero();
    }

    public boolean isPosZero() {
        return this.isZero() && !this.isNegative();
    }

    public boolean isNegZero() {
        return this.isZero() && this.isNegative();
    }

    public boolean isSmallest() {
        return this.isFiniteNonZero() && this.exponent == this.semantics.minExponent && this.significandMSB() == 0;
    }

    public boolean isLargest() {
        return this.isFiniteNonZero() && this.exponent == this.semantics.maxExponent && this.isSignificandAllOnes();
    }

    public boolean isInteger() {
        if (!this.isFinite()) {
            return false;
        }
        APFloat truncated = new APFloat(this);
        truncated.roundToIntegral(roundingMode.rmTowardZero);
        return this.compare(truncated) == cmpResult.cmpEqual;
    }

    public APFloat $assign(APFloat rhs) {
        if (this != Native.$AddrOf((Object)rhs)) {
            if (this.semantics != rhs.semantics) {
                this.freeSignificand();
                this.initialize(rhs.semantics);
            }
            this.assign(rhs);
        }
        return this;
    }

    public APFloat $assignMove(APFloat rhs) {
        assert (this != rhs);
        this.freeSignificand();
        this.semantics = rhs.semantics;
        this.significand.$assign(rhs.significand);
        this.exponent = rhs.exponent;
        this.category = rhs.category;
        this.sign = rhs.sign;
        rhs.semantics = (fltSemantics)Native.$AddrOf((Object)Bogus);
        return this;
    }

    public void __toString(SmallString Str) {
        this.__toString(Str, 0, 3);
    }

    public void __toString(SmallString Str, int FormatPrecision) {
        this.__toString(Str, FormatPrecision, 3);
    }

    public void __toString(SmallString Str, int FormatPrecision, int FormatMaxPadding) {
        int I;
        int I2;
        int MSD;
        int precision;
        switch (this.category) {
            case fcInfinity: {
                if (this.isNegative()) {
                    APFloatStatics.append(Str, new StringRef("-Inf"));
                    return;
                }
                APFloatStatics.append(Str, new StringRef("+Inf"));
                return;
            }
            case fcNaN: {
                APFloatStatics.append(Str, new StringRef("NaN"));
                return;
            }
            case fcZero: {
                if (this.isNegative()) {
                    Str.push_back((byte)45);
                }
                if (FormatMaxPadding == 0) {
                    APFloatStatics.append(Str, new StringRef("0.0E+0"));
                } else {
                    Str.push_back((byte)48);
                }
                return;
            }
        }
        if (this.isNegative()) {
            Str.push_back((byte)45);
        }
        int.ref exp = NativePointer.create_int$ref((int)(this.exponent - (this.semantics.precision - 1)));
        APInt significand = new APInt(this.semantics.precision, llvm.makeArrayRef(this.significandParts$Const(), APFloatStatics.partCountForBits(this.semantics.precision)));
        if (FormatPrecision == 0) {
            FormatPrecision = 2 + Unsigned.$div_uint((int)(this.semantics.precision * 59), (int)196);
        }
        int trailingZeros = significand.countTrailingZeros();
        exp.$set$addassign(trailingZeros);
        significand.$assignMove(significand.lshr(trailingZeros));
        if (exp.$deref() != 0) {
            if (exp.$deref() > 0) {
                significand.$assignMove(significand.zext(this.semantics.precision + exp.$deref()));
                significand.$lshiftassign(exp.$deref());
                exp.$set(0);
            } else {
                int texp = -exp.$deref();
                precision = this.semantics.precision + (137 * texp + 136) / 59;
                significand.$assignMove(significand.zext(precision));
                APInt five_to_the_i = new APInt(precision, Unsigned.$int2ulong((int)5));
                while (true) {
                    if ((texp & 1) != 0) {
                        significand.$starassign(five_to_the_i);
                    }
                    if ((texp >>= 1) == 0) break;
                    five_to_the_i.$starassign(five_to_the_i);
                }
            }
        }
        APFloatStatics.AdjustToPrecision(significand, exp, FormatPrecision);
        SmallString buffer = new SmallString(256);
        precision = significand.getBitWidth();
        APInt ten = new APInt(precision, Unsigned.$int2ulong((int)10));
        APInt digit = new APInt(precision, Unsigned.$int2ulong((int)0));
        boolean inTrail = true;
        while (significand.$noteq(Unsigned.$int2ulong((int)0))) {
            APInt.udivrem(significand, ten, significand, digit);
            int d = Unsigned.$ulong2uint((long)digit.getZExtValue());
            if (inTrail && d == 0) {
                exp.$set$postInc();
                continue;
            }
            buffer.push_back(Unsigned.$uint2char((int)(Unsigned.$char2uint((byte)48) + d)));
            inTrail = false;
        }
        assert (!buffer.empty()) : "no characters in buffer!";
        APFloatStatics.AdjustToPrecision(buffer, exp, FormatPrecision);
        int NDigits = buffer.size();
        boolean FormatScientific = FormatMaxPadding == 0 ? true : (exp.$deref() >= 0 ? Unsigned.$greater_uint((int)exp.$deref(), (int)FormatMaxPadding) || Unsigned.$greater_uint((int)(NDigits + exp.$deref()), (int)FormatPrecision) : ((MSD = exp.$deref() + (NDigits - 1)) >= 0 ? false : Unsigned.$greater_uint((int)(-MSD), (int)FormatMaxPadding)));
        if (FormatScientific) {
            exp.$set$addassign(NDigits - 1);
            Str.push_back(buffer.$at(NDigits - 1));
            Str.push_back((byte)46);
            if (NDigits == 1) {
                Str.push_back((byte)48);
            } else {
                for (I2 = 1; I2 != NDigits; ++I2) {
                    Str.push_back(buffer.$at(NDigits - 1 - I2));
                }
            }
            Str.push_back((byte)69);
            Str.push_back(exp.$deref() >= 0 ? (byte)43 : 45);
            if (exp.$deref() < 0) {
                exp.$set(-exp.$deref());
            }
            SmallString expbuf = new SmallString(6);
            do {
                expbuf.push_back((byte)(48 + exp.$deref() % 10));
                exp.$set$slashassign(10);
            } while (exp.$deref() != 0);
            int E = expbuf.size();
            for (int I3 = 0; I3 != E; ++I3) {
                Str.push_back(expbuf.$at(E - 1 - I3));
            }
            return;
        }
        if (exp.$deref() >= 0) {
            for (I2 = 0; I2 != NDigits; ++I2) {
                Str.push_back(buffer.$at(NDigits - 1 - I2));
            }
            for (I2 = 0; I2 != exp.$deref(); ++I2) {
                Str.push_back((byte)48);
            }
            return;
        }
        int NWholeDigits = exp.$deref() + NDigits;
        if (NWholeDigits > 0) {
            for (I = 0; I != NWholeDigits; ++I) {
                Str.push_back(buffer.$at(NDigits - I - 1));
            }
            Str.push_back((byte)46);
        } else {
            int NZeros = 1 + -NWholeDigits;
            Str.push_back((byte)48);
            Str.push_back((byte)46);
            for (int Z = 1; Z != NZeros; ++Z) {
                Str.push_back((byte)48);
            }
        }
        while (I != NDigits) {
            Str.push_back(buffer.$at(NDigits - I - 1));
            ++I;
        }
    }

    public boolean getExactInverse(APFloat inv) {
        if (!this.isFiniteNonZero()) {
            return false;
        }
        if (this.significandLSB() != this.semantics.precision - 1) {
            return false;
        }
        APFloat reciprocal = new APFloat((fltSemantics)Native.$Deref((Object)this.semantics), 1L);
        if (reciprocal.divide(this, roundingMode.rmNearestTiesToEven) != 0) {
            return false;
        }
        if (reciprocal.isDenormal()) {
            return false;
        }
        assert (reciprocal.isFiniteNonZero() && reciprocal.significandLSB() == reciprocal.semantics.precision - 1);
        if (inv != null) {
            inv.$assign(reciprocal);
        }
        return true;
    }

    public static int ilogb(APFloat Arg) {
        if (Arg.isNaN()) {
            return IlogbErrorKinds.IEK_NaN.getValue();
        }
        if (Arg.isZero()) {
            return IlogbErrorKinds.IEK_Zero.getValue();
        }
        if (Arg.isInfinity()) {
            return IlogbErrorKinds.IEK_Inf.getValue();
        }
        return Arg.exponent;
    }

    private ulong.ptr significandParts() {
        if (Unsigned.$greater_uint((int)this.partCount(), (int)1)) {
            return this.significand.parts;
        }
        return new ulong.ptr.inout(this.significand){

            protected long $star$impl() {
                return ((APFloat)APFloat.this).significand.part;
            }

            protected long $set$impl(long value) {
                ((APFloat)APFloat.this).significand.part = value;
                return ((APFloat)APFloat.this).significand.part;
            }
        };
    }

    public ulong.ptr significandParts$Const() {
        return this.significandParts();
    }

    public int partCount() {
        return APFloatStatics.partCountForBits(this.semantics.precision + 1);
    }

    private long addSignificand(APFloat rhs) {
        ulong.ptr parts = NativePointer.create_ulong$ptr();
        parts = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        assert (this.semantics == rhs.semantics);
        assert (this.exponent == rhs.exponent);
        return APInt.tcAdd(parts, rhs.significandParts$Const(), Unsigned.$int2ulong((int)0), this.partCount());
    }

    private long subtractSignificand(APFloat rhs, long borrow) {
        ulong.ptr parts = NativePointer.create_ulong$ptr();
        parts = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        assert (this.semantics == rhs.semantics);
        assert (this.exponent == rhs.exponent);
        return APInt.tcSubtract(parts, rhs.significandParts$Const(), borrow, this.partCount());
    }

    private lostFraction addOrSubtractSignificand(APFloat rhs, boolean subtract) {
        lostFraction lost_fraction;
        boolean bl = Unsigned.$bool2uint((boolean)(this.sign ^ rhs.sign)) != 0;
        int bits = this.exponent - rhs.exponent;
        if (subtract ^= bl) {
            long carry;
            boolean reverse;
            APFloat temp_rhs = new APFloat(rhs);
            if (bits == 0) {
                reverse = this.compareAbsoluteValue(temp_rhs) == cmpResult.cmpLessThan;
                lost_fraction = lostFraction.lfExactlyZero;
            } else if (bits > 0) {
                lost_fraction = temp_rhs.shiftSignificandRight(bits - 1);
                this.shiftSignificandLeft(1);
                reverse = false;
            } else {
                lost_fraction = this.shiftSignificandRight(-bits - 1);
                temp_rhs.shiftSignificandLeft(1);
                reverse = true;
            }
            if (reverse) {
                carry = temp_rhs.subtractSignificand(this, lost_fraction != lostFraction.lfExactlyZero ? 1 : 0);
                this.copySignificand(temp_rhs);
                this.sign = !this.sign;
            } else {
                carry = this.subtractSignificand(temp_rhs, lost_fraction != lostFraction.lfExactlyZero ? 1 : 0);
            }
            if (lost_fraction == lostFraction.lfLessThanHalf) {
                lost_fraction = lostFraction.lfMoreThanHalf;
            } else if (lost_fraction == lostFraction.lfMoreThanHalf) {
                lost_fraction = lostFraction.lfLessThanHalf;
            }
            assert (carry == 0L);
        } else {
            long carry;
            if (bits > 0) {
                APFloat temp_rhs = new APFloat(rhs);
                lost_fraction = temp_rhs.shiftSignificandRight(bits);
                carry = this.addSignificand(temp_rhs);
            } else {
                lost_fraction = this.shiftSignificandRight(-bits);
                carry = this.addSignificand(rhs);
            }
            assert (carry == 0L);
        }
        return lost_fraction;
    }

    private lostFraction multiplySignificand(APFloat rhs, APFloat addend) {
        ulong.ptr lhsSignificand = NativePointer.create_ulong$ptr();
        long[] scratch = NativePointer.new$ulong((int)4);
        ulong.ptr fullSignificand = NativePointer.create_ulong$ptr();
        bool.ptr ignored = NativePointer.create_bool$ptr();
        assert (this.semantics == rhs.semantics);
        int precision = this.semantics.precision;
        int newPartsCount = APFloatStatics.partCountForBits(precision * 2 + 1);
        fullSignificand = Unsigned.$greater_uint((int)newPartsCount, (int)4) ? NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)newPartsCount)) : (ulong.ptr)Native.$tryClone((NativeCloneable)NativePointer.create_ulong$ptr((long[])scratch));
        lhsSignificand = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        int partsCount = this.partCount();
        APInt.tcFullMultiply(fullSignificand, lhsSignificand, rhs.significandParts$Const(), partsCount, partsCount);
        lostFraction lost_fraction = lostFraction.lfExactlyZero;
        int omsb = APInt.tcMSB(fullSignificand, newPartsCount) + 1;
        this.exponent = (short)(this.exponent + rhs.exponent);
        this.exponent = (short)(this.exponent + 2);
        if (addend != null && addend.isNonZero()) {
            Significand savedSignificand = new Significand(this.significand);
            fltSemantics savedSemantics = this.semantics;
            fltSemantics extendedSemantics = new fltSemantics();
            int extendedPrecision = 2 * precision + 1;
            if (omsb != extendedPrecision - 1) {
                assert (Unsigned.$greater_uint((int)extendedPrecision, (int)omsb));
                APInt.tcShiftLeft(fullSignificand, newPartsCount, extendedPrecision - 1 - omsb);
                this.exponent = (short)(this.exponent - (extendedPrecision - 1 - omsb));
            }
            extendedSemantics.$assign((fltSemantics)Native.$Deref((Object)this.semantics));
            extendedSemantics.precision = extendedPrecision;
            if (newPartsCount == 1) {
                this.significand.part = fullSignificand.$at(0);
            } else {
                this.significand.parts = (ulong.ptr)Native.$tryClone((NativeCloneable)fullSignificand);
            }
            this.semantics = (fltSemantics)Native.$AddrOf((Object)extendedSemantics);
            APFloat extendedAddend = new APFloat((APFloat)Native.$Deref((Object)addend));
            int status = extendedAddend.convert(extendedSemantics, roundingMode.rmTowardZero, (bool.ptr)Native.$AddrOf((Object)ignored));
            assert (status == 0);
            lost_fraction = extendedAddend.shiftSignificandRight(1);
            assert (lost_fraction == lostFraction.lfExactlyZero) : "Lost precision while shifting addend for fused-multiply-add.";
            lost_fraction = this.addOrSubtractSignificand(extendedAddend, false);
            if (newPartsCount == 1) {
                fullSignificand.$set(0, this.significand.part);
            }
            this.significand.$assign(savedSignificand);
            this.semantics = savedSemantics;
            omsb = APInt.tcMSB(fullSignificand, newPartsCount) + 1;
        }
        this.exponent = (short)(this.exponent - (precision + 1));
        if (Unsigned.$greater_uint((int)omsb, (int)precision)) {
            int bits = omsb - precision;
            int significantParts = APFloatStatics.partCountForBits(omsb);
            lostFraction lf = APFloatStatics.shiftRight(fullSignificand, significantParts, bits);
            lost_fraction = APFloatStatics.combineLostFractions(lf, lost_fraction);
            this.exponent = (short)(this.exponent + bits);
        }
        APInt.tcAssign(lhsSignificand, fullSignificand, partsCount);
        if (Unsigned.$greater_uint((int)newPartsCount, (int)4)) {
            Destructors.$destroyArray((Object)fullSignificand);
        }
        return lost_fraction;
    }

    private lostFraction divideSignificand(APFloat rhs) {
        ulong.ptr lhsSignificand = NativePointer.create_ulong$ptr();
        ulong.ptr dividend = NativePointer.create_ulong$ptr();
        ulong.ptr divisor = NativePointer.create_ulong$ptr();
        long[] scratch = NativePointer.new$ulong((int)4);
        assert (this.semantics == rhs.semantics);
        lhsSignificand = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        ulong.ptr rhsSignificand = (ulong.ptr)Native.$tryClone((NativeCloneable)rhs.significandParts$Const());
        int partsCount = this.partCount();
        dividend = Unsigned.$greater_uint((int)partsCount, (int)2) ? NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)(partsCount * 2))) : (ulong.ptr)Native.$tryClone((NativeCloneable)NativePointer.create_ulong$ptr((long[])scratch));
        divisor = (ulong.ptr)Native.$tryClone((NativeCloneable)((ulong.ptr)dividend.$add(partsCount)));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)partsCount)) {
            dividend.$set(i, lhsSignificand.$at(i));
            divisor.$set(i, rhsSignificand.$at(i));
            lhsSignificand.$set(i, Unsigned.$int2ulong((int)0));
            ++i;
        }
        this.exponent = (short)(this.exponent - rhs.exponent);
        int precision = this.semantics.precision;
        int bit = precision - APInt.tcMSB(divisor, partsCount) - 1;
        if (bit != 0) {
            this.exponent = (short)(this.exponent + bit);
            APInt.tcShiftLeft(divisor, partsCount, bit);
        }
        if ((bit = precision - APInt.tcMSB(dividend, partsCount) - 1) != 0) {
            this.exponent = (short)(this.exponent - bit);
            APInt.tcShiftLeft(dividend, partsCount, bit);
        }
        if (APInt.tcCompare(dividend, divisor, partsCount) < 0) {
            this.exponent = (short)(this.exponent - 1);
            APInt.tcShiftLeft(dividend, partsCount, 1);
            assert (APInt.tcCompare(dividend, divisor, partsCount) >= 0);
        }
        for (bit = precision; bit != 0; --bit) {
            if (APInt.tcCompare(dividend, divisor, partsCount) >= 0) {
                APInt.tcSubtract(dividend, divisor, Unsigned.$int2ulong((int)0), partsCount);
                APInt.tcSetBit(lhsSignificand, bit - 1);
            }
            APInt.tcShiftLeft(dividend, partsCount, 1);
        }
        int cmp = APInt.tcCompare(dividend, divisor, partsCount);
        lostFraction lost_fraction = cmp > 0 ? lostFraction.lfMoreThanHalf : (cmp == 0 ? lostFraction.lfExactlyHalf : (APInt.tcIsZero(dividend, partsCount) ? lostFraction.lfExactlyZero : lostFraction.lfLessThanHalf));
        if (Unsigned.$greater_uint((int)partsCount, (int)2)) {
            Destructors.$destroyArray((Object)dividend);
        }
        return lost_fraction;
    }

    private void incrementSignificand() {
        long carry = APInt.tcIncrement(this.significandParts(), this.partCount());
        assert (carry == Unsigned.$int2ullong((int)0));
    }

    private void initialize(fltSemantics ourSemantics) {
        this.semantics = ourSemantics;
        int count = this.partCount();
        if (Unsigned.$greater_uint((int)count, (int)1)) {
            this.significand.parts = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)count));
        }
    }

    private void shiftSignificandLeft(int bits) {
        assert (Unsigned.$less_uint((int)bits, (int)this.semantics.precision));
        if (bits != 0) {
            int partsCount = this.partCount();
            APInt.tcShiftLeft(this.significandParts(), partsCount, bits);
            this.exponent = (short)(this.exponent - bits);
            assert (!APInt.tcIsZero(this.significandParts(), partsCount));
        }
    }

    private lostFraction shiftSignificandRight(int bits) {
        assert ((short)(this.exponent + bits) >= this.exponent);
        this.exponent = (short)(this.exponent + bits);
        return APFloatStatics.shiftRight(this.significandParts(), this.partCount(), bits);
    }

    private int significandLSB() {
        return APInt.tcLSB(this.significandParts$Const(), this.partCount());
    }

    private int significandMSB() {
        return APInt.tcMSB(this.significandParts$Const(), this.partCount());
    }

    private void zeroSignificand() {
        APInt.tcSet(this.significandParts(), Unsigned.$int2ulong((int)0), this.partCount());
    }

    private boolean isSignificandAllOnes() {
        ulong.ptr Parts = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts$Const());
        int PartCount = this.partCount();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)(PartCount - 1))) {
            if ((Parts.$at(i) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                return false;
            }
            ++i;
        }
        int NumHighBits = PartCount * llvm.integerPartWidth - this.semantics.precision + 1;
        assert (Unsigned.$lesseq_uint((int)NumHighBits, (int)llvm.integerPartWidth)) : "Can not have more high bits to fill than integerPartWidth";
        long HighBitFill = (Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL) << llvm.integerPartWidth - NumHighBits;
        return ((Parts.$at(PartCount - 1) | HighBitFill) ^ 0xFFFFFFFFFFFFFFFFL) == 0L;
    }

    private boolean isSignificandAllZeros() {
        ulong.ptr Parts = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts$Const());
        int PartCount = this.partCount();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)(PartCount - 1))) {
            if (Parts.$at(i) != 0L) {
                return false;
            }
            ++i;
        }
        int NumHighBits = PartCount * llvm.integerPartWidth - this.semantics.precision + 1;
        assert (Unsigned.$lesseq_uint((int)NumHighBits, (int)llvm.integerPartWidth)) : "Can not have more high bits to clear than integerPartWidth";
        long HighBitMask = (Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL) >>> NumHighBits;
        return (Parts.$at(PartCount - 1) & HighBitMask) == 0L;
    }

    private int addOrSubtractSpecials(APFloat rhs, boolean subtract) {
        switch (this.category.getValue() * 4 + rhs.category.getValue()) {
            default: {
                throw new llvm_unreachable(null);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                return 0;
            }
            case 1: 
            case 9: 
            case 13: {
                this.sign = Unsigned.$uint2uint_1bit((int)(Unsigned.$bool2uint((boolean)rhs.sign) ^ (subtract ? 1 : 0)));
                this.category = fltCategory.fcNaN;
                this.copySignificand(rhs);
                return 0;
            }
            case 8: 
            case 12: {
                this.category = fltCategory.fcInfinity;
                this.sign = Unsigned.$uint2uint_1bit((int)(Unsigned.$bool2uint((boolean)rhs.sign) ^ (subtract ? 1 : 0)));
                return 0;
            }
            case 14: {
                this.assign(rhs);
                this.sign = Unsigned.$uint2uint_1bit((int)(Unsigned.$bool2uint((boolean)rhs.sign) ^ (subtract ? 1 : 0)));
                return 0;
            }
            case 15: {
                return 0;
            }
            case 0: {
                if (Unsigned.$bool2uint((boolean)(this.sign ^ rhs.sign)) != 0 != subtract) {
                    this.makeNaN();
                    return 1;
                }
                return 0;
            }
            case 10: 
        }
        return 2;
    }

    private int divideSpecials(APFloat rhs) {
        switch (this.category.getValue() * 4 + rhs.category.getValue()) {
            default: {
                throw new llvm_unreachable(null);
            }
            case 1: 
            case 9: 
            case 13: {
                this.category = fltCategory.fcNaN;
                this.copySignificand(rhs);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.sign = false;
            }
            case 2: 
            case 3: 
            case 12: 
            case 14: {
                return 0;
            }
            case 8: {
                this.category = fltCategory.fcZero;
                return 0;
            }
            case 11: {
                this.category = fltCategory.fcInfinity;
                return 2;
            }
            case 0: 
            case 15: {
                this.makeNaN();
                return 1;
            }
            case 10: 
        }
        return 0;
    }

    private int multiplySpecials(APFloat rhs) {
        switch (this.category.getValue() * 4 + rhs.category.getValue()) {
            default: {
                throw new llvm_unreachable(null);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.sign = false;
                return 0;
            }
            case 1: 
            case 9: 
            case 13: {
                this.sign = false;
                this.category = fltCategory.fcNaN;
                this.copySignificand(rhs);
                return 0;
            }
            case 0: 
            case 2: 
            case 8: {
                this.category = fltCategory.fcInfinity;
                return 0;
            }
            case 11: 
            case 14: 
            case 15: {
                this.category = fltCategory.fcZero;
                return 0;
            }
            case 3: 
            case 12: {
                this.makeNaN();
                return 1;
            }
            case 10: 
        }
        return 0;
    }

    private int modSpecials(APFloat rhs) {
        switch (this.category.getValue() * 4 + rhs.category.getValue()) {
            default: {
                throw new llvm_unreachable(null);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                return 0;
            }
            case 1: 
            case 9: 
            case 13: {
                this.sign = false;
                this.category = fltCategory.fcNaN;
                this.copySignificand(rhs);
                return 0;
            }
            case 0: 
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                this.makeNaN();
                return 1;
            }
            case 10: 
        }
        return 0;
    }

    private void makeLargest() {
        this.makeLargest(false);
    }

    private void makeLargest(boolean Negative) {
        this.category = fltCategory.fcNormal;
        this.sign = Negative;
        this.exponent = this.semantics.maxExponent;
        ulong.ptr significand = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        int PartCount = this.partCount();
        std.memset((ulong.ptr)significand, (long)255L, (int)(NativeType.$sizeof_ULong() * (PartCount - 1)));
        int NumUnusedHighBits = PartCount * llvm.integerPartWidth - this.semantics.precision;
        significand.$set(PartCount - 1, Unsigned.$less_uint((int)NumUnusedHighBits, (int)llvm.integerPartWidth) ? (Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL) >>> NumUnusedHighBits : Unsigned.$int2ullong((int)0));
    }

    private void makeSmallest() {
        this.makeSmallest(false);
    }

    private void makeSmallest(boolean Negative) {
        this.category = fltCategory.fcNormal;
        this.sign = Negative;
        this.exponent = this.semantics.minExponent;
        APInt.tcSet(this.significandParts(), Unsigned.$int2ulong((int)1), this.partCount());
    }

    private void makeNaN() {
        this.makeNaN(false, false, null);
    }

    private void makeNaN(boolean SNaN) {
        this.makeNaN(SNaN, false, null);
    }

    private void makeNaN(boolean SNaN, boolean Negative) {
        this.makeNaN(SNaN, Negative, null);
    }

    private void makeNaN(boolean SNaN, boolean Negative, APInt fill) {
        this.category = fltCategory.fcNaN;
        this.sign = Negative;
        ulong.ptr significand = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        int numParts = this.partCount();
        if (fill == null || Unsigned.$less_uint((int)fill.getNumWords(), (int)numParts)) {
            APInt.tcSet(significand, Unsigned.$int2ulong((int)0), numParts);
        }
        if (fill != null) {
            APInt.tcAssign(significand, fill.getRawData(), std.min_uint((int)fill.getNumWords(), (int)numParts));
            int bitsToPreserve = this.semantics.precision - 1;
            int part = Unsigned.$div_uint((int)bitsToPreserve, (int)64);
            bitsToPreserve = Unsigned.$rem_uint((int)bitsToPreserve, (int)64);
            significand.$set$andassign(part, (1L << bitsToPreserve) - Unsigned.$int2ullong((int)1));
            ++part;
            while (part != numParts) {
                significand.$set(part, Unsigned.$int2ulong((int)0));
                ++part;
            }
        }
        int QNaNBit = this.semantics.precision - 2;
        if (SNaN) {
            APInt.tcClearBit(significand, QNaNBit);
            if (APInt.tcIsZero(significand, numParts)) {
                APInt.tcSetBit(significand, QNaNBit - 1);
            }
        } else {
            APInt.tcSetBit(significand, QNaNBit);
        }
        if (this.semantics == Native.$AddrOf((Object)x87DoubleExtended)) {
            APInt.tcSetBit(significand, QNaNBit + 1);
        }
    }

    private static APFloat makeNaN(fltSemantics Sem, boolean SNaN, boolean Negative, APInt fill) {
        APFloat value = new APFloat(Sem, uninitializedTag.uninitialized);
        value.makeNaN(SNaN, Negative, fill);
        return value;
    }

    private void makeInf() {
        this.makeInf(false);
    }

    private void makeInf(boolean Negative) {
        this.category = fltCategory.fcInfinity;
        this.sign = Negative;
        this.exponent = Unsigned.$int2short((int)(this.semantics.maxExponent + 1));
        APInt.tcSet(this.significandParts(), Unsigned.$int2ulong((int)0), this.partCount());
    }

    private void makeZero() {
        this.makeZero(false);
    }

    private void makeZero(boolean Negative) {
        this.category = fltCategory.fcZero;
        this.sign = Negative;
        this.exponent = Unsigned.$int2short((int)(this.semantics.minExponent - 1));
        APInt.tcSet(this.significandParts(), Unsigned.$int2ulong((int)0), this.partCount());
    }

    public void makeQuiet() {
        assert (this.isNaN());
        APInt.tcSetBit(this.significandParts(), this.semantics.precision - 2);
    }

    private boolean convertFromStringSpecials(StringRef str) {
        if (str.equals("inf") || str.equals("INFINITY")) {
            this.makeInf(false);
            return true;
        }
        if (str.equals("-inf") || str.equals("-INFINITY")) {
            this.makeInf(true);
            return true;
        }
        if (str.equals("nan") || str.equals("NaN")) {
            this.makeNaN(false, false);
            return true;
        }
        if (str.equals("-nan") || str.equals("-NaN")) {
            this.makeNaN(false, true);
            return true;
        }
        return false;
    }

    public int normalize(roundingMode rounding_mode, lostFraction lost_fraction) {
        if (!this.isFiniteNonZero()) {
            return 0;
        }
        int omsb = this.significandMSB() + 1;
        if (omsb != 0) {
            int exponentChange = omsb - this.semantics.precision;
            if (this.exponent + exponentChange > this.semantics.maxExponent) {
                return this.handleOverflow(rounding_mode);
            }
            if (this.exponent + exponentChange < this.semantics.minExponent) {
                exponentChange = this.semantics.minExponent - this.exponent;
            }
            if (exponentChange < 0) {
                assert (lost_fraction == lostFraction.lfExactlyZero);
                this.shiftSignificandLeft(-exponentChange);
                return 0;
            }
            if (exponentChange > 0) {
                lostFraction lf = this.shiftSignificandRight(exponentChange);
                lost_fraction = APFloatStatics.combineLostFractions(lf, lost_fraction);
                omsb = Unsigned.$greater_uint((int)omsb, (int)exponentChange) ? (omsb -= exponentChange) : 0;
            }
        }
        if (lost_fraction == lostFraction.lfExactlyZero) {
            if (omsb == 0) {
                this.category = fltCategory.fcZero;
            }
            return 0;
        }
        if (this.roundAwayFromZero(rounding_mode, lost_fraction, 0)) {
            if (omsb == 0) {
                this.exponent = this.semantics.minExponent;
            }
            this.incrementSignificand();
            omsb = this.significandMSB() + 1;
            if (omsb == this.semantics.precision + 1) {
                if (this.exponent == this.semantics.maxExponent) {
                    this.category = fltCategory.fcInfinity;
                    return 20;
                }
                this.shiftSignificandRight(1);
                return 16;
            }
        }
        if (omsb == this.semantics.precision) {
            return 16;
        }
        assert (Unsigned.$less_uint((int)omsb, (int)this.semantics.precision));
        if (omsb == 0) {
            this.category = fltCategory.fcZero;
        }
        return 24;
    }

    private int addOrSubtract(APFloat rhs, roundingMode rounding_mode, boolean subtract) {
        int fs2 = this.addOrSubtractSpecials(rhs, subtract);
        if (fs2 == 2) {
            lostFraction lost_fraction = this.addOrSubtractSignificand(rhs, subtract);
            fs2 = this.normalize(rounding_mode, lost_fraction);
            assert (this.category != fltCategory.fcZero || lost_fraction == lostFraction.lfExactlyZero);
        }
        if (this.category == fltCategory.fcZero && (rhs.category != fltCategory.fcZero || this.sign == rhs.sign == subtract)) {
            this.sign = rounding_mode == roundingMode.rmTowardNegative;
        }
        return fs2;
    }

    private cmpResult compareAbsoluteValue(APFloat rhs) {
        assert (this.semantics == rhs.semantics);
        assert (this.isFiniteNonZero());
        assert (rhs.isFiniteNonZero());
        int compare = this.exponent - rhs.exponent;
        if (compare == 0) {
            compare = APInt.tcCompare(this.significandParts$Const(), rhs.significandParts$Const(), this.partCount());
        }
        if (compare > 0) {
            return cmpResult.cmpGreaterThan;
        }
        if (compare < 0) {
            return cmpResult.cmpLessThan;
        }
        return cmpResult.cmpEqual;
    }

    private int handleOverflow(roundingMode rounding_mode) {
        if (rounding_mode == roundingMode.rmNearestTiesToEven || rounding_mode == roundingMode.rmNearestTiesToAway || rounding_mode == roundingMode.rmTowardPositive && !this.sign || rounding_mode == roundingMode.rmTowardNegative && this.sign) {
            this.category = fltCategory.fcInfinity;
            return 20;
        }
        this.category = fltCategory.fcNormal;
        this.exponent = this.semantics.maxExponent;
        APInt.tcSetLeastSignificantBits(this.significandParts(), this.partCount(), this.semantics.precision);
        return 16;
    }

    private boolean roundAwayFromZero(roundingMode rounding_mode, lostFraction lost_fraction, int bit) {
        assert (this.isFiniteNonZero() || this.category == fltCategory.fcZero);
        assert (lost_fraction != lostFraction.lfExactlyZero);
        switch (rounding_mode) {
            case rmNearestTiesToAway: {
                return lost_fraction == lostFraction.lfExactlyHalf || lost_fraction == lostFraction.lfMoreThanHalf;
            }
            case rmNearestTiesToEven: {
                if (lost_fraction == lostFraction.lfMoreThanHalf) {
                    return true;
                }
                if (lost_fraction == lostFraction.lfExactlyHalf && this.category != fltCategory.fcZero) {
                    return APInt.tcExtractBit(this.significandParts$Const(), bit) != 0;
                }
                return false;
            }
            case rmTowardZero: {
                return false;
            }
            case rmTowardPositive: {
                return !this.sign;
            }
            case rmTowardNegative: {
                return this.sign;
            }
        }
        throw new llvm_unreachable("Invalid rounding mode found");
    }

    private int convertToSignExtendedInteger(ulong.ptr parts, int width, boolean isSigned, roundingMode rounding_mode, bool.ptr isExact) {
        lostFraction lost_fraction;
        int truncatedBits;
        isExact.$set(false);
        if (this.category == fltCategory.fcInfinity || this.category == fltCategory.fcNaN) {
            return 1;
        }
        int dstPartsCount = APFloatStatics.partCountForBits(width);
        if (this.category == fltCategory.fcZero) {
            APInt.tcSet(parts, Unsigned.$int2ulong((int)0), dstPartsCount);
            isExact.$set(!this.sign);
            return 0;
        }
        ulong.ptr src = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts$Const());
        if (this.exponent < 0) {
            APInt.tcSet(parts, Unsigned.$int2ulong((int)0), dstPartsCount);
            truncatedBits = this.semantics.precision - 1 - Unsigned.$short2uint((short)this.exponent);
        } else {
            int bits = Unsigned.$short2uint((short)this.exponent) + 1;
            if (Unsigned.$greater_uint((int)bits, (int)width)) {
                return 1;
            }
            if (Unsigned.$less_uint((int)bits, (int)this.semantics.precision)) {
                truncatedBits = this.semantics.precision - bits;
                APInt.tcExtract(parts, dstPartsCount, src, bits, truncatedBits);
            } else {
                APInt.tcExtract(parts, dstPartsCount, src, this.semantics.precision, 0);
                APInt.tcShiftLeft(parts, dstPartsCount, bits - this.semantics.precision);
                truncatedBits = 0;
            }
        }
        if (truncatedBits != 0) {
            lost_fraction = APFloatStatics.lostFractionThroughTruncation(src, this.partCount(), truncatedBits);
            if (lost_fraction != lostFraction.lfExactlyZero && this.roundAwayFromZero(rounding_mode, lost_fraction, truncatedBits) && APInt.tcIncrement(parts, dstPartsCount) != 0L) {
                return 1;
            }
        } else {
            lost_fraction = lostFraction.lfExactlyZero;
        }
        int omsb = APInt.tcMSB(parts, dstPartsCount) + 1;
        if (this.sign) {
            if (!isSigned) {
                if (omsb != 0) {
                    return 1;
                }
            } else {
                if (omsb == width && APInt.tcLSB(parts, dstPartsCount) + 1 != omsb) {
                    return 1;
                }
                if (Unsigned.$greater_uint((int)omsb, (int)width)) {
                    return 1;
                }
            }
            APInt.tcNegate(parts, dstPartsCount);
        } else if (Unsigned.$greatereq_uint((int)omsb, (int)(width + (!isSigned ? 1 : 0)))) {
            return 1;
        }
        if (lost_fraction == lostFraction.lfExactlyZero) {
            isExact.$set(true);
            return 0;
        }
        return 16;
    }

    private int convertFromUnsignedParts(ulong.ptr src, int srcCount, roundingMode rounding_mode) {
        lostFraction lost_fraction;
        ulong.ptr dst = NativePointer.create_ulong$ptr();
        this.category = fltCategory.fcNormal;
        int omsb = APInt.tcMSB(src, srcCount) + 1;
        dst = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        int dstCount = this.partCount();
        int precision = this.semantics.precision;
        if (Unsigned.$lesseq_uint((int)precision, (int)omsb)) {
            this.exponent = Unsigned.$uint2short((int)(omsb - 1));
            lost_fraction = APFloatStatics.lostFractionThroughTruncation(src, srcCount, omsb - precision);
            APInt.tcExtract(dst, dstCount, src, precision, omsb - precision);
        } else {
            this.exponent = Unsigned.$uint2short((int)(precision - 1));
            lost_fraction = lostFraction.lfExactlyZero;
            APInt.tcExtract(dst, dstCount, src, omsb, 0);
        }
        return this.normalize(rounding_mode, lost_fraction);
    }

    private int convertFromHexadecimalString(StringRef s, roundingMode rounding_mode) {
        lostFraction lost_fraction = lostFraction.lfExactlyZero;
        this.category = fltCategory.fcNormal;
        this.zeroSignificand();
        this.exponent = 0;
        ulong.ptr significand = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts());
        int partsCount = this.partCount();
        int bitPos = partsCount * llvm.integerPartWidth;
        boolean computedTrailingFraction = false;
        char.ptr begin = Native.$tryClone((char.ptr)s.begin());
        char.ptr end = Native.$tryClone((char.ptr)s.end());
        char.ptr dot = Native.$tryClone((char.ptr)end);
        char.ptr p = Native.$tryClone((char.ptr)APFloatStatics.skipLeadingZeroesAndAnyDot(begin, end, dot));
        char.ptr firstSignificantDigit = Native.$tryClone((char.ptr)p);
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) {
            if (p.$star() == 46) {
                assert (Native.$eq_ptr((void.ptr)dot, (void.ptr)end)) : "String contains multiple dots";
                dot = Native.$tryClone((char.ptr)((char.ptr)p.$postInc()));
                continue;
            }
            long hex_value = Unsigned.$uint2ulong((int)llvm.hexDigitValue(p.$star()));
            if (hex_value == Unsigned.$uint2ullong((int)-1)) break;
            p.$postInc();
            if (bitPos != 0) {
                significand.$set$orassign(Unsigned.$div_uint((int)bitPos, (int)llvm.integerPartWidth), hex_value <<= Unsigned.$rem_uint((int)(bitPos -= 4), (int)llvm.integerPartWidth));
                continue;
            }
            if (computedTrailingFraction) continue;
            lost_fraction = APFloatStatics.trailingHexadecimalFraction(p, end, Unsigned.$ulong2uint((long)hex_value));
            computedTrailingFraction = true;
        }
        assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) : "Hex strings require an exponent";
        assert (p.$star() == 112 || p.$star() == 80) : "Invalid character in significand";
        assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)begin)) : "Significand has no digits";
        assert (Native.$eq_ptr((void.ptr)dot, (void.ptr)end) || p.$sub((abstract_iterator)begin) != 1) : "Significand has no digits";
        if (Native.$noteq_ptr((void.ptr)p, (void.ptr)firstSignificantDigit)) {
            int expAdjustment;
            if (Native.$eq_ptr((void.ptr)dot, (void.ptr)end)) {
                dot = Native.$tryClone((char.ptr)p);
            }
            if ((expAdjustment = dot.$sub((abstract_iterator)firstSignificantDigit)) < 0) {
                ++expAdjustment;
            }
            expAdjustment = expAdjustment * 4 - 1;
            expAdjustment += this.semantics.precision;
            this.exponent = Unsigned.$int2short((int)APFloatStatics.totalExponent((char.ptr)p.$add(1), end, expAdjustment -= partsCount * llvm.integerPartWidth));
        }
        return this.normalize(rounding_mode, lost_fraction);
    }

    private int convertFromDecimalString(StringRef str, roundingMode rounding_mode) {
        int fs2;
        decimalInfo D = new decimalInfo();
        char.ptr p = Native.$tryClone((char.ptr)str.begin());
        APFloatStatics.interpretDecimal(p, str.end(), (decimalInfo)Native.$AddrOf((Object)D));
        if (Native.$eq_ptr((void.ptr)D.firstSigDigit, (void.ptr)str.end()) || Unsigned.$greatereq_uint((int)APFloatStatics.decDigitValue(Unsigned.$char2uint((byte)D.firstSigDigit.$star())), (int)10)) {
            this.category = fltCategory.fcZero;
            fs2 = 0;
        } else if (D.normalizedExponent - 1 > 51083) {
            fs2 = this.handleOverflow(rounding_mode);
        } else if (D.normalizedExponent - 1 < -51083 || (D.normalizedExponent + 1) * 28738 <= 8651 * (this.semantics.minExponent - this.semantics.precision)) {
            this.category = fltCategory.fcNormal;
            this.zeroSignificand();
            fs2 = this.normalize(rounding_mode, lostFraction.lfLessThanHalf);
        } else if ((D.normalizedExponent - 1) * 42039 >= 12655 * this.semantics.maxExponent) {
            fs2 = this.handleOverflow(rounding_mode);
        } else {
            int partCount = D.lastSigDigit.$sub((abstract_iterator)D.firstSigDigit) + 1;
            partCount = APFloatStatics.partCountForBits(1 + Unsigned.$div_uint((int)(196 * partCount), (int)59));
            ulong.ptr decSignificand = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)(partCount + 1)));
            partCount = 0;
            do {
                long val = Unsigned.$int2ulong((int)0);
                long multiplier = Unsigned.$int2ulong((int)1);
                do {
                    if (p.$star() == 46) {
                        p.$postInc();
                        if (Native.$eq_ptr((void.ptr)p, (void.ptr)str.end())) break;
                    }
                    long decValue = Unsigned.$uint2ulong((int)APFloatStatics.decDigitValue(Unsigned.$char2uint((byte)((char.ptr)p.$postInc()).$star())));
                    assert (Unsigned.$less_ulong_uint((long)decValue, (int)10)) : "Invalid character in significand";
                    val = val * Unsigned.$int2ullong((int)10) + decValue;
                } while (p.$lesseq((Object)D.lastSigDigit) && Unsigned.$lesseq_ulong_ullong((long)(multiplier *= Unsigned.$int2ullong((int)10)), (long)Unsigned.$div_ullong((long)((Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL) - Unsigned.$int2ullong((int)9)), (long)Unsigned.$int2ullong((int)10))));
                APInt.tcMultiplyPart(decSignificand, decSignificand, multiplier, val, partCount, partCount + 1, false);
                if (decSignificand.$at(partCount) == 0L) continue;
                ++partCount;
            } while (p.$lesseq((Object)D.lastSigDigit));
            this.category = fltCategory.fcNormal;
            fs2 = this.roundSignificandWithExponent(decSignificand, partCount, D.exponent, rounding_mode);
            Destructors.$destroyArray((Object)decSignificand);
        }
        return fs2;
    }

    private char.ptr convertNormalToHexString(char.ptr dst, int hexDigits, boolean upperCase, roundingMode rounding_mode) {
        char.ptr hexDigitChars = NativePointer.create_char$ptr();
        char.ptr p = NativePointer.create_char$ptr();
        ((char.ptr)dst.$postInc()).$set((byte)48);
        ((char.ptr)dst.$postInc()).$set(upperCase ? (byte)88 : 120);
        boolean roundUp = false;
        hexDigitChars = Native.$tryClone((char.ptr)(upperCase ? APFloatStatics.hexDigitsUpper : APFloatStatics.hexDigitsLower));
        ulong.ptr significand = (ulong.ptr)Native.$tryClone((NativeCloneable)this.significandParts$Const());
        int partsCount = this.partCount();
        int valueBits = this.semantics.precision + 3;
        int shift = llvm.integerPartWidth - Unsigned.$rem_uint((int)valueBits, (int)llvm.integerPartWidth);
        int outputDigits = Unsigned.$div_uint((int)(valueBits - this.significandLSB() + 3), (int)4);
        if (hexDigits != 0) {
            if (Unsigned.$less_uint((int)hexDigits, (int)outputDigits)) {
                int bits = valueBits - hexDigits * 4;
                lostFraction fraction = APFloatStatics.lostFractionThroughTruncation(significand, partsCount, bits);
                roundUp = this.roundAwayFromZero(rounding_mode, fraction, bits);
            }
            outputDigits = hexDigits;
        }
        p = Native.$tryClone((char.ptr)((char.ptr)dst.$preInc()));
        int count = Unsigned.$div_uint((int)(valueBits + llvm.integerPartWidth - 1), (int)llvm.integerPartWidth);
        while (outputDigits != 0 && count != 0) {
            int curDigits;
            long part = --count == partsCount ? Unsigned.$int2ulong((int)0) : significand.$at(count) << shift;
            if (count != 0 && shift != 0) {
                part |= significand.$at(count - 1) >>> llvm.integerPartWidth - shift;
            }
            if (Unsigned.$greater_uint((int)(curDigits = Unsigned.$div_uint((int)llvm.integerPartWidth, (int)4)), (int)outputDigits)) {
                curDigits = outputDigits;
            }
            dst.$inc(APFloatStatics.partAsHex(dst, part, curDigits, hexDigitChars));
            outputDigits -= curDigits;
        }
        if (roundUp) {
            char.ptr q = Native.$tryClone((char.ptr)dst);
            do {
                q.$postDec();
                q.$set(hexDigitChars.$at(llvm.hexDigitValue(q.$star()) + 1));
            } while (q.$star() == 48);
            assert (q.$greatereq((Object)p));
        } else {
            std.memset((char.ptr)dst, (byte)48, (int)outputDigits);
            dst.$inc(outputDigits);
        }
        p.$set(-1, p.$at(0));
        if (Native.$eq_ptr((void.ptr)((char.ptr)dst.$sub(1)), (void.ptr)p)) {
            dst.$postDec();
        } else {
            p.$set(0, (byte)46);
        }
        ((char.ptr)dst.$postInc()).$set(upperCase ? (byte)80 : 112);
        return APFloatStatics.writeSignedDecimal(dst, this.exponent);
    }

    private int roundSignificandWithExponent(ulong.ptr decSigParts, int sigPartCount, int exp, roundingMode rounding_mode) {
        fltSemantics calcSemantics = new fltSemantics(Short.MAX_VALUE, -32767, 0, 0);
        ulong.ptr pow5Parts = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)600));
        boolean isNearest = rounding_mode == roundingMode.rmNearestTiesToEven || rounding_mode == roundingMode.rmNearestTiesToAway;
        int parts = APFloatStatics.partCountForBits(this.semantics.precision + 11);
        int pow5PartCount = APFloatStatics.powerOf5(pow5Parts, exp >= 0 ? exp : -exp);
        while (true) {
            int powHUerr;
            lostFraction calcLostFraction;
            int excessPrecision;
            calcSemantics.precision = parts * llvm.integerPartWidth - 1;
            int truncatedBits = excessPrecision = calcSemantics.precision - this.semantics.precision;
            APFloat decSig = APFloat.getZero(calcSemantics, this.sign);
            APFloat pow5 = new APFloat(calcSemantics);
            int sigStatus = decSig.convertFromUnsignedParts(decSigParts, sigPartCount, roundingMode.rmNearestTiesToEven);
            int powStatus = pow5.convertFromUnsignedParts(pow5Parts, pow5PartCount, roundingMode.rmNearestTiesToEven);
            decSig.exponent = (short)(decSig.exponent + exp);
            if (exp >= 0) {
                calcLostFraction = decSig.multiplySignificand(pow5, null);
                powHUerr = powStatus != 0 ? 1 : 0;
            } else {
                calcLostFraction = decSig.divideSignificand(pow5);
                if (decSig.exponent < this.semantics.minExponent) {
                    truncatedBits = excessPrecision += this.semantics.minExponent - decSig.exponent;
                    if (Unsigned.$greater_uint((int)excessPrecision, (int)calcSemantics.precision)) {
                        excessPrecision = calcSemantics.precision;
                    }
                }
                int n = powHUerr = powStatus == 0 && calcLostFraction == lostFraction.lfExactlyZero ? 0 : 2;
            }
            assert (APInt.tcExtractBit(decSig.significandParts(), calcSemantics.precision - 1) == 1);
            long HUerr = Unsigned.$uint2ulong((int)APFloatStatics.HUerrBound(calcLostFraction != lostFraction.lfExactlyZero, sigStatus != 0 ? 1 : 0, powHUerr));
            long HUdistance = Unsigned.$int2ullong((int)2) * APFloatStatics.ulpsFromBoundary(decSig.significandParts(), excessPrecision, isNearest);
            if (Unsigned.$greatereq_ulong((long)HUdistance, (long)HUerr)) {
                APInt.tcExtract(this.significandParts(), this.partCount(), decSig.significandParts(), calcSemantics.precision - excessPrecision, excessPrecision);
                this.exponent = Unsigned.$uint2short((int)(Unsigned.$short2uint((short)decSig.exponent) + this.semantics.precision - (calcSemantics.precision - excessPrecision)));
                calcLostFraction = APFloatStatics.lostFractionThroughTruncation(decSig.significandParts(), decSig.partCount(), truncatedBits);
                return this.normalize(rounding_mode, calcLostFraction);
            }
            parts *= 2;
        }
    }

    private APInt convertHalfAPFloatToAPInt() {
        int mysignificand;
        int myexponent;
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEhalf));
        assert (this.partCount() == 1);
        if (this.isFiniteNonZero()) {
            myexponent = this.exponent + 15;
            mysignificand = Unsigned.$ulong2uint((long)this.significandParts$Const().$star());
            if (myexponent == 1 && (mysignificand & 0x400) == 0) {
                myexponent = 0;
            }
        } else if (this.category == fltCategory.fcZero) {
            myexponent = 0;
            mysignificand = 0;
        } else if (this.category == fltCategory.fcInfinity) {
            myexponent = 31;
            mysignificand = 0;
        } else {
            assert (this.category == fltCategory.fcNaN) : "Unknown category!";
            myexponent = 31;
            mysignificand = Unsigned.$ulong2uint((long)this.significandParts$Const().$star());
        }
        return new APInt(16, Unsigned.$uint2ulong((int)((Unsigned.$bool2uint((boolean)this.sign) & 1) << 15 | (myexponent & 0x1F) << 10 | mysignificand & 0x3FF)));
    }

    private APInt convertFloatAPFloatToAPInt() {
        int mysignificand;
        int myexponent;
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEsingle));
        assert (this.partCount() == 1);
        if (this.isFiniteNonZero()) {
            myexponent = this.exponent + 127;
            mysignificand = Unsigned.$ulong2uint((long)this.significandParts$Const().$star());
            if (myexponent == 1 && (mysignificand & 0x800000) == 0) {
                myexponent = 0;
            }
        } else if (this.category == fltCategory.fcZero) {
            myexponent = 0;
            mysignificand = 0;
        } else if (this.category == fltCategory.fcInfinity) {
            myexponent = 255;
            mysignificand = 0;
        } else {
            assert (this.category == fltCategory.fcNaN) : "Unknown category!";
            myexponent = 255;
            mysignificand = Unsigned.$ulong2uint((long)this.significandParts$Const().$star());
        }
        return new APInt(32, Unsigned.$uint2ulong((int)((Unsigned.$bool2uint((boolean)this.sign) & 1) << 31 | (myexponent & 0xFF) << 23 | mysignificand & 0x7FFFFF)));
    }

    private APInt convertDoubleAPFloatToAPInt() {
        long mysignificand;
        long myexponent;
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEdouble));
        assert (this.partCount() == 1);
        if (this.isFiniteNonZero()) {
            myexponent = Unsigned.$int2ulong((int)(this.exponent + 1023));
            mysignificand = this.significandParts$Const().$star();
            if (myexponent == Unsigned.$int2ullong((int)1) && (mysignificand & 0x10000000000000L) == 0L) {
                myexponent = Unsigned.$int2ulong((int)0);
            }
        } else if (this.category == fltCategory.fcZero) {
            myexponent = Unsigned.$int2ulong((int)0);
            mysignificand = Unsigned.$int2ulong((int)0);
        } else if (this.category == fltCategory.fcInfinity) {
            myexponent = Unsigned.$int2ulong((int)2047);
            mysignificand = Unsigned.$int2ulong((int)0);
        } else {
            assert (this.category == fltCategory.fcNaN) : "Unknown category!";
            myexponent = Unsigned.$int2ulong((int)2047);
            mysignificand = this.significandParts$Const().$star();
        }
        return new APInt(64, Unsigned.$int2ulong((int)(Unsigned.$bool2uint((boolean)this.sign) & 1)) << 63 | (myexponent & Unsigned.$int2ullong((int)2047)) << 52 | mysignificand & 0xFFFFFFFFFFFFFL);
    }

    private APInt convertQuadrupleAPFloatToAPInt() {
        long mysignificand2;
        long mysignificand;
        long myexponent;
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)IEEEquad));
        assert (this.partCount() == 2);
        if (this.isFiniteNonZero()) {
            myexponent = Unsigned.$int2ulong((int)(this.exponent + 16383));
            mysignificand = this.significandParts$Const().$at(0);
            mysignificand2 = this.significandParts$Const().$at(1);
            if (myexponent == Unsigned.$int2ullong((int)1) && (mysignificand2 & 0x1000000000000L) == 0L) {
                myexponent = Unsigned.$int2ulong((int)0);
            }
        } else if (this.category == fltCategory.fcZero) {
            myexponent = Unsigned.$int2ulong((int)0);
            mysignificand = mysignificand2 = Unsigned.$int2ulong((int)0);
        } else if (this.category == fltCategory.fcInfinity) {
            myexponent = Unsigned.$int2ulong((int)Short.MAX_VALUE);
            mysignificand = mysignificand2 = Unsigned.$int2ulong((int)0);
        } else {
            assert (this.category == fltCategory.fcNaN) : "Unknown category!";
            myexponent = Unsigned.$int2ulong((int)Short.MAX_VALUE);
            mysignificand = this.significandParts$Const().$at(0);
            mysignificand2 = this.significandParts$Const().$at(1);
        }
        long[] words = NativePointer.new$ulong((int)2);
        words[0] = mysignificand;
        words[1] = Unsigned.$int2ulong((int)(Unsigned.$bool2uint((boolean)this.sign) & 1)) << 63 | (myexponent & Unsigned.$int2ullong((int)Short.MAX_VALUE)) << 48 | mysignificand2 & 0xFFFFFFFFFFFFL;
        return new APInt(128, new ArrayRefULong(words));
    }

    private APInt convertF80LongDoubleAPFloatToAPInt() {
        long mysignificand;
        long myexponent;
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)x87DoubleExtended));
        assert (this.partCount() == 2);
        if (this.isFiniteNonZero()) {
            myexponent = Unsigned.$int2ulong((int)(this.exponent + 16383));
            mysignificand = this.significandParts$Const().$at(0);
            if (myexponent == Unsigned.$int2ullong((int)1) && (mysignificand & Long.MIN_VALUE) == 0L) {
                myexponent = Unsigned.$int2ulong((int)0);
            }
        } else if (this.category == fltCategory.fcZero) {
            myexponent = Unsigned.$int2ulong((int)0);
            mysignificand = Unsigned.$int2ulong((int)0);
        } else if (this.category == fltCategory.fcInfinity) {
            myexponent = Unsigned.$int2ulong((int)Short.MAX_VALUE);
            mysignificand = Long.MIN_VALUE;
        } else {
            assert (this.category == fltCategory.fcNaN) : "Unknown category";
            myexponent = Unsigned.$int2ulong((int)Short.MAX_VALUE);
            mysignificand = this.significandParts$Const().$at(0);
        }
        long[] words = NativePointer.new$ulong((int)2);
        words[0] = mysignificand;
        words[1] = Unsigned.$int2ulong((int)(Unsigned.$bool2uint((boolean)this.sign) & 1)) << 15 | myexponent & 0x7FFFL;
        return new APInt(80, new ArrayRefULong(words));
    }

    private APInt convertPPCDoubleDoubleAPFloatToAPInt() {
        assert (this.semantics == (fltSemantics)Native.$AddrOf((Object)PPCDoubleDouble));
        assert (this.partCount() == 2);
        long[] words = NativePointer.new$ulong((int)2);
        bool.ptr losesInfo = NativePointer.create_bool$ptr();
        fltSemantics extendedSemantics = new fltSemantics((fltSemantics)Native.$Deref((Object)this.semantics));
        extendedSemantics.minExponent = APFloat.IEEEdouble.minExponent;
        APFloat extended = new APFloat(this);
        int fs2 = extended.convert(extendedSemantics, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
        assert (fs2 == 0 && !losesInfo.$star());
        APFloat u = new APFloat(extended);
        fs2 = u.convert(IEEEdouble, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
        assert (fs2 == 0 || fs2 == 16);
        words[0] = u.convertDoubleAPFloatToAPInt().getRawData().$star();
        if (u.isFiniteNonZero() && losesInfo.$star()) {
            fs2 = u.convert(extendedSemantics, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
            assert (fs2 == 0 && !losesInfo.$star());
            APFloat v = new APFloat(extended);
            v.subtract(u, roundingMode.rmNearestTiesToEven);
            fs2 = v.convert(IEEEdouble, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
            assert (fs2 == 0 && !losesInfo.$star());
            words[1] = v.convertDoubleAPFloatToAPInt().getRawData().$star();
        } else {
            words[1] = Unsigned.$int2ulong((int)0);
        }
        return new APInt(128, new ArrayRefULong(words));
    }

    private void initFromAPInt(fltSemantics Sem, APInt api) {
        if (Sem == Native.$AddrOf((Object)IEEEhalf)) {
            this.initFromHalfAPInt(api);
            return;
        }
        if (Sem == Native.$AddrOf((Object)IEEEsingle)) {
            this.initFromFloatAPInt(api);
            return;
        }
        if (Sem == Native.$AddrOf((Object)IEEEdouble)) {
            this.initFromDoubleAPInt(api);
            return;
        }
        if (Sem == Native.$AddrOf((Object)x87DoubleExtended)) {
            this.initFromF80LongDoubleAPInt(api);
            return;
        }
        if (Sem == Native.$AddrOf((Object)IEEEquad)) {
            this.initFromQuadrupleAPInt(api);
            return;
        }
        if (Sem == Native.$AddrOf((Object)PPCDoubleDouble)) {
            this.initFromPPCDoubleDoubleAPInt(api);
            return;
        }
        throw new llvm_unreachable(null);
    }

    private void initFromHalfAPInt(APInt api) {
        assert (api.getBitWidth() == 16);
        int i = Unsigned.$ulong2uint((long)api.getRawData().$star());
        int myexponent = i >>> 10 & 0x1F;
        int mysignificand = i & 0x3FF;
        this.initialize((fltSemantics)Native.$AddrOf((Object)IEEEhalf));
        assert (this.partCount() == 1);
        this.sign = Unsigned.$uint2uint_1bit((int)(i >>> 15));
        if (myexponent == 0 && mysignificand == 0) {
            this.category = fltCategory.fcZero;
        } else if (myexponent == 31 && mysignificand == 0) {
            this.category = fltCategory.fcInfinity;
        } else if (myexponent == 31 && mysignificand != 0) {
            this.category = fltCategory.fcNaN;
            this.significandParts().$set(Unsigned.$uint2ulong((int)mysignificand));
        } else {
            this.category = fltCategory.fcNormal;
            this.exponent = Unsigned.$uint2short((int)(myexponent - 15));
            this.significandParts().$set(Unsigned.$uint2ulong((int)mysignificand));
            if (myexponent == 0) {
                this.exponent = (short)-14;
            } else {
                this.significandParts().$set$orassign(0, Unsigned.$int2ullong((int)1024));
            }
        }
    }

    private void initFromFloatAPInt(APInt api) {
        assert (api.getBitWidth() == 32);
        int i = Unsigned.$ulong2uint((long)api.getRawData().$star());
        int myexponent = i >>> 23 & 0xFF;
        int mysignificand = i & 0x7FFFFF;
        this.initialize((fltSemantics)Native.$AddrOf((Object)IEEEsingle));
        assert (this.partCount() == 1);
        this.sign = Unsigned.$uint2uint_1bit((int)(i >>> 31));
        if (myexponent == 0 && mysignificand == 0) {
            this.category = fltCategory.fcZero;
        } else if (myexponent == 255 && mysignificand == 0) {
            this.category = fltCategory.fcInfinity;
        } else if (myexponent == 255 && mysignificand != 0) {
            this.category = fltCategory.fcNaN;
            this.significandParts().$set(Unsigned.$uint2ulong((int)mysignificand));
        } else {
            this.category = fltCategory.fcNormal;
            this.exponent = Unsigned.$uint2short((int)(myexponent - 127));
            this.significandParts().$set(Unsigned.$uint2ulong((int)mysignificand));
            if (myexponent == 0) {
                this.exponent = (short)-126;
            } else {
                this.significandParts().$set$orassign(0, Unsigned.$int2ullong((int)0x800000));
            }
        }
    }

    private void initFromDoubleAPInt(APInt api) {
        assert (api.getBitWidth() == 64);
        long i = api.getRawData().$star();
        long myexponent = i >>> 52 & Unsigned.$int2ullong((int)2047);
        long mysignificand = i & 0xFFFFFFFFFFFFFL;
        this.initialize((fltSemantics)Native.$AddrOf((Object)IEEEdouble));
        assert (this.partCount() == 1);
        this.sign = Unsigned.$uint2uint_1bit((int)Unsigned.$ulong2uint((long)(i >>> 63)));
        if (myexponent == Unsigned.$int2ullong((int)0) && mysignificand == Unsigned.$int2ullong((int)0)) {
            this.category = fltCategory.fcZero;
        } else if (myexponent == Unsigned.$int2ullong((int)2047) && mysignificand == Unsigned.$int2ullong((int)0)) {
            this.category = fltCategory.fcInfinity;
        } else if (myexponent == Unsigned.$int2ullong((int)2047) && mysignificand != Unsigned.$int2ullong((int)0)) {
            this.category = fltCategory.fcNaN;
            this.significandParts().$set(mysignificand);
        } else {
            this.category = fltCategory.fcNormal;
            this.exponent = Unsigned.$ullong2short((long)(myexponent - Unsigned.$int2ullong((int)1023)));
            this.significandParts().$set(mysignificand);
            if (myexponent == Unsigned.$int2ullong((int)0)) {
                this.exponent = (short)-1022;
            } else {
                this.significandParts().$set$orassign(0, 0x10000000000000L);
            }
        }
    }

    private void initFromQuadrupleAPInt(APInt api) {
        assert (api.getBitWidth() == 128);
        long i1 = api.getRawData().$at(0);
        long i2 = api.getRawData().$at(1);
        long myexponent = i2 >>> 48 & Unsigned.$int2ullong((int)Short.MAX_VALUE);
        long mysignificand = i1;
        long mysignificand2 = i2 & 0xFFFFFFFFFFFFL;
        this.initialize((fltSemantics)Native.$AddrOf((Object)IEEEquad));
        assert (this.partCount() == 2);
        this.sign = Unsigned.$uint2uint_1bit((int)Unsigned.$ulong2uint((long)(i2 >>> 63)));
        if (myexponent == Unsigned.$int2ullong((int)0) && mysignificand == Unsigned.$int2ullong((int)0) && mysignificand2 == Unsigned.$int2ullong((int)0)) {
            this.category = fltCategory.fcZero;
        } else if (myexponent == Unsigned.$int2ullong((int)Short.MAX_VALUE) && mysignificand == Unsigned.$int2ullong((int)0) && mysignificand2 == Unsigned.$int2ullong((int)0)) {
            this.category = fltCategory.fcInfinity;
        } else if (myexponent == Unsigned.$int2ullong((int)Short.MAX_VALUE) && (mysignificand != Unsigned.$int2ullong((int)0) || mysignificand2 != Unsigned.$int2ullong((int)0))) {
            this.category = fltCategory.fcNaN;
            this.significandParts().$set(0, mysignificand);
            this.significandParts().$set(1, mysignificand2);
        } else {
            this.category = fltCategory.fcNormal;
            this.exponent = Unsigned.$ullong2short((long)(myexponent - Unsigned.$int2ullong((int)16383)));
            this.significandParts().$set(0, mysignificand);
            this.significandParts().$set(1, mysignificand2);
            if (myexponent == Unsigned.$int2ullong((int)0)) {
                this.exponent = (short)-16382;
            } else {
                this.significandParts().$set$orassign(1, 0x1000000000000L);
            }
        }
    }

    private void initFromF80LongDoubleAPInt(APInt api) {
        assert (api.getBitWidth() == 80);
        long i1 = api.getRawData().$at(0);
        long i2 = api.getRawData().$at(1);
        long myexponent = i2 & Unsigned.$int2ullong((int)Short.MAX_VALUE);
        long mysignificand = i1;
        this.initialize((fltSemantics)Native.$AddrOf((Object)x87DoubleExtended));
        assert (this.partCount() == 2);
        this.sign = Unsigned.$uint2uint_1bit((int)Unsigned.$ulong2uint((long)(i2 >>> 15)));
        if (myexponent == Unsigned.$int2ullong((int)0) && mysignificand == Unsigned.$int2ullong((int)0)) {
            this.category = fltCategory.fcZero;
        } else if (myexponent == Unsigned.$int2ullong((int)Short.MAX_VALUE) && mysignificand == Long.MIN_VALUE) {
            this.category = fltCategory.fcInfinity;
        } else if (myexponent == Unsigned.$int2ullong((int)Short.MAX_VALUE) && mysignificand != Long.MIN_VALUE) {
            this.category = fltCategory.fcNaN;
            this.significandParts().$set(0, mysignificand);
            this.significandParts().$set(1, Unsigned.$int2ulong((int)0));
        } else {
            this.category = fltCategory.fcNormal;
            this.exponent = Unsigned.$ullong2short((long)(myexponent - Unsigned.$int2ullong((int)16383)));
            this.significandParts().$set(0, mysignificand);
            this.significandParts().$set(1, Unsigned.$int2ulong((int)0));
            if (myexponent == Unsigned.$int2ullong((int)0)) {
                this.exponent = (short)-16382;
            }
        }
    }

    private void initFromPPCDoubleDoubleAPInt(APInt api) {
        assert (api.getBitWidth() == 128);
        long i1 = api.getRawData().$at(0);
        long i2 = api.getRawData().$at(1);
        bool.ptr losesInfo = NativePointer.create_bool$ptr();
        this.initFromDoubleAPInt(new APInt(64, i1));
        int fs2 = this.convert(PPCDoubleDouble, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
        assert (fs2 == 0 && !losesInfo.$star());
        if (this.isFiniteNonZero()) {
            APFloat v = new APFloat(IEEEdouble, new APInt(64, i2));
            fs2 = v.convert(PPCDoubleDouble, roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
            assert (fs2 == 0 && !losesInfo.$star());
            this.add(v, roundingMode.rmNearestTiesToEven);
        }
    }

    private void assign(APFloat rhs) {
        assert (this.semantics == rhs.semantics);
        this.sign = rhs.sign;
        this.category = rhs.category;
        this.exponent = rhs.exponent;
        if (this.isFiniteNonZero() || this.category == fltCategory.fcNaN) {
            this.copySignificand(rhs);
        }
    }

    private void copySignificand(APFloat rhs) {
        assert (this.isFiniteNonZero() || this.category == fltCategory.fcNaN);
        assert (Unsigned.$greatereq_uint((int)rhs.partCount(), (int)this.partCount()));
        APInt.tcAssign(this.significandParts(), rhs.significandParts$Const(), this.partCount());
    }

    private void freeSignificand() {
        if (this.needsCleanup()) {
            Destructors.$destroyArray((Object)this.significand.parts);
        }
    }

    public APFloat move() {
        return new APFloat(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public String toString() {
        String txt = "";
        try {
            SmallString buf = new SmallString(64);
            this.__toString(buf);
            txt = buf.toJavaString();
        }
        catch (Throwable e) {
            txt = "<ERROR>";
        }
        return "[" + txt + "]: semantics=" + this.semantics + ", significand=" + this.significand + ", exponent=" + this.exponent + ", category=" + (Object)((Object)this.category) + ", sign=" + this.sign;
    }

    static {
        assert (fltCategory.fcInfinity.value == 0);
        assert (fltCategory.fcNaN.value == 1);
        assert (fltCategory.fcNormal.value == 2);
        assert (fltCategory.fcZero.value == 3);
    }

    private static class Significand {
        public long part;
        public ulong.ptr parts;

        public Significand $assign(Significand $Prm0) {
            this.part = $Prm0.part;
            this.parts = (ulong.ptr)Native.$tryClone((NativeCloneable)$Prm0.parts);
            return this;
        }

        public Significand() {
        }

        public Significand(Significand $Prm0) {
        }

        public String toString() {
            return "part=" + this.part + ", parts=" + this.parts;
        }
    }

    public static final class IlogbErrorKinds
    extends Enum<IlogbErrorKinds>
    implements Native.ComparableLower {
        public static final /* enum */ IlogbErrorKinds IEK_Zero = new IlogbErrorKinds(-2147483647);
        public static final /* enum */ IlogbErrorKinds IEK_NaN = new IlogbErrorKinds(Integer.MIN_VALUE);
        public static final /* enum */ IlogbErrorKinds IEK_Inf = new IlogbErrorKinds(Integer.MAX_VALUE);
        private final int value;
        private static final /* synthetic */ IlogbErrorKinds[] $VALUES;

        public static IlogbErrorKinds[] values() {
            return (IlogbErrorKinds[])$VALUES.clone();
        }

        public static IlogbErrorKinds valueOf(String name) {
            return Enum.valueOf(IlogbErrorKinds.class, name);
        }

        public static IlogbErrorKinds valueOf(int val) {
            IlogbErrorKinds out;
            IlogbErrorKinds ilogbErrorKinds = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private IlogbErrorKinds(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_int((int)this.value, (int)((IlogbErrorKinds)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_int((int)this.value, (int)((IlogbErrorKinds)((Object)obj)).value);
        }

        static {
            $VALUES = new IlogbErrorKinds[]{IEK_Zero, IEK_NaN, IEK_Inf};
        }

        private static final class Values {
            private static final IlogbErrorKinds[] VALUES;
            private static final IlogbErrorKinds[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (IlogbErrorKinds kind : IlogbErrorKinds.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new IlogbErrorKinds[min < 0 ? 1 - min : 0];
                VALUES = new IlogbErrorKinds[max >= 0 ? 1 + max : 0];
                for (IlogbErrorKinds kind : IlogbErrorKinds.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((IlogbErrorKinds)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((IlogbErrorKinds)kind).value] = kind;
                }
            }
        }
    }

    public static final class uninitializedTag
    extends Enum<uninitializedTag>
    implements Native.ComparableLower {
        public static final /* enum */ uninitializedTag uninitialized = new uninitializedTag(0);
        private final int value;
        private static final /* synthetic */ uninitializedTag[] $VALUES;

        public static uninitializedTag[] values() {
            return (uninitializedTag[])$VALUES.clone();
        }

        public static uninitializedTag valueOf(String name) {
            return Enum.valueOf(uninitializedTag.class, name);
        }

        public static uninitializedTag valueOf(int val) {
            uninitializedTag out;
            uninitializedTag uninitializedTag2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private uninitializedTag(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((uninitializedTag)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((uninitializedTag)((Object)obj)).value);
        }

        static {
            $VALUES = new uninitializedTag[]{uninitialized};
        }

        private static final class Values {
            private static final uninitializedTag[] VALUES;
            private static final uninitializedTag[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (uninitializedTag kind : uninitializedTag.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new uninitializedTag[min < 0 ? 1 - min : 0];
                VALUES = new uninitializedTag[max >= 0 ? 1 + max : 0];
                for (uninitializedTag kind : uninitializedTag.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((uninitializedTag)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((uninitializedTag)kind).value] = kind;
                }
            }
        }
    }

    public static final class fltCategory
    extends Enum<fltCategory>
    implements Native.ComparableLower {
        public static final /* enum */ fltCategory fcInfinity = new fltCategory(0);
        public static final /* enum */ fltCategory fcNaN = new fltCategory(fcInfinity.getValue() + 1);
        public static final /* enum */ fltCategory fcNormal = new fltCategory(fcNaN.getValue() + 1);
        public static final /* enum */ fltCategory fcZero = new fltCategory(fcNormal.getValue() + 1);
        private final int value;
        private static final /* synthetic */ fltCategory[] $VALUES;

        public static fltCategory[] values() {
            return (fltCategory[])$VALUES.clone();
        }

        public static fltCategory valueOf(String name) {
            return Enum.valueOf(fltCategory.class, name);
        }

        public static fltCategory valueOf(int val) {
            fltCategory out;
            fltCategory fltCategory2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private fltCategory(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((fltCategory)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((fltCategory)((Object)obj)).value);
        }

        static {
            $VALUES = new fltCategory[]{fcInfinity, fcNaN, fcNormal, fcZero};
        }

        private static final class Values {
            private static final fltCategory[] VALUES;
            private static final fltCategory[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (fltCategory kind : fltCategory.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new fltCategory[min < 0 ? 1 - min : 0];
                VALUES = new fltCategory[max >= 0 ? 1 + max : 0];
                for (fltCategory kind : fltCategory.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((fltCategory)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((fltCategory)kind).value] = kind;
                }
            }
        }
    }

    public static final class opStatus {
        public static final int opOK = 0;
        public static final int opInvalidOp = 1;
        public static final int opDivByZero = 2;
        public static final int opOverflow = 4;
        public static final int opUnderflow = 8;
        public static final int opInexact = 16;
    }

    public static final class roundingMode
    extends Enum<roundingMode>
    implements Native.ComparableLower {
        public static final /* enum */ roundingMode rmNearestTiesToEven = new roundingMode(0);
        public static final /* enum */ roundingMode rmTowardPositive = new roundingMode(rmNearestTiesToEven.getValue() + 1);
        public static final /* enum */ roundingMode rmTowardNegative = new roundingMode(rmTowardPositive.getValue() + 1);
        public static final /* enum */ roundingMode rmTowardZero = new roundingMode(rmTowardNegative.getValue() + 1);
        public static final /* enum */ roundingMode rmNearestTiesToAway = new roundingMode(rmTowardZero.getValue() + 1);
        private final int value;
        private static final /* synthetic */ roundingMode[] $VALUES;

        public static roundingMode[] values() {
            return (roundingMode[])$VALUES.clone();
        }

        public static roundingMode valueOf(String name) {
            return Enum.valueOf(roundingMode.class, name);
        }

        public static roundingMode valueOf(int val) {
            roundingMode out;
            roundingMode roundingMode2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private roundingMode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((roundingMode)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((roundingMode)((Object)obj)).value);
        }

        static {
            $VALUES = new roundingMode[]{rmNearestTiesToEven, rmTowardPositive, rmTowardNegative, rmTowardZero, rmNearestTiesToAway};
        }

        private static final class Values {
            private static final roundingMode[] VALUES;
            private static final roundingMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (roundingMode kind : roundingMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new roundingMode[min < 0 ? 1 - min : 0];
                VALUES = new roundingMode[max >= 0 ? 1 + max : 0];
                for (roundingMode kind : roundingMode.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((roundingMode)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((roundingMode)kind).value] = kind;
                }
            }
        }
    }

    public static final class cmpResult
    extends Enum<cmpResult>
    implements Native.ComparableLower {
        public static final /* enum */ cmpResult cmpLessThan = new cmpResult(0);
        public static final /* enum */ cmpResult cmpEqual = new cmpResult(cmpLessThan.getValue() + 1);
        public static final /* enum */ cmpResult cmpGreaterThan = new cmpResult(cmpEqual.getValue() + 1);
        public static final /* enum */ cmpResult cmpUnordered = new cmpResult(cmpGreaterThan.getValue() + 1);
        private final int value;
        private static final /* synthetic */ cmpResult[] $VALUES;

        public static cmpResult[] values() {
            return (cmpResult[])$VALUES.clone();
        }

        public static cmpResult valueOf(String name) {
            return Enum.valueOf(cmpResult.class, name);
        }

        public static cmpResult valueOf(int val) {
            cmpResult out;
            cmpResult cmpResult2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private cmpResult(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((cmpResult)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((cmpResult)((Object)obj)).value);
        }

        static {
            $VALUES = new cmpResult[]{cmpLessThan, cmpEqual, cmpGreaterThan, cmpUnordered};
        }

        private static final class Values {
            private static final cmpResult[] VALUES;
            private static final cmpResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (cmpResult kind : cmpResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new cmpResult[min < 0 ? 1 - min : 0];
                VALUES = new cmpResult[max >= 0 ? 1 + max : 0];
                for (cmpResult kind : cmpResult.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((cmpResult)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((cmpResult)kind).value] = kind;
                }
            }
        }
    }
}

