/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.textmate.frontend;

import andel.text.Text;
import andel.text.TextLine;
import andel.text.TextLines;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.api.FileAddress;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.frontend.editor.editorconfig.EditorConfigExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigs;
import fleet.frontend.editor.editorconfig.TypingSettings;
import fleet.frontend.lang.Indent;
import fleet.frontend.lang.Indenter;
import fleet.frontend.lang.IndentingMode;
import fleet.frontend.lang.indent.IndentKt;
import fleet.plugins.textmate.frontend.TextMateIndenterKt;
import fleet.util.SequenceKt;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010$\u001a\u00020\u0019*\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010&\u001a\u00020\u0018*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lfleet/plugins/textmate/frontend/TextMateIndenter;", "Lfleet/frontend/lang/Indenter;", "indentationRules", "Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;)V", "indent", "Lfleet/frontend/lang/Indent;", "offset", "", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "text", "Landel/text/Text;", "path", "Lfleet/api/FileAddress;", "settings", "Lfleet/frontend/editor/editorconfig/TypingSettings;", "mode", "Lfleet/frontend/lang/IndentingMode;", "doIndent", "editorConfig", "Lfleet/frontend/editor/editorconfig/EditorConfigs;", "hasMoreThanIndentation", "", "", "indentOnNewLine", "indentOnExistingLine", "indentExistingArbitraryLine", "targetLineNumber", "lines", "Landel/text/TextLines;", "indentStep", "indentSize", "", "indentExistingFirstLine", "translateIntoLocalIndent", "localIndentStep", "allSymbolsAreSame", "Companion", "fleet.plugins.textmate.frontend"})
@SourceDebugExtension(value={"SMAP\nTextMateIndenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateIndenter.kt\nfleet/plugins/textmate/frontend/TextMateIndenter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1088#2,2:202\n18#3,2:204\n18#3,2:207\n1#4:206\n*S KotlinDebug\n*F\n+ 1 TextMateIndenter.kt\nfleet/plugins/textmate/frontend/TextMateIndenter\n*L\n48#1:202,2\n78#1:204,2\n121#1:207,2\n*E\n"})
public final class TextMateIndenter
implements Indenter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IndentationRules indentationRules;
    @NotNull
    private static final Indent EMPTY_INDENT = new Indent("");
    @NotNull
    private static final KLogger logger = KLoggers.INSTANCE.logger(TextMateIndenter.class);

    public TextMateIndenter(@NotNull IndentationRules indentationRules) {
        Intrinsics.checkNotNullParameter((Object)indentationRules, (String)"indentationRules");
        this.indentationRules = indentationRules;
    }

    @NotNull
    public Indent indent(long offset, @NotNull SyntaxNode root, @NotNull Text text, @Nullable FileAddress path, @NotNull TypingSettings settings, @NotNull IndentingMode mode) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return this.doIndent(offset, text, path, settings.getEditorConfigs(), mode);
    }

    @NotNull
    public final Indent doIndent(long offset, @NotNull Text text, @Nullable FileAddress path, @NotNull EditorConfigs editorConfig, @NotNull IndentingMode mode) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> this.indentOnNewLine(offset, text, path, editorConfig);
            case 2 -> this.indentOnExistingLine(offset, text, path, editorConfig);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasMoreThanIndentation(String $this$hasMoreThanIndentation) {
        if (((CharSequence)$this$hasMoreThanIndentation).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$any$iv = $this$hasMoreThanIndentation;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char it = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (it != ' ' && it != '\t' && it != '\n') {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final Indent indentOnNewLine(long offset, Text text, FileAddress path, EditorConfigs editorConfig) {
        if (offset <= 0L) {
            return EMPTY_INDENT;
        }
        TextLines lines = TextViewExtKt.textLines((TextView)text.view(), (boolean)true);
        long lineNumber = lines.offsetToLineNumber(offset);
        if (lineNumber <= 0L) {
            return EMPTY_INDENT;
        }
        String string = (String)SequencesKt.lastOrNull((Sequence)SequenceKt.takeWhileInclusive((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.downTo((long)(lineNumber - 1L), (int)0))), (Function1)((Function1)new Function1<Long, String>(lines){
            final /* synthetic */ TextLines $lines;
            {
                this.$lines = $lines;
                super(1);
            }

            public final String invoke(long it) {
                return this.$lines.get(it).toString();
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ TextMateIndenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TextMateIndenter.access$hasMoreThanIndentation(this.this$0, it);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ TextMateIndenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(String lineContent) {
                Intrinsics.checkNotNullParameter((Object)lineContent, (String)"lineContent");
                return TextMateIndenterKt.matches(lineContent, TextMateIndenter.access$getIndentationRules$p(this.this$0).getUnIndentedLinePattern());
            }
        })));
        if (string == null) {
            string = "";
        }
        String referenceIndentLine2 = string;
        String referenceIndent = TextMateIndenterKt.getIndent(referenceIndentLine2);
        String prevLine = lines.get(lineNumber - 1L).toString();
        String step = IndentKt.makeIndent((EditorConfigs)editorConfig, (FileAddress)path);
        String indent = TextMateIndenterKt.matches(prevLine, this.indentationRules.getIndentNextLinePattern()) || TextMateIndenterKt.matches(prevLine, this.indentationRules.getIncreaseIndentPattern()) ? referenceIndent + step : referenceIndent;
        return new Indent(indent);
    }

    private final Indent indentOnExistingLine(long offset, Text text, FileAddress path, EditorConfigs editorConfig) {
        if (offset < 0L) {
            KLogger this_$iv = logger;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)"Asked for reindentation on negative offset. Declined");
            }
            return EMPTY_INDENT;
        }
        TextLines lines = TextViewExtKt.textLines((TextView)text.view(), (boolean)true);
        long lineNumber = lines.offsetToLineNumber(offset);
        String indentStep = IndentKt.makeIndent((EditorConfigs)editorConfig, (FileAddress)path);
        int indentSize = EditorConfigExtKt.indentSize((EditorConfigs)editorConfig, (FileAddress)path);
        return TextMateIndenterKt.matches(lines.get(lineNumber).toString(), this.indentationRules.getUnIndentedLinePattern()) ? EMPTY_INDENT : (lineNumber == 0L ? this.indentExistingFirstLine(lines, indentStep, indentSize) : this.indentExistingArbitraryLine(lineNumber, lines, indentStep, indentSize));
    }

    private final Indent indentExistingArbitraryLine(long targetLineNumber, TextLines lines, String indentStep, int indentSize) {
        Pair pair;
        if (!(targetLineNumber > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Pair referenceIndentLineNumberAndContent2 = (Pair)SequencesKt.lastOrNull((Sequence)SequenceKt.takeWhileInclusive((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.downTo((long)(targetLineNumber - 1L), (int)0))), (Function1)((Function1)new Function1<Long, Pair<? extends Long, ? extends String>>(lines){
            final /* synthetic */ TextLines $lines;
            {
                this.$lines = $lines;
                super(1);
            }

            public final Pair<Long, String> invoke(long it) {
                return TuplesKt.to((Object)it, (Object)this.$lines.get(it).toString());
            }
        })), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends String>, Boolean>(this){
            final /* synthetic */ TextMateIndenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(Pair<Long, String> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<destruct>");
                String contents = (String)pair.component2();
                return TextMateIndenter.access$hasMoreThanIndentation(this.this$0, contents);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends String>, Boolean>(this){
            final /* synthetic */ TextMateIndenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(Pair<Long, String> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<destruct>");
                String lineContent = (String)pair.component2();
                return TextMateIndenterKt.matches(lineContent, TextMateIndenter.access$getIndentationRules$p(this.this$0).getUnIndentedLinePattern());
            }
        })));
        if (referenceIndentLineNumberAndContent2 != null) {
            String string;
            boolean bl;
            Long l;
            long refLineNumber = ((Number)referenceIndentLineNumberAndContent2.component1()).longValue();
            String refLineContent = (String)referenceIndentLineNumberAndContent2.component2();
            Long l2 = refLineNumber;
            long it = ((Number)l2).longValue();
            boolean bl2 = false;
            Long l3 = l = it > 1L ? l2 : null;
            if (l != null) {
                long it2 = ((Number)l).longValue();
                boolean bl3 = false;
                bl = TextMateIndenterKt.matches(lines.get(it2 - 1L).toString(), this.indentationRules.getIndentNextLinePattern());
            } else {
                bl = false;
            }
            boolean shouldTrim = bl;
            String preliminaryIndent = this.translateIntoLocalIndent(TextMateIndenterKt.getIndent(refLineContent), indentStep, indentSize);
            if (shouldTrim) {
                if (!StringsKt.endsWith$default((String)preliminaryIndent, (String)indentStep, (boolean)false, (int)2, null)) {
                    KLogger this_$iv = logger;
                    boolean $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl4 = false;
                        kLogger.warn((Object)("The line " + refLineNumber + " indentation does not contain symbols defined in editorconfig as indenters. Can't deindent it."));
                    }
                    string = "";
                } else {
                    string = StringsKt.dropLast((String)preliminaryIndent, (int)indentStep.length());
                }
            } else {
                string = preliminaryIndent;
            }
            String indent = string;
            pair = TuplesKt.to((Object)refLineNumber, (Object)indent);
        } else {
            pair = TuplesKt.to((Object)0L, (Object)"");
        }
        Pair pair2 = pair;
        long startingLine = ((Number)pair2.component1()).longValue();
        String referenceIndent = (String)pair2.component2();
        int accumulatedIndentDifferenceSteps2 = ((Number)SequencesKt.last((Sequence)SequencesKt.scan((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new LongRange(startingLine, targetLineNumber))), (Object)0, (Function2)((Function2)new Function2<Integer, Long, Integer>(lines, targetLineNumber, this, startingLine){
            final /* synthetic */ TextLines $lines;
            final /* synthetic */ long $targetLineNumber;
            final /* synthetic */ TextMateIndenter this$0;
            final /* synthetic */ long $startingLine;
            {
                this.$lines = $lines;
                this.$targetLineNumber = $targetLineNumber;
                this.this$0 = $receiver;
                this.$startingLine = $startingLine;
                super(2);
            }

            public final Integer invoke(int accumulatedDeltaIndent, long currentLineNumber) {
                String currentLineContent = this.$lines.get(currentLineNumber).toString();
                int counter = 0;
                if (currentLineNumber == this.$targetLineNumber - 1L && TextMateIndenterKt.matches(currentLineContent, TextMateIndenter.access$getIndentationRules$p(this.this$0).getIndentNextLinePattern())) {
                    ++counter;
                }
                if (currentLineNumber != this.$targetLineNumber && TextMateIndenterKt.matches(currentLineContent, TextMateIndenter.access$getIndentationRules$p(this.this$0).getIncreaseIndentPattern())) {
                    ++counter;
                }
                if (currentLineNumber != this.$startingLine && TextMateIndenterKt.matches(currentLineContent, TextMateIndenter.access$getIndentationRules$p(this.this$0).getDecreaseIndentPattern())) {
                    --counter;
                }
                return accumulatedDeltaIndent + counter;
            }
        })))).intValue();
        String resultingIndent = accumulatedIndentDifferenceSteps2 < 0 ? StringsKt.dropLast((String)referenceIndent, (int)(indentStep.length() * -1 * accumulatedIndentDifferenceSteps2)) : (accumulatedIndentDifferenceSteps2 > 0 ? referenceIndent + StringsKt.repeat((CharSequence)indentStep, (int)accumulatedIndentDifferenceSteps2) : referenceIndent);
        return new Indent(resultingIndent);
    }

    private final Indent indentExistingFirstLine(TextLines lines, String indentStep, int indentSize) {
        String lineContents = ((TextLine)lines.get(0)).toString();
        return new Indent(this.translateIntoLocalIndent(TextMateIndenterKt.getIndent(lineContents), indentStep, indentSize));
    }

    private final String translateIntoLocalIndent(String $this$translateIntoLocalIndent, String localIndentStep, int indentSize) {
        String string;
        if (!this.allSymbolsAreSame(localIndentStep)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (StringsKt.first((CharSequence)localIndentStep) == '\t') {
            String toReplace = StringsKt.repeat((CharSequence)" ", (int)indentSize);
            string = ((Object)StringsKt.reversed((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.reversed((CharSequence)$this$translateIntoLocalIndent)).toString(), (String)toReplace, (String)localIndentStep, (boolean)false, (int)4, null))).toString();
        } else {
            string = StringsKt.replace$default((String)$this$translateIntoLocalIndent, (String)"\t", (String)localIndentStep, (boolean)false, (int)4, null);
        }
        return string;
    }

    private final boolean allSymbolsAreSame(String $this$allSymbolsAreSame) {
        char[] cArray = $this$allSymbolsAreSame.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        return ArraysKt.distinct((char[])cArray).size() == 1;
    }

    public static final /* synthetic */ boolean access$hasMoreThanIndentation(TextMateIndenter $this, String $receiver) {
        return $this.hasMoreThanIndentation($receiver);
    }

    public static final /* synthetic */ IndentationRules access$getIndentationRules$p(TextMateIndenter $this) {
        return $this.indentationRules;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lfleet/plugins/textmate/frontend/TextMateIndenter$Companion;", "", "<init>", "()V", "EMPTY_INDENT", "Lfleet/frontend/lang/Indent;", "getEMPTY_INDENT", "()Lfleet/frontend/lang/Indent;", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "fleet.plugins.textmate.frontend"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Indent getEMPTY_INDENT() {
            return EMPTY_INDENT;
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndentingMode.values().length];
            try {
                nArray[IndentingMode.ADJUST_ON_ENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentingMode.ADJUST_EXISTING_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

