/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.IdentityHashCodeKt;
import androidx.compose.runtime.collection.IdentityArraySet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0011\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u001dH\u0082\bJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010$\u001a\u00020\u001dH\u0002J\u001b\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u0011\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0002H\u0086\u0002J7\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020\u00022!\u0010/\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b()\u0012\u0004\u0012\u00020.00H\u0086\b\u00f8\u0001\u0000J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010(\u001a\u00020\u0002H\u0002J\u0006\u00104\u001a\u00020.J\u001b\u00105\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J/\u00106\u001a\u00020.2!\u00107\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b()\u0012\u0004\u0012\u00020'00H\u0086\b\u00f8\u0001\u0000J\u0013\u00108\u001a\u00020.2\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u00109J#\u0010:\u001a\u00020.2\u0018\u0010;\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0004\u0012\u00020.00H\u0082\bJ\u0012\u0010<\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010?\u001a\u00020\u001dH\u0002R$\u0010\u0005\u001a\u00020\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR.\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\u0013\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R4\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00150\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\u001b\u0012\u0004\b\u0016\u0010\u0004\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u001d8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001e\u0010\u0004\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006@"}, d2={"Landroidx/compose/runtime/collection/IdentityScopeMap;", "T", "", "<init>", "()V", "valueOrder", "", "getValueOrder$annotations", "getValueOrder", "()[I", "setValueOrder", "([I)V", "values", "", "getValues$annotations", "getValues", "()[Ljava/lang/Object;", "setValues", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "scopeSets", "Landroidx/compose/runtime/collection/IdentityArraySet;", "getScopeSets$annotations", "getScopeSets", "()[Landroidx/compose/runtime/collection/IdentityArraySet;", "setScopeSets", "([Landroidx/compose/runtime/collection/IdentityArraySet;)V", "[Landroidx/compose/runtime/collection/IdentityArraySet;", "size", "", "getSize$annotations", "getSize", "()I", "setSize", "(I)V", "valueAt", "index", "scopeSetAt", "add", "", "value", "scope", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "contains", "element", "forEachScopeOf", "", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "getOrCreateIdentitySet", "clear", "remove", "removeValueIf", "predicate", "removeScope", "(Ljava/lang/Object;)V", "removingScopes", "removalOperation", "find", "findExactIndex", "midIndex", "valueHash", "fleet.noria.cells"})
@SourceDebugExtension(value={"SMAP\nIdentityScopeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityScopeMap.kt\nandroidx/compose/runtime/collection/IdentityScopeMap\n+ 2 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n*L\n1#1,315:1\n236#1,5:322\n241#1,17:343\n236#1,22:360\n61#1:382\n61#1:383\n61#1:384\n108#2,6:316\n265#2,16:327\n*S KotlinDebug\n*F\n+ 1 IdentityScopeMap.kt\nandroidx/compose/runtime/collection/IdentityScopeMap\n*L\n220#1:322,5\n220#1:343,17\n230#1:360,22\n270#1:382\n292#1:383\n302#1:384\n91#1:316,6\n221#1:327,16\n*E\n"})
public final class IdentityScopeMap<T> {
    @NotNull
    private int[] valueOrder;
    @NotNull
    private Object[] values;
    @NotNull
    private IdentityArraySet<T>[] scopeSets;
    private int size;

    public IdentityScopeMap() {
        int n = 0;
        int[] nArray = new int[50];
        IdentityScopeMap identityScopeMap = this;
        while (n < 50) {
            int n2;
            nArray[n2] = n2 = n++;
        }
        identityScopeMap.valueOrder = nArray;
        this.values = new Object[50];
        this.scopeSets = new IdentityArraySet[50];
    }

    @NotNull
    public final int[] getValueOrder() {
        return this.valueOrder;
    }

    public final void setValueOrder(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.valueOrder = nArray;
    }

    @PublishedApi
    public static /* synthetic */ void getValueOrder$annotations() {
    }

    @NotNull
    public final Object[] getValues() {
        return this.values;
    }

    public final void setValues(@NotNull Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.values = objectArray;
    }

    @PublishedApi
    public static /* synthetic */ void getValues$annotations() {
    }

    @NotNull
    public final IdentityArraySet<T>[] getScopeSets() {
        return this.scopeSets;
    }

    public final void setScopeSets(@NotNull IdentityArraySet<T>[] identityArraySetArray) {
        Intrinsics.checkNotNullParameter(identityArraySetArray, (String)"<set-?>");
        this.scopeSets = identityArraySetArray;
    }

    @PublishedApi
    public static /* synthetic */ void getScopeSets$annotations() {
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @PublishedApi
    public static /* synthetic */ void getSize$annotations() {
    }

    private final Object valueAt(int index) {
        boolean $i$f$valueAt = false;
        Object object = this.values[this.valueOrder[index]];
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final IdentityArraySet<T> scopeSetAt(int index) {
        IdentityArraySet<T> identityArraySet = this.scopeSets[this.valueOrder[index]];
        Intrinsics.checkNotNull(identityArraySet);
        return identityArraySet;
    }

    public final boolean add(@NotNull Object value, @NotNull T scope) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        IdentityArraySet<T> valueSet = this.getOrCreateIdentitySet(value);
        return valueSet.add(scope);
    }

    public final boolean contains(@NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.find(element) >= 0;
    }

    public final void forEachScopeOf(@NotNull Object value, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachScopeOf = false;
        int index = this.find(value);
        if (index >= 0) {
            IdentityArraySet this_$iv = this.scopeSetAt(index);
            boolean $i$f$fastForEach = false;
            Object[] values$iv = this_$iv.getValues();
            int n = this_$iv.size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Object object = values$iv[i$iv];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                block.invoke(object);
            }
        }
    }

    private final IdentityArraySet<T> getOrCreateIdentitySet(Object value) {
        int index = 0;
        if (this.size > 0) {
            index = this.find(value);
            if (index >= 0) {
                return this.scopeSetAt(index);
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        if (this.size < this.valueOrder.length) {
            IdentityArraySet<T> scopeSet;
            int valueIndex = this.valueOrder[this.size];
            this.values[valueIndex] = value;
            IdentityArraySet<T> identityArraySet = this.scopeSets[valueIndex];
            if (identityArraySet == null) {
                IdentityArraySet identityArraySet2;
                IdentityArraySet it = identityArraySet2 = new IdentityArraySet();
                boolean bl = false;
                this.scopeSets[valueIndex] = it;
                identityArraySet = scopeSet = identityArraySet2;
            }
            if (insertIndex < this.size) {
                ArraysKt.copyInto((int[])this.valueOrder, (int[])this.valueOrder, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
            }
            this.valueOrder[insertIndex] = valueIndex;
            int n = this.size;
            this.size = n + 1;
            return scopeSet;
        }
        int newSize = this.valueOrder.length * 2;
        int valueIndex = this.size;
        IdentityArraySet<T>[] identityArraySetArray = Arrays.copyOf(this.scopeSets, newSize);
        Intrinsics.checkNotNullExpressionValue(identityArraySetArray, (String)"copyOf(...)");
        this.scopeSets = identityArraySetArray;
        IdentityArraySet scopeSet = new IdentityArraySet();
        this.scopeSets[valueIndex] = scopeSet;
        Object[] objectArray = Arrays.copyOf(this.values, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        this.values = objectArray;
        this.values[valueIndex] = value;
        int[] newKeyOrder = new int[newSize];
        for (int i = this.size + 1; i < newSize; ++i) {
            newKeyOrder[i] = i;
        }
        if (insertIndex < this.size) {
            ArraysKt.copyInto((int[])this.valueOrder, (int[])newKeyOrder, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
        }
        newKeyOrder[insertIndex] = valueIndex;
        if (insertIndex > 0) {
            ArraysKt.copyInto$default((int[])this.valueOrder, (int[])newKeyOrder, (int)0, (int)0, (int)insertIndex, (int)6, null);
        }
        this.valueOrder = newKeyOrder;
        int n = this.size;
        this.size = n + 1;
        return scopeSet;
    }

    public final void clear() {
        int n = this.scopeSets.length;
        for (int i = 0; i < n; ++i) {
            IdentityArraySet<T> identityArraySet = this.scopeSets[i];
            if (identityArraySet != null) {
                identityArraySet.clear();
            }
            this.valueOrder[i] = i;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public final boolean remove(@NotNull Object value, @NotNull T scope) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        int index = this.find(value);
        if (index >= 0) {
            int valueOrderIndex = this.valueOrder[index];
            IdentityArraySet<T> identityArraySet = this.scopeSets[valueOrderIndex];
            if (identityArraySet == null) {
                return false;
            }
            IdentityArraySet<T> set2 = identityArraySet;
            boolean removed = set2.remove(scope);
            if (set2.size() == 0) {
                int startIndex = index + 1;
                int endIndex = this.size;
                if (startIndex < endIndex) {
                    ArraysKt.copyInto((int[])this.valueOrder, (int[])this.valueOrder, (int)index, (int)startIndex, (int)endIndex);
                }
                this.valueOrder[this.size - 1] = valueOrderIndex;
                this.values[valueOrderIndex] = null;
                int n = this.size;
                this.size = n + -1;
            }
            return removed;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function1<? super T, Boolean> predicate) {
        int i$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeValueIf = false;
        IdentityScopeMap this_$iv = this;
        boolean $i$f$removingScopes = false;
        int destinationIndex$iv = 0;
        int n = this_$iv.getSize();
        for (i$iv = 0; i$iv < n; ++i$iv) {
            int i$iv2;
            IdentityArraySet<T> set$iv;
            int valueIndex$iv = this_$iv.getValueOrder()[i$iv];
            Intrinsics.checkNotNull(this_$iv.getScopeSets()[valueIndex$iv]);
            IdentityArraySet<T> scopeSet = set$iv;
            boolean bl = false;
            IdentityArraySet<T> this_$iv2 = scopeSet;
            boolean $i$f$removeValueIf2 = false;
            int destinationIndex$iv2 = 0;
            int n2 = this_$iv2.size();
            for (i$iv2 = 0; i$iv2 < n2; ++i$iv2) {
                Object item$iv;
                Intrinsics.checkNotNull((Object)this_$iv2.getValues()[i$iv2], (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                if (((Boolean)predicate.invoke(item$iv)).booleanValue()) continue;
                if (destinationIndex$iv2 != i$iv2) {
                    this_$iv2.getValues()[destinationIndex$iv2] = item$iv;
                }
                ++destinationIndex$iv2;
            }
            n2 = this_$iv2.size();
            for (i$iv2 = destinationIndex$iv2; i$iv2 < n2; ++i$iv2) {
                this_$iv2.getValues()[i$iv2] = null;
            }
            IdentityArraySet.access$setSize$p(this_$iv2, destinationIndex$iv2);
            if (set$iv.size() <= 0) continue;
            if (destinationIndex$iv != i$iv) {
                int destinationKeyOrder$iv = this_$iv.getValueOrder()[destinationIndex$iv];
                this_$iv.getValueOrder()[destinationIndex$iv] = valueIndex$iv;
                this_$iv.getValueOrder()[i$iv] = destinationKeyOrder$iv;
            }
            ++destinationIndex$iv;
        }
        n = this_$iv.getSize();
        for (i$iv = destinationIndex$iv; i$iv < n; ++i$iv) {
            this_$iv.getValues()[this_$iv.getValueOrder()[i$iv]] = null;
        }
        this_$iv.setSize(destinationIndex$iv);
    }

    public final void removeScope(@NotNull T scope) {
        int i$iv;
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        IdentityScopeMap this_$iv = this;
        boolean $i$f$removingScopes = false;
        int destinationIndex$iv = 0;
        int n = this_$iv.getSize();
        for (i$iv = 0; i$iv < n; ++i$iv) {
            IdentityArraySet<T> set$iv;
            int valueIndex$iv = this_$iv.getValueOrder()[i$iv];
            Intrinsics.checkNotNull(this_$iv.getScopeSets()[valueIndex$iv]);
            IdentityArraySet<T> scopeSet = set$iv;
            boolean bl = false;
            scopeSet.remove(scope);
            if (set$iv.size() <= 0) continue;
            if (destinationIndex$iv != i$iv) {
                int destinationKeyOrder$iv = this_$iv.getValueOrder()[destinationIndex$iv];
                this_$iv.getValueOrder()[destinationIndex$iv] = valueIndex$iv;
                this_$iv.getValueOrder()[i$iv] = destinationKeyOrder$iv;
            }
            ++destinationIndex$iv;
        }
        n = this_$iv.getSize();
        for (i$iv = destinationIndex$iv; i$iv < n; ++i$iv) {
            this_$iv.getValues()[this_$iv.getValueOrder()[i$iv]] = null;
        }
        this_$iv.setSize(destinationIndex$iv);
    }

    private final void removingScopes(Function1<? super IdentityArraySet<T>, Unit> removalOperation) {
        int i;
        boolean $i$f$removingScopes = false;
        int destinationIndex = 0;
        int n = this.getSize();
        for (i = 0; i < n; ++i) {
            IdentityArraySet<T> set2;
            int valueIndex = this.getValueOrder()[i];
            Intrinsics.checkNotNull(this.getScopeSets()[valueIndex]);
            removalOperation.invoke(set2);
            if (set2.size() <= 0) continue;
            if (destinationIndex != i) {
                int destinationKeyOrder = this.getValueOrder()[destinationIndex];
                this.getValueOrder()[destinationIndex] = valueIndex;
                this.getValueOrder()[i] = destinationKeyOrder;
            }
            ++destinationIndex;
        }
        n = this.getSize();
        for (i = destinationIndex; i < n; ++i) {
            this.getValues()[this.getValueOrder()[i]] = null;
        }
        this.setSize(destinationIndex);
    }

    private final int find(Object value) {
        int valueIdentity = IdentityHashCodeKt.identityHashCode(value);
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            Object midValue;
            int mid = low + high >>> 1;
            IdentityScopeMap this_$iv = this;
            boolean $i$f$valueAt = false;
            Intrinsics.checkNotNull((Object)this_$iv.values[this_$iv.valueOrder[mid]]);
            int midValHash = IdentityHashCodeKt.identityHashCode(midValue);
            if (midValHash < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midValHash > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (value == midValue) {
                return mid;
            }
            return this.findExactIndex(mid, value, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        int i;
        for (i = midIndex - 1; -1 < i; --i) {
            Object v;
            IdentityScopeMap this_$iv = this;
            boolean $i$f$valueAt = false;
            Intrinsics.checkNotNull((Object)this_$iv.values[this_$iv.valueOrder[i]]);
            if (v == value) {
                return i;
            }
            if (IdentityHashCodeKt.identityHashCode(v) != valueHash) break;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object v;
            IdentityScopeMap this_$iv = this;
            boolean $i$f$valueAt = false;
            Intrinsics.checkNotNull((Object)this_$iv.values[this_$iv.valueOrder[i]]);
            if (v == value) {
                return i;
            }
            if (IdentityHashCodeKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(this.size + 1);
    }
}

