/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.frontend.schema;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.mercury.frontend.schema.AbstractMercuryTestConfigurationStructureAnalyserBase;
import fleet.mercury.frontend.schema.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lfleet/mercury/frontend/schema/AndroidTestConfigurationStructureAnalyser;", "Lfleet/mercury/frontend/schema/AbstractMercuryTestConfigurationStructureAnalyserBase;", "<init>", "()V", "validate", "", "keyName", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "fleet.plugins.mercury.frontend"})
public final class AndroidTestConfigurationStructureAnalyser
extends AbstractMercuryTestConfigurationStructureAnalyserBase {
    @NotNull
    public static final AndroidTestConfigurationStructureAnalyser INSTANCE = new AndroidTestConfigurationStructureAnalyser();

    private AndroidTestConfigurationStructureAnalyser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected String validate(@Nullable String keyName, @NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = keyName;
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 1542179859: {
                if (string.equals("testMethod")) {
                    n = 1;
                }
                break;
            }
            case -1199661228: {
                if (string.equals("testPackage")) {
                    n = 2;
                }
                break;
            }
            case -1206222842: {
                if (string.equals("testClass")) {
                    n = 3;
                }
                break;
            }
            case -1192573227: {
                if (string.equals("testRegex")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                if (UtilKt.siblingPropertyValue(node, "testRegex") != null) {
                    return "'testClass' cannot be declared simultaneously with a 'testRegex'";
                }
                if (UtilKt.siblingPropertyValue(node, "testPackage") == null) return null;
                return "'testClass' cannot be declared simultaneously with a 'testPackage'";
            }
            case 2: {
                if (UtilKt.siblingPropertyValue(node, "testRegex") != null) {
                    return "'testPackage' cannot be declared simultaneously with a 'testRegex'";
                }
                if (UtilKt.siblingPropertyValue(node, "testClass") == null) return null;
                return "'testPackage' cannot be declared simultaneously with a 'testClass'";
            }
            case 4: {
                if (UtilKt.siblingPropertyValue(node, "testPackage") != null) {
                    return "'testRegex' cannot be declared simultaneously with a 'testPackage'";
                }
                if (UtilKt.siblingPropertyValue(node, "testClass") == null) return null;
                return "'testRegex' cannot be declared simultaneously with a 'testClass'";
            }
            case 1: {
                if (UtilKt.siblingPropertyValue(node, "testClass") != null) return null;
                return "'testMethod' requires a 'testClass' to be present";
            }
            default: {
                return null;
            }
        }
    }
}

