/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.frontend;

import andel.text.Text;
import andel.text.TextRange;
import fleet.api.FileAddress;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigs;
import fleet.frontend.lang.FoldableNodeAspect;
import fleet.frontend.lang.Indent;
import fleet.frontend.lang.NodeIndentAspect;
import fleet.mercury.frontend.SwiftSwitchCaseBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lfleet/mercury/frontend/SwiftSwitchCaseBlock;", "Lfleet/frontend/lang/NodeIndentAspect;", "Lfleet/frontend/lang/FoldableNodeAspect;", "<init>", "()V", "foldableRegions", "", "Landel/text/TextRange;", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "placeholder", "", "indentForChild", "Lfleet/frontend/lang/Indent;", "parent", "child", "lineStart", "", "Landel/text/CharOffset;", "text", "Landel/text/Text;", "path", "Lfleet/api/FileAddress;", "editorConfig", "Lfleet/frontend/editor/editorconfig/EditorConfigs;", "showGuide", "", "getShowGuide", "()Z", "fleet.plugins.mercury.frontend"})
final class SwiftSwitchCaseBlock
implements NodeIndentAspect,
FoldableNodeAspect {
    private final boolean showGuide;

    public SwiftSwitchCaseBlock() {
        this.showGuide = true;
    }

    @NotNull
    public List<TextRange> foldableRegions(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SyntaxNode syntaxNode = node.firstChild();
        if (syntaxNode == null) {
            return CollectionsKt.emptyList();
        }
        long startOffset = syntaxNode.getEndOffset();
        return CollectionsKt.listOf((Object)new TextRange(startOffset, node.getEndOffset()));
    }

    @NotNull
    public String placeholder(@NotNull SyntaxNode node) {
        String string;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SyntaxNode syntaxNode = (SyntaxNode)SequencesKt.singleOrNull((Sequence)SequencesKt.drop((Sequence)SequencesKt.filterNot((Sequence)SyntaxNodeExtKt.children((SyntaxNode)node), (Function1)placeholder.1.INSTANCE), (int)1));
        return syntaxNode != null && (charSequence = syntaxNode.getText()) != null && (string = ((Object)charSequence).toString()) != null ? string : "...";
    }

    @NotNull
    public Indent indentForChild(@NotNull SyntaxNode parent2, @Nullable SyntaxNode child, long lineStart, @NotNull Text text, @Nullable FileAddress path, @NotNull EditorConfigs editorConfig) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        return Indent.Companion.createIndent(editorConfig, path, parent2, text, EditorConfigExtKt.indentSize((EditorConfigs)editorConfig, (FileAddress)path));
    }

    public boolean getShowGuide() {
        return this.showGuide;
    }

    public boolean defaultFolded(@NotNull SyntaxNode node, @NotNull TextRange textRange) {
        return FoldableNodeAspect.DefaultImpls.defaultFolded((FoldableNodeAspect)this, (SyntaxNode)node, (TextRange)textRange);
    }
}

