/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.descriptor;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssElementDescriptor {

    public static enum CssVersion {
        UNKNOWN("UNKNOWN", 0),
        CSS_1("CSS 1.0", 1),
        CSS_2("CSS 2.0", 2),
        CSS_2_1("CSS 2.1", 3),
        CSS_3_0("CSS 3.0", 4),
        CSS_4_0("CSS 4.0", 5),
        CSS_3_0_MOZILLA("CSS3 Mozilla", 0),
        CSS_3_0_SAFARI("CSS3 Safari", 0),
        CSS_3_0_OPERA("CSS3 Opera", 0);

        @NotNull
        private final String myPresentableName;
        private final int myValue;

        private CssVersion(String presentableName, int myValue) {
            this.myPresentableName = presentableName;
            this.myValue = myValue;
        }

        @NotNull
        public String getPresentableName() {
            return this.myPresentableName;
        }

        @NotNull
        public static CssVersion fromString(@Nullable String string) {
            if ("1.0".equals(string)) {
                return CSS_1;
            }
            if ("2.0".equals(string)) {
                return CSS_2;
            }
            if ("2.1".equals(string)) {
                return CSS_2_1;
            }
            if ("3.0".equals(string)) {
                return CSS_3_0;
            }
            if ("4.0".equals(string)) {
                return CSS_4_0;
            }
            return UNKNOWN;
        }

        public int value() {
            return this.myValue;
        }
    }
}

