/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.core;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusProperties;
import androidx.compose.ui.focus.FocusPropertiesImpl;
import androidx.compose.ui.focus.FocusState;
import androidx.compose.ui.focus.FocusStateImpl;
import fleet.compose.foundation.FocusDataContext;
import fleet.compose.foundation.MetaData;
import fleet.preferences.FleetPropertiesKt;
import fleet.util.openmap.BoundedOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.Bindings;
import noria.ClosureContext;
import noria.ID;
import noria.ui.core.FocusKt;
import noria.ui.core.Node;
import noria.ui.core.NoriaLogger;
import noria.ui.core.Selector;
import noria.ui.loop.RenderLoopKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004:;<=B+\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0007J\u0014\u0010\u001f\u001a\u00020\u00132\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J\u0006\u0010\"\u001a\u00020\u0013J\r\u0010-\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b1R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00008VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010'R\u0012\u00102\u001a\u000203X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u000207X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u0082\u0001\u0004>3!?\u00a8\u0006@"}, d2={"Lnoria/ui/core/FocusNode;", "Lnoria/ui/core/Node;", "parent", "debugName", "", "debugLocation", "Lnoria/ui/core/DebugLocation;", "layerIndex", "", "<init>", "(Lnoria/ui/core/FocusNode;Ljava/lang/String;Ljava/lang/Object;I)V", "getDebugName", "()Ljava/lang/String;", "getDebugLocation-KfPC8fY", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getLayerIndex", "()I", "value", "", "detached", "getDetached", "()Z", "getParent", "()Lnoria/ui/core/FocusNode;", "setParent", "(Lnoria/ui/core/FocusNode;)V", "detach", "", "composeFocusState", "Landroidx/compose/ui/focus/FocusState;", "hasFocusedDescendant", "selectedNode", "Lnoria/ui/core/FocusNode$Target;", "isTraversable", "debugChildrenLayoutIDs", "", "Lnoria/ID;", "getDebugChildrenLayoutIDs", "()Ljava/util/List;", "childrenLayoutIDs", "", "mutableChildren", "children", "getChildren", "clearChildren", "clearChildren$fleet_noria_ui", "addChild", "focusNode", "addChild$fleet_noria_ui", "root", "Lnoria/ui/core/FocusNode$Root;", "getRoot", "()Lnoria/ui/core/FocusNode$Root;", "layerRoot", "Lnoria/ui/core/Selector;", "getLayerRoot", "()Lnoria/ui/core/Selector;", "Root", "Target", "Data", "Transparent", "Lnoria/ui/core/FocusNode$Data;", "Lnoria/ui/core/FocusNode$Transparent;", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nFocus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Focus.kt\nnoria/ui/core/FocusNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,980:1\n1#2:981\n1755#3,3:982\n*S KotlinDebug\n*F\n+ 1 Focus.kt\nnoria/ui/core/FocusNode\n*L\n165#1:982,3\n*E\n"})
public abstract class FocusNode
implements Node {
    @NotNull
    private final String debugName;
    @NotNull
    private final Object debugLocation;
    private final int layerIndex;
    private boolean detached;
    @Nullable
    private FocusNode parent;
    @NotNull
    private final List<ID> childrenLayoutIDs;
    @NotNull
    private final List<FocusNode> mutableChildren;

    private FocusNode(FocusNode parent, String debugName, Object debugLocation, int layerIndex) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter((Object)debugLocation, (String)"debugLocation");
        this.debugName = debugName;
        this.debugLocation = debugLocation;
        this.layerIndex = layerIndex;
        this.parent = parent;
        this.childrenLayoutIDs = new ArrayList();
        this.mutableChildren = new ArrayList();
    }

    @NotNull
    public final String getDebugName() {
        return this.debugName;
    }

    @NotNull
    public final Object getDebugLocation-KfPC8fY() {
        return this.debugLocation;
    }

    public final int getLayerIndex() {
        return this.layerIndex;
    }

    public final boolean getDetached() {
        return this.detached;
    }

    @Override
    @Nullable
    public FocusNode getParent() {
        if (!(!this.detached)) {
            boolean bl = false;
            String string = "Cannot read the parent of a detached focus node";
            throw new IllegalStateException(string.toString());
        }
        return this.parent;
    }

    public void setParent(@Nullable FocusNode focusNode2) {
        this.parent = focusNode2;
    }

    public final void detach() {
        if (!this.detached) {
            if (this instanceof Target) {
                if (((Target)this).isLayerRoot()) {
                    Root root2 = ((Target)this).getRoot();
                    root2.setLayerRoots(CollectionsKt.minus((Iterable)root2.getLayerRoots(), (Object)this));
                }
                if (((Target)this).getState().isFocused()) {
                    RenderLoopKt.tryToInvalidateCurrentFrame(((Target)this).getBindings(), (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                        final /* synthetic */ FocusNode this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Boolean invoke() {
                            block9: {
                                block8: {
                                    block7: {
                                        if (!((Target)this.this$0).getState().isFocused()) break block8;
                                        var2_1 = FocusKt.access$selectedChild(((Target)this.this$0).getLayerRoot());
                                        if (var2_1 == null) ** GOTO lbl-1000
                                        var4_2 = var2_1;
                                        it = var4_2;
                                        $i$a$-takeIf-FocusNode$detach$1$successfullyRefocused$1 = false;
                                        v0 = var3_6 = it.getDetached() == false != false ? var4_2 : null;
                                        if (var3_6 != null) {
                                            v1 = FocusKt.requestFocus--OM-vw8$default(var3_6, FocusDirection.Companion.getEnter-dhqQ-8s(), null, 2, null);
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            it = FocusKt.access$selectableChildren(((Target)this.this$0).getLayerRoot());
                                            $i$f$any = false;
                                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                v1 = false;
                                            } else {
                                                for (T element$iv : $this$any$iv) {
                                                    it = (Target)element$iv;
                                                    $i$a$-any-FocusNode$detach$1$successfullyRefocused$2 = false;
                                                    if (!(it.getDetached() == false && FocusKt.requestFocus--OM-vw8$default(it, FocusDirection.Companion.getEnter-dhqQ-8s(), null, 2, null) != false)) continue;
                                                    v1 = true;
                                                    break block7;
                                                }
                                                v1 = successfullyRefocused = false;
                                            }
                                        }
                                    }
                                    if (!successfullyRefocused) {
                                        this_$iv = NoriaLogger.INSTANCE.getLogger();
                                        $i$f$warn = false;
                                        if (this_$iv.isWarnEnabled()) {
                                            var11_13 = this_$iv;
                                            $i$a$-warn-FocusNode$detach$1$1 = false;
                                            var11_13.warn((Object)"Could not find a valid focus target to focus after currently focused target left the composition; clearing focus in the entire layer. This might be unexpected and will require explicit refocusing.");
                                        }
                                        ((Target)this.this$0).getLayerRoot().clearSubtreeSelection();
                                    }
                                    v2 = true;
                                    break block9;
                                }
                                v2 = false;
                            }
                            return v2;
                        }
                    }));
                }
            }
            this.mutableChildren.clear();
            Object object = this.getParent();
            if (object != null && (object = ((FocusNode)object).mutableChildren) != null) {
                object.remove(this);
            }
            this.setParent(null);
            this.detached = true;
        }
    }

    @Composable
    @NotNull
    public final FocusState composeFocusState() {
        FocusState focusState2;
        if (this.detached) {
            focusState2 = FocusStateImpl.Inactive;
        } else if (!FocusKt.hasFocusInLayer(this)) {
            focusState2 = FocusStateImpl.Inactive;
        } else if (FocusNode.hasFocusedDescendant$default(this, null, 1, null)) {
            focusState2 = FocusStateImpl.ActiveParent;
        } else {
            Target target2 = FocusKt.selfOrParentTarget(this);
            focusState2 = (target2 != null ? target2.getCanFocus() : false) ? (FocusState)FocusStateImpl.Active : (FocusState)FocusStateImpl.Inactive;
        }
        return focusState2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Composable
    public final boolean hasFocusedDescendant(@Nullable Target selectedNode) {
        boolean bl;
        Iterable $this$any$iv = this.getChildren();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FocusNode child2 = (FocusNode)element$iv;
            boolean bl2 = false;
            if (child2.detached) {
                bl = false;
                continue;
            }
            if (child2 instanceof Target) {
                if (Intrinsics.areEqual((Object)child2, (Object)selectedNode)) {
                    if (((Target)child2).getCanFocus()) return true;
                    Target $this$hasFocusedDescendant_u24lambda_u243_u24lambda_u241 = (Target)child2;
                    boolean bl3 = false;
                    if (FocusNode.hasFocusedDescendant$default($this$hasFocusedDescendant_u24lambda_u243_u24lambda_u241, null, 1, null)) {
                        return true;
                    }
                }
                bl = false;
                continue;
            }
            if (child2 instanceof Transparent) {
                Transparent $this$hasFocusedDescendant_u24lambda_u243_u24lambda_u242 = (Transparent)child2;
                boolean bl4 = false;
                bl = $this$hasFocusedDescendant_u24lambda_u243_u24lambda_u242.hasFocusedDescendant(selectedNode);
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static /* synthetic */ boolean hasFocusedDescendant$default(FocusNode focusNode2, Target target2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hasFocusedDescendant");
        }
        if ((n & 1) != 0) {
            target2 = FocusKt.selfOrParentSelector(focusNode2).getSelectedNode();
        }
        return focusNode2.hasFocusedDescendant(target2);
    }

    public final boolean isTraversable() {
        boolean bl;
        if (this.detached) {
            bl = false;
        } else {
            Target target2 = FocusKt.selfOrParentTarget(this);
            if (target2 != null) {
                Target currentTarget = target2;
                boolean bl2 = false;
                Selector selector = FocusKt.access$selector(currentTarget);
                if (selector instanceof Target && ((Target)selector).isLayerRoot()) {
                    bl = true;
                } else {
                    Target target3 = FocusKt.selfOrParentTarget(selector);
                    bl = target3 != null ? target3.isTraversable() : true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final List<ID> getDebugChildrenLayoutIDs() {
        return this.childrenLayoutIDs;
    }

    @NotNull
    public List<FocusNode> getChildren() {
        return this.mutableChildren;
    }

    public final void clearChildren$fleet_noria_ui() {
        this.mutableChildren.clear();
        this.childrenLayoutIDs.clear();
    }

    public final void addChild$fleet_noria_ui(@NotNull FocusNode focusNode2) {
        Intrinsics.checkNotNullParameter((Object)focusNode2, (String)"focusNode");
        if (FleetPropertiesKt.isFleetDebugMode() && !(!this.mutableChildren.contains(focusNode2))) {
            boolean bl = false;
            String string = "Attempted to add FocusNode as a child twice: " + focusNode2 + " from " + focusNode2.debugLocation;
            throw new IllegalArgumentException(string.toString());
        }
        this.mutableChildren.add(focusNode2);
    }

    @NotNull
    public abstract Root getRoot();

    @NotNull
    public abstract Selector getLayerRoot();

    public /* synthetic */ FocusNode(FocusNode parent, String debugName, Object debugLocation, int layerIndex, DefaultConstructorMarker $constructor_marker) {
        this(parent, debugName, debugLocation, layerIndex);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R+\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lnoria/ui/core/FocusNode$Data;", "Lnoria/ui/core/FocusNode;", "parent", "debugLocation", "Lnoria/ui/core/DebugLocation;", "<init>", "(Lnoria/ui/core/FocusNode;Ljava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "data", "Lkotlin/Function1;", "Lfleet/compose/foundation/FocusDataContext;", "", "Lkotlin/ExtensionFunctionType;", "getData", "()Lkotlin/jvm/functions/Function1;", "setData", "(Lkotlin/jvm/functions/Function1;)V", "root", "Lnoria/ui/core/FocusNode$Root;", "getRoot", "()Lnoria/ui/core/FocusNode$Root;", "layerRoot", "Lnoria/ui/core/Selector;", "getLayerRoot", "()Lnoria/ui/core/Selector;", "fleet.noria.ui"})
    public static final class Data
    extends FocusNode {
        public Function1<? super FocusDataContext, Unit> data;
        @NotNull
        private final Root root;
        @NotNull
        private final Selector layerRoot;

        private Data(FocusNode parent, Object debugLocation) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)debugLocation, (String)"debugLocation");
            super(parent, "data", debugLocation, parent.getLayerIndex(), null);
            this.root = parent.getRoot();
            this.layerRoot = parent.getLayerRoot();
        }

        @NotNull
        public final Function1<FocusDataContext, Unit> getData() {
            Function1<? super FocusDataContext, Unit> function1 = this.data;
            if (function1 != null) {
                return function1;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            return null;
        }

        public final void setData(@NotNull Function1<? super FocusDataContext, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.data = function1;
        }

        @Override
        @NotNull
        public Root getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public Selector getLayerRoot() {
            return this.layerRoot;
        }

        public /* synthetic */ Data(FocusNode parent, Object debugLocation, DefaultConstructorMarker $constructor_marker) {
            this(parent, debugLocation);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R/\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00158B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR7\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150!2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150!8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u001c\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lnoria/ui/core/FocusNode$Root;", "Lnoria/ui/core/FocusNode;", "Lnoria/ui/core/Selector;", "debugName", "", "debugLocation", "Lnoria/ui/core/DebugLocation;", "windowFocused", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getWindowFocused", "()Lkotlin/jvm/functions/Function0;", "root", "getRoot", "()Lnoria/ui/core/FocusNode$Root;", "layerRoot", "getLayerRoot", "()Lnoria/ui/core/Selector;", "<set-?>", "Lnoria/ui/core/FocusNode$Target;", "backingSelectedNode", "getBackingSelectedNode", "()Lnoria/ui/core/FocusNode$Target;", "setBackingSelectedNode", "(Lnoria/ui/core/FocusNode$Target;)V", "backingSelectedNode$delegate", "Landroidx/compose/runtime/MutableState;", "value", "selectedNode", "getSelectedNode", "setSelectedNode", "", "layerRoots", "getLayerRoots", "()Ljava/util/List;", "setLayerRoots", "(Ljava/util/List;)V", "layerRoots$delegate", "eventReceivers", "", "getEventReceivers", "()Ljava/lang/Iterable;", "fleet.noria.ui"})
    @SourceDebugExtension(value={"SMAP\nFocus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Focus.kt\nnoria/ui/core/FocusNode$Root\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n*L\n1#1,980:1\n68#2:981\n94#2,2:982\n68#2:984\n94#2,2:985\n1053#3:987\n72#4,6:988\n*S KotlinDebug\n*F\n+ 1 Focus.kt\nnoria/ui/core/FocusNode$Root\n*L\n232#1:981\n232#1:982,2\n239#1:984\n239#1:985,2\n245#1:987\n245#1:988,6\n*E\n"})
    public static final class Root
    extends FocusNode
    implements Selector {
        @NotNull
        private final Function0<Boolean> windowFocused;
        @NotNull
        private final MutableState backingSelectedNode$delegate;
        @NotNull
        private final MutableState layerRoots$delegate;

        private Root(String debugName, Object debugLocation, Function0<Boolean> windowFocused) {
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter((Object)debugLocation, (String)"debugLocation");
            Intrinsics.checkNotNullParameter(windowFocused, (String)"windowFocused");
            super(null, debugName, debugLocation, 0, null);
            this.windowFocused = windowFocused;
            this.backingSelectedNode$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
            this.layerRoots$delegate = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        }

        @NotNull
        public final Function0<Boolean> getWindowFocused() {
            return this.windowFocused;
        }

        @Override
        @NotNull
        public Root getRoot() {
            return this;
        }

        @Override
        @NotNull
        public Selector getLayerRoot() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final Target getBackingSelectedNode() {
            void $this$getValue$iv;
            State state2 = (State)this.backingSelectedNode$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (Target)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void setBackingSelectedNode(Target target2) {
            void $this$setValue$iv;
            MutableState mutableState = this.backingSelectedNode$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue((Object)target2);
        }

        @Override
        @Nullable
        public Target getSelectedNode() {
            return this.getBackingSelectedNode();
        }

        @Override
        public void setSelectedNode(@Nullable Target value2) {
            this.setBackingSelectedNode(value2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Target> getLayerRoots() {
            void $this$getValue$iv;
            State state2 = (State)this.layerRoots$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (List)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setLayerRoots(@NotNull List<Target> list) {
            void $this$setValue$iv;
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            MutableState mutableState = this.layerRoots$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(list);
        }

        @NotNull
        public final Iterable<FocusNode> getEventReceivers() {
            Iterable $this$sortedBy$iv = this.getLayerRoots();
            boolean $i$f$sortedBy = false;
            Iterable $this$takeTillFirst$iv = CollectionsKt.plus((Collection)CollectionsKt.asReversed((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Target it = (Target)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getLayerIndex());
                    it = (Target)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLayerIndex()));
                }
            })), (Object)this);
            boolean $i$f$takeTillFirst = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeTillFirst$iv) {
                list$iv.add(item$iv);
                Node it = (Node)item$iv;
                boolean bl = false;
                if (!(it instanceof Target && ((Target)it).getModal())) continue;
            }
            return list$iv;
        }

        @Override
        public void select(@NotNull Target target2) {
            Selector.DefaultImpls.select(this, target2);
        }

        @Override
        public void clearSubtreeSelection() {
            Selector.DefaultImpls.clearSubtreeSelection(this);
        }

        public /* synthetic */ Root(String debugName, Object debugLocation, Function0 windowFocused, DefaultConstructorMarker $constructor_marker) {
            this(debugName, debugLocation, (Function0<Boolean>)windowFocused);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R/\u0010\u001b\u001a\u0004\u0018\u00010\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u00008V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R+\u0010&\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020(0'\u00a2\u0006\u0002\b)X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u00100\u001a\u00020/2\u0006\u0010.\u001a\u00020/@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R1\u00105\u001a\u0019\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020(06\u00a2\u0006\u0002\b)X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0012\u00a8\u0006>"}, d2={"Lnoria/ui/core/FocusNode$Target;", "Lnoria/ui/core/FocusNode;", "Lnoria/ui/core/Selector;", "parent", "debugName", "", "debugLocation", "Lnoria/ui/core/DebugLocation;", "bindings", "Lnoria/Bindings;", "modal", "", "isLayerRoot", "<init>", "(Lnoria/ui/core/FocusNode;Ljava/lang/String;Ljava/lang/Object;Lnoria/Bindings;ZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBindings", "()Lnoria/Bindings;", "getModal", "()Z", "root", "Lnoria/ui/core/FocusNode$Root;", "getRoot", "()Lnoria/ui/core/FocusNode$Root;", "layerRoot", "getLayerRoot", "()Lnoria/ui/core/Selector;", "<set-?>", "selectedNode", "getSelectedNode", "()Lnoria/ui/core/FocusNode$Target;", "setSelectedNode", "(Lnoria/ui/core/FocusNode$Target;)V", "selectedNode$delegate", "Landroidx/compose/runtime/MutableState;", "properties", "Landroidx/compose/ui/focus/FocusProperties;", "getProperties", "()Landroidx/compose/ui/focus/FocusProperties;", "propertyConfigurator", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getPropertyConfigurator$fleet_noria_ui", "()Lkotlin/jvm/functions/Function1;", "setPropertyConfigurator$fleet_noria_ui", "(Lkotlin/jvm/functions/Function1;)V", "value", "Landroidx/compose/ui/focus/FocusState;", "state", "getState", "()Landroidx/compose/ui/focus/FocusState;", "setState", "(Landroidx/compose/ui/focus/FocusState;)V", "changeListener", "Lkotlin/Function2;", "Lnoria/ClosureContext;", "getChangeListener$fleet_noria_ui", "()Lkotlin/jvm/functions/Function2;", "setChangeListener$fleet_noria_ui", "(Lkotlin/jvm/functions/Function2;)V", "canFocus", "getCanFocus", "fleet.noria.ui"})
    @SourceDebugExtension(value={"SMAP\nFocus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Focus.kt\nnoria/ui/core/FocusNode$Target\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,980:1\n68#2:981\n94#2,2:982\n*S KotlinDebug\n*F\n+ 1 Focus.kt\nnoria/ui/core/FocusNode$Target\n*L\n265#1:981\n265#1:982,2\n*E\n"})
    public static final class Target
    extends FocusNode
    implements Selector {
        @NotNull
        private final Bindings bindings;
        private final boolean modal;
        private final boolean isLayerRoot;
        @NotNull
        private final Root root;
        @NotNull
        private final Selector layerRoot;
        @NotNull
        private final MutableState selectedNode$delegate;
        public Function1<? super FocusProperties, Unit> propertyConfigurator;
        @NotNull
        private FocusState state;
        public Function2<? super ClosureContext, ? super FocusState, Unit> changeListener;

        private Target(FocusNode parent, String debugName, Object debugLocation, Bindings bindings, boolean modal, boolean isLayerRoot) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter((Object)debugLocation, (String)"debugLocation");
            Intrinsics.checkNotNullParameter((Object)bindings, (String)"bindings");
            super(parent, debugName, debugLocation, isLayerRoot ? parent.getLayerIndex() + 1 : parent.getLayerIndex(), null);
            this.bindings = bindings;
            this.modal = modal;
            this.isLayerRoot = isLayerRoot;
            this.root = parent.getRoot();
            this.layerRoot = this.isLayerRoot ? (Selector)this : parent.getLayerRoot();
            this.selectedNode$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
            this.state = FocusStateImpl.Inactive;
        }

        public /* synthetic */ Target(FocusNode focusNode2, String string, Object object, Bindings bindings, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            this(focusNode2, string, object, bindings, bl, bl2, null);
        }

        @NotNull
        public final Bindings getBindings() {
            return this.bindings;
        }

        public final boolean getModal() {
            return this.modal;
        }

        public final boolean isLayerRoot() {
            return this.isLayerRoot;
        }

        @Override
        @NotNull
        public Root getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public Selector getLayerRoot() {
            return this.layerRoot;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Target getSelectedNode() {
            void $this$getValue$iv;
            State state2 = (State)this.selectedNode$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (Target)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setSelectedNode(@Nullable Target target2) {
            void $this$setValue$iv;
            MutableState mutableState = this.selectedNode$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue((Object)target2);
        }

        @NotNull
        public final FocusProperties getProperties() {
            FocusPropertiesImpl focusPropertiesImpl = new FocusPropertiesImpl();
            this.getPropertyConfigurator$fleet_noria_ui().invoke((Object)focusPropertiesImpl);
            return focusPropertiesImpl;
        }

        @NotNull
        public final Function1<FocusProperties, Unit> getPropertyConfigurator$fleet_noria_ui() {
            Function1<? super FocusProperties, Unit> function1 = this.propertyConfigurator;
            if (function1 != null) {
                return function1;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"propertyConfigurator");
            return null;
        }

        public final void setPropertyConfigurator$fleet_noria_ui(@NotNull Function1<? super FocusProperties, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.propertyConfigurator = function1;
        }

        @NotNull
        public final FocusState getState() {
            return this.state;
        }

        public final void setState(@NotNull FocusState value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.state = value2;
            this.getChangeListener$fleet_noria_ui().invoke((Object)ClosureContext.Companion, (Object)value2);
        }

        @NotNull
        public final Function2<ClosureContext, FocusState, Unit> getChangeListener$fleet_noria_ui() {
            Function2<? super ClosureContext, ? super FocusState, Unit> function2 = this.changeListener;
            if (function2 != null) {
                return function2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeListener");
            return null;
        }

        public final void setChangeListener$fleet_noria_ui(@NotNull Function2<? super ClosureContext, ? super FocusState, Unit> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            this.changeListener = function2;
        }

        public final boolean getCanFocus() {
            return !this.getDetached() && this.getProperties().getCanFocus();
        }

        @Override
        public void select(@NotNull Target target2) {
            Selector.DefaultImpls.select(this, target2);
        }

        @Override
        public void clearSubtreeSelection() {
            Selector.DefaultImpls.clearSubtreeSelection(this);
        }

        public /* synthetic */ Target(FocusNode parent, String debugName, Object debugLocation, Bindings bindings, boolean modal, boolean isLayerRoot, DefaultConstructorMarker $constructor_marker) {
            this(parent, debugName, debugLocation, bindings, modal, isLayerRoot);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R0\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lnoria/ui/core/FocusNode$Transparent;", "Lnoria/ui/core/FocusNode;", "parent", "debugName", "", "debugLocation", "Lnoria/ui/core/DebugLocation;", "<init>", "(Lnoria/ui/core/FocusNode;Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "root", "Lnoria/ui/core/FocusNode$Root;", "getRoot", "()Lnoria/ui/core/FocusNode$Root;", "layerRoot", "Lnoria/ui/core/Selector;", "getLayerRoot", "()Lnoria/ui/core/Selector;", "meta", "Lfleet/util/openmap/BoundedOpenMap;", "Lfleet/compose/foundation/MetaData;", "", "Lfleet/util/openmap/OpenMap;", "getMeta", "()Lfleet/util/openmap/BoundedOpenMap;", "setMeta", "(Lfleet/util/openmap/BoundedOpenMap;)V", "fleet.noria.ui"})
    public static final class Transparent
    extends FocusNode {
        @NotNull
        private final Root root;
        @NotNull
        private final Selector layerRoot;
        @NotNull
        private BoundedOpenMap<MetaData, Object> meta;

        private Transparent(FocusNode parent, String debugName, Object debugLocation) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter((Object)debugLocation, (String)"debugLocation");
            super(parent, debugName, debugLocation, parent.getLayerIndex(), null);
            this.root = parent.getRoot();
            this.layerRoot = parent.getLayerRoot();
            this.meta = BoundedOpenMap.Companion.empty();
        }

        @Override
        @NotNull
        public Root getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public Selector getLayerRoot() {
            return this.layerRoot;
        }

        @NotNull
        public final BoundedOpenMap<MetaData, Object> getMeta() {
            return this.meta;
        }

        public final void setMeta(@NotNull BoundedOpenMap<MetaData, Object> boundedOpenMap) {
            Intrinsics.checkNotNullParameter(boundedOpenMap, (String)"<set-?>");
            this.meta = boundedOpenMap;
        }

        public /* synthetic */ Transparent(FocusNode parent, String debugName, Object debugLocation, DefaultConstructorMarker $constructor_marker) {
            this(parent, debugName, debugLocation);
        }
    }
}

