/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components.tree;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentSet;
import noria.Cell;
import noria.CellKt;
import noria.ClosureContext;
import noria.ReadScope;
import noria.StateCell;
import noria.model.ActionContext;
import noria.model.FocusDataKey;
import noria.model.components.ListScrollCommand;
import noria.model.components.ScrollKind;
import noria.model.components.TreeModelKt;
import noria.model.components.TreePath;
import noria.model.components.TreeState;
import noria.ui.components.list.Direction;
import noria.ui.components.list.ListActionsKt;
import noria.ui.components.list.ListItem;
import noria.ui.components.list.ListModel;
import noria.ui.components.list.ListViewKt;
import noria.ui.components.tree.TreeDataKeys;
import noria.ui.components.tree.TreeItem;
import noria.ui.components.tree.TreeKt;
import noria.ui.components.tree.TreeModel;
import noria.ui.components.tree.TreeViewOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B?\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000b\u00a2\u0006\u0004\b\f\u0010\rJ:\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\u0006\u0010&\u001a\u00020\u0017J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0015\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000bH\u00c6\u0003JO\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000bH\u00c6\u0001J\u0013\u0010,\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00062"}, d2={"Lnoria/ui/components/tree/TreeModel;", "T", "", "root", "Lnoria/ui/components/tree/TreeItem;", "options", "Lnoria/ui/components/tree/TreeViewOptions;", "state", "Lnoria/StateCell;", "Lnoria/model/components/TreeState;", "listModel", "Lnoria/ui/components/list/ListModel;", "<init>", "(Lnoria/ui/components/tree/TreeItem;Lnoria/ui/components/tree/TreeViewOptions;Lnoria/StateCell;Lnoria/ui/components/list/ListModel;)V", "getRoot", "()Lnoria/ui/components/tree/TreeItem;", "getOptions", "()Lnoria/ui/components/tree/TreeViewOptions;", "getState", "()Lnoria/StateCell;", "getListModel", "()Lnoria/ui/components/list/ListModel;", "select", "", "treePath", "Lnoria/model/components/TreePath;", "animateScroll", "", "expand", "xScrollKind", "Lnoria/model/components/ScrollKind;", "yScrollKind", "collapseAll", "collapseOrMoveCursor", "actionContext", "Lnoria/model/ActionContext;", "expandOrMoveCursor", "toggle", "cancelSearch", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "fleet.noria.ui"})
public final class TreeModel<T> {
    @NotNull
    private final TreeItem<T> root;
    @NotNull
    private final TreeViewOptions options;
    @NotNull
    private final StateCell<TreeState> state;
    @NotNull
    private final ListModel<TreeItem<T>> listModel;

    public TreeModel(@NotNull TreeItem<? extends T> root2, @NotNull TreeViewOptions options, @NotNull StateCell<TreeState> state2, @NotNull ListModel<TreeItem<T>> listModel2) {
        Intrinsics.checkNotNullParameter(root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        Intrinsics.checkNotNullParameter(listModel2, (String)"listModel");
        this.root = root2;
        this.options = options;
        this.state = state2;
        this.listModel = listModel2;
    }

    @NotNull
    public final TreeItem<T> getRoot() {
        return this.root;
    }

    @NotNull
    public final TreeViewOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final StateCell<TreeState> getState() {
        return this.state;
    }

    @NotNull
    public final ListModel<TreeItem<T>> getListModel() {
        return this.listModel;
    }

    public final void select(@NotNull TreePath treePath, boolean animateScroll, boolean expand2, @Nullable ScrollKind xScrollKind, @Nullable ScrollKind yScrollKind) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        this.state.update((Function1)new Function1<TreeState, TreeState>(treePath, animateScroll, expand2, xScrollKind, yScrollKind){
            final /* synthetic */ TreePath $treePath;
            final /* synthetic */ boolean $animateScroll;
            final /* synthetic */ boolean $expand;
            final /* synthetic */ ScrollKind $xScrollKind;
            final /* synthetic */ ScrollKind $yScrollKind;
            {
                this.$treePath = $treePath;
                this.$animateScroll = $animateScroll;
                this.$expand = $expand;
                this.$xScrollKind = $xScrollKind;
                this.$yScrollKind = $yScrollKind;
                super(1);
            }

            public final TreeState invoke(TreeState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TreeModelKt.select(it, this.$treePath, this.$animateScroll, this.$expand, this.$xScrollKind, this.$yScrollKind);
            }
        });
    }

    public static /* synthetic */ void select$default(TreeModel treeModel2, TreePath treePath, boolean bl, boolean bl2, ScrollKind scrollKind, ScrollKind scrollKind2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            scrollKind = null;
        }
        if ((n & 0x10) != 0) {
            scrollKind2 = null;
        }
        treeModel2.select(treePath, bl, bl2, scrollKind, scrollKind2);
    }

    public final void expand(@NotNull TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        this.state.update((Function1)new Function1<TreeState, TreeState>(treePath){
            final /* synthetic */ TreePath $treePath;
            {
                this.$treePath = $treePath;
                super(1);
            }

            public final TreeState invoke(TreeState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TreeModelKt.expand(it, this.$treePath);
            }
        });
    }

    public final void collapseAll() {
        this.state.update((Function1)collapseAll.1.INSTANCE);
    }

    public final void collapseOrMoveCursor(@NotNull ActionContext actionContext2) {
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        TreeModel treeModel2 = this;
        this.state.update((Function1)new Function1<TreeState, TreeState>(treeModel2, this, actionContext2){
            final /* synthetic */ TreeModel<T> $treeModel;
            final /* synthetic */ TreeModel<T> this$0;
            final /* synthetic */ ActionContext $actionContext;
            {
                this.$treeModel = $treeModel;
                this.this$0 = $receiver;
                this.$actionContext = $actionContext;
                super(1);
            }

            public final TreeState invoke(TreeState prev) {
                Object object;
                block12: {
                    block11: {
                        TreeState treeState;
                        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
                        object = prev.getCursor();
                        if (object == null) break block11;
                        TreePath treePath = object;
                        TreeModel<T> treeModel2 = this.$treeModel;
                        TreeModel<T> treeModel3 = this.this$0;
                        ActionContext actionContext2 = this.$actionContext;
                        TreePath cursor2 = treePath;
                        boolean bl = false;
                        ReadScope $this$invoke_u24lambda_u241_u24lambda_u240 = ReadScope.Companion.getEmpty();
                        boolean bl2 = false;
                        TreeItem treeItem = TreeKt.access$treeItem($this$invoke_u24lambda_u241_u24lambda_u240, treeModel2, cursor2);
                        if (treeItem == null) {
                            return prev;
                        }
                        TreeItem treeItem2 = treeItem;
                        if (treeItem2.getCollapsable() && prev.getExpansions().contains((Object)cursor2)) {
                            PersistentSet persistentSet = prev.getExpansions().remove((Object)cursor2);
                            ListScrollCommand listScrollCommand = prev.getScrollCommand();
                            ListScrollCommand listScrollCommand2 = new ListScrollCommand(cursor2, null, null, (listScrollCommand != null ? listScrollCommand.getTimestamp() : -1L) + 1L, false, 6, null);
                            treeState = TreeState.copy$default(prev, null, null, persistentSet, null, null, listScrollCommand2, cursor2, null, 155, null);
                        } else {
                            Integer parentIndex;
                            TreePath parentPath = cursor2.getParentPath();
                            Map read = (Map)$this$invoke_u24lambda_u241_u24lambda_u240.read(treeModel3.getListModel().getIndex());
                            TreePath treePath2 = parentPath;
                            Integer n = parentIndex = treePath2 != null ? (Integer)read.get(treePath2) : null;
                            if (parentPath != null && parentIndex != null) {
                                PersistentSet persistentSet;
                                if (treeModel3.getOptions().getUpdateSelectionWithCursor()) {
                                    Object[] objectArray = new TreePath[]{parentPath};
                                    persistentSet = ExtensionsKt.persistentHashSetOf((Object[])objectArray);
                                } else {
                                    persistentSet = prev.getSelection();
                                }
                                ListScrollCommand listScrollCommand = prev.getScrollCommand();
                                treeState = TreeState.copy$default(prev, parentPath, persistentSet, null, null, null, new ListScrollCommand(parentPath, null, null, (listScrollCommand != null ? listScrollCommand.getTimestamp() : -1L) + 1L, false, 6, null), null, null, 220, null);
                            } else {
                                Object firstListItemKey = ListViewKt.nextSelectableItemKey($this$invoke_u24lambda_u241_u24lambda_u240, 0, treeModel3.getListModel(), false, Direction.Forward);
                                if (firstListItemKey != null) {
                                    ListActionsKt.moveCursor(treeModel3.getListModel(), actionContext2, firstListItemKey, true);
                                }
                                treeState = prev;
                            }
                        }
                        object = treeState;
                        if (treeState != null) break block12;
                    }
                    object = prev;
                }
                return object;
            }
        });
    }

    public final void expandOrMoveCursor(@NotNull ActionContext actionContext2) {
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        this.state.update((Function1)new Function1<TreeState, TreeState>(this, actionContext2){
            final /* synthetic */ TreeModel<T> this$0;
            final /* synthetic */ ActionContext $actionContext;
            {
                this.this$0 = $receiver;
                this.$actionContext = $actionContext;
                super(1);
            }

            public final TreeState invoke(TreeState prev) {
                Object object;
                block9: {
                    block8: {
                        TreeState treeState;
                        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
                        object = prev.getCursor();
                        if (object == null) break block8;
                        TreePath treePath = object;
                        TreeModel<T> treeModel2 = this.this$0;
                        ActionContext actionContext2 = this.$actionContext;
                        TreePath cursor2 = treePath;
                        boolean bl = false;
                        ReadScope $this$invoke_u24lambda_u241_u24lambda_u240 = ReadScope.Companion.getEmpty();
                        boolean bl2 = false;
                        Integer n = (Integer)((Map)$this$invoke_u24lambda_u241_u24lambda_u240.read(treeModel2.getListModel().getIndex())).get(cursor2);
                        if (n == null) {
                            return prev;
                        }
                        int listIndex = n;
                        ListItem listItem = (ListItem)treeModel2.getListModel().getNth().invoke((Object)$this$invoke_u24lambda_u241_u24lambda_u240, (Object)listIndex);
                        if (((TreeItem)listItem.getItem()).getExpandable() && !prev.getExpansions().contains((Object)cursor2)) {
                            TreeItem treeItem = (TreeItem)listItem.getItem();
                            Function2<ClosureContext, ActionContext, Unit> function2 = treeItem.getOnExpand();
                            if (function2 != null) {
                                function2.invoke((Object)ClosureContext.Companion, (Object)actionContext2);
                            }
                            PersistentSet persistentSet = prev.getExpansions().add((Object)cursor2);
                            ListScrollCommand listScrollCommand = prev.getScrollCommand();
                            ListScrollCommand listScrollCommand2 = new ListScrollCommand(cursor2, null, null, (listScrollCommand != null ? listScrollCommand.getTimestamp() : -1L) + 1L, false, 6, null);
                            treeState = TreeState.copy$default(prev, null, null, persistentSet, null, null, listScrollCommand2, cursor2, null, 155, null);
                        } else {
                            Object nextListItemKey = ListViewKt.nextSelectableItemKey($this$invoke_u24lambda_u241_u24lambda_u240, listIndex + 1, treeModel2.getListModel(), false, Direction.Forward);
                            if (nextListItemKey != null) {
                                ListActionsKt.moveCursor(treeModel2.getListModel(), actionContext2, nextListItemKey, false);
                            }
                            treeState = prev;
                        }
                        object = treeState;
                        if (treeState != null) break block9;
                    }
                    object = prev;
                }
                return object;
            }
        });
    }

    public final void toggle(@NotNull ActionContext actionContext2) {
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        this.state.update((Function1)new Function1<TreeState, TreeState>(actionContext2, this){
            final /* synthetic */ ActionContext $actionContext;
            final /* synthetic */ TreeModel<T> this$0;
            {
                this.$actionContext = $actionContext;
                this.this$0 = $receiver;
                super(1);
            }

            public final TreeState invoke(TreeState prev) {
                TreeState treeState;
                Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
                AggregateType AggregateType = this.$actionContext.get((FocusDataKey)TreeDataKeys.INSTANCE.getTreeCursorNode());
                Intrinsics.checkNotNull(AggregateType);
                TreePath path = (TreePath)AggregateType;
                if (prev.getExpansions().contains((Object)path)) {
                    TreePath cursor2 = SequencesKt.contains((Sequence)SequencesKt.generateSequence((Object)prev.getCursor(), (Function1)toggle.cursor.1.INSTANCE), (Object)path) ? path : prev.getCursor();
                    treeState = TreeState.copy$default(prev, cursor2, !Intrinsics.areEqual(this.$actionContext.get((FocusDataKey)TreeDataKeys.INSTANCE.getChevronToggleMode()), (Object)true) && this.this$0.getOptions().getUpdateSelectionWithCursor() ? ExtensionsKt.toPersistentHashSet((Iterable)CollectionsKt.listOfNotNull((Object)cursor2)) : prev.getSelection(), prev.getExpansions().remove((Object)path), null, null, null, path, null, 184, null);
                } else {
                    ReadScope readScope = ReadScope.Companion.getEmpty();
                    TreeModel<T> treeModel2 = this.this$0;
                    ActionContext actionContext2 = this.$actionContext;
                    ReadScope $this$invoke_u24lambda_u240 = readScope;
                    boolean bl = false;
                    Integer n = (Integer)((Map)$this$invoke_u24lambda_u240.read(treeModel2.getListModel().getIndex())).get(path);
                    if (n == null) {
                        return prev;
                    }
                    int listIndex = n;
                    TreeItem treeItem = (TreeItem)((ListItem)treeModel2.getListModel().getNth().invoke((Object)$this$invoke_u24lambda_u240, (Object)listIndex)).getItem();
                    Function2<ClosureContext, ActionContext, Unit> function2 = treeItem.getOnExpand();
                    if (function2 != null) {
                        function2.invoke((Object)ClosureContext.Companion, (Object)actionContext2);
                    }
                    treeState = TreeState.copy$default(prev, null, null, prev.getExpansions().add((Object)path), null, null, null, path, null, 187, null);
                }
                return treeState;
            }
        });
    }

    public final void cancelSearch() {
        block0: {
            Function0<Unit> function0 = (Function0<Unit>)CellKt.readNonReactive((Cell)((Cell)this.listModel.getSearchData()));
            if (function0 == null || (function0 = function0.getCancelSearch()) == null) break block0;
            function0.invoke();
        }
    }

    @NotNull
    public final TreeItem<T> component1() {
        return this.root;
    }

    @NotNull
    public final TreeViewOptions component2() {
        return this.options;
    }

    @NotNull
    public final StateCell<TreeState> component3() {
        return this.state;
    }

    @NotNull
    public final ListModel<TreeItem<T>> component4() {
        return this.listModel;
    }

    @NotNull
    public final TreeModel<T> copy(@NotNull TreeItem<? extends T> root2, @NotNull TreeViewOptions options, @NotNull StateCell<TreeState> state2, @NotNull ListModel<TreeItem<T>> listModel2) {
        Intrinsics.checkNotNullParameter(root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        Intrinsics.checkNotNullParameter(listModel2, (String)"listModel");
        return new TreeModel<T>(root2, options, state2, listModel2);
    }

    public static /* synthetic */ TreeModel copy$default(TreeModel treeModel2, TreeItem treeItem, TreeViewOptions treeViewOptions, StateCell stateCell, ListModel listModel2, int n, Object object) {
        if ((n & 1) != 0) {
            treeItem = treeModel2.root;
        }
        if ((n & 2) != 0) {
            treeViewOptions = treeModel2.options;
        }
        if ((n & 4) != 0) {
            stateCell = treeModel2.state;
        }
        if ((n & 8) != 0) {
            listModel2 = treeModel2.listModel;
        }
        return treeModel2.copy(treeItem, treeViewOptions, stateCell, listModel2);
    }

    @NotNull
    public String toString() {
        return "TreeModel(root=" + this.root + ", options=" + this.options + ", state=" + this.state + ", listModel=" + this.listModel + ")";
    }

    public int hashCode() {
        int result2 = this.root.hashCode();
        result2 = result2 * 31 + this.options.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        result2 = result2 * 31 + this.listModel.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TreeModel)) {
            return false;
        }
        TreeModel treeModel2 = (TreeModel)other;
        if (!Intrinsics.areEqual(this.root, treeModel2.root)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.options, (Object)treeModel2.options)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.state, treeModel2.state)) {
            return false;
        }
        return Intrinsics.areEqual(this.listModel, treeModel2.listModel);
    }
}

