/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontVariation;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.LoadedFont;
import androidx.compose.ui.text.platform.Platform;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.ResourceFont;
import androidx.compose.ui.text.platform.SystemFont;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.FontVariationAxis;
import org.jetbrains.skia.Typeface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003H\u0002\u001a\b\u0010\u001a\u001a\u00020\u001bH\u0000\"\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Font", "Landroidx/compose/ui/text/font/Font;", "resource", "", "weight", "Landroidx/compose/ui/text/font/FontWeight;", "style", "Landroidx/compose/ui/text/font/FontStyle;", "Font-RetOiIg", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "file", "Ljava/io/File;", "variationSettings", "Landroidx/compose/ui/text/font/FontVariation$Settings;", "Font-Ej4NQ78", "(Ljava/io/File;Landroidx/compose/ui/text/font/FontWeight;ILandroidx/compose/ui/text/font/FontVariation$Settings;)Landroidx/compose/ui/text/font/Font;", "applyFontVariationSettings", "Lorg/jetbrains/skia/Typeface;", "loadTypeface", "font", "typefaceResource", "resourceName", "skFontStyle", "Lorg/jetbrains/skia/FontStyle;", "getSkFontStyle", "(Landroidx/compose/ui/text/font/Font;)Lorg/jetbrains/skia/FontStyle;", "currentPlatform", "Landroidx/compose/ui/text/platform/Platform;", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nDesktopFont.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,231:1\n1611#2,9:232\n1863#2:241\n1864#2:245\n1620#2:246\n12574#3,2:242\n1#4:244\n1#4:249\n37#5,2:247\n*S KotlinDebug\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n*L\n176#1:232,9\n176#1:241\n176#1:245\n176#1:246\n178#1:242,2\n176#1:244\n186#1:247,2\n*E\n"})
public final class DesktopFont_desktopKt {
    @NotNull
    public static final Font Font-RetOiIg(@NotNull String resource2, @NotNull FontWeight weight, int style) {
        Intrinsics.checkNotNullParameter((Object)resource2, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        return new ResourceFont(resource2, weight, style, null, 8, null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(String string, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(string, fontWeight, n);
    }

    @NotNull
    public static final Font Font-Ej4NQ78(@NotNull File file, @NotNull FontWeight weight, int style, @NotNull FontVariation.Settings variationSettings) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)variationSettings, (String)"variationSettings");
        return new FileFont(file, weight, style, variationSettings, null);
    }

    public static /* synthetic */ Font Font-Ej4NQ78$default(File file, FontWeight fontWeight, int n, FontVariation.Settings settings, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        if ((n2 & 8) != 0) {
            settings = FontVariation.INSTANCE.Settings-6EWAqTQ(fontWeight, n, new FontVariation.Setting[0]);
        }
        return DesktopFont_desktopKt.Font-Ej4NQ78(file, fontWeight, n, settings);
    }

    /*
     * WARNING - void declaration
     */
    private static final Typeface applyFontVariationSettings(Typeface $this$applyFontVariationSettings, FontVariation.Settings variationSettings) {
        Typeface typeface2;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = variationSettings.getSettings();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            org.jetbrains.skia.FontVariation it$iv$iv;
            boolean bl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FontVariation.Setting variation = (FontVariation.Setting)element$iv$iv;
            boolean bl3 = false;
            Density density = DensityKt.Density$default(1.0f, 0.0f, 2, null);
            if ($this$applyFontVariationSettings.getVariationAxes() != null) {
                boolean bl4;
                block6: {
                    FontVariationAxis[] $this$any$iv;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        FontVariationAxis element$iv;
                        FontVariationAxis it = element$iv = $this$any$iv[i];
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getTag(), (Object)variation.getAxisName())) continue;
                        bl4 = true;
                        break block6;
                    }
                    bl4 = false;
                }
                bl = bl4;
            } else {
                bl = false;
            }
            if ((bl ? new org.jetbrains.skia.FontVariation(variation.getAxisName(), variation.toVariationValue(density)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List variations = (List)destination$iv$iv;
        if (!((Collection)variations).isEmpty()) {
            Collection $this$toTypedArray$iv = variations;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            typeface2 = Typeface.makeClone$default((Typeface)$this$applyFontVariationSettings, (org.jetbrains.skia.FontVariation[])thisCollection$iv.toArray(new org.jetbrains.skia.FontVariation[0]), (int)0, (int)2, null);
        } else {
            typeface2 = $this$applyFontVariationSettings;
        }
        return typeface2;
    }

    @NotNull
    public static final Typeface loadTypeface(@NotNull Font font) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (!(font instanceof PlatformFont)) {
            throw new IllegalArgumentException("Unsupported font type: " + font);
        }
        PlatformFont platformFont = (PlatformFont)font;
        if (platformFont instanceof ResourceFont) {
            object = DesktopFont_desktopKt.applyFontVariationSettings(DesktopFont_desktopKt.typefaceResource(((ResourceFont)font).getName()), ((ResourceFont)font).getVariationSettings());
        } else if (platformFont instanceof FileFont) {
            FontMgr fontMgr = FontMgr.Companion.getDefault();
            String string = ((FileFont)font).getFile().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Typeface typeface2 = FontMgr.makeFromFile$default((FontMgr)fontMgr, (String)string, (int)0, (int)2, null);
            object = typeface2 != null ? DesktopFont_desktopKt.applyFontVariationSettings(typeface2, ((FileFont)font).getVariationSettings()) : null;
        } else if (platformFont instanceof LoadedFont) {
            Typeface typeface3 = FontMgr.makeFromData$default((FontMgr)FontMgr.Companion.getDefault(), (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])((byte[])((LoadedFont)font).getGetData$fleet_noria_ui().invoke()), (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
            object = typeface3 != null ? DesktopFont_desktopKt.applyFontVariationSettings(typeface3, ((LoadedFont)font).getVariationSettings()) : null;
        } else if (platformFont instanceof SystemFont) {
            Typeface typeface4 = FontMgr.Companion.getDefault().matchFamilyStyle(((SystemFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font));
            object = typeface4 != null ? DesktopFont_desktopKt.applyFontVariationSettings(typeface4, ((SystemFont)font).getVariationSettings()) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface5 = object;
        if (object == null && ((typeface5 = FontMgr.Companion.getDefault().legacyMakeTypeface(((PlatformFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font))) == null || (typeface5 = DesktopFont_desktopKt.applyFontVariationSettings(typeface5, ((PlatformFont)font).getVariationSettings())) == null)) {
            throw new IllegalStateException("loadTypeface legacyMakeTypeface failed".toString());
        }
        return typeface5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface typefaceResource(String resourceName) {
        byte[] byArray;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        ClassLoader contextClassLoader = classLoader;
        InputStream inputStream = contextClassLoader.getResourceAsStream(resourceName);
        if (inputStream == null && (inputStream = ((Object)((Object)typefaceResource.resource.1.INSTANCE)).getClass().getResourceAsStream(resourceName)) == null) {
            throw new IllegalStateException(("Can't load font from " + resourceName).toString());
        }
        InputStream resource2 = inputStream;
        Closeable closeable = resource2;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = it.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bytes = byArray;
        FontMgr fontMgr = FontMgr.Companion.getDefault();
        Intrinsics.checkNotNull((Object)bytes);
        Typeface typeface2 = FontMgr.makeFromData$default((FontMgr)fontMgr, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])bytes, (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)typeface2);
        return typeface2;
    }

    private static final org.jetbrains.skia.FontStyle getSkFontStyle(Font $this$skFontStyle) {
        return new org.jetbrains.skia.FontStyle($this$skFontStyle.getWeight().getWeight(), 5, FontStyle.equals-impl0($this$skFontStyle.getStyle-_-LCdwA(), FontStyle.Companion.getItalic-_-LCdwA()) ? FontSlant.ITALIC : FontSlant.UPRIGHT);
    }

    @NotNull
    public static final Platform currentPlatform() {
        String name = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.startsWith$default((String)name, (String)"Linux", (boolean)false, (int)2, null) ? Platform.Linux : (StringsKt.startsWith$default((String)name, (String)"Win", (boolean)false, (int)2, null) ? Platform.Windows : (Intrinsics.areEqual((Object)name, (Object)"Mac OS X") ? Platform.MacOS : Platform.Unknown));
    }

    public static final /* synthetic */ Typeface access$typefaceResource(String resourceName) {
        return DesktopFont_desktopKt.typefaceResource(resourceName);
    }
}

