/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.PathKt;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0010\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010C\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010D\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010E\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0015\u0010F\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bKJ\u0012\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010@\u001a\u00020\u0005H\u0002J\u0010\u0010N\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010O\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010P\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0018\u0010Q\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u0007H\u0016J\u0010\u0010S\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010T\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020%H\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010M2\u0006\u0010V\u001a\u00020%H\u0002J\u0018\u0010X\u001a\u00020%2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u0007H\u0016J\u0013\u0010`\u001a\b\u0012\u0004\u0012\u00020M0[H\u0002\u00a2\u0006\u0002\u0010_J\u0012\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010@\u001a\u00020\u0005H\u0002J\u001c\u0010c\u001a\u0004\u0018\u00010b2\u0006\u0010@\u001a\u00020\u00052\b\b\u0002\u0010>\u001a\u00020\u0005H\u0002J\u0010\u0010d\u001a\u00020e2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010f\u001a\u00020e2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0017\u0010g\u001a\u00020\u00052\u0006\u0010h\u001a\u00020iH\u0016\u00a2\u0006\u0004\bj\u0010kJ\u0010\u0010l\u001a\u0002082\u0006\u0010@\u001a\u00020\u0005H\u0016J'\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\bt\u0010uJ\u0017\u0010v\u001a\u00020p2\u0006\u0010@\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\bw\u0010xJ7\u0010y\u001a\u00020n2\u0006\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010\u007f2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0016\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0083\u0001JM\u0010y\u001a\u00020n2\u0006\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010\u007f2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u00012\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0017\u00a2\u0006\u0006\b\u0088\u0001\u0010\u0089\u0001JX\u0010y\u001a\u00020n2\u0006\u0010z\u001a\u00020{2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010~\u001a\u0004\u0018\u00010\u007f2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u00012\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0017\u00a2\u0006\u0006\b\u008d\u0001\u0010\u008e\u0001J\u0012\u0010\u008f\u0001\u001a\u00020n2\u0006\u0010@\u001a\u00020\u0005H\u0082\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010*\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010'R\u0014\u0010,\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010'R\u0014\u0010.\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010'R\u0014\u00100\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010'R\u0014\u00102\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000fR\u0014\u00104\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\rR\u001c\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u000108078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0018\u0010Z\u001a\n\u0012\u0004\u0012\u00020M\u0018\u00010[X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\\R\u001a\u0010]\u001a\b\u0012\u0004\u0012\u00020M0[8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_\u00a8\u0006\u0090\u0001"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "intrinsics", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/compose/ui/unit/Constraints;", "<init>", "(Landroidx/compose/ui/text/ParagraphIntrinsics;IZLandroidx/compose/ui/unit/Constraints;)V", "getMaxLines", "()I", "getEllipsis", "()Z", "getConstraints", "()Landroidx/compose/ui/unit/Constraints;", "ellipsisChar", "", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$fleet_noria_ui", "()Lorg/jetbrains/skia/Font;", "value", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraph", "setParagraph", "(Lorg/jetbrains/skia/paragraph/Paragraph;)V", "text", "getText", "()Ljava/lang/String;", "width", "", "getWidth", "()F", "height", "getHeight", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "firstBaseline", "getFirstBaseline", "lastBaseline", "getLastBaseline", "didExceedMaxLines", "getDidExceedMaxLines", "lineCount", "getLineCount", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getCursorRect", "offset", "getLineLeft", "lineIndex", "getLineRight", "getLineTop", "getLineBottom", "getLineAscent", "getLineAscent$fleet_noria_ui", "getLineBaseline", "getLineBaseline$fleet_noria_ui", "getLineDescent", "getLineDescent$fleet_noria_ui", "lineMetricsForOffset", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineHeight", "getLineWidth", "getLineStart", "getLineEnd", "visibleEnd", "isLineEllipsized", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineMetricsForVerticalPosition", "getHorizontalPosition", "usePrimaryDirection", "_lineMetrics", "", "[Lorg/jetbrains/skia/paragraph/LineMetrics;", "lineMetrics", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "receiveLineMetrics", "getBoxForwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "getBoxBackwardByOffset", "getParagraphDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBidiRunDirection", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getBoundingBox", "fillBoundingBoxes", "", "range", "Landroidx/compose/ui/text/TextRange;", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getWordBoundary", "getWordBoundary--jx7JFs", "(I)J", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "checkOffsetIsValid", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nSkiaParagraph.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph_skikoKt\n*L\n1#1,632:1\n547#1,4:638\n547#1,4:662\n547#1,4:666\n547#1,4:670\n1#2:633\n11165#3:634\n11500#3,3:635\n621#4,10:642\n621#4,10:652\n*S KotlinDebug\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n*L\n190#1:638,4\n287#1:662,4\n303#1:666,4\n448#1:670,4\n112#1:634\n112#1:635,3\n192#1:642,10\n236#1:652,10\n*E\n"})
public final class SkiaParagraph
implements Paragraph {
    private final int maxLines;
    private final boolean ellipsis;
    @NotNull
    private final Constraints constraints;
    @NotNull
    private final String ellipsisChar;
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    @Nullable
    private LineMetrics[] _lineMetrics;

    /*
     * WARNING - void declaration
     */
    public SkiaParagraph(@NotNull ParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, @NotNull Constraints constraints) {
        void $this$layouter_u24lambda_u240;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.constraints = constraints;
        this.ellipsisChar = this.ellipsis ? "\u2026" : "";
        this.paragraphIntrinsics = (SkiaParagraphIntrinsics)intrinsics;
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$layouter_u24lambda_u240.setParagraphStyle(this.maxLines, this.ellipsisChar);
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getEllipsis() {
        return this.ellipsis;
    }

    @NotNull
    public final Constraints getConstraints() {
        return this.constraints;
    }

    @NotNull
    public final Font getDefaultFont$fleet_noria_ui() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph value2) {
        this.paragraph = value2;
        this._lineMetrics = null;
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return this.constraints.getMaxWidth();
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_firstBaseline__u24lambda_u241 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_firstBaseline__u24lambda_u241.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_lastBaseline__u24lambda_u242 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_lastBaseline__u24lambda_u242.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual((Object)this.getText(), (Object)"") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.paragraph.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect(it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start2, int end2) {
        TextBox[] boxes = this.paragraph.getRectsForRange(start2, end2, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path = PathKt.Path();
        for (TextBox b : boxes) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath(path), (org.jetbrains.skia.Rect)b.getRect(), null, (int)0, (int)6, null);
        }
        return path;
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        double d;
        double d2;
        float horizontal = this.getHorizontalPosition(offset, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics line = lineMetrics;
        boolean isNewEmptyLine = offset - 1 == line.getStartIndex() && offset == this.getText().length();
        FontMetrics metrics = this.getDefaultFont$fleet_noria_ui().getMetrics();
        double it = line.getAscent();
        boolean bl = false;
        if (isNewEmptyLine) {
            double ascent = -((double)metrics.getAscent());
            d2 = RangesKt.coerceAtMost((double)it, (double)ascent);
        } else {
            d2 = it;
        }
        double asc = d2;
        double it2 = line.getDescent();
        boolean bl2 = false;
        if (isNewEmptyLine) {
            double descent = metrics.getDescent();
            d = RangesKt.coerceAtMost((double)it2, (double)descent);
        } else {
            d = it2;
        }
        double desc = d;
        return new Rect(horizontal, (float)(line.getBaseline() - asc), horizontal, (float)(line.getBaseline() + desc));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final int getLineAscent$fleet_noria_ui(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return -(lineMetrics != null ? MathKt.roundToInt((double)lineMetrics.getAscent()) : 0);
    }

    public final int getLineBaseline$fleet_noria_ui(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? MathKt.roundToInt((double)lineMetrics.getBaseline()) : 0;
    }

    public final int getLineDescent$fleet_noria_ui(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? MathKt.roundToInt((double)lineMetrics.getDescent()) : 0;
    }

    private final LineMetrics lineMetricsForOffset(int offset) {
        Object object;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        Object[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            object = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])$this$binarySearchFirstMatchingOrLast$iv), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(offset){
                final /* synthetic */ int $offset$inlined;
                {
                    this.$offset$inlined = n;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return this.$offset$inlined < it2.getEndIncludingNewline() ? 1 : -1;
                }
            }), (int)3, null);
            object = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost((int)(-index$iv - 1), (int)ArraysKt.getLastIndex((Object[])$this$binarySearchFirstMatchingOrLast$iv))];
        }
        return object;
    }

    @Override
    public float getLineHeight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public float getLineWidth(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getWidth() : 0.0f;
    }

    @Override
    public int getLineStart(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics metrics = lineMetrics;
        return visibleEnd ? (lineIndex > 0 && metrics.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics.getEndIndex() : (metrics.getStartIndex() < this.getText().length() && this.getText().charAt(metrics.getStartIndex()) == '\n' ? metrics.getStartIndex() : metrics.getEndExcludingWhitespaces())) : metrics.getEndIndex();
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return false;
    }

    @Override
    public int getLineForOffset(int offset) {
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(vertical);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float vertical) {
        Object object;
        Object[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            object = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])$this$binarySearchFirstMatchingOrLast$iv), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(vertical){
                final /* synthetic */ float $vertical$inlined;
                {
                    this.$vertical$inlined = f;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return (double)this.$vertical$inlined < it2.getBaseline() + it2.getDescent() ? 1 : -1;
                }
            }), (int)3, null);
            object = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost((int)(-index$iv - 1), (int)ArraysKt.getLastIndex((Object[])$this$binarySearchFirstMatchingOrLast$iv))];
        }
        return object;
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset);
        boolean isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean isLtr = !isRtl;
        if (prevBox == null && nextBox == null) {
            f = isRtl ? this.getWidth() : 0.0f;
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull((Object)textBox);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isLtr && prevBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isRtl && prevBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)))));
        }
        return f;
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray = this._lineMetrics;
        if (this._lineMetrics == null) {
            LineMetrics[] lineMetricsArray2;
            LineMetrics[] it = lineMetricsArray2 = this.receiveLineMetrics();
            boolean bl = false;
            this._lineMetrics = it;
            lineMetricsArray = lineMetricsArray2;
        }
        LineMetrics[] lineMetrics = lineMetricsArray;
        return lineMetrics;
    }

    private final LineMetrics[] receiveLineMetrics() {
        LineMetrics[] lineMetrics = ((CharSequence)this.getText()).length() == 0 ? this.layouter.emptyLineMetrics$fleet_noria_ui(this.paragraph) : this.paragraph.getLineMetrics();
        FontMetrics fontMetrics = this.getDefaultFont$fleet_noria_ui().getMetrics();
        if (!(lineMetrics.length == 0)) {
            lineMetrics[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetrics[0], fontMetrics, this.layouter.getTextStyle());
            lineMetrics[lineMetrics.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetrics[lineMetrics.length - 1], fontMetrics, this.layouter.getTextStyle());
        }
        return lineMetrics;
    }

    private final TextBox getBoxForwardByOffset(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException(string.toString());
        }
        for (int to = offset + 1; to <= this.getText().length(); ++to) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(offset, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset, int end2) {
        boolean isRtl;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        boolean bl = isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int from = offset - 1; from >= 0; --from) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(from, end2, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from) == '\n') {
                TextBox textBox;
                if (!isRtl) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                    return new TextBox(rect, box.getDirection());
                }
                if (from == StringsKt.getLastIndex((CharSequence)this.getText())) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(this.getWidth(), box.getRect().getBottom(), this.getWidth(), bottom);
                    textBox = new TextBox(rect, box.getDirection());
                } else {
                    TextBox nextBox = (TextBox)ArraysKt.first((Object[])this.paragraph.getRectsForRange(offset, offset + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(nextBox.getRect().getLeft(), nextBox.getRect().getTop(), nextBox.getRect().getLeft(), nextBox.getRect().getBottom());
                    textBox = new TextBox(rect, nextBox.getDirection());
                }
                return textBox;
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        TextBox textBox = this.getBoxForwardByOffset(offset);
        Object object = textBox != null ? textBox.getDirection() : null;
        return switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> ResolvedTextDirection.Rtl;
            case 2 -> ResolvedTextDirection.Ltr;
            case -1 -> ResolvedTextDirection.Ltr;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        float rightX;
        boolean isNotEmptyLine;
        int glyphPosition = this.paragraph.getGlyphPositionAtCoordinate(Offset.getX-impl(position), Offset.getY-impl(position)).getPosition();
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Offset.getY-impl(position));
        if (lineMetrics == null) {
            return glyphPosition;
        }
        LineMetrics expectedLine = lineMetrics;
        boolean bl = isNotEmptyLine = expectedLine.getStartIndex() < expectedLine.getEndIndex();
        if ((double)Offset.getX-impl(position) > expectedLine.getLeft() && (double)Offset.getX-impl(position) < expectedLine.getRight()) {
            return glyphPosition;
        }
        Object rects = isNotEmptyLine ? this.paragraph.getRectsForRange(expectedLine.getStartIndex(), expectedLine.isHardBreak() ? expectedLine.getEndIndex() : expectedLine.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null;
        TextBox textBox = rects;
        float leftX = textBox != null && (textBox = (TextBox[])ArraysKt.firstOrNull(textBox)) != null && (textBox = textBox.getRect()) != null ? textBox.getLeft() : (float)expectedLine.getLeft();
        TextBox textBox2 = rects;
        float f = rightX = textBox2 != null && (textBox2 = (TextBox)ArraysKt.lastOrNull((Object[])textBox2)) != null && (textBox2 = textBox2.getRect()) != null ? textBox2.getRight() : (float)expectedLine.getRight();
        if (leftX == rightX) {
            return glyphPosition;
        }
        int correctedGlyphPosition = glyphPosition;
        if (Offset.getX-impl(position) <= leftX) {
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(leftX + 1.0f, Offset.getY-impl(position)).getPosition();
        } else if (Offset.getX-impl(position) >= rightX) {
            boolean isNeutralChar;
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(rightX - 1.0f, Offset.getY-impl(position)).getPosition();
            boolean bl2 = isNeutralChar = (0 <= correctedGlyphPosition ? correctedGlyphPosition < ((CharSequence)this.getText()).length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), correctedGlyphPosition)) : false;
            if (!isNeutralChar) {
                TextBox textBox3 = SkiaParagraph.getBoxBackwardByOffset$default(this, correctedGlyphPosition, 0, 2, null);
                if ((textBox3 != null ? textBox3.getDirection() : null) == Direction.RTL) {
                    --correctedGlyphPosition;
                }
            }
        }
        return correctedGlyphPosition;
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextBox box;
        Object object;
        TextBox textBox = this.getBoxForwardByOffset(offset);
        if (textBox == null) {
            textBox = this.getBoxBackwardByOffset(offset, this.getText().length());
        }
        if ((object = (box = textBox)) == null || (object = object.getRect()) == null || (object = Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)object)) == null) {
            object = Rect.Companion.getZero();
        }
        return object;
    }

    @Override
    public void fillBoundingBoxes-8ffj60Q(long range, @NotNull float[] array, int arrayStart) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        System.out.println((Object)"Compose Multiplatform doesn't support fillBoundingBoxes` yet. Follow https://github.com/JetBrains/compose-multiplatform/issues/4236");
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException(string.toString());
        }
        if (offset < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(offset)) || offset == this.getText().length()) {
            return offset > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(offset - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset - 1)) : TextRangeKt.TextRange(offset, offset);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long color2, @Nullable Shadow shadow2, @Nullable TextDecoration textDecoration) {
        void $this$paint_RPmYEkk_u24lambda_u2411;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_RPmYEkk_u24lambda_u2411.setTextStyle-ek8zF_U(color2, shadow2, textDecoration);
        skiaParagraph.setParagraph($this$paint_RPmYEkk_u24lambda_u2411.layoutParagraph(this.getWidth()));
        this.paragraph.paint(CanvasKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-LG529CI(@NotNull Canvas canvas, long color2, @Nullable Shadow shadow2, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_LG529CI_u24lambda_u2412;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u2412.setTextStyle-ek8zF_U(color2, shadow2, textDecoration);
        $this$paint_LG529CI_u24lambda_u2412.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u2412.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_LG529CI_u24lambda_u2412.layoutParagraph(this.getWidth()));
        this.paragraph.paint(CanvasKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha2, @Nullable Shadow shadow2, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_hn5TExg_u24lambda_u2413;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_hn5TExg_u24lambda_u2413.setTextStyle-eZhPAX0(brush, SizeKt.Size(this.getWidth(), this.getHeight()), alpha2, shadow2, textDecoration);
        $this$paint_hn5TExg_u24lambda_u2413.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u2413.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_hn5TExg_u24lambda_u2413.layoutParagraph(this.getWidth()));
        this.paragraph.paint(CanvasKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int offset) {
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this.getText().length() + "]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

