/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.DrawModifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.layout.ScaleFactorKt;
import androidx.compose.ui.platform.InspectorInfo;
import androidx.compose.ui.platform.InspectorValueInfo;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.UnpackedConstraintsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BZ\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001c\u0010'\u001a\u00020(*\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u001c\u0010.\u001a\u00020/*\u0002002\u0006\u0010*\u001a\u0002012\u0006\u00102\u001a\u00020/H\u0016J\u001c\u00103\u001a\u00020/*\u0002002\u0006\u0010*\u001a\u0002012\u0006\u00102\u001a\u00020/H\u0016J\u001c\u00104\u001a\u00020/*\u0002002\u0006\u0010*\u001a\u0002012\u0006\u00105\u001a\u00020/H\u0016J\u001c\u00106\u001a\u00020/*\u0002002\u0006\u0010*\u001a\u0002012\u0006\u00105\u001a\u00020/H\u0016J\u0017\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0002\u00a2\u0006\u0004\b:\u0010;J\u0010\u0010<\u001a\u00020-2\u0006\u0010,\u001a\u00020-H\u0002J\f\u0010=\u001a\u00020\u0013*\u00020>H\u0016J\u0013\u0010?\u001a\u00020\u0007*\u000208H\u0002\u00a2\u0006\u0004\b@\u0010AJ\u0013\u0010B\u001a\u00020\u0007*\u000208H\u0002\u00a2\u0006\u0004\bC\u0010AJ\b\u0010D\u001a\u00020/H\u0016J\u0013\u0010E\u001a\u00020\u00072\b\u0010F\u001a\u0004\u0018\u00010GH\u0096\u0002J\b\u0010H\u001a\u00020IH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\"\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001a\u00a8\u0006J"}, d2={"Landroidx/compose/ui/draw/PainterModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "Landroidx/compose/ui/draw/DrawModifier;", "Landroidx/compose/ui/platform/InspectorValueInfo;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "sizeToIntrinsics", "", "alignment", "Landroidx/compose/ui/Alignment;", "contentScale", "Landroidx/compose/ui/layout/ContentScale;", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "inspectorInfo", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/InspectorInfo;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Landroidx/compose/ui/graphics/painter/Painter;ZLandroidx/compose/ui/Alignment;Landroidx/compose/ui/layout/ContentScale;FLandroidx/compose/ui/graphics/ColorFilter;Lkotlin/jvm/functions/Function1;)V", "getPainter", "()Landroidx/compose/ui/graphics/painter/Painter;", "getSizeToIntrinsics", "()Z", "getAlignment", "()Landroidx/compose/ui/Alignment;", "getContentScale", "()Landroidx/compose/ui/layout/ContentScale;", "getAlpha", "()F", "getColorFilter", "()Landroidx/compose/ui/graphics/ColorFilter;", "getInspectorInfo", "()Lkotlin/jvm/functions/Function1;", "useIntrinsicSize", "getUseIntrinsicSize", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurable", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "minIntrinsicWidth", "", "Landroidx/compose/ui/layout/IntrinsicMeasureScope;", "Landroidx/compose/ui/layout/IntrinsicMeasurable;", "height", "maxIntrinsicWidth", "minIntrinsicHeight", "width", "maxIntrinsicHeight", "calculateScaledSize", "Landroidx/compose/ui/geometry/Size;", "dstSize", "calculateScaledSize-E7KxVPU", "(J)J", "modifyConstraints", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "hasSpecifiedAndFiniteWidth", "hasSpecifiedAndFiniteWidth-uvyYCjk", "(J)Z", "hasSpecifiedAndFiniteHeight", "hasSpecifiedAndFiniteHeight-uvyYCjk", "hashCode", "equals", "other", "", "toString", "", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nPainterModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PainterModifier.kt\nandroidx/compose/ui/draw/PainterModifier\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,320:1\n152#2:321\n122#3,4:322\n*S KotlinDebug\n*F\n+ 1 PainterModifier.kt\nandroidx/compose/ui/draw/PainterModifier\n*L\n104#1:321\n279#1:322,4\n*E\n"})
final class PainterModifier
extends InspectorValueInfo
implements LayoutModifier,
DrawModifier {
    @NotNull
    private final Painter painter;
    private final boolean sizeToIntrinsics;
    @NotNull
    private final Alignment alignment;
    @NotNull
    private final ContentScale contentScale;
    private final float alpha;
    @Nullable
    private final ColorFilter colorFilter;
    @NotNull
    private final Function1<InspectorInfo, Unit> inspectorInfo;

    public PainterModifier(@NotNull Painter painter2, boolean sizeToIntrinsics, @NotNull Alignment alignment, @NotNull ContentScale contentScale, float alpha2, @Nullable ColorFilter colorFilter, @NotNull Function1<? super InspectorInfo, Unit> inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)painter2, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        Intrinsics.checkNotNullParameter(inspectorInfo, (String)"inspectorInfo");
        super(inspectorInfo);
        this.painter = painter2;
        this.sizeToIntrinsics = sizeToIntrinsics;
        this.alignment = alignment;
        this.contentScale = contentScale;
        this.alpha = alpha2;
        this.colorFilter = colorFilter;
        this.inspectorInfo = inspectorInfo;
    }

    public /* synthetic */ PainterModifier(Painter painter2, boolean bl, Alignment alignment, ContentScale contentScale, float f, ColorFilter colorFilter, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            alignment = Alignment.Companion.getCenter();
        }
        if ((n & 8) != 0) {
            contentScale = ContentScale.Companion.getInside();
        }
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        if ((n & 0x20) != 0) {
            colorFilter = null;
        }
        this(painter2, bl, alignment, contentScale, f, colorFilter, (Function1<? super InspectorInfo, Unit>)function1);
    }

    @NotNull
    public final Painter getPainter() {
        return this.painter;
    }

    public final boolean getSizeToIntrinsics() {
        return this.sizeToIntrinsics;
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public final ContentScale getContentScale() {
        return this.contentScale;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    @Nullable
    public final ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    @NotNull
    public final Function1<InspectorInfo, Unit> getInspectorInfo() {
        return this.inspectorInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getUseIntrinsicSize() {
        if (!this.sizeToIntrinsics) return false;
        long $this$isSpecified$iv = this.painter.getIntrinsicSize-NH-jbRc();
        boolean bl = false;
        if ($this$isSpecified$iv == Size.Companion.getUnspecified-NH-jbRc()) return false;
        return true;
    }

    @Override
    @NotNull
    public MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull Measurable measurable, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Placeable placeable = measurable.measure(this.modifyConstraints(constraints));
        return MeasureScope.DefaultImpls.layout$default($this$measure, placeable.getWidth(), placeable.getHeight(), null, (Function1)new Function1<Placeable.PlacementScope, Unit>(placeable){
            final /* synthetic */ Placeable $placeable;
            {
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.placeRelative$default($this$layout, this.$placeable, 0, 0, 0.0f, 4, null);
            }
        }, 4, null);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            Constraints constraints = this.modifyConstraints(new Constraints(0, 0, 0, height2, 7, null));
            int layoutWidth = measurable.minIntrinsicWidth(height2);
            n = Math.max(constraints.getMinWidth(), layoutWidth);
        } else {
            n = measurable.minIntrinsicWidth(height2);
        }
        return n;
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            Constraints constraints = this.modifyConstraints(new Constraints(0, 0, 0, height2, 7, null));
            int layoutWidth = measurable.maxIntrinsicWidth(height2);
            n = Math.max(constraints.getMinWidth(), layoutWidth);
        } else {
            n = measurable.maxIntrinsicWidth(height2);
        }
        return n;
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            Constraints constraints = this.modifyConstraints(new Constraints(0, width2, 0, 0, 13, null));
            int layoutHeight = measurable.minIntrinsicHeight(width2);
            n = Math.max(constraints.getMinHeight(), layoutHeight);
        } else {
            n = measurable.minIntrinsicHeight(width2);
        }
        return n;
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            Constraints constraints = this.modifyConstraints(new Constraints(0, width2, 0, 0, 13, null));
            int layoutHeight = measurable.maxIntrinsicHeight(width2);
            n = Math.max(constraints.getMinHeight(), layoutHeight);
        } else {
            n = measurable.maxIntrinsicHeight(width2);
        }
        return n;
    }

    private final long calculateScaledSize-E7KxVPU(long dstSize) {
        long l;
        if (!this.getUseIntrinsicSize()) {
            l = dstSize;
        } else {
            float srcWidth = !this.hasSpecifiedAndFiniteWidth-uvyYCjk(this.painter.getIntrinsicSize-NH-jbRc()) ? Size.getWidth-impl(dstSize) : Size.getWidth-impl(this.painter.getIntrinsicSize-NH-jbRc());
            float srcHeight = !this.hasSpecifiedAndFiniteHeight-uvyYCjk(this.painter.getIntrinsicSize-NH-jbRc()) ? Size.getHeight-impl(dstSize) : Size.getHeight-impl(this.painter.getIntrinsicSize-NH-jbRc());
            long srcSize = SizeKt.Size(srcWidth, srcHeight);
            l = !(Size.getWidth-impl(dstSize) == 0.0f) && !(Size.getHeight-impl(dstSize) == 0.0f) ? ScaleFactorKt.times-UQTWf7w(srcSize, this.contentScale.computeScaleFactor-H7hwNQA(srcSize, dstSize)) : Size.Companion.getZero-NH-jbRc();
        }
        return l;
    }

    private final Constraints modifyConstraints(Constraints constraints) {
        boolean hasFixedDimens;
        boolean hasBoundedDimens = constraints.getHasBoundedWidth() && constraints.getHasBoundedHeight();
        boolean bl = hasFixedDimens = constraints.getHasFixedWidth() && constraints.getHasFixedHeight();
        if (!this.getUseIntrinsicSize() && hasBoundedDimens || hasFixedDimens) {
            return Constraints.copy$default(constraints, constraints.getMaxWidth(), 0, constraints.getMaxHeight(), 0, 10, null);
        }
        long intrinsicSize = this.painter.getIntrinsicSize-NH-jbRc();
        int intrinsicWidth = this.hasSpecifiedAndFiniteWidth-uvyYCjk(intrinsicSize) ? MathKt.roundToInt((float)Size.getWidth-impl(intrinsicSize)) : constraints.getMinWidth();
        int intrinsicHeight = this.hasSpecifiedAndFiniteHeight-uvyYCjk(intrinsicSize) ? MathKt.roundToInt((float)Size.getHeight-impl(intrinsicSize)) : constraints.getMinHeight();
        int constrainedWidth = UnpackedConstraintsKt.constrainWidth(constraints, intrinsicWidth);
        int constrainedHeight = UnpackedConstraintsKt.constrainHeight(constraints, intrinsicHeight);
        long scaledSize = this.calculateScaledSize-E7KxVPU(SizeKt.Size(constrainedWidth, constrainedHeight));
        int minWidth = UnpackedConstraintsKt.constrainWidth(constraints, MathKt.roundToInt((float)Size.getWidth-impl(scaledSize)));
        int minHeight = UnpackedConstraintsKt.constrainHeight(constraints, MathKt.roundToInt((float)Size.getHeight-impl(scaledSize)));
        return Constraints.copy$default(constraints, minWidth, 0, minHeight, 0, 10, null);
    }

    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        long intrinsicSize = this.painter.getIntrinsicSize-NH-jbRc();
        float srcWidth = this.hasSpecifiedAndFiniteWidth-uvyYCjk(intrinsicSize) ? Size.getWidth-impl(intrinsicSize) : Size.getWidth-impl($this$draw.getSize-NH-jbRc());
        float srcHeight = this.hasSpecifiedAndFiniteHeight-uvyYCjk(intrinsicSize) ? Size.getHeight-impl(intrinsicSize) : Size.getHeight-impl($this$draw.getSize-NH-jbRc());
        long srcSize = SizeKt.Size(srcWidth, srcHeight);
        long scaledSize = !(Size.getWidth-impl($this$draw.getSize-NH-jbRc()) == 0.0f) && !(Size.getHeight-impl($this$draw.getSize-NH-jbRc()) == 0.0f) ? ScaleFactorKt.times-UQTWf7w(srcSize, this.contentScale.computeScaleFactor-H7hwNQA(srcSize, $this$draw.getSize-NH-jbRc())) : Size.Companion.getZero-NH-jbRc();
        long alignedPosition = this.alignment.align-KFBX0sM(IntSizeKt.IntSize(MathKt.roundToInt((float)Size.getWidth-impl(scaledSize)), MathKt.roundToInt((float)Size.getHeight-impl(scaledSize))), IntSizeKt.IntSize(MathKt.roundToInt((float)Size.getWidth-impl($this$draw.getSize-NH-jbRc())), MathKt.roundToInt((float)Size.getHeight-impl($this$draw.getSize-NH-jbRc()))), $this$draw.getLayoutDirection());
        float dx = IntOffset.getX-impl(alignedPosition);
        float dy = IntOffset.getY-impl(alignedPosition);
        DrawScope $this$translate$iv = $this$draw;
        boolean $i$f$translate = false;
        $this$translate$iv.getDrawContext().getTransform().translate(dx, dy);
        DrawScope $this$draw_u24lambda_u241 = $this$translate$iv;
        boolean bl = false;
        Painter $this$draw_u24lambda_u241_u24lambda_u240 = this.painter;
        boolean bl2 = false;
        $this$draw_u24lambda_u241_u24lambda_u240.draw-x_KDEd0($this$draw_u24lambda_u241, scaledSize, this.alpha, this.colorFilter);
        $this$translate$iv.getDrawContext().getTransform().translate(-dx, -dy);
        $this$draw.drawContent();
    }

    private final boolean hasSpecifiedAndFiniteWidth-uvyYCjk(long $this$hasSpecifiedAndFiniteWidth_u2duvyYCjk) {
        float f;
        return !Size.equals-impl0($this$hasSpecifiedAndFiniteWidth_u2duvyYCjk, Size.Companion.getUnspecified-NH-jbRc()) && !Float.isInfinite(f = Size.getWidth-impl($this$hasSpecifiedAndFiniteWidth_u2duvyYCjk)) && !Float.isNaN(f);
    }

    private final boolean hasSpecifiedAndFiniteHeight-uvyYCjk(long $this$hasSpecifiedAndFiniteHeight_u2duvyYCjk) {
        float f;
        return !Size.equals-impl0($this$hasSpecifiedAndFiniteHeight_u2duvyYCjk, Size.Companion.getUnspecified-NH-jbRc()) && !Float.isInfinite(f = Size.getHeight-impl($this$hasSpecifiedAndFiniteHeight_u2duvyYCjk)) && !Float.isNaN(f);
    }

    public int hashCode() {
        int result2 = this.painter.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.sizeToIntrinsics);
        result2 = 31 * result2 + this.alignment.hashCode();
        result2 = 31 * result2 + this.contentScale.hashCode();
        result2 = 31 * result2 + Float.hashCode(this.alpha);
        ColorFilter colorFilter = this.colorFilter;
        result2 = 31 * result2 + (colorFilter != null ? colorFilter.hashCode() : 0);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        PainterModifier painterModifier = other instanceof PainterModifier ? (PainterModifier)other : null;
        if (painterModifier == null) {
            return false;
        }
        PainterModifier otherModifier = painterModifier;
        return Intrinsics.areEqual((Object)this.painter, (Object)otherModifier.painter) && this.sizeToIntrinsics == otherModifier.sizeToIntrinsics && Intrinsics.areEqual((Object)this.alignment, (Object)otherModifier.alignment) && Intrinsics.areEqual((Object)this.contentScale, (Object)otherModifier.contentScale) && this.alpha == otherModifier.alpha && Intrinsics.areEqual((Object)this.colorFilter, (Object)otherModifier.colorFilter);
    }

    @NotNull
    public String toString() {
        return "PainterModifier(painter=" + this.painter + ", sizeToIntrinsics=" + this.sizeToIntrinsics + ", alignment=" + this.alignment + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ")";
    }

    @Override
    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldIn(this, initial, operation);
    }

    @Override
    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldOut(this, initial, operation);
    }

    @Override
    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.any(this, predicate);
    }

    @Override
    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.all(this, predicate);
    }

    @Override
    @NotNull
    public Modifier then(@NotNull Modifier other) {
        return LayoutModifier.DefaultImpls.then(this, other);
    }
}

