/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.shape;

import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J?\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a2\u0006\u0004\b\u0019\u0010\u001aJ0\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H&J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/shape/CornerBasedShape;", "Landroidx/compose/ui/graphics/Shape;", "topStart", "Landroidx/compose/foundation/shape/CornerSize;", "topEnd", "bottomEnd", "bottomStart", "<init>", "(Landroidx/compose/foundation/shape/CornerSize;Landroidx/compose/foundation/shape/CornerSize;Landroidx/compose/foundation/shape/CornerSize;Landroidx/compose/foundation/shape/CornerSize;)V", "getTopStart", "()Landroidx/compose/foundation/shape/CornerSize;", "getTopEnd", "getBottomEnd", "getBottomStart", "createOutline", "Landroidx/compose/ui/graphics/Outline;", "size", "Landroidx/compose/ui/geometry/Size;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "createOutline-Pq9zytI", "(JLandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;)Landroidx/compose/ui/graphics/Outline;", "", "createOutline-LjSzlW0", "(JFFFFLandroidx/compose/ui/unit/LayoutDirection;)Landroidx/compose/ui/graphics/Outline;", "copy", "all", "fleet.noria.ui"})
public abstract class CornerBasedShape
implements Shape {
    @NotNull
    private final CornerSize topStart;
    @NotNull
    private final CornerSize topEnd;
    @NotNull
    private final CornerSize bottomEnd;
    @NotNull
    private final CornerSize bottomStart;

    public CornerBasedShape(@NotNull CornerSize topStart, @NotNull CornerSize topEnd, @NotNull CornerSize bottomEnd, @NotNull CornerSize bottomStart) {
        Intrinsics.checkNotNullParameter((Object)topStart, (String)"topStart");
        Intrinsics.checkNotNullParameter((Object)topEnd, (String)"topEnd");
        Intrinsics.checkNotNullParameter((Object)bottomEnd, (String)"bottomEnd");
        Intrinsics.checkNotNullParameter((Object)bottomStart, (String)"bottomStart");
        this.topStart = topStart;
        this.topEnd = topEnd;
        this.bottomEnd = bottomEnd;
        this.bottomStart = bottomStart;
    }

    @NotNull
    public final CornerSize getTopStart() {
        return this.topStart;
    }

    @NotNull
    public final CornerSize getTopEnd() {
        return this.topEnd;
    }

    @NotNull
    public final CornerSize getBottomEnd() {
        return this.bottomEnd;
    }

    @NotNull
    public final CornerSize getBottomStart() {
        return this.bottomStart;
    }

    @Override
    @NotNull
    public final Outline createOutline-Pq9zytI(long size2, @NotNull LayoutDirection layoutDirection, @NotNull Density density) {
        float scale2;
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        float topStart = 0.0f;
        topStart = this.topStart.toPx-TmRCtEA(size2, density);
        float topEnd = 0.0f;
        topEnd = this.topEnd.toPx-TmRCtEA(size2, density);
        float bottomEnd = 0.0f;
        bottomEnd = this.bottomEnd.toPx-TmRCtEA(size2, density);
        float bottomStart = 0.0f;
        bottomStart = this.bottomStart.toPx-TmRCtEA(size2, density);
        float minDimension = Size.getMinDimension-impl(size2);
        if (topStart + bottomStart > minDimension) {
            scale2 = minDimension / (topStart + bottomStart);
            topStart *= scale2;
            bottomStart *= scale2;
        }
        if (topEnd + bottomEnd > minDimension) {
            scale2 = minDimension / (topEnd + bottomEnd);
            topEnd *= scale2;
            bottomEnd *= scale2;
        }
        if (!(topStart >= 0.0f && topEnd >= 0.0f && bottomEnd >= 0.0f && bottomStart >= 0.0f)) {
            boolean bl = false;
            String string = "Corner size in Px can't be negative(topStart = " + topStart + ", topEnd = " + topEnd + ", bottomEnd = " + bottomEnd + ", bottomStart = " + bottomStart + ")!";
            throw new IllegalArgumentException(string.toString());
        }
        return this.createOutline-LjSzlW0(size2, topStart, topEnd, bottomEnd, bottomStart, layoutDirection);
    }

    @NotNull
    public abstract Outline createOutline-LjSzlW0(long var1, float var3, float var4, float var5, float var6, @NotNull LayoutDirection var7);

    @NotNull
    public abstract CornerBasedShape copy(@NotNull CornerSize var1, @NotNull CornerSize var2, @NotNull CornerSize var3, @NotNull CornerSize var4);

    public static /* synthetic */ CornerBasedShape copy$default(CornerBasedShape cornerBasedShape, CornerSize cornerSize, CornerSize cornerSize2, CornerSize cornerSize3, CornerSize cornerSize4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            cornerSize = cornerBasedShape.topStart;
        }
        if ((n & 2) != 0) {
            cornerSize2 = cornerBasedShape.topEnd;
        }
        if ((n & 4) != 0) {
            cornerSize3 = cornerBasedShape.bottomEnd;
        }
        if ((n & 8) != 0) {
            cornerSize4 = cornerBasedShape.bottomStart;
        }
        return cornerBasedShape.copy(cornerSize, cornerSize2, cornerSize3, cornerSize4);
    }

    @NotNull
    public final CornerBasedShape copy(@NotNull CornerSize all) {
        Intrinsics.checkNotNullParameter((Object)all, (String)"all");
        return this.copy(all, all, all, all);
    }
}

