/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.LazyListItemPlacementAnimator;
import androidx.compose.foundation.lazy.LazyListPlaceableWrapper;
import androidx.compose.foundation.lazy.LazyListPositionedItem;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B{\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0003\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0011\u0010\u0017\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0011\u0010!\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001bR\u0011\u0010#\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001b\u00a8\u0006*"}, d2={"Landroidx/compose/foundation/lazy/LazyMeasuredItem;", "", "index", "", "placeables", "", "Landroidx/compose/ui/layout/Placeable;", "isVertical", "", "horizontalAlignment", "Landroidx/compose/ui/Alignment$Horizontal;", "verticalAlignment", "Landroidx/compose/ui/Alignment$Vertical;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "reverseLayout", "beforeContentPadding", "afterContentPadding", "placementAnimator", "Landroidx/compose/foundation/lazy/LazyListItemPlacementAnimator;", "spacing", "visualOffset", "Landroidx/compose/ui/unit/IntOffset;", "key", "<init>", "(ILjava/util/List;ZLandroidx/compose/ui/Alignment$Horizontal;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/ui/unit/LayoutDirection;ZIILandroidx/compose/foundation/lazy/LazyListItemPlacementAnimator;IJLjava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getIndex", "()I", "J", "getKey", "()Ljava/lang/Object;", "size", "getSize", "sizeWithSpacings", "getSizeWithSpacings", "crossAxisSize", "getCrossAxisSize", "position", "Landroidx/compose/foundation/lazy/LazyListPositionedItem;", "offset", "layoutWidth", "layoutHeight", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nLazyMeasuredItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyMeasuredItem.kt\nandroidx/compose/foundation/lazy/LazyMeasuredItem\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,193:1\n34#2,5:194\n34#2,5:199\n*S KotlinDebug\n*F\n+ 1 LazyMeasuredItem.kt\nandroidx/compose/foundation/lazy/LazyMeasuredItem\n*L\n72#1:194,5\n93#1:199,5\n*E\n"})
public final class LazyMeasuredItem {
    private final int index;
    @NotNull
    private final List<Placeable> placeables;
    private final boolean isVertical;
    @Nullable
    private final Alignment.Horizontal horizontalAlignment;
    @Nullable
    private final Alignment.Vertical verticalAlignment;
    @NotNull
    private final LayoutDirection layoutDirection;
    private final boolean reverseLayout;
    private final int beforeContentPadding;
    private final int afterContentPadding;
    @NotNull
    private final LazyListItemPlacementAnimator placementAnimator;
    private final int spacing;
    private final long visualOffset;
    @NotNull
    private final Object key;
    private final int size;
    private final int sizeWithSpacings;
    private final int crossAxisSize;

    private LazyMeasuredItem(int index2, List<? extends Placeable> placeables, boolean isVertical, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int beforeContentPadding, int afterContentPadding, LazyListItemPlacementAnimator placementAnimator, int spacing, long visualOffset, Object key) {
        Intrinsics.checkNotNullParameter(placeables, (String)"placeables");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)placementAnimator, (String)"placementAnimator");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.index = index2;
        this.placeables = placeables;
        this.isVertical = isVertical;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.layoutDirection = layoutDirection;
        this.reverseLayout = reverseLayout;
        this.beforeContentPadding = beforeContentPadding;
        this.afterContentPadding = afterContentPadding;
        this.placementAnimator = placementAnimator;
        this.spacing = spacing;
        this.visualOffset = visualOffset;
        this.key = key;
        int mainAxisSize = 0;
        int maxCrossAxis = 0;
        List<Placeable> $this$fastForEach$iv = this.placeables;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Placeable item$iv;
            Placeable it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            mainAxisSize += this.isVertical ? it.getHeight() : it.getWidth();
            maxCrossAxis = Math.max(maxCrossAxis, !this.isVertical ? it.getHeight() : it.getWidth());
        }
        this.size = mainAxisSize;
        this.sizeWithSpacings = RangesKt.coerceAtLeast((int)(this.size + this.spacing), (int)0);
        this.crossAxisSize = maxCrossAxis;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final Object getKey() {
        return this.key;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSizeWithSpacings() {
        return this.sizeWithSpacings;
    }

    public final int getCrossAxisSize() {
        return this.crossAxisSize;
    }

    @NotNull
    public final LazyListPositionedItem position(int offset, int layoutWidth, int layoutHeight) {
        List wrappers = new ArrayList();
        int mainAxisLayoutSize = this.isVertical ? layoutHeight : layoutWidth;
        int mainAxisOffset = 0;
        mainAxisOffset = offset;
        List<Placeable> $this$fastForEach$iv = this.placeables;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            long l;
            Placeable item$iv;
            Placeable it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (this.isVertical) {
                Alignment.Horizontal horizontal = this.horizontalAlignment;
                if (horizontal == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int x = horizontal.align(it.getWidth(), layoutWidth, this.layoutDirection);
                l = IntOffsetKt.IntOffset(x, mainAxisOffset);
            } else {
                Alignment.Vertical vertical = this.verticalAlignment;
                if (vertical == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int y = vertical.align(it.getHeight(), layoutHeight);
                l = IntOffsetKt.IntOffset(mainAxisOffset, y);
            }
            long placeableOffset = l;
            mainAxisOffset += this.isVertical ? it.getHeight() : it.getWidth();
            wrappers.add(new LazyListPlaceableWrapper(placeableOffset, it, null));
        }
        return new LazyListPositionedItem(offset, this.index, this.key, this.size, -this.beforeContentPadding, mainAxisLayoutSize + this.afterContentPadding, this.isVertical, wrappers, this.placementAnimator, this.visualOffset, this.reverseLayout, mainAxisLayoutSize, null);
    }

    @ExperimentalFoundationApi
    public /* synthetic */ LazyMeasuredItem(int index2, List placeables, boolean isVertical, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int beforeContentPadding, int afterContentPadding, LazyListItemPlacementAnimator placementAnimator, int spacing, long visualOffset, Object key, DefaultConstructorMarker $constructor_marker) {
        this(index2, placeables, isVertical, horizontalAlignment, verticalAlignment, layoutDirection, reverseLayout, beforeContentPadding, afterContentPadding, placementAnimator, spacing, visualOffset, key);
    }
}

