/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\r\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Landroidx/compose/animation/core/VectorizedFloatDecaySpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;", "floatDecaySpec", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "<init>", "(Landroidx/compose/animation/core/FloatDecayAnimationSpec;)V", "getFloatDecaySpec", "()Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "targetVector", "absVelocityThreshold", "", "getAbsVelocityThreshold", "()F", "getValueFromNanos", "playTimeNanos", "", "initialValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getDurationNanos", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getVelocityFromNanos", "getTargetValue", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "fleet.noria.ui"})
final class VectorizedFloatDecaySpec<V extends AnimationVector>
implements VectorizedDecayAnimationSpec<V> {
    @NotNull
    private final FloatDecayAnimationSpec floatDecaySpec;
    private V valueVector;
    private V velocityVector;
    private V targetVector;
    private final float absVelocityThreshold;

    public VectorizedFloatDecaySpec(@NotNull FloatDecayAnimationSpec floatDecaySpec) {
        Intrinsics.checkNotNullParameter((Object)floatDecaySpec, (String)"floatDecaySpec");
        this.floatDecaySpec = floatDecaySpec;
        this.absVelocityThreshold = this.floatDecaySpec.getAbsVelocityThreshold();
    }

    @NotNull
    public final FloatDecayAnimationSpec getFloatDecaySpec() {
        return this.floatDecaySpec;
    }

    @Override
    public float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$fleet_noria_ui();
        while (i < n) {
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$fleet_noria_ui(i, this.floatDecaySpec.getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$fleet_noria_ui(i), ((AnimationVector)initialVelocity).get$fleet_noria_ui(i)));
            ++i;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$fleet_noria_ui();
        while (i < n) {
            maxDuration = Math.max(maxDuration, this.floatDecaySpec.getDurationNanos(((AnimationVector)initialValue).get$fleet_noria_ui(i), ((AnimationVector)initialVelocity).get$fleet_noria_ui(i)));
            ++i;
        }
        return maxDuration;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$fleet_noria_ui();
        while (i < n) {
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$fleet_noria_ui(i, this.floatDecaySpec.getVelocityFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$fleet_noria_ui(i), ((AnimationVector)initialVelocity).get$fleet_noria_ui(i)));
            ++i;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    @NotNull
    public V getTargetValue(@NotNull V initialValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.targetVector == null) {
            this.targetVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.targetVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$fleet_noria_ui();
        while (i < n) {
            V v2 = this.targetVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$fleet_noria_ui(i, this.floatDecaySpec.getTargetValue(((AnimationVector)initialValue).get$fleet_noria_ui(i), ((AnimationVector)initialVelocity).get$fleet_noria_ui(i)));
            ++i;
        }
        V v3 = this.targetVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            v3 = null;
        }
        return v3;
    }
}

