/*
 * Decompiled with CFR 0.152.
 */
package fleet.profiling.core.idea;

import fleet.api.Arch;
import fleet.api.Os;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lfleet/profiling/core/idea/Platform;", "", "platformName", "", "readableName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getPlatformName", "()Ljava/lang/String;", "getReadableName", "WINDOWS_X64", "WINDOWS_AARCH64", "LINUX_X64", "LINUX_AARCH64", "MACOS_X64", "MACOS_M1", "Companion", "fleet.profiling.core"})
final class Platform
extends Enum<Platform> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String platformName;
    @NotNull
    private final String readableName;
    public static final /* enum */ Platform WINDOWS_X64;
    public static final /* enum */ Platform WINDOWS_AARCH64;
    public static final /* enum */ Platform LINUX_X64;
    public static final /* enum */ Platform LINUX_AARCH64;
    public static final /* enum */ Platform MACOS_X64;
    public static final /* enum */ Platform MACOS_M1;
    private static final /* synthetic */ Platform[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Platform(String platformName, String readableName) {
        this.platformName = platformName;
        this.readableName = readableName;
    }

    @NotNull
    public final String getPlatformName() {
        return this.platformName;
    }

    @NotNull
    public final String getReadableName() {
        return this.readableName;
    }

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String value) {
        return Enum.valueOf(Platform.class, value);
    }

    @NotNull
    public static EnumEntries<Platform> getEntries() {
        return $ENTRIES;
    }

    static {
        WINDOWS_X64 = new Platform("windows", "Windows, x86_64");
        WINDOWS_AARCH64 = new Platform("windows-aarch64", "Windows, aarch64");
        LINUX_X64 = new Platform("linux", "Linux, x86_64");
        LINUX_AARCH64 = new Platform("linux-aarch64", "Linux, aarch64");
        MACOS_X64 = new Platform("macos", "Mac OS X, x86_64");
        MACOS_M1 = new Platform("macos", "Apple M1");
        $VALUES = platformArray = new Platform[]{Platform.WINDOWS_X64, Platform.WINDOWS_AARCH64, Platform.LINUX_X64, Platform.LINUX_AARCH64, Platform.MACOS_X64, Platform.MACOS_M1};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lfleet/profiling/core/idea/Platform$Companion;", "", "<init>", "()V", "from", "Lfleet/profiling/core/idea/Platform;", "os", "Lfleet/api/Os;", "arch", "Lfleet/api/Arch;", "fleet.profiling.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Platform from(@NotNull Os os, @NotNull Arch arch) {
            Platform platform;
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            if (os == Os.Windows && arch == Arch.x86_64) {
                platform = WINDOWS_X64;
            } else if (os == Os.Windows && arch == Arch.arm) {
                platform = WINDOWS_AARCH64;
            } else if (os == Os.Linux && arch == Arch.x86_64) {
                platform = LINUX_X64;
            } else if (os == Os.Linux && arch == Arch.arm) {
                platform = LINUX_AARCH64;
            } else if (os == Os.Macos && arch == Arch.x86_64) {
                platform = MACOS_X64;
            } else if (os == Os.Macos && arch == Arch.aarch64) {
                platform = MACOS_M1;
            } else {
                throw new IllegalStateException("Library libasyncProfiler is not available for platform: " + os + " [" + arch + "]");
            }
            return platform;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

