/*
 * Decompiled with CFR 0.152.
 */
package fleet.docker.frontend.devcontainers.vscode;

import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/docker/frontend/devcontainers/vscode/DockerResponseItemTtyHandler;", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "<init>", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "currentStreams", "", "", "", "progressFormat", "Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat;", "handleItem", "", "item", "Lcom/github/dockerjava/api/model/BuildResponseItem;", "displayItem", "Companion", "fleet.plugins.docker.frontend"})
@SourceDebugExtension(value={"SMAP\nDockerResponseItemTtyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerResponseItemTtyHandler.kt\nfleet/docker/frontend/devcontainers/vscode/DockerResponseItemTtyHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n381#2,7:105\n1#3:112\n*S KotlinDebug\n*F\n+ 1 DockerResponseItemTtyHandler.kt\nfleet/docker/frontend/devcontainers/vscode/DockerResponseItemTtyHandler\n*L\n32#1:105,7\n*E\n"})
public final class DockerResponseItemTtyHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TtySink ttySink;
    @NotNull
    private final Map<String, Integer> currentStreams;
    @NotNull
    private final DockerProgressDetailsFormat progressFormat;
    @NotNull
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public DockerResponseItemTtyHandler(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
        this.currentStreams = new LinkedHashMap();
        this.progressFormat = new DockerProgressDetailsFormat(null, 1, null);
    }

    public final void handleItem(@NotNull BuildResponseItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int jump = 0;
        String id = item.getId();
        if (id == null || item.getProgress() == null) {
            this.currentStreams.clear();
        } else {
            Integer n;
            Map<String, Integer> $this$getOrPut$iv = this.currentStreams;
            boolean $i$f$getOrPut = false;
            Integer value$iv = $this$getOrPut$iv.get(id);
            if (value$iv == null) {
                boolean bl = false;
                this.ttySink.invoke("\r\n");
                Integer answer$iv = this.currentStreams.size();
                $this$getOrPut$iv.put(id, answer$iv);
                n = answer$iv;
            } else {
                n = value$iv;
            }
            int itemIdx = ((Number)n).intValue();
            jump = this.currentStreams.size() - itemIdx;
            this.ttySink.ttyCursorUp(jump);
        }
        this.displayItem(item);
        if (id != null) {
            this.ttySink.ttyCursorDown(jump);
        }
    }

    private final void displayItem(BuildResponseItem item) {
        block21: {
            String endLine;
            block23: {
                Object object;
                String safeStatus;
                block27: {
                    ResponseItem.ErrorDetail error;
                    block26: {
                        String string;
                        block25: {
                            String string2;
                            block24: {
                                String string3;
                                block22: {
                                    CharSequence it;
                                    block20: {
                                        String string4;
                                        Long time;
                                        boolean bl;
                                        ResponseItem.ErrorDetail errorDetail = item.getErrorDetail();
                                        if (errorDetail != null) {
                                            Integer n = errorDetail.getCode();
                                            bl = n != null && 401 == n;
                                        } else {
                                            bl = false;
                                        }
                                        if (bl) {
                                            this.ttySink.invoke("authentication is required");
                                            return;
                                        }
                                        endLine = "";
                                        String string5 = item.getStream();
                                        if (string5 == null) {
                                            string5 = "";
                                        }
                                        if (((CharSequence)string5).length() == 0 && item.getProgressDetail() != null) {
                                            this.ttySink.ttyClearLine();
                                            endLine = "\r";
                                        }
                                        if ((time = item.getTime()) != null) {
                                            long l = 0L;
                                            if (time != l) {
                                                this.ttySink.invoke(TIME_FORMAT.format(new Date(time)) + " ");
                                            }
                                        }
                                        String string6 = item.getId();
                                        if (string6 != null) {
                                            it = string6;
                                            boolean bl2 = false;
                                            this.ttySink.invoke(it + ": ");
                                        }
                                        String string7 = item.getFrom();
                                        if (string7 != null) {
                                            it = string7;
                                            boolean bl3 = false;
                                            this.ttySink.invoke("(from " + it + ")");
                                        }
                                        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
                                        if (progressDetail != null) {
                                            ResponseItem.ProgressDetail it2 = progressDetail;
                                            boolean bl4 = false;
                                            string4 = this.progressFormat.toTtyString((DockerResponseItem.ProgressDetail)new DockerResponseItem.ProgressDetail.Impl(DockerResponseItemTtyHandler.Companion.orZero(it2.getStart()), DockerResponseItemTtyHandler.Companion.orZero(it2.getTotal()), DockerResponseItemTtyHandler.Companion.orZero(it2.getCurrent())));
                                        } else {
                                            string4 = null;
                                        }
                                        String progress = string4;
                                        if (progress == null) break block20;
                                        this.ttySink.invoke(item.getStatus() + " " + progress + endLine);
                                        break block21;
                                    }
                                    if (item.getStream() == null) break block22;
                                    String string8 = item.getStream();
                                    Intrinsics.checkNotNull((Object)string8);
                                    it = string8;
                                    Object it2 = new Regex("(?<=[^\r])\n");
                                    String bl4 = "\r\n";
                                    it2 = it2.replace(it, bl4);
                                    boolean bl = false;
                                    Object fixedStream = StringsKt.startsWith$default((CharSequence)((CharSequence)it2), (char)'\n', (boolean)false, (int)2, null) ? "\r" + (String)it2 : it2;
                                    this.ttySink.invoke((String)fixedStream + endLine);
                                    break block21;
                                }
                                if (item.getErrorDetail() == null) break block23;
                                ResponseItem.ErrorDetail errorDetail = item.getErrorDetail();
                                Intrinsics.checkNotNull((Object)errorDetail);
                                error = errorDetail;
                                string2 = item.getStatus();
                                if (string2 == null) break block24;
                                String it = string3 = string2;
                                boolean bl = false;
                                string2 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                                if (string2 != null) break block25;
                            }
                            string2 = safeStatus = "Error response from daemon:";
                        }
                        if ((object = error.getMessage()) == null) break block26;
                        String it = string = object;
                        boolean bl = false;
                        object = !StringsKt.isBlank((CharSequence)it) ? string : null;
                        if (object != null) break block27;
                    }
                    object = "Error code " + error.getCode();
                }
                Object errorMessage = object;
                this.ttySink.invoke(safeStatus + " " + (String)errorMessage + "\r\n");
                break block21;
            }
            endLine = "\r";
            String string = item.getStatus();
            if (string == null) {
                string = "";
            }
            this.ttySink.invoke(string + endLine + "\n");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lfleet/docker/frontend/devcontainers/vscode/DockerResponseItemTtyHandler$Companion;", "", "<init>", "()V", "TIME_FORMAT", "Ljava/text/SimpleDateFormat;", "getTIME_FORMAT", "()Ljava/text/SimpleDateFormat;", "orZero", "", "(Ljava/lang/Long;)J", "fleet.plugins.docker.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDateFormat getTIME_FORMAT() {
            return TIME_FORMAT;
        }

        private final long orZero(Long $this$orZero) {
            Long l = $this$orZero;
            return l != null ? l : 0L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

