/*
 * Decompiled with CFR 0.152.
 */
package fleet.docker.frontend;

import androidx.compose.foundation.BackgroundKt;
import androidx.compose.foundation.FocusableKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.common.document.DocumentEntity;
import fleet.common.fs.SharedWorkspaceRootEntity;
import fleet.common.settings.SettingsChangerKt;
import fleet.common.settings.SettingsKey;
import fleet.common.topology.Contract;
import fleet.common.topology.ContractKt;
import fleet.common.topology.Host;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.JobsKt;
import fleet.compose.theme.components.ButtonKt;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.docker.common.DockerEngine;
import fleet.docker.common.DockerErrorUtilsKt;
import fleet.docker.common.DockerSettingsKeys;
import fleet.docker.frontend.CheckState;
import fleet.docker.frontend.DockerControlKt;
import fleet.docker.frontend.DockerKeys;
import fleet.docker.frontend.DockerViewEntity;
import fleet.docker.frontend.DockerViewEntityKt;
import fleet.docker.frontend.containers.DockerContainerNodeKt;
import fleet.docker.frontend.images.DockerImageNodeKt;
import fleet.docker.protocol.DockerError;
import fleet.frontend.KernelExtKt;
import fleet.frontend.fsd.FleetFileChooserKt;
import fleet.frontend.fsd.LocalFsdExtKt;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.layout.ConfirmDialogCommand;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.navigation.ContextFile;
import fleet.frontend.navigation.FilesActionsKt;
import fleet.frontend.navigation.ViewDslKt;
import fleet.frontend.settings.LazySettingsDocument;
import fleet.frontend.ui.db.DurableStateKt;
import fleet.frontend.ui.layout.PlaceholdersKt;
import fleet.frontend.ui.layout.window.WindowViewKt;
import fleet.kernel.SagaKt;
import fleet.kernel.TransactorKt;
import fleet.kernel.plugins.ContributionScope;
import fleet.kernel.plugins.PluginScope;
import fleet.navigation.common.api.ViewTypeId;
import fleet.util.openmap.Key;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import noria.Cell;
import noria.CellKt;
import noria.NoriaContext;
import noria.ReadScope;
import noria.StateCell;
import noria.impl.Runtime;
import noria.model.ActionContext;
import noria.model.ThemeKey;
import noria.ui.ApplyModifierKt;
import noria.ui.components.split.SplitContext;
import noria.ui.components.split.SplitDirection;
import noria.ui.components.split.SplitModel;
import noria.ui.components.split.SplitState;
import noria.ui.components.split.SplitViewKt;
import noria.ui.components.split.StretchPolicy;
import noria.ui.events.HandlerScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a\u001e\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\f\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DockerViewType", "Lfleet/navigation/common/api/ViewTypeId;", "", "dockerView", "Lfleet/kernel/plugins/ContributionScope;", "renderDockerViewEntity", "Lnoria/NoriaContext;", "dockerViewEntity", "Lfleet/docker/frontend/DockerViewEntity;", "updateState", "newState", "Lfleet/docker/frontend/CheckState;", "(Lfleet/docker/frontend/DockerViewEntity;Lfleet/docker/frontend/CheckState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findRandomHostForDockerOrThrow", "Lfleet/common/topology/Host;", "fleet.plugins.docker.frontend"})
@SourceDebugExtension(value={"SMAP\nDockerViewEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerViewEntity.kt\nfleet/docker/frontend/DockerViewEntityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n230#2,2:249\n*S KotlinDebug\n*F\n+ 1 DockerViewEntity.kt\nfleet/docker/frontend/DockerViewEntityKt\n*L\n247#1:249,2\n*E\n"})
public final class DockerViewEntityKt {
    @NotNull
    private static final ViewTypeId<Unit> DockerViewType = new ViewTypeId("docker");

    public static final void dockerView(@NotNull ContributionScope $this$dockerView) {
        Intrinsics.checkNotNullParameter((Object)$this$dockerView, (String)"<this>");
        ViewDslKt.viewType((ContributionScope)$this$dockerView, DockerViewType, (KSerializer)BuiltinSerializersKt.serializer((Unit)Unit.INSTANCE), (Function1)dockerView.1.INSTANCE);
    }

    @Composable
    private static final void renderDockerViewEntity(NoriaContext $this$renderDockerViewEntity, DockerViewEntity dockerViewEntity) {
        Host host2 = Host.Companion.lookup(dockerViewEntity.getHostId());
        if (host2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Host host3 = host2;
        DockerEngine dockerEngine = (DockerEngine)EntityAttributeKt.entityOnNonUniqueAttribute((EntityAttribute)((EntityAttribute)DockerEngine.Companion.getRunningOnHostIdAttr()), (Object)dockerViewEntity.getHostId());
        PluginScope pluginScope = (PluginScope)$this$renderDockerViewEntity.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope());
        WindowEntity window2 = (WindowEntity)$this$renderDockerViewEntity.getCurrent((CompositionLocal)WindowViewKt.getLocalWindowEntity());
        Runtime.enterScope((NoriaContext)$this$renderDockerViewEntity, (int)21);
        Object[] objectArray = new Object[]{dockerViewEntity, pluginScope, window2, host3, dockerEngine};
        ApplyModifierKt.withModifier((NoriaContext)$this$renderDockerViewEntity, (Modifier)FocusableKt.focusGroup((Modifier)BackgroundKt.background-bw27NRU$default((Modifier)((Modifier)Modifier.Companion), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$renderDockerViewEntity)).get(ThemeKeys.INSTANCE.getToolBackground())).unbox-impl(), null, (int)2, null)), (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(dockerViewEntity, pluginScope, window2, host3, dockerEngine){
            final /* synthetic */ DockerViewEntity $dockerViewEntity;
            final /* synthetic */ PluginScope $pluginScope;
            final /* synthetic */ WindowEntity $window;
            final /* synthetic */ Host $host;
            final /* synthetic */ DockerEngine $dockerEngine;
            {
                this.$dockerViewEntity = $dockerViewEntity;
                this.$pluginScope = $pluginScope;
                this.$window = $window;
                this.$host = $host;
                this.$dockerEngine = $dockerEngine;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void invoke(NoriaContext $this$withModifier) {
                Intrinsics.checkNotNullParameter((Object)$this$withModifier, (String)"$this$withModifier");
                DockerError error = this.$dockerViewEntity.getError();
                if (error != null) {
                    if (error instanceof DockerError.DockerNotFound) {
                        Runtime.enterScope((NoriaContext)$this$withModifier, (int)4);
                        Object[] objectArray = new Object[]{this.$pluginScope, this.$window};
                        PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)"Docker", (CharSequence)"No Docker executable found.\nLocate or install Docker to run Docker containers", null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(this.$pluginScope, this.$window){
                            final /* synthetic */ PluginScope $pluginScope;
                            final /* synthetic */ WindowEntity $window;
                            {
                                this.$pluginScope = $pluginScope;
                                this.$window = $window;
                                super(1);
                            }

                            public final void invoke(NoriaContext $this$defaultTabPlaceholder) {
                                Intrinsics.checkNotNullParameter((Object)$this$defaultTabPlaceholder, (String)"$this$defaultTabPlaceholder");
                                Runtime.enterScope((NoriaContext)$this$defaultTabPlaceholder, (int)3);
                                Object[] objectArray = new Object[]{this.$pluginScope, this.$window};
                                ButtonKt.Button$default((NoriaContext)$this$defaultTabPlaceholder, null, (String)"Locate Docker...", null, null, null, (boolean)false, (boolean)false, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<HandlerScope, Unit>(this.$pluginScope, this.$window){
                                    final /* synthetic */ PluginScope $pluginScope;
                                    final /* synthetic */ WindowEntity $window;
                                    {
                                        this.$pluginScope = $pluginScope;
                                        this.$window = $window;
                                        super(1);
                                    }

                                    public final void invoke(HandlerScope $this$Button) {
                                        Intrinsics.checkNotNullParameter((Object)$this$Button, (String)"$this$Button");
                                        ContextFile contextFile = FilesActionsKt.contextDirectory((ActionContext)$this$Button.getActionContext());
                                        Object preferredDir = contextFile != null ? contextFile.getFileAddress() : null;
                                        Object object = preferredDir;
                                        if (object == null) {
                                            SharedWorkspaceRootEntity sharedWorkspaceRootEntity = (SharedWorkspaceRootEntity)CollectionsKt.firstOrNull((Iterable)SharedWorkspaceRootEntity.Companion.all());
                                            object = sharedWorkspaceRootEntity != null ? sharedWorkspaceRootEntity.getDirAddress() : null;
                                        }
                                        FileAddress initialDir = object;
                                        SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.$pluginScope), (Entity[])new Entity[0], null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$window, initialDir, null){
                                            int label;
                                            final /* synthetic */ WindowEntity $window;
                                            final /* synthetic */ FileAddress $initialDir;
                                            {
                                                this.$window = $window;
                                                this.$initialDir = $initialDir;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = FleetFileChooserKt.showOpenDialog$default((WindowEntity)this.$window, (boolean)false, (FileAddress)this.$initialDir, null, (boolean)false, (boolean)false, (Function2)((Function2)new Function2<FileAddress, Continuation<? super ConfirmDialogCommand>, Object>(null){
                                                            int label;
                                                            /* synthetic */ Object L$0;

                                                            /*
                                                             * Unable to fully structure code
                                                             */
                                                            public final Object invokeSuspend(Object var1_1) {
                                                                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)var1_1);
                                                                        fileAddress = (FileAddress)this.L$0;
                                                                        pathString = fileAddress.getPath().joinToString();
                                                                        this.L$0 = pathString;
                                                                        this.label = 1;
                                                                        v0 = new LazySettingsDocument((Function0)renderDockerViewEntity.document.1.INSTANCE).getOrCreateDocument((Continuation)this);
                                                                        if (v0 == var5_2) {
                                                                            return var5_2;
                                                                        }
                                                                        ** GOTO lbl17
                                                                    }
                                                                    case 1: {
                                                                        pathString = (String)this.L$0;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v0 = $result;
lbl17:
                                                                        // 2 sources

                                                                        document = (DocumentEntity)v0;
                                                                        this.L$0 = null;
                                                                        this.label = 2;
                                                                        v1 = SettingsChangerKt.changeInDocument((SettingsKey)DockerSettingsKeys.INSTANCE.getDockerExecutable(), (DocumentEntity)document, (Object)pathString, (Continuation)((Continuation)this));
                                                                        if (v1 == var5_2) {
                                                                            return var5_2;
                                                                        }
                                                                        ** GOTO lbl27
                                                                    }
                                                                    case 2: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v1 = $result;
lbl27:
                                                                        // 2 sources

                                                                        return ConfirmDialogCommand.CLOSE;
                                                                    }
                                                                }
                                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                            }

                                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                var3_3.L$0 = value;
                                                                return (Continuation)var3_3;
                                                            }

                                                            public final Object invoke(FileAddress p1, Continuation<? super ConfirmDialogCommand> p2) {
                                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                            }
                                                        }), (Continuation)((Continuation)this), (int)58, null);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)6, null);
                                    }
                                })), (int)253, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$defaultTabPlaceholder);
                            }
                        })), (int)8, null);
                        Unit unit = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)$this$withModifier);
                        return;
                    } else {
                        String title = "Can\u2019t Connect to Docker Daemon";
                        if (error instanceof DockerError.ConnectionToDaemonError && ((DockerError.ConnectionToDaemonError)error).getSocket() != null) {
                            String socketFile = DockerErrorUtilsKt.getSocketFile((DockerError.ConnectionToDaemonError)((DockerError.ConnectionToDaemonError)error));
                            Runtime.enterScope((NoriaContext)$this$withModifier, (int)5);
                            StateCell stateCell = CellKt.state((NoriaContext)$this$withModifier, (Function0)renderDockerViewEntity.triedToLaunch.1.INSTANCE);
                            Runtime.exitScope((NoriaContext)$this$withModifier);
                            StateCell triedToLaunch2 = stateCell;
                            CheckState checkState = this.$dockerViewEntity.getCheckState();
                            if (Intrinsics.areEqual((Object)checkState, (Object)CheckState.Checking.INSTANCE)) {
                                Runtime.enterScope((NoriaContext)$this$withModifier, (int)6);
                                PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)title, (CharSequence)("Checking the daemon status at " + ((DockerError.ConnectionToDaemonError)error).getSocket() + "..."), null, null, (int)24, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withModifier);
                                Runtime.enterScope((NoriaContext)$this$withModifier, (int)7);
                                JobsKt.LaunchedBackgroundEffect((NoriaContext)$this$withModifier, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$dockerViewEntity, this.$host, socketFile, this.$window, null){
                                    Object L$0;
                                    int label;
                                    final /* synthetic */ DockerViewEntity $dockerViewEntity;
                                    final /* synthetic */ Host $host;
                                    final /* synthetic */ String $socketFile;
                                    final /* synthetic */ WindowEntity $window;
                                    {
                                        this.$dockerViewEntity = $dockerViewEntity;
                                        this.$host = $host;
                                        this.$socketFile = $socketFile;
                                        this.$window = $window;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object var1_1) {
                                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                var2_3 = this.$dockerViewEntity;
                                                this.L$0 = var2_3;
                                                this.label = 1;
                                                v0 = DockerControlKt.checkDockerState(this.$host, this.$socketFile, this.$window, (Continuation<? super CheckState>)((Continuation)this));
                                                if (v0 == var3_2) {
                                                    return var3_2;
                                                }
                                                ** GOTO lbl16
                                            }
                                            case 1: {
                                                var2_3 = (DockerViewEntity)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl16:
                                                // 2 sources

                                                this.L$0 = null;
                                                this.label = 2;
                                                v1 = DockerViewEntityKt.access$updateState(var2_3, (CheckState)v0, (Continuation)this);
                                                if (v1 == var3_2) {
                                                    return var3_2;
                                                }
                                                ** GOTO lbl25
                                            }
                                            case 2: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl25:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }));
                                unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withModifier);
                                return;
                            } else if (checkState instanceof CheckState.DaemonExecutableNotFound) {
                                Runtime.enterScope((NoriaContext)$this$withModifier, (int)8);
                                PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)title, (CharSequence)((CheckState.DaemonExecutableNotFound)checkState).getError(), null, null, (int)24, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withModifier);
                                return;
                            } else if (checkState instanceof CheckState.DaemonNotRunning) {
                                Runtime.enterScope((NoriaContext)$this$withModifier, (int)11);
                                Object[] objectArray = new Object[]{checkState, triedToLaunch2, this.$pluginScope, this.$host, socketFile, this.$window, this.$dockerViewEntity};
                                PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)title, (CharSequence)((CheckState.DaemonNotRunning)checkState).problemDescription((Boolean)$this$withModifier.read((Cell)triedToLaunch2)), null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(checkState, (StateCell<Boolean>)triedToLaunch2, this.$pluginScope, this.$host, socketFile, this.$window, this.$dockerViewEntity){
                                    final /* synthetic */ CheckState $checkState;
                                    final /* synthetic */ StateCell<Boolean> $triedToLaunch;
                                    final /* synthetic */ PluginScope $pluginScope;
                                    final /* synthetic */ Host $host;
                                    final /* synthetic */ String $socketFile;
                                    final /* synthetic */ WindowEntity $window;
                                    final /* synthetic */ DockerViewEntity $dockerViewEntity;
                                    {
                                        this.$checkState = $checkState;
                                        this.$triedToLaunch = $triedToLaunch;
                                        this.$pluginScope = $pluginScope;
                                        this.$host = $host;
                                        this.$socketFile = $socketFile;
                                        this.$window = $window;
                                        this.$dockerViewEntity = $dockerViewEntity;
                                        super(1);
                                    }

                                    public final void invoke(NoriaContext $this$defaultTabPlaceholder) {
                                        Intrinsics.checkNotNullParameter((Object)$this$defaultTabPlaceholder, (String)"$this$defaultTabPlaceholder");
                                        Runtime.enterScope((NoriaContext)$this$defaultTabPlaceholder, (int)9);
                                        StateCell stateCell = CellKt.state((NoriaContext)$this$defaultTabPlaceholder, (Function0)renderDockerViewEntity.executionInProgress.1.INSTANCE);
                                        Runtime.exitScope((NoriaContext)$this$defaultTabPlaceholder);
                                        StateCell executionInProgress2 = stateCell;
                                        boolean execInProgressValue = (Boolean)$this$defaultTabPlaceholder.read((Cell)executionInProgress2);
                                        Runtime.enterScope((NoriaContext)$this$defaultTabPlaceholder, (int)10);
                                        Object[] objectArray = new Object[]{executionInProgress2, this.$pluginScope, this.$checkState, this.$host, this.$socketFile, this.$window, this.$triedToLaunch, this.$dockerViewEntity};
                                        ButtonKt.Button$default((NoriaContext)$this$defaultTabPlaceholder, null, (String)((CheckState.DaemonNotRunning)this.$checkState).buttonText(execInProgressValue, (Boolean)$this$defaultTabPlaceholder.read((Cell)this.$triedToLaunch)), null, null, null, (!execInProgressValue ? 1 : 0) != 0, (boolean)false, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<HandlerScope, Unit>((StateCell<Boolean>)executionInProgress2, this.$pluginScope, this.$checkState, this.$host, this.$socketFile, this.$window, this.$triedToLaunch, this.$dockerViewEntity){
                                            final /* synthetic */ StateCell<Boolean> $executionInProgress;
                                            final /* synthetic */ PluginScope $pluginScope;
                                            final /* synthetic */ CheckState $checkState;
                                            final /* synthetic */ Host $host;
                                            final /* synthetic */ String $socketFile;
                                            final /* synthetic */ WindowEntity $window;
                                            final /* synthetic */ StateCell<Boolean> $triedToLaunch;
                                            final /* synthetic */ DockerViewEntity $dockerViewEntity;
                                            {
                                                this.$executionInProgress = $executionInProgress;
                                                this.$pluginScope = $pluginScope;
                                                this.$checkState = $checkState;
                                                this.$host = $host;
                                                this.$socketFile = $socketFile;
                                                this.$window = $window;
                                                this.$triedToLaunch = $triedToLaunch;
                                                this.$dockerViewEntity = $dockerViewEntity;
                                                super(1);
                                            }

                                            public final void invoke(HandlerScope $this$Button) {
                                                Intrinsics.checkNotNullParameter((Object)$this$Button, (String)"$this$Button");
                                                this.$executionInProgress.update((Function1)renderDockerViewEntity.1.INSTANCE);
                                                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)this.$pluginScope), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$checkState, this.$host, this.$socketFile, this.$window, this.$triedToLaunch, this.$dockerViewEntity, null){
                                                    int I$0;
                                                    int I$1;
                                                    Object L$0;
                                                    Object L$1;
                                                    Object L$2;
                                                    int label;
                                                    final /* synthetic */ CheckState $checkState;
                                                    final /* synthetic */ Host $host;
                                                    final /* synthetic */ String $socketFile;
                                                    final /* synthetic */ WindowEntity $window;
                                                    final /* synthetic */ StateCell<Boolean> $triedToLaunch;
                                                    final /* synthetic */ DockerViewEntity $dockerViewEntity;
                                                    {
                                                        this.$checkState = $checkState;
                                                        this.$host = $host;
                                                        this.$socketFile = $socketFile;
                                                        this.$window = $window;
                                                        this.$triedToLaunch = $triedToLaunch;
                                                        this.$dockerViewEntity = $dockerViewEntity;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    public final Object invokeSuspend(Object var1_1) {
                                                        var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.label = 1;
                                                                v0 = ((CheckState.DaemonNotRunning)this.$checkState).getFix().invoke((Object)this);
                                                                if (v0 == var9_2) {
                                                                    return var9_2;
                                                                }
                                                                ** GOTO lbl13
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl13:
                                                                // 2 sources

                                                                var2_3 = 5;
                                                                var3_5 = this.$host;
                                                                var4_6 = this.$socketFile;
                                                                var5_7 = this.$window;
                                                                var6_8 = 0;
lbl18:
                                                                // 2 sources

                                                                while (var6_8 < var2_3) {
                                                                    $i$a$-repeat-DockerViewEntityKt$renderDockerViewEntity$1$3$1$2$1 = false;
                                                                    this.L$0 = var3_5;
                                                                    this.L$1 = var4_6;
                                                                    this.L$2 = var5_7;
                                                                    this.I$0 = var2_3;
                                                                    this.I$1 = var6_8;
                                                                    this.label = 2;
                                                                    v1 = DockerControlKt.checkDockerState(var3_5, var4_6, var5_7, (Continuation<? super CheckState>)this);
                                                                    if (v1 == var9_2) {
                                                                        return var9_2;
                                                                    }
                                                                    ** GOTO lbl40
                                                                }
                                                                break;
                                                            }
                                                            case 2: {
                                                                $i$a$-repeat-DockerViewEntityKt$renderDockerViewEntity$1$3$1$2$1 = false;
                                                                var6_8 = this.I$1;
                                                                var2_3 = this.I$0;
                                                                var5_7 = (WindowEntity)this.L$2;
                                                                var4_6 = (String)this.L$1;
                                                                var3_5 = (Host)this.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v1 = $result;
lbl40:
                                                                // 2 sources

                                                                if ((s = (CheckState)v1) instanceof CheckState.AllInPlace) {
                                                                    return Unit.INSTANCE;
                                                                }
                                                                this.L$0 = var3_5;
                                                                this.L$1 = var4_6;
                                                                this.L$2 = var5_7;
                                                                this.I$0 = var2_3;
                                                                this.I$1 = var6_8;
                                                                this.label = 3;
                                                                v2 = DelayKt.delay((long)4000L, (Continuation)this);
                                                                if (v2 == var9_2) {
                                                                    return var9_2;
                                                                }
                                                                ** GOTO lbl61
                                                            }
                                                            case 3: {
                                                                $i$a$-repeat-DockerViewEntityKt$renderDockerViewEntity$1$3$1$2$1 = false;
                                                                var6_8 = this.I$1;
                                                                var2_3 = this.I$0;
                                                                var5_7 = (WindowEntity)this.L$2;
                                                                var4_6 = (String)this.L$1;
                                                                var3_5 = (Host)this.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v2 = $result;
lbl61:
                                                                // 2 sources

                                                                ++var6_8;
                                                                ** GOTO lbl18
                                                            }
                                                        }
                                                        this.L$0 = null;
                                                        this.L$1 = null;
                                                        this.L$2 = null;
                                                        this.label = 4;
                                                        v3 = DockerControlKt.checkDockerState(this.$host, this.$socketFile, this.$window, (Continuation<? super CheckState>)((Continuation)this));
                                                        if (v3 == var9_2) {
                                                            return var9_2;
                                                        }
                                                        ** GOTO lbl74
                                                        {
                                                            case 4: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v3 = $result;
lbl74:
                                                                // 2 sources

                                                                if ((lastChanceState = (CheckState)v3) instanceof CheckState.DaemonNotRunning) {
                                                                    this.$triedToLaunch.update((Function1)renderDockerViewEntity.2.INSTANCE);
                                                                }
                                                                this.label = 5;
                                                                v4 = DockerViewEntityKt.access$updateState(this.$dockerViewEntity, lastChanceState, (Continuation)this);
                                                                if (v4 == var9_2) {
                                                                    return var9_2;
                                                                }
                                                                ** GOTO lbl84
                                                            }
                                                            case 5: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v4 = $result;
lbl84:
                                                                // 2 sources

                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (int)3, null);
                                            }
                                        })), (int)221, null);
                                        Unit unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)$this$defaultTabPlaceholder);
                                    }
                                })), (int)8, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withModifier);
                                return;
                            } else if (checkState instanceof CheckState.NoSocket) {
                                Runtime.enterScope((NoriaContext)$this$withModifier, (int)12);
                                PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)title, (CharSequence)("Docker daemon seems to be running, but socket file " + ((DockerError.ConnectionToDaemonError)error).getSocket() + " does not exist or can't be accessed"), null, null, (int)24, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withModifier);
                                return;
                            } else {
                                if (!Intrinsics.areEqual((Object)checkState, (Object)CheckState.AllInPlace.INSTANCE)) throw new NoWhenBranchMatchedException();
                                Runtime.enterScope((NoriaContext)$this$withModifier, (int)13);
                                PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)title, (CharSequence)("Docker daemon seems to be running and socket " + ((DockerError.ConnectionToDaemonError)error).getSocket() + " exists, but there is still a connection issue"), null, null, (int)24, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withModifier);
                            }
                            return;
                        } else {
                            Runtime.enterScope((NoriaContext)$this$withModifier, (int)14);
                            PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getErrorOutline(), (String)title, (CharSequence)error.getMessage(), null, null, (int)24, null);
                            Unit socketFile = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)$this$withModifier);
                        }
                    }
                    return;
                } else if (this.$dockerEngine == null) {
                    Runtime.enterScope((NoriaContext)$this$withModifier, (int)15);
                    PlaceholdersKt.defaultTabPlaceholder$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.INSTANCE.getDocker(), (String)"Docker", (CharSequence)"Connecting to Docker daemon\u2026", null, null, (int)24, null);
                    Unit title = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$withModifier);
                    return;
                } else {
                    StretchPolicy.Ratio stretchPolicy = new StretchPolicy.Ratio(0.2f, 0.0f, null, null, 14, null);
                    Runtime.enterScope((NoriaContext)$this$withModifier, (int)17);
                    Object[] objectArray = new Object[]{this.$dockerViewEntity};
                    StateCell stateCell = DurableStateKt.stateWithDurableInit((NoriaContext)$this$withModifier, (Key)DockerKeys.ContainerToImageSplitKey.INSTANCE, (Function0)((Function0)new Function0<SplitState>(stretchPolicy){
                        final /* synthetic */ StretchPolicy.Ratio $stretchPolicy;
                        {
                            this.$stretchPolicy = $stretchPolicy;
                            super(0);
                        }

                        public final SplitState invoke() {
                            return SplitState.Companion.fromPolicy((StretchPolicy)this.$stretchPolicy);
                        }
                    }), (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<NoriaContext, SplitState, StateCell<SplitState>>(this.$dockerViewEntity){
                        final /* synthetic */ DockerViewEntity $dockerViewEntity;
                        {
                            this.$dockerViewEntity = $dockerViewEntity;
                            super(2);
                        }

                        public final StateCell<SplitState> invoke(NoriaContext $this$stateWithDurableInit, SplitState v) {
                            Intrinsics.checkNotNullParameter((Object)$this$stateWithDurableInit, (String)"$this$stateWithDurableInit");
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            Runtime.enterScope((NoriaContext)$this$stateWithDurableInit, (int)16);
                            StateCell stateCell = DurableStateKt.durableState((NoriaContext)$this$stateWithDurableInit, (Entity)this.$dockerViewEntity, (String)"docker-split", (Function0)((Function0)new Function0<SplitState>(v){
                                final /* synthetic */ SplitState $v;
                                {
                                    this.$v = $v;
                                    super(0);
                                }

                                public final SplitState invoke() {
                                    return this.$v;
                                }
                            }));
                            Runtime.exitScope((NoriaContext)$this$stateWithDurableInit);
                            return stateCell;
                        }
                    })));
                    Runtime.exitScope((NoriaContext)$this$withModifier);
                    StateCell splitState2 = stateCell;
                    Runtime.enterScope((NoriaContext)$this$withModifier, (int)20);
                    objectArray = new Object[]{this.$dockerViewEntity, this.$dockerEngine};
                    SplitViewKt.splitView$default((NoriaContext)$this$withModifier, (SplitDirection)SplitDirection.VERTICAL, (StretchPolicy)((StretchPolicy)stretchPolicy), null, (StateCell)splitState2, null, (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<SplitContext, SplitModel, Unit>(this.$dockerViewEntity, this.$dockerEngine){
                        final /* synthetic */ DockerViewEntity $dockerViewEntity;
                        final /* synthetic */ DockerEngine $dockerEngine;
                        {
                            this.$dockerViewEntity = $dockerViewEntity;
                            this.$dockerEngine = $dockerEngine;
                            super(2);
                        }

                        public final void invoke(SplitContext $this$splitView, SplitModel it) {
                            Intrinsics.checkNotNullParameter((Object)$this$splitView, (String)"$this$splitView");
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Object[] objectArray = new Object[]{this.$dockerViewEntity, this.$dockerEngine};
                            SplitContext.first$default((SplitContext)$this$splitView, null, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(this.$dockerViewEntity, this.$dockerEngine){
                                final /* synthetic */ DockerViewEntity $dockerViewEntity;
                                final /* synthetic */ DockerEngine $dockerEngine;
                                {
                                    this.$dockerViewEntity = $dockerViewEntity;
                                    this.$dockerEngine = $dockerEngine;
                                    super(1);
                                }

                                public final void invoke(NoriaContext $this$first) {
                                    Intrinsics.checkNotNullParameter((Object)$this$first, (String)"$this$first");
                                    Runtime.enterScope((NoriaContext)$this$first, (int)18);
                                    DockerContainerNodeKt.renderDockerContainersGroup($this$first, this.$dockerViewEntity, this.$dockerEngine);
                                    Unit unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)$this$first);
                                }
                            })), (int)3, null);
                            objectArray = new Object[]{this.$dockerViewEntity, this.$dockerEngine};
                            SplitContext.second$default((SplitContext)$this$splitView, null, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(this.$dockerViewEntity, this.$dockerEngine){
                                final /* synthetic */ DockerViewEntity $dockerViewEntity;
                                final /* synthetic */ DockerEngine $dockerEngine;
                                {
                                    this.$dockerViewEntity = $dockerViewEntity;
                                    this.$dockerEngine = $dockerEngine;
                                    super(1);
                                }

                                public final void invoke(NoriaContext $this$second) {
                                    Intrinsics.checkNotNullParameter((Object)$this$second, (String)"$this$second");
                                    Runtime.enterScope((NoriaContext)$this$second, (int)19);
                                    DockerImageNodeKt.renderDockerImagesGroup($this$second, this.$dockerViewEntity, this.$dockerEngine);
                                    Unit unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)$this$second);
                                }
                            })), (int)3, null);
                        }
                    })), (int)20, null);
                    stateCell = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$withModifier);
                }
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderDockerViewEntity);
    }

    private static final Object updateState(DockerViewEntity dockerViewEntity, CheckState newState, Continuation<? super Unit> $completion) {
        Object object = TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>(dockerViewEntity, newState){
            final /* synthetic */ DockerViewEntity $dockerViewEntity;
            final /* synthetic */ CheckState $newState;
            {
                this.$dockerViewEntity = $dockerViewEntity;
                this.$newState = $newState;
                super(1);
            }

            public final void invoke(ChangeScope $this$change) {
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                if (!EntitiesKt.exists((Entity)this.$dockerViewEntity)) {
                    return;
                }
                $this$change.set((Entity)this.$dockerViewEntity, DockerViewEntity.Companion.getCheckStateAttr(), (Object)this.$newState);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public static final Host findRandomHostForDockerOrThrow() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = ContractKt.all((Contract)((Contract)Host.Companion));
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Host it = (Host)element$iv2;
                boolean bl = false;
                if (!(!LocalFsdExtKt.isLocalHost((Host)it))) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Host)element$iv2;
    }

    public static final /* synthetic */ void access$renderDockerViewEntity(NoriaContext $receiver, DockerViewEntity dockerViewEntity) {
        DockerViewEntityKt.renderDockerViewEntity($receiver, dockerViewEntity);
    }

    public static final /* synthetic */ Object access$updateState(DockerViewEntity dockerViewEntity, CheckState newState, Continuation $completion) {
        return DockerViewEntityKt.updateState(dockerViewEntity, newState, (Continuation<? super Unit>)$completion);
    }
}

