/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.statements.loops;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimBlob;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Variable;
import com.maddyhome.idea.vim.vimscript.parser.DeletionInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0003J-\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/statements/loops/ForLoop;", "Lcom/maddyhome/idea/vim/vimscript/model/Executable;", "variable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Variable;", "iterable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "body", "", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Variable;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Ljava/util/List;)V", "getBody", "()Ljava/util/List;", "getIterable", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "rangeInScript", "Lcom/maddyhome/idea/vim/common/TextRange;", "getRangeInScript", "()Lcom/maddyhome/idea/vim/common/TextRange;", "setRangeInScript", "(Lcom/maddyhome/idea/vim/common/TextRange;)V", "getVariable", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Variable;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getVimContext", "()Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "setVimContext", "(Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "", "execute", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "hashCode", "", "restoreOriginalRange", "", "deletionInfo", "Lcom/maddyhome/idea/vim/vimscript/parser/DeletionInfo;", "toString", "", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nForLoop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForLoop.kt\ncom/maddyhome/idea/vim/vimscript/model/statements/loops/ForLoop\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1855#2,2:157\n1855#2,2:159\n*S KotlinDebug\n*F\n+ 1 ForLoop.kt\ncom/maddyhome/idea/vim/vimscript/model/statements/loops/ForLoop\n*L\n35#1:157,2\n91#1:159,2\n*E\n"})
public final class ForLoop
implements Executable {
    @NotNull
    private final Variable variable;
    @NotNull
    private final Expression iterable;
    @NotNull
    private final List<Executable> body;
    public VimLContext vimContext;
    public TextRange rangeInScript;

    public ForLoop(@NotNull Variable variable, @NotNull Expression iterable, @NotNull List<? extends Executable> body) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.variable = variable;
        this.iterable = iterable;
        this.body = body;
    }

    @NotNull
    public final Variable getVariable() {
        return this.variable;
    }

    @NotNull
    public final Expression getIterable() {
        return this.iterable;
    }

    @NotNull
    public final List<Executable> getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public VimLContext getVimContext() {
        VimLContext vimLContext = this.vimContext;
        if (vimLContext != null) {
            return vimLContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"vimContext");
        return null;
    }

    @Override
    public void setVimContext(@NotNull VimLContext vimLContext) {
        Intrinsics.checkNotNullParameter((Object)vimLContext, (String)"<set-?>");
        this.vimContext = vimLContext;
    }

    @Override
    @NotNull
    public TextRange getRangeInScript() {
        TextRange textRange = this.rangeInScript;
        if (textRange != null) {
            return textRange;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rangeInScript");
        return null;
    }

    @Override
    public void setRangeInScript(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.rangeInScript = textRange;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VimInjectorKt.getInjector().getStatisticsService().setIfLoopUsed(true);
        ExecutionResult result = ExecutionResult.Success.INSTANCE;
        Iterable $this$forEach$iv = this.body;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Executable it = (Executable)element$iv;
            boolean bl = false;
            it.setVimContext(this);
        }
        VimDataType iterableValue = this.iterable.evaluate(editor, context, this);
        if (iterableValue instanceof VimString) {
            String $i$f$forEach2 = ((VimString)iterableValue).getValue();
            int element$iv = $i$f$forEach2.length();
            for (int i = 0; i < element$iv; ++i) {
                char i2 = $i$f$forEach2.charAt(i);
                VimInjectorKt.getInjector().getVariableService().storeVariable(this.variable, new VimString(String.valueOf(i2)), editor, context, this);
                for (Executable statement : this.body) {
                    if (!(result instanceof ExecutionResult.Success)) break;
                    result = statement.execute(editor, context);
                }
                if (result instanceof ExecutionResult.Break) {
                    result = ExecutionResult.Success.INSTANCE;
                } else {
                    if (result instanceof ExecutionResult.Continue) {
                        result = ExecutionResult.Success.INSTANCE;
                        continue;
                    }
                    if (!(result instanceof ExecutionResult.Error)) {
                        continue;
                    }
                }
                break;
            }
        } else if (iterableValue instanceof VimList) {
            int index = 0;
            while (index < ((VimList)iterableValue).getValues().size()) {
                VimInjectorKt.getInjector().getVariableService().storeVariable(this.variable, ((VimList)iterableValue).getValues().get(index), editor, context, this);
                for (Executable statement : this.body) {
                    if (!(result instanceof ExecutionResult.Success)) break;
                    result = statement.execute(editor, context);
                }
                if (result instanceof ExecutionResult.Break) {
                    result = ExecutionResult.Success.INSTANCE;
                } else {
                    if (result instanceof ExecutionResult.Continue) {
                        result = ExecutionResult.Success.INSTANCE;
                        continue;
                    }
                    if (!(result instanceof ExecutionResult.Error)) {
                        ++index;
                        VimDataType vimDataType = this.iterable.evaluate(editor, context, this);
                        Intrinsics.checkNotNull((Object)vimDataType, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.vimscript.model.datatypes.VimList");
                        iterableValue = (VimList)vimDataType;
                        continue;
                    }
                }
                break;
            }
        } else {
            if (iterableValue instanceof VimBlob) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            throw new ExException("E1098: String, List or Blob required");
        }
        return result;
    }

    @Override
    public void restoreOriginalRange(@NotNull DeletionInfo deletionInfo) {
        Intrinsics.checkNotNullParameter((Object)deletionInfo, (String)"deletionInfo");
        Executable.super.restoreOriginalRange(deletionInfo);
        Iterable $this$forEach$iv = this.body;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Executable it = (Executable)element$iv;
            boolean bl = false;
            it.restoreOriginalRange(deletionInfo);
        }
    }

    @NotNull
    public final Variable component1() {
        return this.variable;
    }

    @NotNull
    public final Expression component2() {
        return this.iterable;
    }

    @NotNull
    public final List<Executable> component3() {
        return this.body;
    }

    @NotNull
    public final ForLoop copy(@NotNull Variable variable, @NotNull Expression iterable, @NotNull List<? extends Executable> body) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new ForLoop(variable, iterable, body);
    }

    public static /* synthetic */ ForLoop copy$default(ForLoop forLoop, Variable variable, Expression expression, List list, int n, Object object) {
        if ((n & 1) != 0) {
            variable = forLoop.variable;
        }
        if ((n & 2) != 0) {
            expression = forLoop.iterable;
        }
        if ((n & 4) != 0) {
            list = forLoop.body;
        }
        return forLoop.copy(variable, expression, list);
    }

    @NotNull
    public String toString() {
        return "ForLoop(variable=" + this.variable + ", iterable=" + this.iterable + ", body=" + this.body + ")";
    }

    public int hashCode() {
        int result = this.variable.hashCode();
        result = result * 31 + this.iterable.hashCode();
        result = result * 31 + ((Object)this.body).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForLoop)) {
            return false;
        }
        ForLoop forLoop = (ForLoop)other;
        if (!Intrinsics.areEqual((Object)this.variable, (Object)forLoop.variable)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.iterable, (Object)forLoop.iterable)) {
            return false;
        }
        return Intrinsics.areEqual(this.body, forLoop.body);
    }
}

