/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.operators.BinaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/BinExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "left", "right", "operator", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/BinaryOperator;", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/BinaryOperator;)V", "getLeft", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getOperator", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/BinaryOperator;", "getRight", "component1", "component2", "component3", "copy", "equals", "", "other", "", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "hashCode", "", "toString", "", "vim-engine"})
public final class BinExpression
extends Expression {
    @NotNull
    private final Expression left;
    @NotNull
    private final Expression right;
    @NotNull
    private final BinaryOperator operator;

    public BinExpression(@NotNull Expression left, @NotNull Expression right, @NotNull BinaryOperator operator) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @NotNull
    public final Expression getLeft() {
        return this.left;
    }

    @NotNull
    public final Expression getRight() {
        return this.right;
    }

    @NotNull
    public final BinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        return this.operator.getHandler().performOperation(this.left.evaluate(editor, context, vimContext), this.right.evaluate(editor, context, vimContext));
    }

    @NotNull
    public final Expression component1() {
        return this.left;
    }

    @NotNull
    public final Expression component2() {
        return this.right;
    }

    @NotNull
    public final BinaryOperator component3() {
        return this.operator;
    }

    @NotNull
    public final BinExpression copy(@NotNull Expression left, @NotNull Expression right, @NotNull BinaryOperator operator) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        return new BinExpression(left, right, operator);
    }

    public static /* synthetic */ BinExpression copy$default(BinExpression binExpression, Expression expression, Expression expression2, BinaryOperator binaryOperator, int n, Object object) {
        if ((n & 1) != 0) {
            expression = binExpression.left;
        }
        if ((n & 2) != 0) {
            expression2 = binExpression.right;
        }
        if ((n & 4) != 0) {
            binaryOperator = binExpression.operator;
        }
        return binExpression.copy(expression, expression2, binaryOperator);
    }

    @NotNull
    public String toString() {
        return "BinExpression(left=" + this.left + ", right=" + this.right + ", operator=" + this.operator + ")";
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = result * 31 + this.right.hashCode();
        result = result * 31 + this.operator.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinExpression)) {
            return false;
        }
        BinExpression binExpression = (BinExpression)other;
        if (!Intrinsics.areEqual((Object)this.left, (Object)binExpression.left)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.right, (Object)binExpression.right)) {
            return false;
        }
        return this.operator == binExpression.operator;
    }
}

