/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/YankLinesCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "setArgument", "(Ljava/lang/String;)V", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "vim-engine"})
public final class YankLinesCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public YankLinesCommand(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    public final void setArgument(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.argument = string;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        char register;
        char c;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        String argument = this.argument;
        VimRegisterGroup registerGroup2 = VimInjectorKt.getInjector().getRegisterGroup();
        if (((CharSequence)argument).length() > 0 && !Character.isDigit(argument.charAt(0))) {
            String string = argument.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.argument = string;
            c = argument.charAt(0);
        } else {
            c = register = registerGroup2.getDefaultRegister();
        }
        if (!registerGroup2.selectRegister(register)) {
            return ExecutionResult.Error.INSTANCE;
        }
        ArrayList<Integer> starts = new ArrayList<Integer>(editor.nativeCarets().size());
        ArrayList<Integer> ends = new ArrayList<Integer>(editor.nativeCarets().size());
        for (VimCaret caret : editor.nativeCarets()) {
            TextRange range = this.getTextRange(editor, caret, true);
            starts.add(range.getStartOffset());
            ends.add(range.getEndOffset());
        }
        return VimInjectorKt.getInjector().getYank().yankRange(editor, new TextRange(CollectionsKt.toIntArray((Collection)starts), CollectionsKt.toIntArray((Collection)ends)), SelectionType.LINE_WISE, false) ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final YankLinesCommand copy(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new YankLinesCommand(ranges, argument);
    }

    public static /* synthetic */ YankLinesCommand copy$default(YankLinesCommand yankLinesCommand, Ranges ranges, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = yankLinesCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = yankLinesCommand.argument;
        }
        return yankLinesCommand.copy(ranges, string);
    }

    @NotNull
    public String toString() {
        return "YankLinesCommand(ranges=" + this.ranges + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YankLinesCommand)) {
            return false;
        }
        YankLinesCommand yankLinesCommand = (YankLinesCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)yankLinesCommand.ranges)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)yankLinesCommand.argument);
    }
}

